/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.update;

import fr.ax_dev.universejobs.UniverseJobs;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private static final String API_URL = "https://api.github.com/repos/UniverseStudiosMC/UniverseJobs/releases/latest";
    private final UniverseJobs plugin;

    public UpdateChecker(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void checkForUpdates() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(API_URL)).header("Accept", "application/vnd.github+json").build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    this.plugin.getLogger().warning("Update check failed: HTTP " + response.statusCode());
                    return;
                }
                String body = response.body();
                String latestTag = this.extractValue(body, "\"tag_name\":\"");
                if (latestTag == null) {
                    this.plugin.getLogger().warning("Could not parse latest version from GitHub response.");
                    return;
                }
                String currentVersion = this.plugin.getDescription().getVersion();
                if (currentVersion.equalsIgnoreCase(latestTag)) {
                    return;
                }
                this.plugin.getLogger().info("New version available: " + latestTag + " (current: " + currentVersion + ")");
                String downloadUrl = this.extractValue(body, "\"browser_download_url\":\"");
                if (downloadUrl == null) {
                    this.plugin.getLogger().warning("No download URL found for latest release.");
                    return;
                }
                Path pluginsDir = this.plugin.getDataFolder().getParentFile().toPath();
                Path target = pluginsDir.resolve("UniverseJobs-" + latestTag + ".jar");
                HttpRequest downloadRequest = HttpRequest.newBuilder().uri(URI.create(downloadUrl)).build();
                HttpResponse<Path> downloadResponse = client.send(downloadRequest, HttpResponse.BodyHandlers.ofFile(target));
                if (downloadResponse.statusCode() == 200) {
                    this.plugin.getLogger().info("Downloaded update to " + String.valueOf(target.getFileName()) + ". Please restart the server to apply the update.");
                } else {
                    this.plugin.getLogger().warning("Failed to download update: HTTP " + downloadResponse.statusCode());
                }
            }
            catch (IOException | InterruptedException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error while checking for updates", e);
            }
        });
    }

    private String extractValue(String json, String key) {
        int start = json.indexOf(key);
        if (start == -1) {
            return null;
        }
        int end = json.indexOf(34, start += key.length());
        if (end == -1) {
            return null;
        }
        return json.substring(start, end);
    }
}

