/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.config.MessageConfig;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.job.XpMessageSettings;
import fr.ax_dev.universejobs.utils.CumulativeGainTracker;
import fr.ax_dev.universejobs.utils.PacketUtils;
import java.util.concurrent.CompletableFuture;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;

public class AsyncXpMessageSender {
    private final UniverseJobs plugin;

    public AsyncXpMessageSender(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void sendXpMessage(Player player, Job job, double xp, double money, PlayerJobData playerData) {
        if (!this.plugin.getConfig().getBoolean("messages.show-xp-gain", true)) {
            return;
        }
        XpMessageSettings settings = job.getXpMessageSettings();
        if (settings.getMessageType() == XpMessageSettings.MessageType.BOSSBAR || settings.getMessageType() == XpMessageSettings.MessageType.ACTIONBAR) {
            try {
                this.sendXpMessageInternal(player, job, xp, money, playerData);
            }
            catch (Exception e) {
                if (this.plugin.getConfigManager().isDebugEnabled()) {
                    this.plugin.getLogger().warning("Failed to send XP message: " + e.getMessage());
                }
            }
        } else {
            CompletableFuture.runAsync(() -> {
                block2: {
                    try {
                        this.sendXpMessageInternal(player, job, xp, money, playerData);
                    }
                    catch (Exception e) {
                        if (!this.plugin.getConfigManager().isDebugEnabled()) break block2;
                        this.plugin.getLogger().warning("Failed to send XP message: " + e.getMessage());
                    }
                }
            }, PacketUtils.getAsyncExecutor());
        }
    }

    private void sendXpMessageInternal(Player player, Job job, double xp, double money, PlayerJobData playerData) {
        double displayMoneyPerAction;
        double displayXpPerAction;
        double displayMoney;
        double displayXp;
        double bossbarProgress;
        boolean useCumulativeTracking;
        if (!player.isOnline()) {
            return;
        }
        XpMessageSettings settings = job.getXpMessageSettings();
        double[] cumulativeGains = null;
        boolean bl = useCumulativeTracking = settings.getMessageType() == XpMessageSettings.MessageType.BOSSBAR || settings.getMessageType() == XpMessageSettings.MessageType.ACTIONBAR;
        if (useCumulativeTracking) {
            cumulativeGains = CumulativeGainTracker.addGains(player, xp, money);
        }
        int currentLevel = playerData.getLevel(job.getId());
        double[] progress = playerData.getXpProgress(job.getId());
        double currentXpInLevel = progress[0];
        double xpNeededForNext = progress[1];
        double progressPercent = xpNeededForNext > 0.0 ? currentXpInLevel / xpNeededForNext * 100.0 : 100.0;
        double d = bossbarProgress = xpNeededForNext > 0.0 ? currentXpInLevel / xpNeededForNext : 1.0;
        if (useCumulativeTracking && cumulativeGains != null) {
            displayXp = cumulativeGains[0];
            displayMoney = cumulativeGains[1];
            displayXpPerAction = cumulativeGains[2];
            displayMoneyPerAction = cumulativeGains[3];
        } else {
            displayXp = xp;
            displayMoney = money;
            displayXpPerAction = xp;
            displayMoneyPerAction = money;
        }
        String message = settings.processMessage(displayXp, displayMoney).replace("{job}", job.getName()).replace("{level}", String.valueOf(currentLevel)).replace("{progress}", String.format("%.1f", progressPercent)).replace("{current_xp}", String.format("%.1f", currentXpInLevel)).replace("{needed_xp}", String.format("%.1f", xpNeededForNext)).replace("{player}", player.getName()).replace("{xp_per_action}", this.formatNumber(displayXpPerAction)).replace("{money_per_action}", this.formatNumber(displayMoneyPerAction));
        message = this.processPlaceholderAPI(player, message);
        switch (settings.getMessageType()) {
            case CHAT: {
                PacketUtils.sendChatAsync(player, message);
                break;
            }
            case ACTIONBAR: {
                PacketUtils.sendActionBarAsync(player, message, settings.getActionbarDuration());
                break;
            }
            case BOSSBAR: {
                double finalProgress = settings.shouldShowProgress() ? bossbarProgress : 1.0;
                PacketUtils.sendBossBarAsync(player, message, settings.toBukkitBarColor(), settings.toBukkitBarStyle(), finalProgress, settings.getBossbarDuration());
                break;
            }
            case TITLE: {
                PacketUtils.sendTitleAsync(player, message, settings.getTitleFadeIn(), settings.getTitleStay(), settings.getTitleFadeOut());
                break;
            }
            default: {
                PacketUtils.sendActionBarAsync(player, message, settings.getActionbarDuration());
            }
        }
    }

    public void sendActionMessage(Player player, String message, MessageConfig messageConfig) {
        CompletableFuture.runAsync(() -> {
            try {
                if (!player.isOnline()) {
                    return;
                }
                String processedMessage = this.processPlaceholderAPI(player, message);
                switch (messageConfig.getType()) {
                    case CHAT: {
                        PacketUtils.sendChatAsync(player, processedMessage);
                        break;
                    }
                    case ACTIONBAR: {
                        PacketUtils.sendActionBarAsync(player, processedMessage, messageConfig.getDuration());
                        break;
                    }
                    case BOSSBAR: {
                        PacketUtils.sendBossBarAsync(player, processedMessage, messageConfig.getBossbarColor(), messageConfig.getBossbarStyle(), 1.0, messageConfig.getDuration());
                        break;
                    }
                    default: {
                        PacketUtils.sendActionBarAsync(player, processedMessage, messageConfig.getDuration());
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, PacketUtils.getAsyncExecutor());
    }

    public void cleanupPlayer(Player player) {
        PacketUtils.cleanupPlayer(player.getUniqueId());
        CumulativeGainTracker.clearGains(player);
    }

    public void shutdown() {
        PacketUtils.shutdown();
        CumulativeGainTracker.clearAllGains();
    }

    private String processPlaceholderAPI(Player player, String message) {
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return message;
        }
        try {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        catch (Exception e) {
            return message;
        }
    }

    private String formatNumber(double value) {
        if (value == Math.floor(value)) {
            return String.valueOf((int)value);
        }
        String formatted = String.format("%.2f", value);
        while (formatted.endsWith("0") && formatted.contains(".")) {
            formatted = formatted.substring(0, formatted.length() - 1);
        }
        if (formatted.endsWith(".")) {
            formatted = formatted.substring(0, formatted.length() - 1);
        }
        return formatted;
    }

    public void sendQuickNotification(Player player, String message) {
        if (player.isOnline()) {
            PacketUtils.sendActionBarAsync(player, message, 40);
        }
    }

    public void sendProgressUpdate(Player player, String message, double progress, int duration) {
        if (player.isOnline()) {
            PacketUtils.sendBossBarAsync(player, message, BarColor.YELLOW, BarStyle.SOLID, progress, duration);
        }
    }
}

