/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.command.handler.ActionLimitCommandHandler;
import fr.ax_dev.universejobs.command.handler.AdminJobCommandHandler;
import fr.ax_dev.universejobs.command.handler.DatabaseCommandHandler;
import fr.ax_dev.universejobs.command.handler.InfoStatsCommandHandler;
import fr.ax_dev.universejobs.command.handler.JoinLeaveCommandHandler;
import fr.ax_dev.universejobs.command.handler.MenuCommandHandler;
import fr.ax_dev.universejobs.command.handler.RewardsCommandHandler;
import fr.ax_dev.universejobs.config.LanguageManager;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class JobCommand
implements CommandExecutor,
TabCompleter {
    private final UniverseJobs plugin;
    private final LanguageManager languageManager;
    private final JoinLeaveCommandHandler joinLeaveHandler;
    private final InfoStatsCommandHandler infoStatsHandler;
    private final RewardsCommandHandler rewardsHandler;
    private final ActionLimitCommandHandler actionLimitHandler;
    private final AdminJobCommandHandler adminJobHandler;
    private final MenuCommandHandler menuHandler;
    private static final String CMD_JOIN = "join";
    private static final String CMD_LEAVE = "leave";
    private static final String CMD_INFO = "info";
    private static final String CMD_LIST = "list";
    private static final String CMD_STATS = "stats";
    private static final String CMD_REWARDS = "rewards";
    private static final String CMD_ACTION_LIMIT = "actionlimit";
    private static final String CMD_MENU = "menu";
    private static final String CMD_ADMIN = "admin";
    private static final String CMD_DATABASE = "database";
    private static final Pattern COMMAND_INJECTION_PATTERN = Pattern.compile("[;&|`$(){}\\[\\]<>\"'\\\\]");
    private final Map<UUID, Long> lastCommandTime = new HashMap<UUID, Long>();
    private static final long COMMAND_COOLDOWN_MS = 100L;

    public JobCommand(UniverseJobs plugin, JobManager jobManager) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.joinLeaveHandler = new JoinLeaveCommandHandler(plugin);
        this.infoStatsHandler = new InfoStatsCommandHandler(plugin);
        this.rewardsHandler = new RewardsCommandHandler(plugin);
        this.actionLimitHandler = new ActionLimitCommandHandler(plugin);
        this.adminJobHandler = new AdminJobCommandHandler(plugin, jobManager);
        this.menuHandler = new MenuCommandHandler(plugin);
        new DatabaseCommandHandler(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (!this.validateCommandStructure(args)) {
            return true;
        }
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player player2 = (Player)sender;
                return this.menuHandler.handleCommand(sender, new String[0]);
            }
            this.sendConsoleHelp(sender);
            return true;
        }
        String subCommand = this.sanitizeInput(args[0].toLowerCase());
        if (!this.isValidSubCommand(subCommand)) {
            this.sendHelpBasedOnSender(sender);
            return true;
        }
        if (!this.validatePlayerRequirement(sender, subCommand)) {
            return true;
        }
        if (sender instanceof Player && !this.checkRateLimit(player = (Player)sender)) {
            return true;
        }
        try {
            boolean handled = false;
            switch (subCommand) {
                case "join": 
                case "leave": {
                    handled = this.joinLeaveHandler.handleCommand(sender, args);
                    break;
                }
                case "info": 
                case "list": 
                case "stats": {
                    handled = this.infoStatsHandler.handleCommand(sender, args);
                    break;
                }
                case "rewards": {
                    handled = this.rewardsHandler.handleCommand(sender, args);
                    break;
                }
                case "actionlimit": {
                    handled = this.actionLimitHandler.handleCommand(sender, args);
                    break;
                }
                case "admin": {
                    handled = this.adminJobHandler.handleAdminCommand(sender, args);
                    break;
                }
                case "menu": {
                    handled = this.menuHandler.handleCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                    break;
                }
                default: {
                    handled = false;
                }
            }
            if (!handled) {
                if (sender instanceof Player) {
                    Player player3 = (Player)sender;
                    this.sendHelp(player3);
                } else {
                    this.sendConsoleHelp(sender);
                }
            }
        }
        catch (Exception e) {
            String senderName = sender instanceof Player ? sender.getName() : "Console";
            this.plugin.getLogger().warning("Error executing command for " + senderName + ": " + e.getMessage());
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>();
            if (sender instanceof Player) {
                subCommands.addAll(Arrays.asList(CMD_JOIN, CMD_LEAVE, CMD_INFO, CMD_LIST, CMD_STATS, CMD_MENU));
                if (sender.hasPermission("universejobs.rewards.use")) {
                    subCommands.add(CMD_REWARDS);
                }
            }
            if (sender.hasPermission("universejobs.admin")) {
                subCommands.add(CMD_ADMIN);
                subCommands.add(CMD_DATABASE);
            }
            if (sender.hasPermission("universejobs.admin.actionlimits")) {
                subCommands.add(CMD_ACTION_LIMIT);
            }
            String input = args[0].toLowerCase();
            for (String subCommand : subCommands) {
                if (!subCommand.startsWith(input)) continue;
                completions.add(subCommand);
            }
        } else {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "join": 
                case "leave": {
                    completions.addAll(this.joinLeaveHandler.getTabCompletions(sender, args));
                    break;
                }
                case "info": 
                case "list": 
                case "stats": {
                    completions.addAll(this.infoStatsHandler.getTabCompletions(sender, args));
                    break;
                }
                case "rewards": {
                    completions.addAll(this.rewardsHandler.getTabCompletions(sender, args));
                    break;
                }
                case "actionlimit": {
                    completions.addAll(this.actionLimitHandler.getTabCompletions(sender, args));
                    break;
                }
                case "admin": {
                    completions.addAll(this.adminJobHandler.getTabCompletions(sender, args));
                    break;
                }
                case "menu": {
                    completions.addAll(this.menuHandler.getTabCompletions(sender, Arrays.copyOfRange(args, 1, args.length)));
                    break;
                }
            }
        }
        return completions;
    }

    private boolean checkRateLimit(Player player) {
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastCommandTime.get(player.getUniqueId());
        if (lastTime != null && currentTime - lastTime < 100L) {
            return false;
        }
        this.lastCommandTime.put(player.getUniqueId(), currentTime);
        return true;
    }

    private boolean validateCommandStructure(String[] args) {
        if (args.length > 10) {
            return false;
        }
        for (String arg : args) {
            if (arg == null || arg.length() > 256) {
                return false;
            }
            if (!COMMAND_INJECTION_PATTERN.matcher(arg).find()) continue;
            return false;
        }
        return true;
    }

    private String sanitizeInput(String input) {
        if (input == null) {
            return "";
        }
        String sanitized = input.replaceAll("[;&|`$(){}\\[\\]<>\"'\\\\]", "");
        return sanitized.substring(0, Math.min(sanitized.length(), 64));
    }

    private boolean isValidSubCommand(String subCommand) {
        Set<String> validCommands = Set.of(CMD_JOIN, CMD_LEAVE, CMD_INFO, CMD_LIST, CMD_STATS, CMD_REWARDS, CMD_ACTION_LIMIT, CMD_MENU, CMD_ADMIN);
        return validCommands.contains(subCommand);
    }

    private boolean requiresPlayer(String subCommand) {
        Set<String> playerOnlyCommands = Set.of(CMD_JOIN, CMD_LEAVE, CMD_INFO, CMD_LIST, CMD_STATS, CMD_REWARDS, CMD_MENU);
        return playerOnlyCommands.contains(subCommand);
    }

    private void sendHelp(Player player) {
        for (String line : this.languageManager.getMessageList("commands.help.player", new Object[0])) {
            MessageUtils.sendMessage(player, line);
        }
        if (player.hasPermission("universejobs.rewards.use")) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.help.rewards"));
        }
        if (player.hasPermission("universejobs.admin")) {
            for (String line : this.languageManager.getMessageList("commands.help.admin", new Object[0])) {
                MessageUtils.sendMessage(player, line);
            }
        }
    }

    private void sendConsoleHelp(CommandSender sender) {
        for (String line : this.languageManager.getMessageList("commands.help.console", new Object[0])) {
            sender.sendMessage(line);
        }
    }

    private void sendHelpBasedOnSender(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.sendHelp(player);
        } else {
            this.sendConsoleHelp(sender);
        }
    }

    private boolean validatePlayerRequirement(CommandSender sender, String subCommand) {
        boolean requiresPlayer = this.requiresPlayer(subCommand);
        if (requiresPlayer && !(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.getMessage("commands.players-only"));
            return false;
        }
        return true;
    }
}

