/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.bonus.BonusManager;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class BonusCommandHandler<T, M extends BonusManager<T>>
extends JobCommandHandler {
    private static final String CMD_REMOVE = "remove";
    protected final M specificBonusManager;
    private final String bonusType;
    private final String permission;

    protected BonusCommandHandler(UniverseJobs plugin, M bonusManager, String bonusType, String permission) {
        super(plugin);
        this.specificBonusManager = bonusManager;
        this.bonusType = bonusType;
        this.permission = permission;
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (!this.hasPermission(sender, this.permission)) {
            sender.sendMessage(this.languageManager.getMessage("commands.no-permission"));
            return true;
        }
        if (args.length < 2) {
            this.sendBonusHelp(sender);
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "give": {
                this.handleBonusGive(sender, args);
                break;
            }
            case "remove": {
                this.handleBonusRemove(sender, args);
                break;
            }
            case "list": {
                this.handleBonusList(sender, args);
                break;
            }
            case "info": {
                this.handleBonusInfo(sender);
                break;
            }
            case "cleanup": {
                this.handleBonusCleanup(sender);
                break;
            }
            default: {
                this.sendBonusHelp(sender);
            }
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!this.hasPermission(sender, this.permission)) {
            return completions;
        }
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            List<String> subCommands = Arrays.asList("give", CMD_REMOVE, "list", "info", "cleanup");
            return subCommands.stream().filter(cmd -> cmd.startsWith(input)).collect(Collectors.toList());
        }
        if (args.length >= 3) {
            return this.getBonusTabCompletions(args);
        }
        return completions;
    }

    private void handleBonusGive(CommandSender sender, String[] args) {
        String senderName;
        Job job;
        String jobId;
        if (args.length < 5) {
            sender.sendMessage(this.languageManager.getMessage("commands.bonus.give-usage", "type", this.bonusType));
            sender.sendMessage(this.languageManager.getMessage("commands.bonus.examples-header"));
            sender.sendMessage(this.languageManager.getMessage("commands.bonus.example-global", "type", this.bonusType));
            sender.sendMessage(this.languageManager.getMessage("commands.bonus.example-player", "type", this.bonusType));
            return;
        }
        String target = this.sanitizeInput(args[2]);
        if (!target.equals("*") && !this.isValidPlayerName(target)) {
            return;
        }
        double multiplier = this.parseMultiplier(args[3]);
        if (multiplier <= 0.0) {
            return;
        }
        long duration = this.parseDuration(args[4]);
        if (duration <= 0L) {
            return;
        }
        String string = jobId = args.length > 5 ? this.sanitizeInput(args[5]) : null;
        if (jobId != null && !jobId.equals("*") && !this.isValidJobId(jobId)) {
            return;
        }
        int reasonStartIndex = jobId != null ? 6 : 5;
        String reason = this.parseReason(args, reasonStartIndex);
        if (jobId != null && !jobId.equals("*") && (job = this.jobManager.getJob(jobId)) == null) {
            return;
        }
        String string2 = senderName = sender instanceof Player ? sender.getName() : "Console";
        if (target.equals("*")) {
            this.specificBonusManager.addGlobalBonus(multiplier, duration, reason, senderName);
        } else {
            Player targetPlayer = Bukkit.getPlayer((String)target);
            if (targetPlayer == null) {
                return;
            }
            if (jobId == null || jobId.equals("*")) {
                this.specificBonusManager.addPlayerBonus(targetPlayer.getUniqueId(), multiplier, duration, reason, senderName);
            } else {
                this.specificBonusManager.addJobBonus(targetPlayer.getUniqueId(), jobId, multiplier, duration, reason, senderName);
            }
        }
    }

    private void handleBonusRemove(CommandSender sender, String[] args) {
        String jobId;
        if (args.length < 3) {
            sender.sendMessage(this.languageManager.getMessage("commands.bonus.remove-usage", "type", this.bonusType));
            return;
        }
        String playerName = this.sanitizeInput(args[2]);
        if (!this.isValidPlayerName(playerName)) {
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            return;
        }
        String string = jobId = args.length > 3 ? this.sanitizeInput(args[3]) : null;
        if (jobId != null && !this.isValidJobId(jobId)) {
            return;
        }
        if (jobId == null) {
            this.specificBonusManager.removeAllBonuses(targetPlayer.getUniqueId());
        } else {
            List<Object> bonuses = this.specificBonusManager.getActiveBonuses(targetPlayer.getUniqueId(), jobId);
            bonuses.forEach(arg_0 -> this.specificBonusManager.removeBonus(arg_0));
        }
    }

    private void handleBonusList(CommandSender sender, String[] args) {
        String playerName;
        String string = args.length > 2 ? args[2] : (playerName = sender instanceof Player ? sender.getName() : null);
        if (playerName == null) {
            sender.sendMessage(this.languageManager.getMessage("commands.bonus.list-usage", "type", this.bonusType));
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            return;
        }
        List bonuses = this.specificBonusManager.getActiveBonuses(targetPlayer.getUniqueId());
        if (bonuses.isEmpty()) {
            return;
        }
    }

    private void handleBonusInfo(CommandSender sender) {
    }

    private void handleBonusCleanup(CommandSender sender) {
        this.specificBonusManager.cleanupExpiredBonuses();
    }

    private double parseMultiplier(String input) {
        try {
            String multiplierStr = this.sanitizeInput(input);
            if (multiplierStr.isEmpty() || multiplierStr.length() > 10) {
                return -1.0;
            }
            double multiplier = Double.parseDouble(multiplierStr);
            return multiplier > 0.0 && multiplier <= 10.0 && !Double.isNaN(multiplier) && !Double.isInfinite(multiplier) ? multiplier : -1.0;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private long parseDuration(String input) {
        try {
            String durationStr = this.sanitizeInput(input);
            if (durationStr.isEmpty() || durationStr.length() > 10) {
                return -1L;
            }
            long duration = Long.parseLong(durationStr);
            return duration > 0L && duration <= 86400L ? duration : -1L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private String parseReason(String[] args, int startIndex) {
        if (args.length <= startIndex) {
            return "Admin bonus";
        }
        StringBuilder reasonBuilder = new StringBuilder();
        for (int i = startIndex; i < args.length && i < startIndex + 5; ++i) {
            String part = this.sanitizeInput(args[i]);
            if (part.isEmpty()) continue;
            if (reasonBuilder.length() > 0) {
                reasonBuilder.append(" ");
            }
            reasonBuilder.append(part);
        }
        String reason = reasonBuilder.length() > 0 ? reasonBuilder.toString() : "Admin bonus";
        return reason.length() > 100 ? reason.substring(0, 100) : reason;
    }

    private List<String> getBonusTabCompletions(String[] args) {
        String subCommand = args[1].toLowerCase();
        return switch (args.length) {
            case 3 -> this.getBonusCompletions3Args(subCommand, args[2].toLowerCase());
            case 4 -> this.getBonusCompletions4Args(subCommand, args[3].toLowerCase());
            case 5 -> this.getBonusCompletions5Args(subCommand, args[4].toLowerCase());
            case 6 -> this.getBonusCompletions6Args(subCommand, args[5].toLowerCase());
            default -> new ArrayList<String>();
        };
    }

    private List<String> getBonusCompletions3Args(String subCommand, String input) {
        ArrayList<String> completions = new ArrayList<String>();
        switch (subCommand) {
            case "give": {
                completions.add("*");
                completions.addAll(this.getFilteredPlayerNames(input));
                break;
            }
            case "remove": 
            case "list": {
                completions.addAll(this.getFilteredPlayerNames(input));
                break;
            }
        }
        return completions;
    }

    private List<String> getBonusCompletions4Args(String subCommand, String input) {
        if (!subCommand.equals("give")) {
            return new ArrayList<String>();
        }
        List<String> multipliers = Arrays.asList("1.25", "1.5", "2.0", "3.0");
        return multipliers.stream().filter(mult -> mult.startsWith(input)).collect(Collectors.toList());
    }

    private List<String> getBonusCompletions5Args(String subCommand, String input) {
        if (!subCommand.equals("give")) {
            return new ArrayList<String>();
        }
        List<String> durations = Arrays.asList("300", "600", "1800", "3600", "7200");
        return durations.stream().filter(dur -> dur.startsWith(input)).collect(Collectors.toList());
    }

    private List<String> getBonusCompletions6Args(String subCommand, String input) {
        if (!subCommand.equals("give")) {
            return new ArrayList<String>();
        }
        ArrayList<String> completions = new ArrayList<String>();
        completions.add("*");
        completions.addAll(this.jobManager.getAllJobs().stream().map(Job::getId).filter(jobId -> jobId.toLowerCase().startsWith(input)).collect(Collectors.toList()));
        return completions;
    }

    private List<String> getFilteredPlayerNames(String input) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
    }

    protected abstract void sendBonusHelp(CommandSender var1);
}

