/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.bonus.BaseBonus;
import fr.ax_dev.universejobs.bonus.MoneyBonus;
import fr.ax_dev.universejobs.bonus.XpBonus;
import fr.ax_dev.universejobs.menu.config.BoostMenuConfig;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BoostManagerGui
implements InventoryHolder {
    private final UniverseJobs plugin;
    private final MiniMessage miniMessage;
    private final BoostMenuConfig config;
    private Inventory currentInventory;

    public BoostManagerGui(UniverseJobs plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.config = plugin.getMenuManager().getMenuConfig().getBoostMenuConfig();
    }

    public void openGui(Player player) {
        if (!player.hasPermission("universejobs.admin.boost")) {
            MessageUtils.sendMessage(player, this.plugin.getLanguageManager().getMessage("boost-gui.no-permission"));
            return;
        }
        Inventory gui = this.createGui();
        this.updateGuiContent(gui);
        this.plugin.getMenuManager().registerBoostGui(player, this);
        this.playSound(player, this.config.getSoundsConfig().openSound);
        player.openInventory(gui);
        this.startAutoUpdate(player, gui);
    }

    private Inventory createGui() {
        Component title = this.miniMessage.deserialize((Object)("<!italic>" + this.config.getTitle()));
        this.currentInventory = Bukkit.createInventory((InventoryHolder)this, (int)this.config.getSize(), (Component)title);
        return this.currentInventory;
    }

    private void updateGuiContent(Inventory gui) {
        gui.clear();
        List<XpBonus> xpBoosts = this.plugin.getBonusManager().getAllActiveBoostIds().stream().map(id -> (XpBonus)this.plugin.getBonusManager().getBoostById((String)id)).filter(Objects::nonNull).filter(BaseBonus::isActive).sorted(Comparator.comparingLong(BaseBonus::getStartTime)).collect(Collectors.toList());
        List<MoneyBonus> moneyBoosts = this.plugin.getMoneyBonusManager().getAllActiveBoostIds().stream().map(id -> (MoneyBonus)this.plugin.getMoneyBonusManager().getBoostById((String)id)).filter(Objects::nonNull).filter(BaseBonus::isActive).sorted(Comparator.comparingLong(BaseBonus::getStartTime)).collect(Collectors.toList());
        this.addCustomItems(gui, xpBoosts.size(), moneyBoosts.size());
        this.addNavigationItems(gui, xpBoosts.size(), moneyBoosts.size());
        this.fillWithGlass(gui);
        if (this.config.getXpBoostConfig() != null && this.config.getXpBoostConfig().enabled) {
            this.placeXpBoosts(gui, xpBoosts);
        }
        if (this.config.getMoneyBoostConfig() != null && this.config.getMoneyBoostConfig().enabled) {
            this.placeMoneyBoosts(gui, moneyBoosts);
        }
    }

    private void fillWithGlass(Inventory gui) {
        if (this.config.getFillerConfig() == null || !this.config.getFillerConfig().enabled) {
            return;
        }
        ItemStack filler = this.createFillerItem();
        List<Integer> slots = this.config.getFillerConfig().slots;
        if (slots.isEmpty()) {
            for (int i = 0; i < gui.getSize(); ++i) {
                if (gui.getItem(i) != null) continue;
                gui.setItem(i, filler);
            }
        } else {
            for (int slot : slots) {
                if (slot < 0 || slot >= gui.getSize()) continue;
                gui.setItem(slot, filler);
            }
        }
    }

    private ItemStack createFillerItem() {
        BoostMenuConfig.FillerConfig fillerConfig = this.config.getFillerConfig();
        ItemStack item = new ItemStack(fillerConfig.material);
        ItemMeta meta = item.getItemMeta();
        Component displayName = this.miniMessage.deserialize((Object)("<!italic>" + fillerConfig.displayName));
        meta.displayName(displayName);
        if (!fillerConfig.lore.isEmpty()) {
            List lore = fillerConfig.lore.stream().map(line -> this.miniMessage.deserialize((Object)("<!italic>" + line))).collect(Collectors.toList());
            meta.lore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private void placeXpBoosts(Inventory gui, List<XpBonus> boosts) {
        List<Integer> slots = this.config.getXpBoostConfig().slots;
        for (int i = 0; i < Math.min(boosts.size(), slots.size()); ++i) {
            XpBonus boost = boosts.get(i);
            int slot = slots.get(i);
            ItemStack item = this.createXpBoostItem(boost);
            gui.setItem(slot, item);
        }
    }

    private void placeMoneyBoosts(Inventory gui, List<MoneyBonus> boosts) {
        List<Integer> slots = this.config.getMoneyBoostConfig().slots;
        for (int i = 0; i < Math.min(boosts.size(), slots.size()); ++i) {
            MoneyBonus boost = boosts.get(i);
            int slot = slots.get(i);
            ItemStack item = this.createMoneyBoostItem(boost);
            gui.setItem(slot, item);
        }
    }

    private ItemStack createXpBoostItem(XpBonus boost) {
        BoostMenuConfig.BoostItemConfig itemConfig = this.config.getXpBoostConfig();
        ItemStack item = new ItemStack(itemConfig.material);
        ItemMeta meta = item.getItemMeta();
        Map<String, String> variables = this.createVariableMap(boost);
        String formattedName = this.formatString(itemConfig.displayName, variables);
        Component displayName = this.miniMessage.deserialize((Object)("<!italic>" + formattedName));
        meta.displayName(displayName);
        List lore = itemConfig.lore.stream().map(line -> this.formatString((String)line, variables)).map(line -> this.miniMessage.deserialize((Object)("<!italic>" + line))).collect(Collectors.toList());
        meta.lore(lore);
        if (itemConfig.customModelData > 0) {
            meta.setCustomModelData(Integer.valueOf(itemConfig.customModelData));
        }
        if (itemConfig.glow) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "boost_id"), PersistentDataType.STRING, (Object)boost.getBoostId());
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createMoneyBoostItem(MoneyBonus boost) {
        BoostMenuConfig.BoostItemConfig itemConfig = this.config.getMoneyBoostConfig();
        ItemStack item = new ItemStack(itemConfig.material);
        ItemMeta meta = item.getItemMeta();
        Map<String, String> variables = this.createVariableMap(boost);
        String formattedName = this.formatString(itemConfig.displayName, variables);
        Component displayName = this.miniMessage.deserialize((Object)("<!italic>" + formattedName));
        meta.displayName(displayName);
        List lore = itemConfig.lore.stream().map(line -> this.formatString((String)line, variables)).map(line -> this.miniMessage.deserialize((Object)("<!italic>" + line))).collect(Collectors.toList());
        meta.lore(lore);
        if (itemConfig.customModelData > 0) {
            meta.setCustomModelData(Integer.valueOf(itemConfig.customModelData));
        }
        if (itemConfig.glow) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "boost_id"), PersistentDataType.STRING, (Object)boost.getBoostId());
        item.setItemMeta(meta);
        return item;
    }

    private Map<String, String> createVariableMap(BaseBonus boost) {
        Player player;
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("boost_id", boost.getBoostId());
        variables.put("multiplier", String.valueOf(boost.getMultiplier()));
        variables.put("remaining_time", boost.getRemainingTimeFormatted());
        String playerName = boost.isGlobal() ? "All Players" : ((player = Bukkit.getPlayer((UUID)boost.getPlayerId())) != null ? player.getName() : "Unknown");
        variables.put("player_name", playerName);
        String jobInfo = boost.getJobId() == null ? "All Jobs" : boost.getJobId();
        variables.put("job_info", jobInfo);
        String actionInfo = this.formatActionInfo(boost.getActionType(), boost.getActionId());
        variables.put("action_info", actionInfo);
        return variables;
    }

    private String formatActionInfo(String actionType, String actionId) {
        if (actionType == null) {
            return "All Actions";
        }
        if (actionId == null) {
            return actionType;
        }
        return actionType + ":" + actionId;
    }

    private String formatString(String format, Map<String, String> variables) {
        String result = format;
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            result = result.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    private void startAutoUpdate(Player player, Inventory gui) {
        this.stopAutoUpdate(player);
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (this.config.getAutoRefreshConfig() == null || !this.config.getAutoRefreshConfig().enabled) {
            return;
        }
        long intervalTicks = this.config.getAutoRefreshConfig().interval;
        if (intervalTicks <= 0L) {
            intervalTicks = 20L;
        }
        long finalIntervalTicks = intervalTicks;
        this.plugin.getFoliaManager().runTimer(() -> {
            if (this.plugin.isEnabled() && player.isOnline() && player.getOpenInventory().getTopInventory().equals((Object)gui)) {
                this.updateGuiContent(gui);
            } else {
                this.stopAutoUpdate(player);
            }
        }, finalIntervalTicks, finalIntervalTicks);
    }

    private void stopAutoUpdate(Player player) {
    }

    public void handleClick(Player player, int slot, boolean isRightClick) {
        ItemStack item = player.getOpenInventory().getTopInventory().getItem(slot);
        if (item == null || item.getItemMeta() == null) {
            return;
        }
        if (this.config.getNavigationConfig() != null) {
            BoostMenuConfig.NavigationConfig nav = this.config.getNavigationConfig();
            if (nav.closeItem.enabled && nav.closeItem.slots.contains(slot)) {
                this.playSound(player, this.config.getSoundsConfig().closeSound);
                player.closeInventory();
                return;
            }
            if (nav.refreshItem.enabled && nav.refreshItem.slots.contains(slot)) {
                MessageUtils.sendMessage(player, this.plugin.getLanguageManager().getMessage("boost-gui.refresh-clicked"));
                this.updateGuiContent(player.getOpenInventory().getTopInventory());
                return;
            }
        }
        if (!isRightClick) {
            return;
        }
        if (!player.hasPermission("universejobs.admin.boost")) {
            MessageUtils.sendMessage(player, this.plugin.getLanguageManager().getMessage("boost-gui.no-permission"));
            return;
        }
        String boostId = (String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "boost_id"), PersistentDataType.STRING);
        if (boostId != null) {
            boolean removedXp = this.plugin.getBonusManager().removeBoostById(boostId);
            boolean removedMoney = this.plugin.getMoneyBonusManager().removeBoostById(boostId);
            if (removedXp || removedMoney) {
                String type = removedXp ? "XP" : "Money";
                this.updateGuiContent(player.getOpenInventory().getTopInventory());
                this.playSound(player, this.config.getSoundsConfig().removeBoostSound);
                MessageUtils.sendMessage(player, this.plugin.getLanguageManager().getMessage("boost-gui.removed", "type", type, "boost_id", boostId));
            }
        }
    }

    public void onInventoryClose(Player player) {
        this.stopAutoUpdate(player);
        this.playSound(player, this.config.getSoundsConfig().closeSound);
    }

    private void addCustomItems(Inventory gui, int xpCount, int moneyCount) {
        if (this.config.getCustomItems() == null) {
            return;
        }
        for (BoostMenuConfig.CustomItemConfig customItem : this.config.getCustomItems().values()) {
            if (!customItem.enabled) continue;
            ItemStack item = new ItemStack(customItem.material);
            ItemMeta meta = item.getItemMeta();
            Component displayName = this.miniMessage.deserialize((Object)("<!italic>" + customItem.displayName));
            meta.displayName(displayName);
            if (!customItem.lore.isEmpty()) {
                List lore = customItem.lore.stream().map(line -> this.miniMessage.deserialize((Object)("<!italic>" + line))).collect(Collectors.toList());
                meta.lore(lore);
            }
            item.setItemMeta(meta);
            for (int slot : customItem.slots) {
                if (slot < 0 || slot >= gui.getSize()) continue;
                gui.setItem(slot, item);
            }
        }
    }

    private void addNavigationItems(Inventory gui, int xpCount, int moneyCount) {
        ItemStack item;
        if (this.config.getNavigationConfig() == null) {
            return;
        }
        BoostMenuConfig.NavigationConfig nav = this.config.getNavigationConfig();
        if (nav.closeItem.enabled) {
            item = this.createNavigationItem(nav.closeItem);
            for (int slot : nav.closeItem.slots) {
                if (slot < 0 || slot >= gui.getSize()) continue;
                gui.setItem(slot, item);
            }
        }
        if (nav.refreshItem.enabled) {
            item = this.createNavigationItem(nav.refreshItem);
            for (int slot : nav.refreshItem.slots) {
                if (slot < 0 || slot >= gui.getSize()) continue;
                gui.setItem(slot, item);
            }
        }
        if (nav.infoItem.enabled) {
            item = this.createNavigationItem(nav.infoItem);
            ItemMeta meta = item.getItemMeta();
            ArrayList<Component> lore = new ArrayList<Component>();
            for (String line : nav.infoItem.lore) {
                String formatted = line.replace("{xp_count}", String.valueOf(xpCount)).replace("{money_count}", String.valueOf(moneyCount)).replace("{total_count}", String.valueOf(xpCount + moneyCount));
                lore.add(this.miniMessage.deserialize((Object)("<!italic>" + formatted)));
            }
            meta.lore(lore);
            item.setItemMeta(meta);
            Iterator<Object> iterator = nav.infoItem.slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= gui.getSize()) continue;
                gui.setItem(slot, item);
            }
        }
    }

    private ItemStack createNavigationItem(BoostMenuConfig.NavigationItemConfig itemConfig) {
        ItemStack item = new ItemStack(itemConfig.material);
        ItemMeta meta = item.getItemMeta();
        Component displayName = this.miniMessage.deserialize((Object)("<!italic>" + itemConfig.displayName));
        meta.displayName(displayName);
        if (!itemConfig.lore.isEmpty()) {
            List lore = itemConfig.lore.stream().map(line -> this.miniMessage.deserialize((Object)("<!italic>" + line))).collect(Collectors.toList());
            meta.lore(lore);
        }
        if (itemConfig.glow) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        item.setItemMeta(meta);
        return item;
    }

    private void playSound(Player player, BoostMenuConfig.SoundConfig soundConfig) {
        if (soundConfig != null && soundConfig.enabled && soundConfig.sound != null) {
            player.playSound(player.getLocation(), soundConfig.sound, soundConfig.volume, soundConfig.pitch);
        }
    }

    public void reloadConfig() {
        this.plugin.getMenuManager().reloadConfigurations();
    }

    public Inventory getInventory() {
        return this.currentInventory;
    }

    public boolean isInventory(Inventory inventory) {
        return inventory != null && inventory.getHolder() == this;
    }
}

