/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.AsyncMenuLoader;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.BoostManagerGui;
import fr.ax_dev.universejobs.menu.ComponentCache;
import fr.ax_dev.universejobs.menu.InventoryPool;
import fr.ax_dev.universejobs.menu.MenuConfig;
import fr.ax_dev.universejobs.menu.MenuScheduler;
import fr.ax_dev.universejobs.menu.OptimizedEventHandler;
import fr.ax_dev.universejobs.menu.config.JobSlotManager;
import fr.ax_dev.universejobs.menu.impl.GlobalRankingsMenu;
import fr.ax_dev.universejobs.menu.impl.JobActionsMenu;
import fr.ax_dev.universejobs.menu.impl.JobsMainMenu;
import fr.ax_dev.universejobs.menu.impl.SingleJobMenu;
import fr.ax_dev.universejobs.utils.PluginAccessor;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class MenuManager {
    private final UniverseJobs plugin;
    private final Map<UUID, BaseMenu> openMenus;
    private final Map<UUID, BoostManagerGui> openBoostGuis;
    private final MenuConfig menuConfig;
    private final JobSlotManager jobSlotManager;
    private final AsyncMenuLoader asyncLoader;
    private final InventoryPool inventoryPool;
    private final ComponentCache componentCache;
    private final OptimizedEventHandler eventHandler;
    private final MenuScheduler scheduler;

    public MenuManager(UniverseJobs plugin) {
        this.plugin = plugin;
        this.openMenus = new ConcurrentHashMap<UUID, BaseMenu>();
        this.openBoostGuis = new ConcurrentHashMap<UUID, BoostManagerGui>();
        this.menuConfig = new MenuConfig(plugin);
        this.jobSlotManager = new JobSlotManager(plugin);
        this.asyncLoader = new AsyncMenuLoader(plugin);
        this.inventoryPool = new InventoryPool();
        this.componentCache = new ComponentCache();
        this.eventHandler = new OptimizedEventHandler(this);
        this.scheduler = new MenuScheduler(plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.eventHandler, (Plugin)plugin);
        this.menuConfig.loadConfigurations();
        this.jobSlotManager.initialize(this.menuConfig);
        this.componentCache.preWarm();
    }

    public void openJobsMainMenu(Player player) {
        this.closeCurrentMenu(player);
        this.eventHandler.registerActivePlayer(player.getUniqueId());
        this.scheduler.runAsync(() -> this.asyncLoader.preloadJobsMainMenuData(player));
        this.scheduler.runSync(() -> {
            JobsMainMenu menu = new JobsMainMenu(this.plugin, player, this.menuConfig.getMainMenuConfig(), this.jobSlotManager);
            this.openMenus.put(player.getUniqueId(), menu);
            menu.open();
        });
    }

    public void openJobMenu(Player player, String jobId) {
        this.closeCurrentMenu(player);
        PluginAccessor accessor = this.plugin.getAccessor();
        if (accessor.getJobManager().getJob(jobId) == null) {
            accessor.getLanguageManager().sendMessage(player, "job-not-found", jobId);
            return;
        }
        this.eventHandler.registerActivePlayer(player.getUniqueId());
        try {
            SingleJobMenu menu = new SingleJobMenu(this.plugin, player, jobId, this.menuConfig.getJobMenuConfig());
            this.openMenus.put(player.getUniqueId(), menu);
            menu.open();
        }
        catch (IllegalArgumentException e) {
            accessor.logWarning("Failed to create SingleJobMenu: " + e.getMessage());
        }
    }

    public void openJobActionsMenu(Player player, String jobId) {
        this.closeCurrentMenu(player);
        PluginAccessor accessor = this.plugin.getAccessor();
        if (accessor.getJobManager().getJob(jobId) == null) {
            accessor.getLanguageManager().sendMessage(player, "job-not-found", jobId);
            return;
        }
        this.eventHandler.registerActivePlayer(player.getUniqueId());
        try {
            JobActionsMenu menu = new JobActionsMenu(this.plugin, player, jobId, this.menuConfig.getActionsMenuConfig());
            this.openMenus.put(player.getUniqueId(), menu);
            menu.open();
        }
        catch (IllegalArgumentException e) {
            accessor.logWarning("Failed to create JobActionsMenu: " + e.getMessage());
        }
    }

    public void openRewardsMenu(Player player, String jobId) {
        this.closeCurrentMenu(player);
        PluginAccessor accessor = this.plugin.getAccessor();
        if (accessor.getJobManager().getJob(jobId) == null) {
            accessor.getLanguageManager().sendMessage(player, "job-not-found", jobId);
            return;
        }
        accessor.getRewardGuiManager().openRewardsGui(player, jobId);
    }

    public void openGlobalRankingsMenu(Player player) {
        this.openGlobalRankingsMenu(player, null);
    }

    public void openGlobalRankingsMenu(Player player, String preSelectedJob) {
        this.closeCurrentMenu(player);
        this.eventHandler.registerActivePlayer(player.getUniqueId());
        GlobalRankingsMenu menu = new GlobalRankingsMenu(this.plugin, player, this.menuConfig.getRankingsMenuConfig(), preSelectedJob);
        this.openMenus.put(player.getUniqueId(), menu);
        if (menu.isReady()) {
            menu.open();
        }
    }

    public void closeCurrentMenu(Player player) {
        BoostManagerGui currentBoostGui;
        UUID playerId = player.getUniqueId();
        BaseMenu currentMenu = this.openMenus.remove(playerId);
        if (currentMenu != null) {
            currentMenu.close();
        }
        if ((currentBoostGui = this.openBoostGuis.remove(playerId)) != null) {
            currentBoostGui.onInventoryClose(player);
            player.closeInventory();
        }
        this.eventHandler.unregisterActivePlayer(playerId);
        this.componentCache.clearPlayer(playerId.toString());
    }

    public Inventory getInventoryFromPool(int size, Component title, InventoryHolder holder) {
        return this.inventoryPool.getInventory(size, title, holder);
    }

    public void returnInventoryToPool(Inventory inventory) {
        this.inventoryPool.returnInventory(inventory);
    }

    public ComponentCache getComponentCache() {
        return this.componentCache;
    }

    public MenuScheduler getScheduler() {
        return this.scheduler;
    }

    public UniverseJobs getPlugin() {
        return this.plugin;
    }

    public void registerBoostGui(Player player, BoostManagerGui boostGui) {
        this.closeCurrentMenu(player);
        this.eventHandler.registerActivePlayer(player.getUniqueId());
        this.openBoostGuis.put(player.getUniqueId(), boostGui);
    }

    public void unregisterBoostGui(Player player) {
        BoostManagerGui boostGui = this.openBoostGuis.remove(player.getUniqueId());
        if (boostGui != null) {
            boostGui.onInventoryClose(player);
        }
    }

    public BoostManagerGui getCurrentBoostGui(Player player) {
        return this.openBoostGuis.get(player.getUniqueId());
    }

    public void closeAllMenus() {
        this.openMenus.values().forEach(BaseMenu::close);
        this.openMenus.clear();
        for (Map.Entry<UUID, BoostManagerGui> entry : this.openBoostGuis.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            entry.getValue().onInventoryClose(player);
            player.closeInventory();
        }
        this.openBoostGuis.clear();
    }

    public void reloadConfigurations() {
        this.menuConfig.loadConfigurations();
        this.jobSlotManager.reload();
    }

    public MenuConfig getMenuConfig() {
        return this.menuConfig;
    }

    public JobSlotManager getJobSlotManager() {
        return this.jobSlotManager;
    }

    public void refreshPlayerMenu(Player player) {
        BaseMenu menu = this.openMenus.get(player.getUniqueId());
        if (menu != null) {
            menu.refresh();
        }
    }

    public void shutdown() {
        for (BaseMenu menu : this.openMenus.values()) {
            if (menu == null) continue;
            menu.close();
        }
        this.openMenus.clear();
        for (BoostManagerGui gui : this.openBoostGuis.values()) {
            if (gui == null) continue;
        }
        this.openBoostGuis.clear();
        this.scheduler.shutdown();
        this.inventoryPool.shutdown();
        this.componentCache.clear();
        this.eventHandler.shutdown();
        this.asyncLoader.shutdown();
    }

    public String getPerformanceStats() {
        return String.format("MenuManager Stats: Active Menus: %d, Pool Size: %d, Component Cache: %d items, Active Menu Players: %d, Scheduler: %s", this.openMenus.size(), this.inventoryPool.getPoolSize(), this.componentCache.getComponentCacheSize(), this.eventHandler.getActiveMenuCount(), this.scheduler.getStats().toString());
    }

    public boolean hasMenuOpen(Player player) {
        return this.openMenus.containsKey(player.getUniqueId());
    }

    public BaseMenu getCurrentMenu(Player player) {
        return this.openMenus.get(player.getUniqueId());
    }
}

