/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.bukkit.Bukkit;

public class MenuScheduler {
    private final UniverseJobs plugin;
    private final ScheduledExecutorService asyncExecutor;
    private final ExecutorService fastExecutor;
    private final AtomicLong tasksExecuted = new AtomicLong(0L);
    private final AtomicInteger activeAsyncTasks = new AtomicInteger(0);
    private static final int ASYNC_CORE_THREADS = Math.max(2, Runtime.getRuntime().availableProcessors() / 4);
    private static final int FAST_CORE_THREADS = Math.max(1, Runtime.getRuntime().availableProcessors() / 8);

    public MenuScheduler(UniverseJobs plugin) {
        this.plugin = plugin;
        this.asyncExecutor = Executors.newScheduledThreadPool(ASYNC_CORE_THREADS, r -> {
            Thread thread = new Thread(r);
            thread.setName("UniverseJobs-MenuAsync-" + thread.getId());
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        });
        this.fastExecutor = Executors.newFixedThreadPool(FAST_CORE_THREADS, r -> {
            Thread thread = new Thread(r);
            thread.setName("UniverseJobs-MenuFast-" + thread.getId());
            thread.setDaemon(true);
            thread.setPriority(4);
            return thread;
        });
    }

    public CompletableFuture<Void> runAsync(Runnable task) {
        return CompletableFuture.runAsync(() -> {
            this.activeAsyncTasks.incrementAndGet();
            try {
                task.run();
                this.tasksExecuted.incrementAndGet();
            }
            finally {
                this.activeAsyncTasks.decrementAndGet();
            }
        }, this.asyncExecutor);
    }

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            this.activeAsyncTasks.incrementAndGet();
            try {
                Object result = supplier.get();
                this.tasksExecuted.incrementAndGet();
                Object t = result;
                return t;
            }
            finally {
                this.activeAsyncTasks.decrementAndGet();
            }
        }, this.asyncExecutor);
    }

    public void runSync(Runnable task) {
        if (Bukkit.isPrimaryThread()) {
            task.run();
        } else {
            this.plugin.getFoliaManager().runNextTick(task);
        }
    }

    public <T> CompletableFuture<T> supplySync(Supplier<T> supplier) {
        if (Bukkit.isPrimaryThread()) {
            return CompletableFuture.completedFuture(supplier.get());
        }
        CompletableFuture future = new CompletableFuture();
        this.plugin.getFoliaManager().runNextTick(() -> {
            try {
                future.complete(supplier.get());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public void runFast(Runnable task) {
        this.fastExecutor.execute(() -> {
            try {
                task.run();
                this.tasksExecuted.incrementAndGet();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Fast task failed: " + e.getMessage());
            }
        });
    }

    public ScheduledFuture<?> scheduleRepeating(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.asyncExecutor.scheduleAtFixedRate(() -> {
            this.activeAsyncTasks.incrementAndGet();
            try {
                task.run();
                this.tasksExecuted.incrementAndGet();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Scheduled task failed: " + e.getMessage());
            }
            finally {
                this.activeAsyncTasks.decrementAndGet();
            }
        }, initialDelay, period, unit);
    }

    public CompletableFuture<Void> runBatch(Runnable ... tasks) {
        return CompletableFuture.runAsync(() -> {
            this.activeAsyncTasks.incrementAndGet();
            try {
                for (Runnable task : tasks) {
                    task.run();
                }
                this.tasksExecuted.addAndGet(tasks.length);
            }
            finally {
                this.activeAsyncTasks.decrementAndGet();
            }
        }, this.asyncExecutor);
    }

    public CompletableFuture<Void> runAsyncWithTimeout(Runnable task, long timeout, TimeUnit unit) {
        return this.runAsync(task).orTimeout(timeout, unit);
    }

    public MenuSchedulerStats getStats() {
        return new MenuSchedulerStats(this.tasksExecuted.get(), this.activeAsyncTasks.get(), ((ThreadPoolExecutor)((Object)this.asyncExecutor)).getActiveCount(), ((ThreadPoolExecutor)this.fastExecutor).getActiveCount());
    }

    public void shutdown() {
        this.asyncExecutor.shutdown();
        this.fastExecutor.shutdown();
        try {
            if (!this.asyncExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.asyncExecutor.shutdownNow();
            }
            if (!this.fastExecutor.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.fastExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.asyncExecutor.shutdownNow();
            this.fastExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static class MenuSchedulerStats {
        public final long totalTasksExecuted;
        public final int activeAsyncTasks;
        public final int activeAsyncThreads;
        public final int activeFastThreads;

        public MenuSchedulerStats(long totalTasksExecuted, int activeAsyncTasks, int activeAsyncThreads, int activeFastThreads) {
            this.totalTasksExecuted = totalTasksExecuted;
            this.activeAsyncTasks = activeAsyncTasks;
            this.activeAsyncThreads = activeAsyncThreads;
            this.activeFastThreads = activeFastThreads;
        }

        public String toString() {
            return String.format("MenuScheduler{tasks=%d, async=%d, threads=%d/%d}", this.totalTasksExecuted, this.activeAsyncTasks, this.activeAsyncThreads, this.activeFastThreads);
        }
    }
}

