/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.BoostManagerGui;
import fr.ax_dev.universejobs.menu.MenuManager;
import fr.ax_dev.universejobs.menu.OptimizedMenuHolder;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.InventoryHolder;

public class OptimizedEventHandler
implements Listener {
    private final MenuManager menuManager;
    private final Set<UUID> activeMenuPlayers = ConcurrentHashMap.newKeySet();

    public OptimizedEventHandler(MenuManager menuManager) {
        this.menuManager = menuManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID playerId = player.getUniqueId();
        if (!this.activeMenuPlayers.contains(playerId)) {
            return;
        }
        if (event.getInventory() == null) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof OptimizedMenuHolder) {
            OptimizedMenuHolder menuHolder = (OptimizedMenuHolder)holder;
            if (!menuHolder.belongsTo(playerId)) {
                return;
            }
            event.setCancelled(true);
            BaseMenu menu = menuHolder.getMenu();
            if (menu != null) {
                try {
                    menu.handleClick(event.getSlot(), event);
                }
                catch (Exception e) {
                    this.menuManager.getPlugin().getLogger().severe("Error handling menu click: " + e.getMessage());
                }
            }
        } else if (holder instanceof BoostManagerGui) {
            BoostManagerGui boostGui = (BoostManagerGui)holder;
            event.setCancelled(true);
            int slot = event.getSlot();
            if (slot < 0 || slot >= event.getInventory().getSize()) {
                return;
            }
            boolean isRightClick = event.getClick() == ClickType.RIGHT;
            try {
                boostGui.handleClick(player, slot, isRightClick);
            }
            catch (Exception e) {
                this.menuManager.getPlugin().getLogger().severe("Error handling boost GUI click: " + e.getMessage());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID playerId = player.getUniqueId();
        this.activeMenuPlayers.remove(playerId);
        if (event.getInventory() == null) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof OptimizedMenuHolder) {
            OptimizedMenuHolder menuHolder = (OptimizedMenuHolder)holder;
            if (menuHolder.belongsTo(playerId)) {
                BaseMenu menu = menuHolder.getMenu();
                if (menu != null) {
                    menu.onClose();
                }
                this.menuManager.returnInventoryToPool(event.getInventory());
            }
        } else if (holder instanceof BoostManagerGui) {
            BoostManagerGui boostGui = (BoostManagerGui)holder;
            boostGui.onInventoryClose(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID playerId = player.getUniqueId();
        if (!this.activeMenuPlayers.contains(playerId)) {
            return;
        }
        if (event.getInventory() == null) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof OptimizedMenuHolder) {
            OptimizedMenuHolder menuHolder = (OptimizedMenuHolder)holder;
            if (menuHolder.belongsTo(playerId)) {
                event.setCancelled(true);
            }
        } else if (holder instanceof BoostManagerGui) {
            event.setCancelled(true);
        }
    }

    public void registerActivePlayer(UUID playerId) {
        this.activeMenuPlayers.add(playerId);
    }

    public void unregisterActivePlayer(UUID playerId) {
        this.activeMenuPlayers.remove(playerId);
    }

    public boolean hasActiveMenu(UUID playerId) {
        return this.activeMenuPlayers.contains(playerId);
    }

    public int getActiveMenuCount() {
        return this.activeMenuPlayers.size();
    }

    public void shutdown() {
        this.activeMenuPlayers.clear();
    }
}

