/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.config;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.utils.EnumUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class BoostMenuConfig {
    private final UniverseJobs plugin;
    private YamlConfiguration config;
    private String title = "<gold><b>Boost Manager</b></gold>";
    private int size = 54;
    private BoostItemConfig xpBoostConfig;
    private BoostItemConfig moneyBoostConfig;
    private FillerConfig fillerConfig;
    private NavigationConfig navigationConfig;
    private Map<String, CustomItemConfig> customItems;
    private AutoRefreshConfig autoRefreshConfig;
    private SoundsConfig soundsConfig;

    public BoostMenuConfig(UniverseJobs plugin) {
        this.plugin = plugin;
        this.customItems = new HashMap<String, CustomItemConfig>();
    }

    public void loadConfiguration() {
        File configFile = new File(this.plugin.getDataFolder(), "menus/boost-manager.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("menus/boost-manager.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        this.loadBasicSettings();
        this.loadBoostConfigs();
        this.loadFillerConfig();
        this.loadNavigationConfig();
        this.loadCustomItems();
        this.loadAutoRefreshConfig();
        this.loadSoundsConfig();
    }

    private void loadBasicSettings() {
        this.title = this.config.getString("title", "<gold><b>Boost Manager</b></gold>");
        this.size = this.config.getInt("size", 54);
    }

    private void loadBoostConfigs() {
        ConfigurationSection moneySection;
        ConfigurationSection xpSection = this.config.getConfigurationSection("xp-boosts");
        if (xpSection != null) {
            this.xpBoostConfig = new BoostItemConfig();
            this.xpBoostConfig.enabled = xpSection.getBoolean("enabled", true);
            this.xpBoostConfig.slots = xpSection.getIntegerList("slots");
            ConfigurationSection itemSection = xpSection.getConfigurationSection("item");
            if (itemSection != null) {
                this.xpBoostConfig.material = EnumUtils.parseMaterial(itemSection.getString("material", "EXPERIENCE_BOTTLE"), Material.EXPERIENCE_BOTTLE);
                this.xpBoostConfig.displayName = itemSection.getString("display-name", "<!italic><white>XP Boost <gold>{boost_id}</gold></white>");
                this.xpBoostConfig.lore = itemSection.getStringList("lore");
                this.xpBoostConfig.glow = itemSection.getBoolean("glow", false);
                this.xpBoostConfig.customModelData = itemSection.getInt("custom-model-data", 0);
            }
        }
        if ((moneySection = this.config.getConfigurationSection("money-boosts")) != null) {
            this.moneyBoostConfig = new BoostItemConfig();
            this.moneyBoostConfig.enabled = moneySection.getBoolean("enabled", true);
            this.moneyBoostConfig.slots = moneySection.getIntegerList("slots");
            ConfigurationSection itemSection = moneySection.getConfigurationSection("item");
            if (itemSection != null) {
                this.moneyBoostConfig.material = EnumUtils.parseMaterial(itemSection.getString("material", "GOLD_INGOT"), Material.GOLD_INGOT);
                this.moneyBoostConfig.displayName = itemSection.getString("display-name", "<!italic><white>Money Boost <gold>{boost_id}</gold></white>");
                this.moneyBoostConfig.lore = itemSection.getStringList("lore");
                this.moneyBoostConfig.glow = itemSection.getBoolean("glow", false);
                this.moneyBoostConfig.customModelData = itemSection.getInt("custom-model-data", 0);
            }
        }
    }

    private void loadFillerConfig() {
        ConfigurationSection fillerSection = this.config.getConfigurationSection("filler");
        if (fillerSection != null) {
            this.fillerConfig = new FillerConfig();
            this.fillerConfig.enabled = fillerSection.getBoolean("enabled", true);
            this.fillerConfig.material = EnumUtils.parseMaterial(fillerSection.getString("material", "GRAY_STAINED_GLASS_PANE"), Material.GRAY_STAINED_GLASS_PANE);
            this.fillerConfig.displayName = fillerSection.getString("display-name", "<!italic><gray> </gray>");
            this.fillerConfig.lore = fillerSection.getStringList("lore");
            this.fillerConfig.slots = fillerSection.getIntegerList("slots");
        }
    }

    private void loadNavigationConfig() {
        ConfigurationSection navSection = this.config.getConfigurationSection("navigation");
        if (navSection != null) {
            this.navigationConfig = new NavigationConfig();
            this.navigationConfig.closeItem = new NavigationItemConfig();
            this.loadNavigationItem(navSection.getConfigurationSection("close"), this.navigationConfig.closeItem);
            this.navigationConfig.refreshItem = new NavigationItemConfig();
            this.loadNavigationItem(navSection.getConfigurationSection("refresh"), this.navigationConfig.refreshItem);
            this.navigationConfig.infoItem = new NavigationItemConfig();
            this.loadNavigationItem(navSection.getConfigurationSection("info"), this.navigationConfig.infoItem);
        }
    }

    private void loadNavigationItem(ConfigurationSection section, NavigationItemConfig item) {
        if (section != null) {
            item.enabled = section.getBoolean("enabled", true);
            item.slots = section.getIntegerList("slots");
            item.material = EnumUtils.parseMaterial(section.getString("material", "BARRIER"), Material.BARRIER);
            item.displayName = section.getString("display-name", "");
            item.lore = section.getStringList("lore");
            item.glow = section.getBoolean("glow", false);
        }
    }

    private void loadCustomItems() {
        ConfigurationSection customSection = this.config.getConfigurationSection("custom-items");
        if (customSection != null) {
            for (String key : customSection.getKeys(false)) {
                ConfigurationSection itemSection = customSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                CustomItemConfig customItem = new CustomItemConfig();
                customItem.enabled = itemSection.getBoolean("enabled", true);
                customItem.slots = itemSection.getIntegerList("slots");
                customItem.material = EnumUtils.parseMaterial(itemSection.getString("material", "STONE"), Material.STONE);
                customItem.displayName = itemSection.getString("display-name", "");
                customItem.lore = itemSection.getStringList("lore");
                this.customItems.put(key, customItem);
            }
        }
    }

    private void loadAutoRefreshConfig() {
        ConfigurationSection refreshSection = this.config.getConfigurationSection("auto-refresh");
        if (refreshSection != null) {
            this.autoRefreshConfig = new AutoRefreshConfig();
            this.autoRefreshConfig.enabled = refreshSection.getBoolean("enabled", true);
            this.autoRefreshConfig.interval = refreshSection.getInt("interval", 20);
        }
    }

    private void loadSoundsConfig() {
        ConfigurationSection soundsSection = this.config.getConfigurationSection("sounds");
        if (soundsSection != null) {
            this.soundsConfig = new SoundsConfig();
            this.soundsConfig.openSound = new SoundConfig();
            this.loadSoundConfig(soundsSection.getConfigurationSection("open"), this.soundsConfig.openSound);
            this.soundsConfig.removeBoostSound = new SoundConfig();
            this.loadSoundConfig(soundsSection.getConfigurationSection("remove-boost"), this.soundsConfig.removeBoostSound);
            this.soundsConfig.closeSound = new SoundConfig();
            this.loadSoundConfig(soundsSection.getConfigurationSection("close"), this.soundsConfig.closeSound);
        }
    }

    private void loadSoundConfig(ConfigurationSection section, SoundConfig sound) {
        if (section != null) {
            sound.enabled = section.getBoolean("enabled", true);
            sound.sound = this.parseSoundSafely(section.getString("sound", "UI_BUTTON_CLICK"));
            sound.volume = (float)section.getDouble("volume", 0.5);
            sound.pitch = (float)section.getDouble("pitch", 1.0);
        }
    }

    private Sound parseSoundSafely(String soundName) {
        if (soundName == null || soundName.isEmpty()) {
            return Sound.UI_BUTTON_CLICK;
        }
        try {
            try {
                NamespacedKey key = NamespacedKey.minecraft((String)soundName.toLowerCase().replace("_", "."));
                Field soundsField = Registry.class.getField("SOUNDS");
                Object soundsRegistry = soundsField.get(null);
                Method getMethod = soundsRegistry.getClass().getMethod("get", NamespacedKey.class);
                Object result = getMethod.invoke(soundsRegistry, key);
                if (result instanceof Sound) {
                    return (Sound)result;
                }
            }
            catch (NoSuchFieldException key) {
            }
            catch (Exception key) {
                // empty catch block
            }
            try {
                Method valueOfMethod = Sound.class.getMethod("valueOf", String.class);
                Object result = valueOfMethod.invoke(null, soundName.toUpperCase());
                if (result instanceof Sound) {
                    return (Sound)result;
                }
            }
            catch (Exception valueOfMethod) {
                // empty catch block
            }
            try {
                Field field = Sound.class.getField(soundName.toUpperCase());
                if (field.getType() == Sound.class) {
                    return (Sound)field.get(null);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Sound.UI_BUTTON_CLICK;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public BoostItemConfig getXpBoostConfig() {
        return this.xpBoostConfig;
    }

    public BoostItemConfig getMoneyBoostConfig() {
        return this.moneyBoostConfig;
    }

    public FillerConfig getFillerConfig() {
        return this.fillerConfig;
    }

    public NavigationConfig getNavigationConfig() {
        return this.navigationConfig;
    }

    public Map<String, CustomItemConfig> getCustomItems() {
        return this.customItems;
    }

    public AutoRefreshConfig getAutoRefreshConfig() {
        return this.autoRefreshConfig;
    }

    public SoundsConfig getSoundsConfig() {
        return this.soundsConfig;
    }

    public static class BoostItemConfig {
        public boolean enabled = true;
        public List<Integer> slots = new ArrayList<Integer>();
        public Material material = Material.EXPERIENCE_BOTTLE;
        public String displayName = "";
        public List<String> lore = new ArrayList<String>();
        public boolean glow = false;
        public int customModelData = 0;
    }

    public static class FillerConfig {
        public boolean enabled = true;
        public Material material = Material.GRAY_STAINED_GLASS_PANE;
        public String displayName = "";
        public List<String> lore = new ArrayList<String>();
        public List<Integer> slots = new ArrayList<Integer>();
    }

    public static class NavigationConfig {
        public NavigationItemConfig closeItem = new NavigationItemConfig();
        public NavigationItemConfig refreshItem = new NavigationItemConfig();
        public NavigationItemConfig infoItem = new NavigationItemConfig();
    }

    public static class NavigationItemConfig {
        public boolean enabled = true;
        public List<Integer> slots = new ArrayList<Integer>();
        public Material material = Material.BARRIER;
        public String displayName = "";
        public List<String> lore = new ArrayList<String>();
        public boolean glow = false;
    }

    public static class CustomItemConfig {
        public boolean enabled = true;
        public List<Integer> slots = new ArrayList<Integer>();
        public Material material = Material.STONE;
        public String displayName = "";
        public List<String> lore = new ArrayList<String>();
    }

    public static class AutoRefreshConfig {
        public boolean enabled = true;
        public int interval = 20;
    }

    public static class SoundsConfig {
        public SoundConfig openSound = new SoundConfig();
        public SoundConfig removeBoostSound = new SoundConfig();
        public SoundConfig closeSound = new SoundConfig();
    }

    public static class SoundConfig {
        public boolean enabled = true;
        public Sound sound = Sound.UI_BUTTON_CLICK;
        public float volume = 0.5f;
        public float pitch = 1.0f;
    }
}

