/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.config;

import fr.ax_dev.universejobs.menu.config.ActionItemFormat;
import fr.ax_dev.universejobs.menu.config.JobItemFormat;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class SingleMenuConfig {
    private final String title;
    private final int size;
    private final MenuItemConfig fillItem;
    private final List<Integer> fillSlots;
    private final List<Integer> contentSlots;
    private final Map<String, MenuItemConfig> staticItems;
    private final Map<String, MenuItemConfig> navigationItems;
    private final Map<String, MenuItemConfig> menuItems;
    private final boolean enablePagination;
    private final int itemsPerPage;
    private final JobItemFormat jobItemFormat;
    private final ActionItemFormat actionItemFormat;
    private final Map<String, Integer> jobSlots;
    private final ConfigurationSection rawConfig;

    public SingleMenuConfig(ConfigurationSection config) {
        this(config, null);
    }

    public SingleMenuConfig(ConfigurationSection config, ConfigurationSection globalDefaults) {
        ConfigurationSection jobFormatSection;
        this.rawConfig = config;
        this.title = config.getString("title", "&6Jobs Menu");
        this.size = config.getInt("size", 54);
        this.enablePagination = config.getBoolean("pagination.enabled", true);
        this.itemsPerPage = config.getInt("pagination.items-per-page", 28);
        ConfigurationSection fillSection = config.getConfigurationSection("fill-item");
        this.fillItem = fillSection != null && fillSection.getBoolean("enabled", false) ? new MenuItemConfig(fillSection, globalDefaults) : null;
        this.fillSlots = config.getIntegerList("fill-slots");
        if (this.fillSlots.isEmpty()) {
            for (int i = 0; i < this.size; ++i) {
                this.fillSlots.add(i);
            }
        }
        this.contentSlots = config.getIntegerList("content-slots");
        if (this.contentSlots.isEmpty()) {
            this.generateDefaultContentSlots();
        }
        this.staticItems = new HashMap<String, MenuItemConfig>();
        ConfigurationSection staticSection = config.getConfigurationSection("static-items");
        if (staticSection != null) {
            for (Object itemKey : staticSection.getKeys(false)) {
                ConfigurationSection itemSection = staticSection.getConfigurationSection((String)itemKey);
                if (itemSection == null) continue;
                this.staticItems.put((String)itemKey, new MenuItemConfig(itemSection, globalDefaults));
            }
        }
        this.navigationItems = new HashMap<String, MenuItemConfig>();
        ConfigurationSection navItemsSection = config.getConfigurationSection("navigation-items");
        if (navItemsSection != null) {
            for (Object itemKey : navItemsSection.getKeys(false)) {
                ConfigurationSection itemSection = navItemsSection.getConfigurationSection((String)itemKey);
                if (itemSection == null) continue;
                this.navigationItems.put((String)itemKey, new MenuItemConfig(itemSection, globalDefaults));
            }
        } else {
            this.generateDefaultNavigationItems();
        }
        this.menuItems = new HashMap<String, MenuItemConfig>();
        ConfigurationSection menuItemsSection = config.getConfigurationSection("menu-items");
        if (menuItemsSection != null) {
            for (String itemKey : menuItemsSection.getKeys(false)) {
                ConfigurationSection itemSection = menuItemsSection.getConfigurationSection(itemKey);
                if (itemSection == null) continue;
                this.menuItems.put(itemKey, new MenuItemConfig(itemSection, globalDefaults));
            }
        }
        this.jobItemFormat = (jobFormatSection = config.getConfigurationSection("job-item-format")) != null ? new JobItemFormat(jobFormatSection) : JobItemFormat.getDefault();
        ConfigurationSection actionFormatSection = config.getConfigurationSection("action-item-format");
        this.actionItemFormat = actionFormatSection != null ? new ActionItemFormat(actionFormatSection) : new ActionItemFormat();
        this.jobSlots = new HashMap<String, Integer>();
        ConfigurationSection jobSlotsSection = config.getConfigurationSection("job-slots");
        if (jobSlotsSection != null) {
            for (String jobId : jobSlotsSection.getKeys(false)) {
                int slot = jobSlotsSection.getInt(jobId);
                if (slot < 0 || slot >= this.size) continue;
                this.jobSlots.put(jobId, slot);
            }
        }
    }

    private void generateDefaultContentSlots() {
        for (int row = 1; row < this.size / 9 - 1; ++row) {
            for (int col = 1; col < 8; ++col) {
                this.contentSlots.add(row * 9 + col);
            }
        }
    }

    private void generateDefaultNavigationItems() {
        this.navigationItems.put("previous", MenuItemConfig.navigationItem("ARROW", "&e\u2190 Previous Page", "previous_page", Arrays.asList(45), "&7Click to go to the previous page"));
        this.navigationItems.put("next", MenuItemConfig.navigationItem("ARROW", "&eNext Page \u2192", "next_page", Arrays.asList(53), "&7Click to go to the next page"));
        this.navigationItems.put("close", MenuItemConfig.navigationItem("BARRIER", "&cClose", "close", Arrays.asList(49), "&7Click to close this menu"));
        this.navigationItems.put("back", MenuItemConfig.navigationItem("ARROW", "&7\u2190 Back", "back", Arrays.asList(48), "&7Click to go back"));
        this.navigationItems.put("info", MenuItemConfig.navigationItem("BOOK", "&6Info", "none", Arrays.asList(50), "&7Menu Information", "&8Page: {current_page}/{total_pages}"));
    }

    public static SingleMenuConfig getDefaultMainMenu() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("title", "&6&lJobs Menu");
        configMap.put("size", 54);
        HashMap<String, Comparable<Boolean>> pagination = new HashMap<String, Comparable<Boolean>>();
        pagination.put("enabled", Boolean.valueOf(true));
        pagination.put("items-per-page", Integer.valueOf(28));
        configMap.put("pagination", pagination);
        return new SingleMenuConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
    }

    public static SingleMenuConfig getDefaultJobMenu() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("title", "&6&l{job_name} Menu");
        configMap.put("size", 45);
        HashMap<String, Comparable<Boolean>> pagination = new HashMap<String, Comparable<Boolean>>();
        pagination.put("enabled", Boolean.valueOf(false));
        pagination.put("items-per-page", Integer.valueOf(21));
        configMap.put("pagination", pagination);
        return new SingleMenuConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
    }

    public static SingleMenuConfig getDefaultActionsMenu() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("title", "&6&l{job_name} Actions & Rewards");
        configMap.put("size", 54);
        HashMap<String, Comparable<Boolean>> pagination = new HashMap<String, Comparable<Boolean>>();
        pagination.put("enabled", Boolean.valueOf(true));
        pagination.put("items-per-page", Integer.valueOf(35));
        configMap.put("pagination", pagination);
        return new SingleMenuConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
    }

    public static SingleMenuConfig getDefaultRankingsMenu() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("title", "&6&lGlobal Rankings");
        configMap.put("size", 54);
        HashMap<String, Comparable<Boolean>> pagination = new HashMap<String, Comparable<Boolean>>();
        pagination.put("enabled", Boolean.valueOf(true));
        pagination.put("items-per-page", Integer.valueOf(35));
        configMap.put("pagination", pagination);
        return new SingleMenuConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public MenuItemConfig getFillItem() {
        return this.fillItem;
    }

    public List<Integer> getFillSlots() {
        return new ArrayList<Integer>(this.fillSlots);
    }

    public List<Integer> getContentSlots() {
        return new ArrayList<Integer>(this.contentSlots);
    }

    public Map<String, MenuItemConfig> getStaticItems() {
        return new HashMap<String, MenuItemConfig>(this.staticItems);
    }

    public Map<String, MenuItemConfig> getNavigationItems() {
        return new HashMap<String, MenuItemConfig>(this.navigationItems);
    }

    public Map<String, MenuItemConfig> getMenuItems() {
        return new HashMap<String, MenuItemConfig>(this.menuItems);
    }

    public boolean isEnablePagination() {
        return this.enablePagination;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public JobItemFormat getJobItemFormat() {
        return this.jobItemFormat;
    }

    public ActionItemFormat getActionItemFormat() {
        return this.actionItemFormat;
    }

    public Map<String, Integer> getJobSlots() {
        return new HashMap<String, Integer>(this.jobSlots);
    }

    public ConfigurationSection getRawConfig() {
        return this.rawConfig;
    }
}

