/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.impl;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.menu.utils.MenuItemUtils;
import fr.ax_dev.universejobs.storage.dao.LeaderboardDao;
import fr.ax_dev.universejobs.utils.NBTItemUtils;
import fr.ax_dev.universejobs.utils.PlayerTextureCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GlobalRankingsMenu
extends BaseMenu {
    private final Map<String, List<RankingEntry>> jobRankings = new HashMap<String, List<RankingEntry>>();
    private final List<String> availableJobs;
    private String selectedJob;

    public GlobalRankingsMenu(UniverseJobs plugin, Player player, SingleMenuConfig config) {
        this(plugin, player, config, null);
    }

    public GlobalRankingsMenu(UniverseJobs plugin, Player player, SingleMenuConfig config, String preSelectedJob) {
        super(plugin, player, config);
        this.availableJobs = plugin.getJobManager().getJobs().values().stream().filter(Job::isEnabled).map(Job::getId).sorted().collect(Collectors.toList());
        if (preSelectedJob != null && this.availableJobs.contains(preSelectedJob)) {
            this.selectedJob = preSelectedJob;
        } else {
            String string = this.selectedJob = this.availableJobs.isEmpty() ? null : this.availableJobs.stream().filter(jobId -> !jobId.startsWith("_")).findFirst().orElse(this.availableJobs.get(0));
        }
        if (!plugin.isDatabaseEnabled()) {
            for (String jobId2 : this.availableJobs) {
                this.jobRankings.put(jobId2, this.calculateJobRankingsFromMemory(jobId2));
            }
            this.initialize();
        } else {
            CompletableFuture<Void> loadFuture = this.loadRankingsAsync();
            loadFuture.thenRun(() -> plugin.getFoliaManager().runAtEntity((Entity)player, () -> {
                this.initialize();
                this.open();
            }));
        }
    }

    public boolean isReady() {
        return this.inventory != null;
    }

    private CompletableFuture<Void> loadRankingsAsync() {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (String jobId : this.availableJobs) {
            CompletionStage future = ((CompletableFuture)this.plugin.getDataStorage().getJobLeaderboard(jobId, 100).thenAccept(entries -> {
                ArrayList<RankingEntry> rankings = new ArrayList<RankingEntry>(entries.size());
                for (int i = 0; i < entries.size(); ++i) {
                    LeaderboardDao.LeaderboardEntry entry = (LeaderboardDao.LeaderboardEntry)entries.get(i);
                    RankingEntry rankEntry = new RankingEntry(entry.getPlayerId(), entry.getPlayerName(), entry.getLevel(), (long)entry.getXp());
                    rankEntry.rank = i + 1;
                    rankings.add(rankEntry);
                    if (i >= 20) continue;
                    PlayerTextureCache.getPlayerProfile(entry.getPlayerId(), entry.getPlayerName());
                }
                this.jobRankings.put(jobId, rankings);
            })).exceptionally(ex -> {
                this.plugin.getLogger().warning("Failed to load rankings for " + jobId + ", using memory fallback: " + ex.getMessage());
                this.jobRankings.put(jobId, this.calculateJobRankingsFromMemory(jobId));
                return null;
            });
            futures.add(future);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private List<RankingEntry> calculateJobRankingsFromMemory(String jobId) {
        ArrayList<RankingEntry> rankings = new ArrayList<RankingEntry>(64);
        Map<UUID, PlayerJobData> allPlayerData = this.plugin.getJobManager().getAllPlayerData();
        for (Map.Entry<UUID, PlayerJobData> entry : allPlayerData.entrySet()) {
            UUID playerId = entry.getKey();
            PlayerJobData playerData = entry.getValue();
            if (!playerData.hasJob(jobId)) continue;
            int level = playerData.getLevel(jobId);
            long xp = (long)playerData.getXp(jobId);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerId);
            String playerName = offlinePlayer.getName();
            if (playerName == null) continue;
            rankings.add(new RankingEntry(playerId, playerName, level, xp));
        }
        rankings.sort((a, b) -> {
            int levelCompare = Integer.compare(b.level, a.level);
            if (levelCompare != 0) {
                return levelCompare;
            }
            return Long.compare(b.xp, a.xp);
        });
        for (int i = 0; i < rankings.size(); ++i) {
            ((RankingEntry)rankings.get((int)i)).rank = i + 1;
        }
        return rankings;
    }

    @Override
    protected void populateInventory() {
        this.inventory.clear();
        this.addJobSelectionButtons();
        this.addRankingEntries();
        this.addNavigationItems();
        this.addStaticItems();
        this.addFillItems();
    }

    private void addJobSelectionButtons() {
        if (this.availableJobs.isEmpty()) {
            return;
        }
        ConfigurationSection selectionConfig = this.config.getRawConfig().getConfigurationSection("job-selection");
        if (selectionConfig == null) {
            this.plugin.getLogger().warning("Missing job-selection configuration in rankings-menu.yml");
            return;
        }
        ConfigurationSection jobsConfig = selectionConfig.getConfigurationSection("jobs");
        Map<String, Integer> jobSlots = this.plugin.getMenuManager().getJobSlotManager().getAllJobSlots();
        for (String jobId : this.availableJobs) {
            ItemStack button;
            ConfigurationSection jobConfig;
            Job job = this.plugin.getJobManager().getJob(jobId);
            if (job == null) continue;
            Integer slot = null;
            if (jobsConfig != null && jobsConfig.contains(jobId) && (jobConfig = jobsConfig.getConfigurationSection(jobId)) != null && jobConfig.contains("slot")) {
                slot = jobConfig.getInt("slot");
            }
            if (slot == null && jobSlots.containsKey(jobId)) {
                slot = jobSlots.get(jobId);
            }
            if (slot == null || slot < 0 || slot >= this.inventory.getSize() || (button = this.createJobSelectionButton(job, jobId.equals(this.selectedJob), selectionConfig, jobsConfig)) == null) continue;
            this.inventory.setItem(slot.intValue(), button);
        }
    }

    private ItemStack createJobSelectionButton(Job job, boolean selected, ConfigurationSection selectionConfig, ConfigurationSection jobsConfig) {
        ConfigurationSection defaultFormat;
        ConfigurationSection jobConfig;
        String stateSuffix;
        List rankings = this.jobRankings.getOrDefault(job.getId(), new ArrayList());
        HashMap<String, String> placeholders = new HashMap<String, String>(16);
        placeholders.put("{job_id}", job.getId());
        placeholders.put("{job_name}", job.getName());
        placeholders.put("{job_material}", job.getIconMaterial() != null ? job.getIconMaterial() : "PAPER");
        placeholders.put("{job_custom-model-data}", String.valueOf(job.getCustomModelData()));
        placeholders.put("{player_count}", String.valueOf(rankings.size()));
        if (!rankings.isEmpty()) {
            RankingEntry topPlayer = (RankingEntry)rankings.get(0);
            placeholders.put("{top_player}", topPlayer.playerName);
            placeholders.put("{top_level}", String.valueOf(topPlayer.level));
        } else {
            placeholders.put("{top_player}", "None");
            placeholders.put("{top_level}", "0");
        }
        ConfigurationSection stateConfig = null;
        String string = stateSuffix = selected ? "selected" : "not_selected";
        if (jobsConfig != null && jobsConfig.contains(job.getId()) && (jobConfig = jobsConfig.getConfigurationSection(job.getId())) != null && jobConfig.contains(stateSuffix)) {
            stateConfig = jobConfig.getConfigurationSection(stateSuffix);
        }
        if (stateConfig == null && (defaultFormat = selectionConfig.getConfigurationSection("default-format")) != null && defaultFormat.contains(stateSuffix)) {
            stateConfig = defaultFormat.getConfigurationSection(stateSuffix);
        }
        if (stateConfig == null) {
            return this.createLegacyJobButton(job, selected, rankings.size());
        }
        HashMap<String, Object> configMap = new HashMap<String, Object>(16);
        String material = stateConfig.getString("material", job.getIconMaterial());
        if (material != null && material.equals("{job_material}")) {
            material = job.getIconMaterial() != null ? job.getIconMaterial() : "PAPER";
        }
        configMap.put("material", material);
        String customModelStr = stateConfig.getString("custom-model-data", "0");
        if (customModelStr.equals("{job_custom-model-data}")) {
            if (job.getCustomModelData() > 0) {
                configMap.put("custom-model-data", job.getCustomModelData());
            }
        } else {
            int customModelData = stateConfig.getInt("custom-model-data", 0);
            if (customModelData > 0) {
                configMap.put("custom-model-data", customModelData);
            } else if (job.getCustomModelData() > 0) {
                configMap.put("custom-model-data", job.getCustomModelData());
            }
        }
        configMap.put("display-name", stateConfig.getString("display-name", job.getName()));
        configMap.put("lore", stateConfig.getStringList("lore"));
        configMap.put("enabled", true);
        configMap.put("amount", stateConfig.getInt("amount", 1));
        configMap.put("glow", stateConfig.getBoolean("glow", false));
        configMap.put("hide-attributes", stateConfig.getBoolean("hide-attributes", true));
        configMap.put("hide-enchants", stateConfig.getBoolean("hide-enchants", false));
        configMap.put("action", "select_job");
        configMap.put("action-value", job.getId());
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        ItemStack item = this.createMenuItem(itemConfig, placeholders);
        if (item != null) {
            item = NBTItemUtils.setStringNBT(item, "universe_job_id", job.getId());
        }
        return item;
    }

    private ItemStack createLegacyJobButton(Job job, boolean selected, int playerCount) {
        MenuItemConfig itemConfig;
        ItemStack item;
        List<String> lore = Arrays.asList("&7Click to view rankings", "", "&7Players: &e" + playerCount, selected ? "" : "", selected ? "&a\u25b6 Currently Selected" : "");
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(job.getIconMaterial(), "&e" + job.getName(), lore, selected);
        configMap.put("enabled", true);
        if (job.getCustomModelData() > 0) {
            configMap.put("custom-model-data", job.getCustomModelData());
        }
        if ((item = this.createMenuItem(itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap)), new HashMap<String, String>())) != null) {
            item = NBTItemUtils.setStringNBT(item, "universe_job_id", job.getId());
        }
        return item;
    }

    private void addRankingEntries() {
        if (this.selectedJob == null) {
            return;
        }
        List rankings = this.jobRankings.getOrDefault(this.selectedJob, new ArrayList());
        if (rankings.isEmpty()) {
            return;
        }
        ArrayList<Integer> contentSlots = new ArrayList<Integer>(this.config.getContentSlots());
        HashSet<Integer> usedSlots = new HashSet<Integer>(contentSlots.size());
        for (RankingEntry entry : rankings) {
            ItemStack rankingItem = this.createRankingItem(entry);
            if (rankingItem == null || entry.preferredSlot == null || entry.preferredSlot < 0 || entry.preferredSlot >= this.inventory.getSize()) continue;
            this.inventory.setItem(entry.preferredSlot.intValue(), rankingItem);
            usedSlots.add(entry.preferredSlot);
            contentSlots.remove(entry.preferredSlot);
        }
        int slotIndex = 0;
        for (RankingEntry entry : rankings) {
            int slot;
            ItemStack rankingItem;
            if (entry.preferredSlot != null || (rankingItem = this.createRankingItem(entry)) == null || slotIndex >= contentSlots.size() || usedSlots.contains(slot = ((Integer)contentSlots.get(slotIndex)).intValue())) continue;
            this.inventory.setItem(slot, rankingItem);
            ++slotIndex;
        }
    }

    private ItemStack createRankingItem(RankingEntry entry) {
        ConfigurationSection entriesConfig = this.config.getRawConfig().getConfigurationSection("ranking-entries");
        if (entriesConfig == null) {
            this.plugin.getLogger().warning("Missing ranking-entries configuration in rankings-menu.yml");
            return this.createDefaultRankingItem(entry);
        }
        ConfigurationSection rankConfig = this.getRankConfig(entriesConfig, entry.rank);
        if (rankConfig == null || !rankConfig.getBoolean("enabled", true)) {
            return null;
        }
        Map<String, String> placeholders = this.createRankingPlaceholders(entry);
        HashMap<String, Object> configMap = new HashMap<String, Object>(16);
        String material = rankConfig.getString("material", "PLAYER_HEAD");
        configMap.put("material", material);
        if (material.equalsIgnoreCase("PLAYER_HEAD")) {
            String headTexture = rankConfig.getString("player-head", "");
            if (headTexture.isEmpty() || headTexture.equals("{player_texture}") || headTexture.equals("{player_name}")) {
                configMap.put("player-head", entry.playerName);
            } else {
                configMap.put("player-head", headTexture);
            }
        }
        configMap.put("display-name", rankConfig.getString("display-name", "#{rank} - {player}"));
        ArrayList lore = new ArrayList(rankConfig.getStringList("lore"));
        configMap.put("lore", lore);
        configMap.put("enabled", true);
        configMap.put("amount", rankConfig.getInt("amount", 1));
        configMap.put("glow", rankConfig.getBoolean("glow", false) || entry.playerId.equals(this.player.getUniqueId()) && entry.rank <= 3);
        configMap.put("hide-attributes", rankConfig.getBoolean("hide-attributes", true));
        configMap.put("hide-enchants", rankConfig.getBoolean("hide-enchants", false));
        int customModelData = rankConfig.getInt("custom-model-data", 0);
        if (customModelData > 0) {
            configMap.put("custom-model-data", customModelData);
        }
        if (rankConfig.contains("slot")) {
            entry.preferredSlot = rankConfig.getInt("slot");
        }
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, placeholders);
    }

    private ConfigurationSection getRankConfig(ConfigurationSection entriesConfig, int rank) {
        if (rank == 1 && entriesConfig.contains("rank-1")) {
            return entriesConfig.getConfigurationSection("rank-1");
        }
        if (rank == 2 && entriesConfig.contains("rank-2")) {
            return entriesConfig.getConfigurationSection("rank-2");
        }
        if (rank == 3 && entriesConfig.contains("rank-3")) {
            return entriesConfig.getConfigurationSection("rank-3");
        }
        if (rank >= 4 && rank <= 10 && entriesConfig.contains("rank-top10")) {
            return entriesConfig.getConfigurationSection("rank-top10");
        }
        if (entriesConfig.contains("rank-default")) {
            return entriesConfig.getConfigurationSection("rank-default");
        }
        return null;
    }

    private ItemStack createDefaultRankingItem(RankingEntry entry) {
        Map<String, String> placeholders = this.createRankingPlaceholders(entry);
        List<String> lore = Arrays.asList("&7Player: &f" + entry.playerName, "&7Level: &a" + entry.level, "&7Total XP: &b" + entry.xp);
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap("PLAYER_HEAD", "#{rank} - {player}", lore, false);
        configMap.put("enabled", true);
        configMap.put("player-head", entry.playerName);
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, placeholders);
    }

    private Map<String, String> createRankingPlaceholders(RankingEntry entry) {
        HashMap<String, String> placeholders = new HashMap<String, String>(10);
        placeholders.put("{rank}", String.valueOf(entry.rank));
        placeholders.put("{player}", entry.playerName);
        placeholders.put("{player_name}", entry.playerName);
        placeholders.put("{player_uuid}", entry.playerId.toString());
        placeholders.put("{level}", String.valueOf(entry.level));
        placeholders.put("{xp}", String.valueOf(entry.xp));
        placeholders.put("{rank_color}", this.getRankColorFromConfig(entry.rank));
        return placeholders;
    }

    private String getRankColorFromConfig(int rank) {
        ConfigurationSection colorConfig = this.config.getRawConfig().getConfigurationSection("ranking-entry-format.rank-colors");
        if (colorConfig == null) {
            return "<white>";
        }
        if (rank == 1 && colorConfig.contains("1")) {
            return colorConfig.getString("1");
        }
        if (rank == 2 && colorConfig.contains("2")) {
            return colorConfig.getString("2");
        }
        if (rank == 3 && colorConfig.contains("3")) {
            return colorConfig.getString("3");
        }
        if (rank <= 10 && colorConfig.contains("top-10")) {
            return colorConfig.getString("top-10");
        }
        return colorConfig.getString("default", "<white>");
    }

    private void addNavigationItems() {
        Map<String, MenuItemConfig> navItems = this.config.getNavigationItems();
        MenuItemUtils.addNavigationItems(this.inventory, navItems, this.currentPage, this.hasNextPage(), this.getNavigationPlaceholders(), config -> this.createMenuItem((MenuItemConfig)config, this.getNavigationPlaceholders()));
    }

    private void addStaticItems() {
        HashMap<String, String> placeholders = this.selectedJob != null ? MenuItemUtils.createJobPlaceholders(this.selectedJob, this.plugin.getJobManager().getJob(this.selectedJob).getName(), this.plugin.getJobManager().getJob(this.selectedJob).getDescription()) : new HashMap<String, String>();
        MenuItemUtils.addStaticItems(this.inventory, this.config.getStaticItems(), placeholders, config -> this.createMenuItem((MenuItemConfig)config, (Map<String, String>)placeholders));
    }

    @Override
    public void handleClick(int slot, InventoryClickEvent event) {
        String jobId;
        if (this.handleNavigationClickWithSound(slot)) {
            return;
        }
        ItemStack clickedItem = this.inventory.getItem(slot);
        if (clickedItem != null && (jobId = NBTItemUtils.getStringNBT(clickedItem, "universe_job_id")) != null && !jobId.equals(this.selectedJob)) {
            this.selectedJob = jobId;
            this.currentPage = 0;
            this.refresh();
            return;
        }
        List<Integer> contentSlots = this.config.getContentSlots();
        if (contentSlots.contains(slot)) {
            // empty if block
        }
    }

    @Override
    protected boolean hasNextPage() {
        if (this.selectedJob == null) {
            return false;
        }
        List rankings = this.jobRankings.getOrDefault(this.selectedJob, new ArrayList());
        return (this.currentPage + 1) * this.config.getItemsPerPage() < rankings.size();
    }

    @Override
    protected void handleBackButton() {
        this.plugin.getMenuManager().openJobsMainMenu(this.player);
    }

    private Map<String, String> getNavigationPlaceholders() {
        ArrayList rankings = this.selectedJob != null ? (List)this.jobRankings.getOrDefault(this.selectedJob, new ArrayList()) : new ArrayList();
        Map<String, String> placeholders = MenuItemUtils.createNavigationPlaceholders(this.currentPage, rankings.size(), this.config.getItemsPerPage());
        placeholders.put("total_players", String.valueOf(rankings.size()));
        placeholders.put("selected_job", this.selectedJob != null ? this.selectedJob : "None");
        return placeholders;
    }

    private static class RankingEntry {
        final UUID playerId;
        final String playerName;
        final int level;
        final long xp;
        int rank;
        Integer preferredSlot;

        RankingEntry(UUID playerId, String playerName, int level, long xp) {
            this.playerId = playerId;
            this.playerName = playerName;
            this.level = level;
            this.xp = xp;
        }
    }
}

