/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.impl;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.action.JobAction;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.OptimizedMenuHolder;
import fr.ax_dev.universejobs.menu.config.ActionItemFormat;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.menu.utils.MaterialUtils;
import fr.ax_dev.universejobs.menu.utils.MenuItemUtils;
import fr.ax_dev.universejobs.utils.EquationEvaluator;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class JobActionsMenu
extends BaseMenu {
    private static final String ACTION_TYPE = "action";
    private final Job job;
    private final Map<String, List<ActionInfo>> groupedActions;
    private final Map<String, String> cachedPlaceholders;
    private final Map<Integer, GroupedActionInfo> slotToActionMap;

    public JobActionsMenu(UniverseJobs plugin, Player player, String jobId, SingleMenuConfig config) {
        super(plugin, player, config);
        this.job = plugin.getJobManager().getJob(jobId);
        if (this.job == null) {
            throw new IllegalArgumentException("Job not found: " + jobId);
        }
        plugin.getLanguageManager();
        this.groupedActions = new HashMap<String, List<ActionInfo>>();
        this.cachedPlaceholders = new HashMap<String, String>();
        this.slotToActionMap = new HashMap<Integer, GroupedActionInfo>();
        this.loadJobData();
        this.cachedPlaceholders.putAll(this.createJobPlaceholders());
        this.initialize();
    }

    @Override
    protected void createInventory() {
        String title = this.config.getTitle().replace("{job_name}", this.job.getDisplayName());
        title = this.processPlaceholders(title);
        Component titleComponent = MessageUtils.parseMessage(title);
        OptimizedMenuHolder holder = new OptimizedMenuHolder(this.player.getUniqueId(), this.getClass().getSimpleName(), this.getMenuId(), this);
        this.inventory = this.plugin.getAccessor().getMenuManager().getInventoryFromPool(this.config.getSize(), titleComponent, holder);
        holder.setInventory(this.inventory);
    }

    @Override
    protected String getMenuId() {
        return this.job != null ? this.job.getId() + "_actions" : "unknown_actions";
    }

    private void loadJobData() {
        this.loadJobActionsEfficiently();
    }

    private void loadJobActionsEfficiently() {
        for (ActionType actionType : this.job.getActionTypes()) {
            for (JobAction action : this.job.getActions(actionType)) {
                String groupKey = action.getDisplayMaterial() != null && !action.getDisplayMaterial().isEmpty() ? action.getDisplayMaterial() : action.getTarget();
                this.groupedActions.computeIfAbsent(groupKey, k -> new ArrayList()).add(new ActionInfo(actionType, action));
            }
        }
        this.groupedActions.values().forEach(actions -> actions.sort((a1, a2) -> Integer.compare(a1.action.getActionMenuPriority(), a2.action.getActionMenuPriority())));
    }

    @Override
    protected void populateInventory() {
        this.addStaticItems();
        this.addFillItems();
        List<DisplayItem> displayItems = this.createDisplayItems();
        this.addPaginatedItems(displayItems);
        this.addNavigationItems();
    }

    private void addStaticItems() {
        Map<String, String> currentPlaceholders = this.createJobPlaceholders();
        for (Map.Entry<String, MenuItemConfig> entry : this.config.getStaticItems().entrySet()) {
            MenuItemConfig itemConfig = entry.getValue();
            if (!itemConfig.isEnabled()) continue;
            ItemStack staticItem = this.createMenuItem(itemConfig, currentPlaceholders);
            for (int slot : itemConfig.getSlots()) {
                this.inventory.setItem(slot, staticItem);
            }
        }
    }

    private List<DisplayItem> createDisplayItems() {
        ArrayList<DisplayItem> displayItems = new ArrayList<DisplayItem>(this.groupedActions.size());
        this.groupedActions.forEach((groupKey, actions) -> displayItems.add(new DisplayItem(ACTION_TYPE, new GroupedActionInfo((String)groupKey, (List<ActionInfo>)actions))));
        displayItems.sort((item1, item2) -> {
            if (ACTION_TYPE.equals(item1.type) && ACTION_TYPE.equals(item2.type)) {
                GroupedActionInfo info1 = (GroupedActionInfo)item1.data;
                GroupedActionInfo info2 = (GroupedActionInfo)item2.data;
                int priority1 = info1.actions.stream().mapToInt(action -> action.action.getActionMenuPriority()).min().orElse(Integer.MAX_VALUE);
                int priority2 = info2.actions.stream().mapToInt(action -> action.action.getActionMenuPriority()).min().orElse(Integer.MAX_VALUE);
                return Integer.compare(priority1, priority2);
            }
            return 0;
        });
        return displayItems;
    }

    private void addPaginatedItems(List<DisplayItem> displayItems) {
        int slotIndex;
        List<Integer> contentSlots = this.config.getContentSlots();
        int itemsPerPage = contentSlots.size();
        int startIndex = this.currentPage * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, displayItems.size());
        this.slotToActionMap.clear();
        for (int i = startIndex; i < endIndex && (slotIndex = i - startIndex) < contentSlots.size(); ++i) {
            DisplayItem displayItem = displayItems.get(i);
            ItemStack item = null;
            if (ACTION_TYPE.equals(displayItem.type)) {
                GroupedActionInfo actionInfo = (GroupedActionInfo)displayItem.data;
                item = this.createGroupedActionItem(actionInfo);
                int slot = contentSlots.get(slotIndex);
                this.slotToActionMap.put(slot, actionInfo);
            }
            if (item == null) continue;
            this.inventory.setItem(contentSlots.get(slotIndex).intValue(), item);
        }
    }

    private ItemStack createGroupedActionItem(GroupedActionInfo groupedInfo) {
        String materialName;
        ActionInfo firstAction = groupedInfo.actions.get(0);
        int customModelData = 0;
        if (firstAction.action.getDisplayMaterial() != null && !firstAction.action.getDisplayMaterial().isEmpty()) {
            String displayMaterial = firstAction.action.getDisplayMaterial();
            if (displayMaterial.contains(":")) {
                String[] parts = displayMaterial.split(":");
                materialName = parts[0];
                try {
                    customModelData = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    customModelData = 0;
                }
            } else {
                materialName = displayMaterial;
            }
        } else {
            Material material = MaterialUtils.getSourceMaterialForTarget(groupedInfo.groupKey, firstAction.actionType);
            materialName = material.name();
        }
        Object displayName = "";
        ActionItemFormat format = this.config.getActionItemFormat();
        boolean useFirstLoreAsDisplayName = false;
        if (format != null && format.getDisplayNameEnabled() != null && !format.getDisplayNameEnabled().isEmpty()) {
            displayName = format.getDisplayNameEnabled().replace("{action_target}", groupedInfo.groupKey).replace("{action_display_name}", firstAction.action.getDisplayName() != null ? firstAction.action.getDisplayName() : groupedInfo.groupKey).replace("{action_type}", firstAction.actionType.name()).replace("{action_name}", firstAction.action.getName());
            if (!((String)displayName).startsWith("<") && !((String)displayName).startsWith("&")) {
                displayName = "<!italic><white>" + (String)displayName;
            }
        } else {
            useFirstLoreAsDisplayName = true;
        }
        List<String> lore = this.buildGroupedActionLore(groupedInfo, useFirstLoreAsDisplayName);
        if (useFirstLoreAsDisplayName && !lore.isEmpty()) {
            displayName = lore.get(0);
            lore.remove(0);
            if (!((String)displayName).startsWith("<") && !((String)displayName).startsWith("&")) {
                displayName = "<!italic><white>" + (String)displayName;
            }
        }
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(materialName, (String)displayName, lore, false, customModelData);
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, this.cachedPlaceholders);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> buildGroupedActionLore(GroupedActionInfo groupedInfo, boolean includeFirstLine) {
        ArrayList<String> lore = new ArrayList<String>();
        for (ActionInfo actionInfo : this.groupedActions.get(groupedInfo.groupKey)) {
            JobAction action = actionInfo.action;
            Object actionTypeStr = actionInfo.actionType.name().toLowerCase();
            actionTypeStr = ((String)actionTypeStr).substring(0, 1).toUpperCase() + ((String)actionTypeStr).substring(1);
            ActionItemFormat format = this.config.getActionItemFormat();
            if (format == null || format.getLoreBonus() == null) continue;
            ArrayList<String> formatLore = new ArrayList<String>(format.getLoreBonus());
            List<String> filteredLore = this.applyHideLineLogicRaw(formatLore, action, format);
            ArrayList<Object> processedLore = new ArrayList<Object>();
            for (String string : filteredLore) {
                void var13_32;
                void var13_28;
                String string2;
                String string3;
                void var13_26;
                String moneySign;
                String actionDisplayName;
                String string7 = this.replacePlaceholder(string, "action_type", (String)actionTypeStr);
                string7 = this.replacePlaceholder(string7, "action_target", action.getTarget());
                string7 = this.replacePlaceholder(string7, "action_name", action.getName());
                string7 = this.replacePlaceholder(string7, "action_display_name", actionDisplayName = action.getDisplayName() != null && !action.getDisplayName().isEmpty() ? action.getDisplayName() : action.getTarget());
                if (string7.contains("{action_lore}")) {
                    if (action.getLore() == null || action.getLore().isEmpty()) continue;
                    for (String loreLine : action.getLore()) {
                        String loreFormat = this.plugin.getConfig().getString("placeholders.action_lore", "<gray>{value}");
                        String processedLine = loreFormat.replace("{value}", loreLine);
                        processedLore.add(processedLine);
                    }
                    continue;
                }
                EquationEvaluator evaluator = new EquationEvaluator(this.plugin);
                double baseXp = action.hasXpEquation() ? evaluator.evaluate(action.getXpEquation(), this.player, this.job, this.job.getId()) : action.getXp();
                double baseMoney = action.hasMoneyEquation() ? evaluator.evaluate(action.getMoneyEquation(), this.player, this.job, this.job.getId()) : action.getMoney();
                String string9 = this.replacePlaceholder(string7, "action_xp_base", String.valueOf(baseXp));
                string9 = this.replacePlaceholder(string9, "action_money_base", String.valueOf(baseMoney));
                double xpMultiplier = this.plugin.getBonusManager().getTotalMultiplier(this.player.getUniqueId(), this.job.getId());
                double moneyMultiplier = this.plugin.getMoneyBonusManager().getTotalMultiplier(this.player.getUniqueId(), this.job.getId());
                double boostedXp = baseXp * xpMultiplier;
                double boostedMoney = baseMoney * moneyMultiplier;
                String string11 = this.replacePlaceholder(string9, "action_xp", this.formatDecimal(boostedXp));
                string11 = this.replacePlaceholder(string11, "action_money", this.formatDecimal(boostedMoney));
                String xpSign = boostedXp >= 0.0 ? "+" : "";
                String string12 = moneySign = boostedMoney >= 0.0 ? "+" : "";
                if (string11.contains("{+-}")) {
                    if (string11.contains("{action_xp}") || string11.contains("XP") || string11.toLowerCase().contains("xp")) {
                        String string13 = string11.replace("{+-}", xpSign);
                    } else if (string11.contains("{action_money}") || string11.contains("Money") || string11.toLowerCase().contains("money") || string11.contains("$")) {
                        String string14 = string11.replace("{+-}", moneySign);
                    } else {
                        String string15 = string11.replace("{+-}", "+");
                    }
                }
                if (var13_26.contains("{action_cooldown}")) {
                    String string16 = this.replacePlaceholder((String)var13_26, "action_cooldown", "0");
                }
                String xpMultiplierText = "";
                String moneyMultiplierText = "";
                if (xpMultiplier > 1.0) {
                    String xpMultiplierFormat = this.plugin.getConfig().getString("placeholders.action_xp_multiplier", "<gray>(<white>x{value}<gray>)");
                    xpMultiplierText = xpMultiplierFormat.replace("{value}", String.format("%.1f", xpMultiplier));
                }
                if (moneyMultiplier > 1.0) {
                    String moneyMultiplierFormat = this.plugin.getConfig().getString("placeholders.action_money_multiplier", "<gray>(<white>x{value}<gray>)");
                    moneyMultiplierText = moneyMultiplierFormat.replace("{value}", String.format("%.1f", moneyMultiplier));
                }
                if (!((string3 = (string2 = var13_28.replace("{action_xp_multiplier}", xpMultiplierText)).replace("{action_money_multiplier}", moneyMultiplierText)).trim().isEmpty() || string3.startsWith("<") || string3.startsWith("&"))) {
                    String string17 = "<!italic><white>" + string3;
                }
                processedLore.add(var13_32);
            }
            lore.addAll(processedLore);
        }
        return lore;
    }

    private List<String> applyHideLineLogicRaw(List<String> rawLoreLines, JobAction action, ActionItemFormat format) {
        ArrayList<String> result = new ArrayList<String>();
        boolean hasNoMoney = !action.hasMoneyEquation() && action.getMoney() <= 0.0;
        boolean hasNoXp = !action.hasXpEquation() && action.getXp() <= 0.0;
        List<Integer> hideWhenNoMoney = format.getHideWhenNoMoney();
        List<Integer> hideWhenNoXp = format.getHideWhenNoXp();
        for (int i = 0; i < rawLoreLines.size(); ++i) {
            int lineNumber = i + 1;
            boolean shouldHide = false;
            if (hasNoMoney && hideWhenNoMoney.contains(lineNumber)) {
                shouldHide = true;
            }
            if (hasNoXp && hideWhenNoXp.contains(lineNumber)) {
                shouldHide = true;
            }
            if (shouldHide) continue;
            result.add(rawLoreLines.get(i));
        }
        return result;
    }

    private String replacePlaceholder(String text, String placeholder, String value) {
        String specificFormat;
        if (!text.contains("{" + placeholder + "}")) {
            return text;
        }
        String format = "action_type".equals(placeholder) ? ((specificFormat = this.plugin.getConfig().getString("placeholders.action_type." + value.toUpperCase())) != null ? specificFormat : this.plugin.getConfig().getString("placeholders.action_type.default", "<white>{value}")) : this.plugin.getConfig().getString("placeholders." + placeholder, "<white>{value}");
        String formatted = format.replace("{value}", value);
        return text.replace("{" + placeholder + "}", formatted);
    }

    private void addNavigationItems() {
        Map<String, String> navPlaceholders = this.createNavigationPlaceholders();
        this.config.getNavigationItems().forEach((key, itemConfig) -> {
            if (itemConfig.isEnabled()) {
                ItemStack navItem = this.createMenuItem((MenuItemConfig)itemConfig, navPlaceholders);
                for (int slot : itemConfig.getSlots()) {
                    this.inventory.setItem(slot, navItem);
                }
            }
        });
    }

    @Override
    public void handleClick(int slot, InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.handleNavigationClickWithSound(slot)) {
            return;
        }
        GroupedActionInfo actionInfo = this.slotToActionMap.get(slot);
        if (actionInfo != null) {
            this.executeActionCommands(actionInfo);
        }
    }

    private void executeActionCommands(GroupedActionInfo actionInfo) {
        ActionItemFormat format = this.config.getActionItemFormat();
        if (format == null) {
            return;
        }
        List<String> commands = format.getCommands();
        if (commands == null || commands.isEmpty()) {
            return;
        }
        ActionInfo firstAction = actionInfo.actions.get(0);
        for (String command : commands) {
            String processedCommand = command.replace("{player}", this.player.getName()).replace("{job_id}", this.job.getId()).replace("{job_name}", this.job.getDisplayName()).replace("{action_type}", firstAction.actionType.name()).replace("{action_target}", firstAction.action.getTarget()).replace("{action_name}", firstAction.action.getName()).replace("{action_display_name}", firstAction.action.getDisplayName() != null ? firstAction.action.getDisplayName() : firstAction.action.getTarget());
            if (processedCommand.startsWith("[console]")) {
                String consoleCmd = processedCommand.substring(9).trim();
                this.plugin.getFoliaManager().runNextTick(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)consoleCmd));
                continue;
            }
            if (processedCommand.startsWith("[player]")) {
                String playerCmd = processedCommand.substring(8).trim();
                this.plugin.getFoliaManager().runNextTick(() -> this.player.performCommand(playerCmd));
                continue;
            }
            if (processedCommand.startsWith("[close]")) {
                this.close();
                continue;
            }
            this.plugin.getFoliaManager().runNextTick(() -> this.player.performCommand(processedCommand));
        }
    }

    @Override
    protected boolean hasNextPage() {
        int itemsPerPage = this.config.getContentSlots().size();
        return (this.currentPage + 1) * itemsPerPage < this.groupedActions.size();
    }

    @Override
    protected void handleBackButton() {
        try {
            this.plugin.getMenuManager().openJobMenu(this.player, this.job.getId());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to open job menu when going back: " + e.getMessage());
            this.close();
        }
    }

    private Map<String, String> createJobPlaceholders() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{job_id}", this.job.getId());
        placeholders.put("{job_name}", this.job.getDisplayName());
        placeholders.put("{job_description}", this.job.getDescription());
        placeholders.put("{job_description_lines}", String.join((CharSequence)"\n", this.job.getDescriptionLines()));
        int totalActions = this.groupedActions.values().stream().mapToInt(List::size).sum();
        placeholders.put("{total_actions}", String.valueOf(totalActions));
        return placeholders;
    }

    private Map<String, String> createNavigationPlaceholders() {
        int totalActions = this.groupedActions.values().stream().mapToInt(List::size).sum();
        int itemsPerPage = this.config.getContentSlots().size();
        Map<String, String> placeholders = MenuItemUtils.createNavigationPlaceholders(this.currentPage, this.groupedActions.size(), itemsPerPage);
        placeholders.put("total_actions", String.valueOf(totalActions));
        placeholders.put("job_name", this.job.getDisplayName());
        return placeholders;
    }

    private String formatDecimal(double value) {
        if (value == (double)((long)value)) {
            return String.valueOf((long)value);
        }
        String str = String.valueOf(value);
        if (str.contains("E") || str.contains("e")) {
            return String.format("%.10f", value).replaceAll("0+$", "").replaceAll("\\.$", "");
        }
        return str.replaceAll("0+$", "").replaceAll("\\.$", "");
    }

    private static class ActionInfo {
        final ActionType actionType;
        final JobAction action;

        ActionInfo(ActionType actionType, JobAction action) {
            this.actionType = actionType;
            this.action = action;
        }
    }

    private static class DisplayItem {
        final String type;
        final Object data;

        DisplayItem(String type, Object data) {
            this.type = type;
            this.data = data;
        }
    }

    private static class GroupedActionInfo {
        final String groupKey;
        final List<ActionInfo> actions;

        GroupedActionInfo(String groupKey, List<ActionInfo> actions) {
            this.groupKey = groupKey;
            this.actions = actions;
        }
    }
}

