/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.utils;

import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.utils.EnumUtils;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class MaterialUtils {
    public static Material getMaterialForTarget(String target) {
        return MaterialUtils.getMaterialForTarget(target, null);
    }

    public static Material getSourceMaterialForTarget(String target, ActionType actionType) {
        Material baseMaterial = MaterialUtils.getMaterialForTarget(target, actionType);
        return MaterialUtils.getSourceMaterial(baseMaterial);
    }

    public static Material getMaterialForTarget(String target, ActionType actionType) {
        Material actionMaterial;
        if (target == null || target.isEmpty()) {
            throw new IllegalArgumentException("Target cannot be null or empty");
        }
        String normalizedTarget = target.trim();
        if (normalizedTarget.contains(":")) {
            String[] parts = normalizedTarget.split(":", 2);
            String namespace = parts[0].toLowerCase();
            if ("mythicmobs".equals(namespace) || "mm".equals(namespace)) {
                return Material.WITHER_SKELETON_SKULL;
            }
            if (parts.length > 1) {
                String itemName = parts[1];
                Material material = EnumUtils.parseMaterial(itemName, null);
                if (material != null) {
                    return material;
                }
                Material spawnEgg = MaterialUtils.getSpawnEggForEntity(itemName);
                if (spawnEgg != null) {
                    return spawnEgg;
                }
                return MaterialUtils.getGenericMaterialForNamespace(namespace);
            }
        }
        try {
            Material material = EnumUtils.parseMaterial(normalizedTarget, null);
            if (material != null && material.isItem()) {
                return material;
            }
        }
        catch (IllegalArgumentException material) {
            // empty catch block
        }
        Material cropMaterial = MaterialUtils.getCropMaterialForStem(normalizedTarget);
        if (cropMaterial != null) {
            return cropMaterial;
        }
        Material spawnEgg = MaterialUtils.getSpawnEggForEntity(normalizedTarget);
        if (spawnEgg != null) {
            return spawnEgg;
        }
        if (actionType != null && (actionMaterial = MaterialUtils.getMaterialForActionType(actionType, normalizedTarget)) != null) {
            return actionMaterial;
        }
        Material fallbackMaterial = MaterialUtils.getFallbackMaterial(normalizedTarget);
        if (fallbackMaterial != null) {
            return fallbackMaterial;
        }
        Material specialMaterial = MaterialUtils.getSpecialMaterial(normalizedTarget);
        if (specialMaterial != null) {
            return specialMaterial;
        }
        return Material.STONE;
    }

    private static Material getSpawnEggForEntity(String entityName) {
        if (entityName == null || entityName.trim().isEmpty()) {
            return null;
        }
        try {
            EntityType entityType = EnumUtils.parseEntityType(entityName.trim(), null);
            if (entityType == null) {
                return null;
            }
            return switch (entityType) {
                case EntityType.ZOMBIE -> Material.ZOMBIE_SPAWN_EGG;
                case EntityType.SKELETON -> Material.SKELETON_SPAWN_EGG;
                case EntityType.CREEPER -> Material.CREEPER_SPAWN_EGG;
                case EntityType.SPIDER -> Material.SPIDER_SPAWN_EGG;
                case EntityType.ENDERMAN -> Material.ENDERMAN_SPAWN_EGG;
                case EntityType.WITCH -> Material.WITCH_SPAWN_EGG;
                case EntityType.BLAZE -> Material.BLAZE_SPAWN_EGG;
                case EntityType.GHAST -> Material.GHAST_SPAWN_EGG;
                case EntityType.SLIME -> Material.SLIME_SPAWN_EGG;
                case EntityType.MAGMA_CUBE -> Material.MAGMA_CUBE_SPAWN_EGG;
                case EntityType.ENDER_DRAGON -> Material.DRAGON_EGG;
                case EntityType.WITHER -> Material.WITHER_SKELETON_SKULL;
                case EntityType.COW -> Material.COW_SPAWN_EGG;
                case EntityType.PIG -> Material.PIG_SPAWN_EGG;
                case EntityType.SHEEP -> Material.SHEEP_SPAWN_EGG;
                case EntityType.CHICKEN -> Material.CHICKEN_SPAWN_EGG;
                case EntityType.HORSE -> Material.HORSE_SPAWN_EGG;
                case EntityType.WOLF -> Material.WOLF_SPAWN_EGG;
                case EntityType.CAT -> Material.CAT_SPAWN_EGG;
                case EntityType.VILLAGER -> Material.VILLAGER_SPAWN_EGG;
                case EntityType.IRON_GOLEM -> Material.IRON_INGOT;
                case EntityType.SNOW_GOLEM -> Material.SNOWBALL;
                case EntityType.SQUID -> Material.SQUID_SPAWN_EGG;
                case EntityType.BAT -> Material.BAT_SPAWN_EGG;
                case EntityType.OCELOT -> Material.OCELOT_SPAWN_EGG;
                case EntityType.RABBIT -> Material.RABBIT_SPAWN_EGG;
                case EntityType.GUARDIAN -> Material.GUARDIAN_SPAWN_EGG;
                case EntityType.ELDER_GUARDIAN -> Material.ELDER_GUARDIAN_SPAWN_EGG;
                case EntityType.SHULKER -> Material.SHULKER_SPAWN_EGG;
                case EntityType.ENDERMITE -> Material.ENDERMITE_SPAWN_EGG;
                case EntityType.SILVERFISH -> Material.SILVERFISH_SPAWN_EGG;
                case EntityType.CAVE_SPIDER -> Material.CAVE_SPIDER_SPAWN_EGG;
                case EntityType.ZOMBIFIED_PIGLIN -> Material.ZOMBIFIED_PIGLIN_SPAWN_EGG;
                case EntityType.WITHER_SKELETON -> Material.WITHER_SKELETON_SPAWN_EGG;
                case EntityType.STRAY -> Material.STRAY_SPAWN_EGG;
                case EntityType.HUSK -> Material.HUSK_SPAWN_EGG;
                case EntityType.ZOMBIE_VILLAGER -> Material.ZOMBIE_VILLAGER_SPAWN_EGG;
                case EntityType.SKELETON_HORSE -> Material.SKELETON_HORSE_SPAWN_EGG;
                case EntityType.ZOMBIE_HORSE -> Material.ZOMBIE_HORSE_SPAWN_EGG;
                case EntityType.DONKEY -> Material.DONKEY_SPAWN_EGG;
                case EntityType.MULE -> Material.MULE_SPAWN_EGG;
                case EntityType.LLAMA -> Material.LLAMA_SPAWN_EGG;
                case EntityType.PARROT -> Material.PARROT_SPAWN_EGG;
                case EntityType.POLAR_BEAR -> Material.POLAR_BEAR_SPAWN_EGG;
                case EntityType.DOLPHIN -> Material.DOLPHIN_SPAWN_EGG;
                case EntityType.TURTLE -> Material.TURTLE_SPAWN_EGG;
                case EntityType.PHANTOM -> Material.PHANTOM_SPAWN_EGG;
                case EntityType.COD -> Material.COD_SPAWN_EGG;
                case EntityType.SALMON -> Material.SALMON_SPAWN_EGG;
                case EntityType.PUFFERFISH -> Material.PUFFERFISH_SPAWN_EGG;
                case EntityType.TROPICAL_FISH -> Material.TROPICAL_FISH_SPAWN_EGG;
                case EntityType.DROWNED -> Material.DROWNED_SPAWN_EGG;
                case EntityType.PILLAGER -> Material.PILLAGER_SPAWN_EGG;
                case EntityType.RAVAGER -> Material.RAVAGER_SPAWN_EGG;
                case EntityType.VINDICATOR -> Material.VINDICATOR_SPAWN_EGG;
                case EntityType.EVOKER -> Material.EVOKER_SPAWN_EGG;
                case EntityType.VEX -> Material.VEX_SPAWN_EGG;
                case EntityType.WANDERING_TRADER -> Material.WANDERING_TRADER_SPAWN_EGG;
                case EntityType.TRADER_LLAMA -> Material.TRADER_LLAMA_SPAWN_EGG;
                case EntityType.FOX -> Material.FOX_SPAWN_EGG;
                case EntityType.BEE -> Material.BEE_SPAWN_EGG;
                case EntityType.HOGLIN -> Material.HOGLIN_SPAWN_EGG;
                case EntityType.PIGLIN -> Material.PIGLIN_SPAWN_EGG;
                case EntityType.PIGLIN_BRUTE -> Material.PIGLIN_BRUTE_SPAWN_EGG;
                case EntityType.ZOGLIN -> Material.ZOGLIN_SPAWN_EGG;
                case EntityType.STRIDER -> Material.STRIDER_SPAWN_EGG;
                case EntityType.AXOLOTL -> Material.AXOLOTL_SPAWN_EGG;
                case EntityType.GLOW_SQUID -> Material.GLOW_SQUID_SPAWN_EGG;
                case EntityType.GOAT -> Material.GOAT_SPAWN_EGG;
                case EntityType.ALLAY -> Material.ALLAY_SPAWN_EGG;
                case EntityType.FROG -> Material.FROG_SPAWN_EGG;
                case EntityType.TADPOLE -> Material.TADPOLE_SPAWN_EGG;
                case EntityType.WARDEN -> Material.SCULK_SHRIEKER;
                case EntityType.CAMEL -> Material.CAMEL_SPAWN_EGG;
                case EntityType.SNIFFER -> Material.SNIFFER_SPAWN_EGG;
                default -> null;
            };
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Material getMaterialForActionType(ActionType actionType, String target) {
        return switch (actionType) {
            case ActionType.ENCHANT -> MaterialUtils.getEnchantmentMaterial(target.toLowerCase());
            case ActionType.POTION -> Material.POTION;
            case ActionType.BREW -> Material.BREWING_STAND;
            case ActionType.FISH -> Material.FISHING_ROD;
            case ActionType.CRAFT -> Material.CRAFTING_TABLE;
            case ActionType.SMELT -> Material.FURNACE;
            case ActionType.MILK -> Material.MILK_BUCKET;
            case ActionType.EAT -> Material.BREAD;
            case ActionType.TAME -> MaterialUtils.getTameMaterial(target);
            case ActionType.BREED -> MaterialUtils.getBreedingMaterial(target);
            case ActionType.SHEAR -> Material.SHEARS;
            default -> null;
        };
    }

    private static Material getBreedingMaterial(String entityName) {
        if (entityName == null) {
            return Material.WHEAT;
        }
        EntityType entityType = EnumUtils.parseEntityType(entityName.trim(), null);
        if (entityType == null) {
            return Material.WHEAT;
        }
        return switch (entityType) {
            case EntityType.COW, EntityType.SHEEP, EntityType.GOAT -> Material.WHEAT;
            case EntityType.MOOSHROOM -> Material.WHEAT;
            case EntityType.PIG -> Material.CARROT;
            case EntityType.CHICKEN -> Material.WHEAT_SEEDS;
            case EntityType.RABBIT -> Material.DANDELION;
            case EntityType.WOLF -> Material.COOKED_BEEF;
            case EntityType.CAT, EntityType.OCELOT -> Material.COD;
            case EntityType.HORSE, EntityType.DONKEY, EntityType.MULE, EntityType.LLAMA, EntityType.TRADER_LLAMA -> Material.GOLDEN_CARROT;
            case EntityType.TURTLE -> Material.SEAGRASS;
            case EntityType.PANDA -> Material.BAMBOO;
            case EntityType.FOX -> Material.SWEET_BERRIES;
            case EntityType.BEE -> Material.POPPY;
            case EntityType.STRIDER -> Material.WARPED_FUNGUS;
            case EntityType.HOGLIN -> Material.CRIMSON_FUNGUS;
            case EntityType.AXOLOTL -> Material.TROPICAL_FISH_BUCKET;
            case EntityType.FROG -> Material.SLIME_BALL;
            case EntityType.CAMEL -> Material.CACTUS;
            case EntityType.SNIFFER -> Material.TORCHFLOWER_SEEDS;
            case EntityType.ARMADILLO -> Material.SPIDER_EYE;
            default -> Material.WHEAT;
        };
    }

    private static Material getTameMaterial(String entityName) {
        if (entityName == null) {
            return Material.BONE;
        }
        EntityType entityType = EnumUtils.parseEntityType(entityName.trim(), null);
        if (entityType == null) {
            return Material.BONE;
        }
        return switch (entityType) {
            case EntityType.WOLF -> Material.BONE;
            case EntityType.CAT, EntityType.OCELOT -> Material.COD;
            case EntityType.PARROT -> Material.WHEAT_SEEDS;
            case EntityType.HORSE, EntityType.DONKEY, EntityType.MULE, EntityType.LLAMA, EntityType.TRADER_LLAMA -> Material.GOLDEN_APPLE;
            case EntityType.AXOLOTL -> Material.TROPICAL_FISH_BUCKET;
            default -> Material.BONE;
        };
    }

    private static Material getGenericMaterialForNamespace(String namespace) {
        return switch (namespace.toLowerCase()) {
            case "customcrops", "crops" -> Material.WHEAT_SEEDS;
            case "itemsadder", "ia" -> Material.COMMAND_BLOCK;
            case "oraxen" -> Material.BARRIER;
            case "nexo" -> Material.STRUCTURE_VOID;
            case "mmoitems", "mmo" -> Material.DIAMOND;
            default -> Material.PAPER;
        };
    }

    private static Material getFallbackMaterial(String target) {
        String lowerTarget = target.toLowerCase();
        if (MaterialUtils.isEnchantment(lowerTarget)) {
            return MaterialUtils.getEnchantmentMaterial(lowerTarget);
        }
        if (MaterialUtils.isPotion(lowerTarget)) {
            return Material.POTION;
        }
        if (MaterialUtils.isFood(lowerTarget)) {
            return Material.BREAD;
        }
        if (MaterialUtils.isTool(lowerTarget)) {
            return MaterialUtils.getToolMaterial(lowerTarget);
        }
        return null;
    }

    private static boolean isEnchantment(String target) {
        return target.equals("sharpness") || target.equals("protection") || target.equals("efficiency") || target.equals("unbreaking") || target.equals("looting") || target.equals("fortune") || target.equals("silk_touch") || target.equals("mending") || target.equals("fire_aspect") || target.equals("knockback") || target.equals("power") || target.equals("punch") || target.equals("flame") || target.equals("infinity");
    }

    private static Material getEnchantmentMaterial(String enchantment) {
        return switch (enchantment) {
            case "sharpness", "fire_aspect", "knockback", "looting" -> Material.DIAMOND_SWORD;
            case "protection" -> Material.DIAMOND_CHESTPLATE;
            case "efficiency", "fortune", "silk_touch" -> Material.DIAMOND_PICKAXE;
            case "unbreaking", "mending" -> Material.ENCHANTED_BOOK;
            case "power", "punch", "flame", "infinity" -> Material.BOW;
            default -> Material.ENCHANTED_BOOK;
        };
    }

    private static boolean isPotion(String target) {
        return target.contains("potion") || target.equals("healing") || target.equals("strength") || target.equals("speed") || target.equals("regeneration") || target.equals("poison");
    }

    private static boolean isFood(String target) {
        return target.equals("eating") || target.equals("food") || target.equals("consume");
    }

    private static boolean isTool(String target) {
        return target.contains("sword") || target.contains("pickaxe") || target.contains("axe") || target.contains("shovel") || target.contains("hoe");
    }

    private static Material getToolMaterial(String tool) {
        if (tool.contains("sword")) {
            return Material.DIAMOND_SWORD;
        }
        if (tool.contains("pickaxe")) {
            return Material.DIAMOND_PICKAXE;
        }
        if (tool.contains("axe")) {
            return Material.DIAMOND_AXE;
        }
        if (tool.contains("shovel")) {
            return Material.DIAMOND_SHOVEL;
        }
        if (tool.contains("hoe")) {
            return Material.DIAMOND_HOE;
        }
        return Material.STICK;
    }

    private static Material getCropMaterialForStem(String target) {
        return switch (target.toUpperCase()) {
            case "MELON_STEM", "ATTACHED_MELON_STEM" -> Material.MELON_SLICE;
            case "PUMPKIN_STEM", "ATTACHED_PUMPKIN_STEM" -> Material.PUMPKIN;
            case "CARROTS" -> Material.CARROT;
            case "POTATOES" -> Material.POTATO;
            case "BEETROOTS" -> Material.BEETROOT;
            case "WHEAT" -> Material.WHEAT_SEEDS;
            case "COCOA" -> Material.COCOA_BEANS;
            case "NETHER_WART" -> Material.NETHER_WART;
            case "SWEET_BERRY_BUSH" -> Material.SWEET_BERRIES;
            default -> null;
        };
    }

    private static Material getSpecialMaterial(String target) {
        switch (target.toUpperCase()) {
            case "PLAYER": {
                return Material.PLAYER_HEAD;
            }
        }
        return null;
    }

    private static Material getSourceMaterial(Material material) {
        return switch (material) {
            case Material.COPPER_INGOT -> Material.COPPER_ORE;
            case Material.COPPER_BLOCK -> Material.COPPER_ORE;
            case Material.IRON_INGOT -> Material.IRON_ORE;
            case Material.IRON_BLOCK -> Material.IRON_ORE;
            case Material.IRON_NUGGET -> Material.IRON_ORE;
            case Material.GOLD_INGOT -> Material.GOLD_ORE;
            case Material.GOLD_BLOCK -> Material.GOLD_ORE;
            case Material.GOLD_NUGGET -> Material.GOLD_ORE;
            case Material.DIAMOND_BLOCK -> Material.DIAMOND_ORE;
            case Material.EMERALD_BLOCK -> Material.EMERALD_ORE;
            case Material.COAL_BLOCK -> Material.COAL_ORE;
            case Material.REDSTONE_BLOCK -> Material.REDSTONE_ORE;
            case Material.LAPIS_BLOCK -> Material.LAPIS_ORE;
            case Material.NETHERITE_INGOT -> Material.ANCIENT_DEBRIS;
            case Material.NETHERITE_BLOCK -> Material.ANCIENT_DEBRIS;
            case Material.OAK_PLANKS -> Material.OAK_LOG;
            case Material.BIRCH_PLANKS -> Material.BIRCH_LOG;
            case Material.SPRUCE_PLANKS -> Material.SPRUCE_LOG;
            case Material.JUNGLE_PLANKS -> Material.JUNGLE_LOG;
            case Material.ACACIA_PLANKS -> Material.ACACIA_LOG;
            case Material.DARK_OAK_PLANKS -> Material.DARK_OAK_LOG;
            case Material.MANGROVE_PLANKS -> Material.MANGROVE_LOG;
            case Material.CHERRY_PLANKS -> Material.CHERRY_LOG;
            case Material.BAMBOO_PLANKS -> Material.BAMBOO;
            case Material.CRIMSON_PLANKS -> Material.CRIMSON_STEM;
            case Material.WARPED_PLANKS -> Material.WARPED_STEM;
            case Material.STONE_BRICKS -> Material.STONE;
            case Material.SMOOTH_STONE -> Material.STONE;
            case Material.STONE_BRICK_SLAB -> Material.STONE;
            case Material.STONE_BRICK_STAIRS -> Material.STONE;
            case Material.COBBLESTONE_SLAB -> Material.COBBLESTONE;
            case Material.COBBLESTONE_STAIRS -> Material.COBBLESTONE;
            case Material.COBBLESTONE_WALL -> Material.COBBLESTONE;
            case Material.BREAD -> Material.WHEAT;
            case Material.COOKIE -> Material.COCOA_BEANS;
            case Material.CAKE -> Material.WHEAT;
            case Material.PUMPKIN_PIE -> Material.PUMPKIN;
            case Material.GLASS -> Material.SAND;
            case Material.GLASS_PANE -> Material.SAND;
            case Material.WHITE_STAINED_GLASS -> Material.SAND;
            case Material.BLACK_STAINED_GLASS -> Material.SAND;
            case Material.BLUE_STAINED_GLASS -> Material.SAND;
            case Material.BROWN_STAINED_GLASS -> Material.SAND;
            case Material.CYAN_STAINED_GLASS -> Material.SAND;
            case Material.GRAY_STAINED_GLASS -> Material.SAND;
            case Material.GREEN_STAINED_GLASS -> Material.SAND;
            case Material.LIGHT_BLUE_STAINED_GLASS -> Material.SAND;
            case Material.LIGHT_GRAY_STAINED_GLASS -> Material.SAND;
            case Material.LIME_STAINED_GLASS -> Material.SAND;
            case Material.MAGENTA_STAINED_GLASS -> Material.SAND;
            case Material.ORANGE_STAINED_GLASS -> Material.SAND;
            case Material.PINK_STAINED_GLASS -> Material.SAND;
            case Material.PURPLE_STAINED_GLASS -> Material.SAND;
            case Material.RED_STAINED_GLASS -> Material.SAND;
            case Material.YELLOW_STAINED_GLASS -> Material.SAND;
            case Material.BRICKS -> Material.CLAY;
            case Material.BRICK_SLAB -> Material.CLAY;
            case Material.BRICK_STAIRS -> Material.CLAY;
            case Material.BRICK_WALL -> Material.CLAY;
            default -> material;
        };
    }
}

