/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.placeholder;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.placeholder.UniversalPlaceholderExpansion;
import org.bukkit.Bukkit;

public class PlaceholderManager {
    private final UniverseJobs plugin;
    private UniversalPlaceholderExpansion universalPlaceholder;
    private boolean placeholderApiEnabled = false;

    public PlaceholderManager(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                this.universalPlaceholder = new UniversalPlaceholderExpansion(this.plugin);
                this.universalPlaceholder.register();
                this.placeholderApiEnabled = true;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to initialize PlaceholderAPI integration: " + e.getMessage());
            }
        } else {
            this.plugin.getLogger().warning("PlaceholderAPI not found. Placeholder features will be disabled.");
        }
    }

    public void shutdown() {
        if (this.placeholderApiEnabled) {
            try {
                if (this.universalPlaceholder != null) {
                    this.universalPlaceholder.unregister();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error while disabling PlaceholderAPI integration: " + e.getMessage());
            }
        }
    }

    public void clearCache() {
        if (this.placeholderApiEnabled && this.universalPlaceholder != null) {
            this.universalPlaceholder.clearCache();
            this.plugin.getLogger().info("Placeholder cache cleared.");
        }
    }

    public void clearJobCache(String jobId) {
        if (this.placeholderApiEnabled && this.universalPlaceholder != null) {
            this.universalPlaceholder.clearJobCache(jobId);
            this.plugin.getLogger().info("Placeholder cache cleared for job: " + jobId);
        }
    }

    public boolean isPlaceholderApiEnabled() {
        return this.placeholderApiEnabled;
    }
}

