/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage.migration;

import fr.ax_dev.universejobs.UniverseJobs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class JobsRebornConverter {
    private final UniverseJobs plugin;
    private final File jobsRebornFolder;
    private final File universeJobsFolder;

    public JobsRebornConverter(UniverseJobs plugin) {
        this.plugin = plugin;
        File jobsPluginFolder = null;
        if (plugin.getServer().getPluginManager().getPlugin("Jobs") != null) {
            jobsPluginFolder = plugin.getServer().getPluginManager().getPlugin("Jobs").getDataFolder();
            plugin.getLogger().info("Found active Jobs plugin at: " + jobsPluginFolder.getAbsolutePath());
        } else {
            String[] possiblePaths;
            for (String path : possiblePaths = new String[]{"Jobs", "JobsReborn", "jobs", "jobsreborn"}) {
                File candidate = new File(plugin.getDataFolder().getParent(), path);
                if (!candidate.exists() || !candidate.isDirectory()) continue;
                jobsPluginFolder = candidate;
                plugin.getLogger().info("Found JobsReborn folder at: " + jobsPluginFolder.getAbsolutePath());
                break;
            }
            if (jobsPluginFolder == null) {
                jobsPluginFolder = new File(plugin.getDataFolder().getParent(), "Jobs");
                plugin.getLogger().warning("No existing JobsReborn folder found, will try: " + jobsPluginFolder.getAbsolutePath());
            }
        }
        this.jobsRebornFolder = jobsPluginFolder;
        this.universeJobsFolder = new File(plugin.getDataFolder(), "jobs");
    }

    public ConversionResult convertAllJobs() {
        return this.convertJobs(null);
    }

    public ConversionResult convertJobs(String specificJobName) {
        ConversionResult result = new ConversionResult();
        if (!this.jobsRebornFolder.exists()) {
            result.error = "JobsReborn folder not found: " + this.jobsRebornFolder.getAbsolutePath();
            return result;
        }
        File[] jobFiles = this.findJobConfigFiles();
        if (jobFiles == null || jobFiles.length == 0) {
            result.error = "No JobsReborn job files found";
            return result;
        }
        try {
            if (jobFiles.length == 1 && jobFiles[0].getName().contains("Config")) {
                YamlConfiguration jobsConfig = YamlConfiguration.loadConfiguration((File)jobFiles[0]);
                this.convertJobsFromConfig((FileConfiguration)jobsConfig, result, specificJobName);
            } else {
                this.convertIndividualJobFiles(jobFiles, result, specificJobName);
            }
            result.success = true;
        }
        catch (Exception e) {
            result.error = "Failed to convert jobs: " + e.getMessage();
            this.plugin.getLogger().log(Level.SEVERE, "Job conversion failed", e);
        }
        return result;
    }

    private File[] findJobConfigFiles() {
        String[] possibleNames;
        if (!this.jobsRebornFolder.exists()) {
            return null;
        }
        File jobsSubfolder = new File(this.jobsRebornFolder, "jobs");
        if (jobsSubfolder.exists() && jobsSubfolder.isDirectory()) {
            this.plugin.getLogger().info("Found jobs subfolder: " + jobsSubfolder.getAbsolutePath());
            File[] jobFiles = jobsSubfolder.listFiles((dir, name) -> name.endsWith(".yml") || name.endsWith(".yaml"));
            if (jobFiles != null && jobFiles.length > 0) {
                this.plugin.getLogger().info("Found " + jobFiles.length + " job files in jobs subfolder:");
                for (File jobFile : jobFiles) {
                    this.plugin.getLogger().info("- " + jobFile.getName());
                }
                return jobFiles;
            }
        }
        for (String name2 : possibleNames = new String[]{"jobs.yml", "jobConfig.yml", "generalConfig.yml", "jobsConfig.yml", "Jobs.yml", "JobsConfig.yml"}) {
            File file = new File(this.jobsRebornFolder, name2);
            if (!file.exists()) continue;
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                if (!config.contains("Jobs")) continue;
                return new File[]{file};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void convertIndividualJobFiles(File[] jobFiles, ConversionResult result, String specificJobName) {
        if (!this.universeJobsFolder.exists()) {
            this.universeJobsFolder.mkdirs();
        }
        for (File jobFile : jobFiles) {
            try {
                String jobName = jobFile.getName().replace(".yml", "").replace(".yaml", "");
                if (specificJobName != null && !jobName.equalsIgnoreCase(specificJobName)) continue;
                this.plugin.getLogger().info("Converting job file: " + jobFile.getName());
                YamlConfiguration jobConfig = YamlConfiguration.loadConfiguration((File)jobFile);
                this.convertSingleJobFromFile(jobName, (FileConfiguration)jobConfig);
                result.convertedJobs.add(jobName.toLowerCase());
                ++result.jobsConverted;
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to convert job file: " + jobFile.getName(), e);
                result.failedJobs.add(jobFile.getName() + ": " + e.getMessage());
            }
        }
        if (specificJobName != null && result.jobsConverted == 0) {
            result.error = "Job '" + specificJobName + "' not found in JobsReborn files";
        }
    }

    private void convertSingleJobFromFile(String jobName, FileConfiguration jobConfig) throws Exception {
        String jobId = jobName.toLowerCase();
        File outputFile = new File(this.universeJobsFolder, jobId + ".yml");
        YamlConfiguration output = new YamlConfiguration();
        ConfigurationSection jobSection = null;
        String capitalizedJobName = jobName.substring(0, 1).toUpperCase() + jobName.substring(1).toLowerCase();
        if (jobConfig.contains(capitalizedJobName)) {
            jobSection = jobConfig.getConfigurationSection(capitalizedJobName);
            this.plugin.getLogger().info("Found job data under section: " + capitalizedJobName);
        } else if (jobConfig.contains(jobName.toLowerCase())) {
            jobSection = jobConfig.getConfigurationSection(jobName.toLowerCase());
            this.plugin.getLogger().info("Found job data under section: " + jobName.toLowerCase());
        } else if (jobConfig.contains(jobName.toUpperCase())) {
            jobSection = jobConfig.getConfigurationSection(jobName.toUpperCase());
            this.plugin.getLogger().info("Found job data under section: " + jobName.toUpperCase());
        } else {
            this.plugin.getLogger().info("Using root level data for job: " + jobName);
        }
        ConfigurationSection dataSource = jobSection != null ? jobSection : jobConfig;
        output.set("name", (Object)this.convertJobDisplayName(jobName, dataSource));
        output.set("description", this.convertJobDescription(dataSource));
        output.set("enabled", (Object)dataSource.getBoolean("enabled", true));
        output.set("max-level", (Object)dataSource.getInt("max-level", 100));
        output.set("permission", (Object)("UniverseJobs.job." + jobId));
        this.convertJobIcon(dataSource, (FileConfiguration)output, jobName);
        this.convertRewards(jobId, (FileConfiguration)output);
        this.convertXpConfig(dataSource, (FileConfiguration)output);
        this.convertActionsFromFile(dataSource, (FileConfiguration)output);
        this.convertLevelupActionsFromFile(dataSource, (FileConfiguration)output);
        output.save(outputFile);
    }

    private void convertJobsFromConfig(FileConfiguration jobsConfig, ConversionResult result, String specificJobName) {
        ConfigurationSection jobsSection;
        if (!this.universeJobsFolder.exists()) {
            this.universeJobsFolder.mkdirs();
        }
        if ((jobsSection = jobsConfig.getConfigurationSection("Jobs")) == null) {
            result.error = "No 'Jobs' section found in configuration";
            return;
        }
        for (String jobName : jobsSection.getKeys(false)) {
            try {
                ConfigurationSection jobSection;
                if (specificJobName != null && !jobName.equalsIgnoreCase(specificJobName) || (jobSection = jobsSection.getConfigurationSection(jobName)) == null) continue;
                this.convertSingleJob(jobName, jobSection);
                result.convertedJobs.add(jobName.toLowerCase());
                ++result.jobsConverted;
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to convert job: " + jobName, e);
                result.failedJobs.add(jobName + ": " + e.getMessage());
            }
        }
        if (specificJobName != null && result.jobsConverted == 0) {
            result.error = "Job '" + specificJobName + "' not found in JobsReborn configuration";
        }
    }

    private void convertSingleJob(String jobName, ConfigurationSection jobSection) throws IOException {
        String jobId = jobName.toLowerCase();
        File outputFile = new File(this.universeJobsFolder, jobId + ".yml");
        YamlConfiguration output = new YamlConfiguration();
        output.set("name", (Object)this.convertJobDisplayName(jobName, jobSection));
        output.set("description", this.convertJobDescription(jobSection));
        output.set("enabled", (Object)jobSection.getBoolean("enabled", true));
        output.set("max-level", (Object)jobSection.getInt("max-level", 100));
        output.set("permission", (Object)("UniverseJobs.job." + jobId));
        this.convertJobIcon(jobSection, (FileConfiguration)output);
        this.convertRewards(jobId, (FileConfiguration)output);
        this.convertXpConfig(jobSection, (FileConfiguration)output);
        this.convertActions(jobSection, (FileConfiguration)output);
        this.convertLevelupActions(jobSection, (FileConfiguration)output);
        output.save(outputFile);
    }

    private String convertJobDisplayName(String jobName, ConfigurationSection dataSource) {
        String chatColor;
        this.plugin.getLogger().info("Converting display name for job: " + jobName);
        this.plugin.getLogger().info("Available keys in data source: " + String.valueOf(dataSource.getKeys(false)));
        String displayName = dataSource.getString("displayName", null);
        if (displayName == null) {
            displayName = dataSource.getString("displayname", null);
        }
        if (displayName == null) {
            displayName = dataSource.getString("fullname", null);
        }
        if (displayName == null) {
            displayName = dataSource.getString("name", jobName);
        }
        if ((chatColor = dataSource.getString("ChatColour", null)) == null) {
            chatColor = dataSource.getString("chatcolour", null);
        }
        if (chatColor == null) {
            chatColor = dataSource.getString("color", null);
        }
        this.plugin.getLogger().info("Converting job display name - jobName: " + jobName + ", displayName: " + displayName + ", chatColor: " + chatColor);
        if (chatColor != null) {
            String hexColor = this.convertChatColorToHex(chatColor);
            String result = hexColor + displayName;
            this.plugin.getLogger().info("Final display name with color: " + result);
            return result;
        }
        this.plugin.getLogger().info("Final display name without color: " + displayName);
        return displayName;
    }

    private List<String> convertJobDescription(ConfigurationSection dataSource) {
        String description;
        this.plugin.getLogger().info("Converting description - available keys: " + String.valueOf(dataSource.getKeys(false)));
        this.plugin.getLogger().info("Checking FullDescription...");
        if (dataSource.contains("FullDescription")) {
            List fullDesc = dataSource.getStringList("FullDescription");
            this.plugin.getLogger().info("Found FullDescription: " + String.valueOf(fullDesc));
            if (fullDesc != null && !fullDesc.isEmpty()) {
                return fullDesc;
            }
        }
        if ((description = dataSource.getString("description", null)) == null) {
            description = dataSource.getString("desc", null);
        }
        if (description == null) {
            description = dataSource.getString("info", null);
        }
        this.plugin.getLogger().info("No FullDescription found, using description: " + description);
        if (description == null || description.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] lines = description.split("\\n");
        return Arrays.asList(lines);
    }

    private void convertJobIcon(ConfigurationSection jobSection, FileConfiguration output) {
        this.convertJobIcon(jobSection, output);
    }

    private void convertJobIcon(ConfigurationSection dataSource, FileConfiguration output, String jobName) {
        this.plugin.getLogger().info("Converting icon for job: " + jobName);
        String iconMaterial = null;
        if (dataSource.contains("Gui.ItemStack")) {
            String[] parts;
            String itemStack = dataSource.getString("Gui.ItemStack");
            this.plugin.getLogger().info("Found Gui.ItemStack: " + itemStack);
            if (itemStack != null && !itemStack.isEmpty() && (parts = itemStack.split(";")).length > 0) {
                String originalMaterial = parts[0];
                iconMaterial = this.convertMaterialName(originalMaterial.toUpperCase());
                this.plugin.getLogger().info("Parsed material: " + originalMaterial + " -> " + iconMaterial);
            }
        } else {
            this.plugin.getLogger().info("No Gui.ItemStack found, checking other icon fields...");
            if (dataSource.contains("icon")) {
                iconMaterial = this.convertMaterialName(dataSource.getString("icon").toUpperCase());
                this.plugin.getLogger().info("Found icon field: " + iconMaterial);
            }
        }
        if (iconMaterial != null && !iconMaterial.isEmpty()) {
            this.plugin.getLogger().info("Final icon material: " + iconMaterial);
            output.set("icon.material", (Object)iconMaterial);
            output.set("icon.custom-model-data", (Object)"");
        } else {
            this.plugin.getLogger().warning("No icon found in JobsReborn config for job: " + jobName);
        }
    }

    private String convertMaterialName(String oldMaterial) {
        switch (oldMaterial.toLowerCase()) {
            case "oaklog": {
                return "OAK_LOG";
            }
            case "wood": {
                return "OAK_PLANKS";
            }
            case "log": {
                return "OAK_LOG";
            }
            case "raw_fish": {
                return "COD";
            }
            case "cooked_fish": {
                return "COOKED_COD";
            }
            case "wood_sword": {
                return "WOODEN_SWORD";
            }
            case "wood_pickaxe": {
                return "WOODEN_PICKAXE";
            }
            case "wood_axe": {
                return "WOODEN_AXE";
            }
            case "wood_shovel": {
                return "WOODEN_SHOVEL";
            }
            case "wood_hoe": {
                return "WOODEN_HOE";
            }
            case "brick_stairs": {
                return "BRICK_STAIRS";
            }
            case "brickstairs": {
                return "BRICK_STAIRS";
            }
        }
        return oldMaterial.toUpperCase();
    }

    private void convertRewards(String jobId, FileConfiguration output) {
    }

    private void convertXpConfig(ConfigurationSection jobSection, FileConfiguration output) {
        output.set("xp.type", (Object)"CURVE");
        output.set("xp.xp", (Object)"default");
    }

    private void convertActions(ConfigurationSection jobSection, FileConfiguration output) {
        ConfigurationSection dyeSection;
        ConfigurationSection shearSection;
        ConfigurationSection milkSection;
        ConfigurationSection breedSection;
        ConfigurationSection tameSection;
        ConfigurationSection repairSection;
        ConfigurationSection enchantSection;
        ConfigurationSection brewSection;
        ConfigurationSection smeltSection;
        ConfigurationSection craftSection;
        ConfigurationSection fishSection;
        ConfigurationSection killSection;
        ConfigurationSection placeSection;
        HashMap<String, Map<String, Object>> actions = new HashMap<String, Map<String, Object>>();
        ConfigurationSection breakSection = jobSection.getConfigurationSection("Break");
        if (breakSection != null) {
            actions.put("BREAK", this.convertActionSection(breakSection, "BREAK"));
        }
        if ((placeSection = jobSection.getConfigurationSection("Place")) != null) {
            actions.put("PLACE", this.convertActionSection(placeSection, "PLACE"));
        }
        if ((killSection = jobSection.getConfigurationSection("Kill")) != null) {
            actions.put("KILL", this.convertActionSection(killSection, "KILL"));
        }
        if ((fishSection = jobSection.getConfigurationSection("Fish")) != null) {
            actions.put("FISH", this.convertActionSection(fishSection, "FISH"));
        }
        if ((craftSection = jobSection.getConfigurationSection("Craft")) != null) {
            actions.put("CRAFT", this.convertActionSection(craftSection, "CRAFT"));
        }
        if ((smeltSection = jobSection.getConfigurationSection("Smelt")) != null) {
            actions.put("SMELT", this.convertActionSection(smeltSection, "SMELT"));
        }
        if ((brewSection = jobSection.getConfigurationSection("Brew")) != null) {
            actions.put("BREW", this.convertActionSection(brewSection, "BREW"));
        }
        if ((enchantSection = jobSection.getConfigurationSection("Enchant")) != null) {
            actions.put("ENCHANT", this.convertActionSection(enchantSection, "ENCHANT"));
        }
        if ((repairSection = jobSection.getConfigurationSection("Repair")) != null) {
            actions.put("REPAIR", this.convertActionSection(repairSection, "REPAIR"));
        }
        if ((tameSection = jobSection.getConfigurationSection("Tame")) != null) {
            actions.put("TAME", this.convertActionSection(tameSection, "TAME"));
        }
        if ((breedSection = jobSection.getConfigurationSection("Breed")) != null) {
            actions.put("BREED", this.convertActionSection(breedSection, "BREED"));
        }
        if ((milkSection = jobSection.getConfigurationSection("Milk")) != null) {
            actions.put("MILK", this.convertActionSection(milkSection, "MILK"));
        }
        if ((shearSection = jobSection.getConfigurationSection("Shear")) != null) {
            actions.put("SHEAR", this.convertActionSection(shearSection, "SHEAR"));
        }
        if ((dyeSection = jobSection.getConfigurationSection("Dye")) != null) {
            actions.put("DYE", this.convertActionSection(dyeSection, "DYE"));
        }
        output.set("actions", actions);
    }

    private void convertActionsFromFile(ConfigurationSection dataSource, FileConfiguration output) {
        String[] actionTypes;
        this.plugin.getLogger().info("Converting actions from file - available keys: " + String.valueOf(dataSource.getKeys(false)));
        HashMap<String, Map<String, Object>> allActions = new HashMap<String, Map<String, Object>>();
        for (String actionType : actionTypes = new String[]{"Break", "Place", "Kill", "Fish", "Craft", "Smelt", "Enchant", "Brew", "Repair", "Tame", "Breed", "Milk", "Shear", "Dye", "Explore", "Collect", "Bucket", "Bake", "StripLogs", "Vax", "TNTBreak", "VTrade", "MMKill", "custom-kill", "PyroFishingPro", "CustomFishing", "Brush"}) {
            if (!dataSource.contains(actionType)) continue;
            this.plugin.getLogger().info("Found action type: " + actionType);
            ConfigurationSection actionSection = dataSource.getConfigurationSection(actionType);
            if (actionSection != null) {
                this.plugin.getLogger().info("Action section keys for " + actionType + ": " + String.valueOf(actionSection.getKeys(false)));
                Map<String, Object> convertedActions = this.convertActionSection(actionSection, actionType);
                this.plugin.getLogger().info("Converted " + convertedActions.size() + " actions for " + actionType);
                if (convertedActions.isEmpty()) continue;
                String targetActionType = actionType.equals("Collect") ? "BREAK" : actionType.toUpperCase();
                allActions.put(targetActionType, convertedActions);
                continue;
            }
            this.plugin.getLogger().info("Action section is null for: " + actionType);
        }
        this.plugin.getLogger().info("Total converted action types: " + allActions.size());
        output.set("actions", allActions);
    }

    private Map<String, Object> convertActionSection(ConfigurationSection section, String actionType) {
        HashMap<String, Object> actions = new HashMap<String, Object>();
        for (String materialKey : section.getKeys(false)) {
            if (section.isConfigurationSection(materialKey)) {
                ConfigurationSection materialSection = section.getConfigurationSection(materialKey);
                String[] materialParts = materialKey.split("-");
                String baseMaterial = materialParts[0];
                Integer age = null;
                if (materialParts.length > 1) {
                    try {
                        age = Integer.parseInt((String)materialParts[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                String actionId = actionType.toLowerCase() + "_" + baseMaterial.toLowerCase();
                if (age != null) {
                    actionId = actionId + "_age_" + age;
                }
                HashMap<String, Object> actionData = new HashMap<String, Object>();
                actionData.put("target", this.convertMaterialName(baseMaterial).toUpperCase());
                actionData.put("display-name", this.formatDisplayName(baseMaterial));
                actionData.put("lore", new ArrayList());
                if (age != null) {
                    actionData.put("age", age);
                }
                double experience = materialSection.getDouble("experience", 1.0);
                double income = materialSection.getDouble("income", experience);
                double points = materialSection.getDouble("points", experience);
                actionData.put("xp", experience);
                actionData.put("money", income);
                actions.put(actionId, actionData);
                continue;
            }
            if (materialKey.equals("materials")) {
                List materialsList = section.getStringList(materialKey);
                for (String materialEntry : materialsList) {
                    String[] parts = materialEntry.split(";");
                    if (parts.length < 2) continue;
                    String material = parts[0];
                    String actionId = actionType.toLowerCase() + "_" + material.toLowerCase();
                    HashMap<String, Object> actionData = new HashMap<String, Object>();
                    actionData.put("target", this.convertMaterialName(material).toUpperCase());
                    actionData.put("display-name", this.formatDisplayName(material));
                    actionData.put("lore", new ArrayList());
                    try {
                        double income = Double.parseDouble(parts[1]);
                        double experience = parts.length > 2 ? Double.parseDouble(parts[2]) : income;
                        actionData.put("xp", experience);
                        actionData.put("money", income);
                    }
                    catch (NumberFormatException e) {
                        actionData.put("xp", 1.0);
                        actionData.put("money", 1.0);
                    }
                    actions.put(actionId, actionData);
                }
                continue;
            }
            String[] materialParts = materialKey.split("-");
            String baseMaterial = materialParts[0];
            Integer age = null;
            if (materialParts.length > 1) {
                try {
                    age = Integer.parseInt(materialParts[1]);
                }
                catch (NumberFormatException parts) {
                    // empty catch block
                }
            }
            String actionId = actionType.toLowerCase() + "_" + baseMaterial.toLowerCase();
            if (age != null) {
                actionId = actionId + "_age_" + age;
            }
            HashMap<String, Object> actionData = new HashMap<String, Object>();
            actionData.put("target", this.convertMaterialName(baseMaterial).toUpperCase());
            actionData.put("display-name", this.formatDisplayName(baseMaterial));
            actionData.put("lore", new ArrayList());
            if (age != null) {
                actionData.put("age", age);
            }
            double value = section.getDouble(materialKey, 1.0);
            actionData.put("xp", value);
            actionData.put("money", value);
            actions.put(actionId, actionData);
        }
        return actions;
    }

    private String formatDisplayName(String material) {
        String[] parts = material.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(parts[i].substring(0, 1).toUpperCase()).append(parts[i].substring(1));
        }
        return result.toString();
    }

    private void convertLevelupActions(ConfigurationSection jobSection, FileConfiguration output) {
        HashMap levelupActions = new HashMap();
        HashMap<String, Object> broadcast = new HashMap<String, Object>();
        broadcast.put("type", "broadcast");
        broadcast.put("min-level", 1);
        broadcast.put("level-interval", 10);
        String jobColor = this.convertChatColorToHex(jobSection.getString("ChatColour", "&a"));
        String jobName = jobSection.getString("displayname", jobSection.getName());
        broadcast.put("messages", Arrays.asList("<#90db8a>{player} <#9a9c9a>has reached level " + jobColor + "{level} <#9a9c9a>in " + jobColor + jobName + "<#9a9c9a>!"));
        levelupActions.put("broadcast", broadcast);
        HashMap<String, Object> title = new HashMap<String, Object>();
        title.put("type", "title");
        title.put("min-level", 1);
        title.put("level-interval", 1);
        title.put("title", jobColor + "Reached level {level}");
        title.put("subtitle", "<#9a9c9a>in " + jobColor + jobName + "<#9a9c9a>!");
        title.put("fade-in", 5);
        title.put("stay", 20);
        title.put("fade-out", 10);
        levelupActions.put("title", title);
        HashMap<String, Object> sound = new HashMap<String, Object>();
        sound.put("type", "sound");
        sound.put("min-level", 1);
        sound.put("level-interval", 1);
        sound.put("sound", "ENTITY_PLAYER_LEVELUP");
        levelupActions.put("sound", sound);
        HashMap<String, Object> particle = new HashMap<String, Object>();
        particle.put("type", "particle");
        particle.put("min-level", 1);
        particle.put("level-interval", 1);
        particle.put("count", "20");
        particle.put("particle", "TOTEM");
        levelupActions.put("particle", particle);
        output.set("levelup-actions", levelupActions);
    }

    private void convertLevelupActionsFromFile(ConfigurationSection dataSource, FileConfiguration output) {
    }

    private String convertChatColorToHex(String chatColor) {
        if (chatColor == null) {
            return "<#32CD32>";
        }
        switch (chatColor.toLowerCase()) {
            case "black": {
                return "<#000000>";
            }
            case "dark_blue": {
                return "<#0000AA>";
            }
            case "dark_green": {
                return "<#00AA00>";
            }
            case "dark_aqua": {
                return "<#00AAAA>";
            }
            case "dark_red": {
                return "<#AA0000>";
            }
            case "dark_purple": {
                return "<#AA00AA>";
            }
            case "gold": {
                return "<#FFAA00>";
            }
            case "gray": {
                return "<#AAAAAA>";
            }
            case "dark_gray": {
                return "<#555555>";
            }
            case "blue": {
                return "<#5555FF>";
            }
            case "green": {
                return "<#55FF55>";
            }
            case "aqua": {
                return "<#55FFFF>";
            }
            case "red": {
                return "<#FF5555>";
            }
            case "light_purple": {
                return "<#FF55FF>";
            }
            case "yellow": {
                return "<#FFFF55>";
            }
            case "white": {
                return "<#FFFFFF>";
            }
            case "&0": {
                return "<#000000>";
            }
            case "&1": {
                return "<#0000AA>";
            }
            case "&2": {
                return "<#00AA00>";
            }
            case "&3": {
                return "<#00AAAA>";
            }
            case "&4": {
                return "<#AA0000>";
            }
            case "&5": {
                return "<#AA00AA>";
            }
            case "&6": {
                return "<#FFAA00>";
            }
            case "&7": {
                return "<#AAAAAA>";
            }
            case "&8": {
                return "<#555555>";
            }
            case "&9": {
                return "<#5555FF>";
            }
            case "&a": {
                return "<#55FF55>";
            }
            case "&b": {
                return "<#55FFFF>";
            }
            case "&c": {
                return "<#FF5555>";
            }
            case "&d": {
                return "<#FF55FF>";
            }
            case "&e": {
                return "<#FFFF55>";
            }
            case "&f": {
                return "<#FFFFFF>";
            }
        }
        if (chatColor.startsWith("#")) {
            return "<" + chatColor + ">";
        }
        return "<#32CD32>";
    }

    public List<String> getAvailableJobNames() {
        ArrayList<String> jobNames = new ArrayList<String>();
        if (!this.jobsRebornFolder.exists()) {
            return jobNames;
        }
        File[] jobFiles = this.findJobConfigFiles();
        if (jobFiles == null || jobFiles.length == 0) {
            return jobNames;
        }
        if (jobFiles.length == 1 && jobFiles[0].getName().contains("Config")) {
            try {
                YamlConfiguration jobsConfig = YamlConfiguration.loadConfiguration((File)jobFiles[0]);
                ConfigurationSection jobsSection = jobsConfig.getConfigurationSection("Jobs");
                if (jobsSection != null) {
                    jobNames.addAll(jobsSection.getKeys(false));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error reading JobsReborn config: " + e.getMessage());
            }
        } else {
            for (File jobFile : jobFiles) {
                String jobName = jobFile.getName().replace(".yml", "").replace(".yaml", "");
                if (jobName.toLowerCase().startsWith("_example") || jobName.toLowerCase().equals("none")) continue;
                jobNames.add(jobName);
            }
        }
        return jobNames;
    }

    public static class ConversionResult {
        public boolean success = false;
        public int jobsConverted = 0;
        public List<String> convertedJobs = new ArrayList<String>();
        public List<String> failedJobs = new ArrayList<String>();
        public String error = null;

        public boolean isSuccessful() {
            return this.success;
        }

        public int getTotalConverted() {
            return this.jobsConverted;
        }
    }
}

