/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage.migration;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.storage.database.DatabaseDataStorage;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class JobsRebornDataMigrator {
    private final UniverseJobs plugin;
    private final DatabaseDataStorage databaseStorage;
    private final File jobsRebornFolder;
    private final File backupFolder;

    public JobsRebornDataMigrator(UniverseJobs plugin, DatabaseDataStorage databaseStorage) {
        this.plugin = plugin;
        this.databaseStorage = databaseStorage;
        File jobsPluginFolder = null;
        jobsPluginFolder = plugin.getServer().getPluginManager().getPlugin("Jobs") != null ? plugin.getServer().getPluginManager().getPlugin("Jobs").getDataFolder() : new File(plugin.getDataFolder().getParent(), "Jobs");
        this.jobsRebornFolder = jobsPluginFolder;
        this.backupFolder = new File(plugin.getDataFolder(), "jobsreborn-migration-backup");
    }

    public CompletableFuture<MigrationResult> migrateAllData() {
        return CompletableFuture.supplyAsync(() -> {
            this.plugin.getLogger().info("Starting data migration from JobsReborn...");
            MigrationResult result = new MigrationResult();
            try {
                this.createBackup();
                result.playerDataMigrated = this.hasJobsRebornDatabase() ? this.migrateDatabaseData() : this.migrateFileData();
                result.success = true;
                this.plugin.getLogger().info("JobsReborn data migration completed successfully!");
                this.plugin.getLogger().info("Player data migrated: " + result.playerDataMigrated);
            }
            catch (Exception e) {
                result.success = false;
                result.error = e.getMessage();
                this.plugin.getLogger().log(Level.SEVERE, "JobsReborn data migration failed", e);
            }
            return result;
        });
    }

    private void createBackup() {
        if (!this.backupFolder.exists()) {
            this.backupFolder.mkdirs();
        }
        File backupDataFolder = new File(this.backupFolder, "jobsreborn-data-" + System.currentTimeMillis());
        if (this.jobsRebornFolder.exists()) {
            this.copyDirectory(this.jobsRebornFolder, backupDataFolder);
            this.plugin.getLogger().info("Created JobsReborn backup at: " + backupDataFolder.getAbsolutePath());
        }
    }

    private boolean hasJobsRebornDatabase() {
        File configFile = new File(this.jobsRebornFolder, "generalConfig.yml");
        if (!configFile.exists()) {
            configFile = new File(this.jobsRebornFolder, "config.yml");
        }
        if (configFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            String storageMethod = config.getString("storage-method", "file");
            return storageMethod.equalsIgnoreCase("mysql") || storageMethod.equalsIgnoreCase("sqlite");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int migrateDatabaseData() {
        AtomicInteger migratedCount = new AtomicInteger(0);
        try {
            Connection connection = this.getJobsRebornConnection();
            if (connection == null) {
                this.plugin.getLogger().warning("Could not connect to JobsReborn database");
                return 0;
            }
            String query = "SELECT * FROM jobs_users";
            try (PreparedStatement stmt = connection.prepareStatement(query);
                 ResultSet rs = stmt.executeQuery();){
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                while (rs.next()) {
                    UUID playerId = this.getPlayerUUID(rs);
                    if (playerId == null) continue;
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        try {
                            PlayerJobData playerData = this.convertDatabasePlayerData(rs, playerId);
                            this.databaseStorage.savePlayerDataAsync(playerId, playerData).join();
                            migratedCount.incrementAndGet();
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().log(Level.WARNING, "Failed to migrate player data for: " + String.valueOf(playerId), e);
                        }
                    });
                    futures.add(future);
                }
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            }
            finally {
                connection.close();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Database migration failed", e);
        }
        return migratedCount.get();
    }

    private int migrateFileData() {
        AtomicInteger migratedCount = new AtomicInteger(0);
        File playersFolder = new File(this.jobsRebornFolder, "players");
        if (!playersFolder.exists() || !playersFolder.isDirectory()) {
            this.plugin.getLogger().info("No JobsReborn player data folder found");
            return 0;
        }
        File[] playerFiles = playersFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (playerFiles == null || playerFiles.length == 0) {
            this.plugin.getLogger().info("No JobsReborn player files found");
            return 0;
        }
        this.plugin.getLogger().info("Migrating " + playerFiles.length + " JobsReborn player files...");
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (File playerFile : playerFiles) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try {
                    String fileName = playerFile.getName();
                    String uuidString = fileName.substring(0, fileName.length() - 4);
                    UUID playerId = UUID.fromString(uuidString);
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
                    PlayerJobData playerData = this.convertFilePlayerData((FileConfiguration)config, playerId);
                    this.databaseStorage.savePlayerDataAsync(playerId, playerData).join();
                    migratedCount.incrementAndGet();
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to migrate player file: " + playerFile.getName(), e);
                }
            });
            futures.add(future);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        return migratedCount.get();
    }

    private Connection getJobsRebornConnection() {
        File configFile = new File(this.jobsRebornFolder, "generalConfig.yml");
        if (!configFile.exists()) {
            configFile = new File(this.jobsRebornFolder, "config.yml");
        }
        if (!configFile.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        String storageMethod = config.getString("storage-method", "file");
        try {
            if (storageMethod.equalsIgnoreCase("mysql")) {
                String host = config.getString("mysql-hostname", "localhost");
                int port = config.getInt("mysql-port", 3306);
                String database = config.getString("mysql-database", "minecraft");
                String username = config.getString("mysql-username", "root");
                String password = config.getString("mysql-password", "");
                String url = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&allowPublicKeyRetrieval=true";
                return DriverManager.getConnection(url, username, password);
            }
            if (storageMethod.equalsIgnoreCase("sqlite")) {
                File sqliteFile = new File(this.jobsRebornFolder, "jobs.sqlite.db");
                if (!sqliteFile.exists()) {
                    sqliteFile = new File(this.jobsRebornFolder, "jobs.db");
                }
                if (sqliteFile.exists()) {
                    String url = "jdbc:sqlite:" + sqliteFile.getAbsolutePath();
                    return DriverManager.getConnection(url);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to connect to JobsReborn database", e);
        }
        return null;
    }

    private UUID getPlayerUUID(ResultSet rs) throws SQLException {
        try {
            String uuidString = rs.getString("player_uuid");
            if (uuidString != null && !uuidString.isEmpty()) {
                return UUID.fromString(uuidString);
            }
        }
        catch (Exception uuidString) {
            // empty catch block
        }
        try {
            String username = rs.getString("username");
            if (username != null && !username.isEmpty()) {
                return this.plugin.getServer().getOfflinePlayer(username).getUniqueId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private PlayerJobData convertDatabasePlayerData(ResultSet rs, UUID playerId) throws SQLException {
        PlayerJobData playerData = new PlayerJobData(playerId);
        try {
            ConfigurationSection jobsSection = null;
            String jobsData = rs.getString("jobs");
            if (jobsData != null && !jobsData.isEmpty()) {
                YamlConfiguration tempConfig = new YamlConfiguration();
                tempConfig.loadFromString(jobsData);
                jobsSection = tempConfig.getConfigurationSection("jobs");
            }
            if (jobsSection != null) {
                this.convertJobsData(jobsSection, playerData);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error parsing jobs data for player: " + String.valueOf(playerId), e);
        }
        return playerData;
    }

    private PlayerJobData convertFilePlayerData(FileConfiguration config, UUID playerId) {
        PlayerJobData playerData = new PlayerJobData(playerId);
        ConfigurationSection jobsSection = config.getConfigurationSection("jobs");
        if (jobsSection != null) {
            this.convertJobsData(jobsSection, playerData);
        }
        return playerData;
    }

    private void convertJobsData(ConfigurationSection jobsSection, PlayerJobData playerData) {
        for (String jobName : jobsSection.getKeys(false)) {
            ConfigurationSection jobSection = jobsSection.getConfigurationSection(jobName);
            if (jobSection == null) continue;
            String jobId = jobName.toLowerCase();
            int level = jobSection.getInt("level", 1);
            double experience = jobSection.getDouble("experience", 0.0);
            playerData.joinJob(jobId);
            playerData.setLevel(jobId, level);
            playerData.setXp(jobId, experience);
        }
    }

    private void copyDirectory(File source, File destination) {
        try {
            if (source.isDirectory()) {
                destination.mkdirs();
                File[] files = source.listFiles();
                if (files != null) {
                    for (File file : files) {
                        File destFile = new File(destination, file.getName());
                        this.copyDirectory(file, destFile);
                    }
                }
            } else {
                Files.copy(source.toPath(), destination.toPath(), new CopyOption[0]);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to copy file: " + source.getName(), e);
        }
    }

    public boolean shouldMigrate() {
        File migrationMarker = new File(this.plugin.getDataFolder(), ".jobsreborn-migrated");
        if (migrationMarker.exists()) {
            return false;
        }
        return this.jobsRebornFolder.exists() && (this.hasJobsRebornDatabase() || new File(this.jobsRebornFolder, "players").exists());
    }

    public void markMigrationComplete() {
        try {
            File migrationMarker = new File(this.plugin.getDataFolder(), ".jobsreborn-migrated");
            migrationMarker.createNewFile();
            this.plugin.getLogger().info("JobsReborn migration marked as complete");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create JobsReborn migration marker", e);
        }
    }

    public static class MigrationResult {
        public boolean success = false;
        public int playerDataMigrated = 0;
        public String error = null;

        public boolean isSuccessful() {
            return this.success;
        }

        public int getTotalMigrated() {
            return this.playerDataMigrated;
        }
    }
}

