/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.EntityType;

public class EnumUtils {
    private static final Map<String, Object> enumCache = new ConcurrentHashMap<String, Object>();
    private static final int MAX_CACHE_SIZE = 500;
    private static Material[] cachedMaterialValues = null;

    public static Sound parseSound(String soundName, Sound defaultSound) {
        if (soundName == null || soundName.isEmpty()) {
            return defaultSound;
        }
        try {
            try {
                NamespacedKey key = NamespacedKey.minecraft((String)soundName.toLowerCase().replace("_", "."));
                Field soundsField = Registry.class.getField("SOUNDS");
                Object soundsRegistry = soundsField.get(null);
                Method getMethod = soundsRegistry.getClass().getMethod("get", NamespacedKey.class);
                Object result = getMethod.invoke(soundsRegistry, key);
                if (result instanceof Sound) {
                    return (Sound)result;
                }
            }
            catch (NoSuchFieldException key) {
            }
            catch (Exception key) {
                // empty catch block
            }
            try {
                Method valueOfMethod = Sound.class.getMethod("valueOf", String.class);
                Object result = valueOfMethod.invoke(null, soundName.toUpperCase());
                if (result instanceof Sound) {
                    return (Sound)result;
                }
            }
            catch (Exception valueOfMethod) {
                // empty catch block
            }
            try {
                Field field = Sound.class.getField(soundName.toUpperCase());
                if (field.getType() == Sound.class) {
                    return (Sound)field.get(null);
                }
            }
            catch (Exception field) {
                // empty catch block
            }
            try {
                Sound[] values;
                Method valuesMethod = Sound.class.getMethod("values", new Class[0]);
                for (Sound enumConstant : values = (Sound[])valuesMethod.invoke(null, new Object[0])) {
                    if (!enumConstant.name().equalsIgnoreCase(soundName)) continue;
                    return enumConstant;
                }
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultSound;
    }

    public static Material parseMaterial(String materialName, Material defaultMaterial) {
        if (materialName == null || materialName.isEmpty()) {
            return defaultMaterial;
        }
        String cacheKey = "Material:" + materialName.toUpperCase();
        Object cached = enumCache.get(cacheKey);
        if (cached != null) {
            return cached == NullMarker.INSTANCE ? defaultMaterial : (Material)cached;
        }
        Material result = EnumUtils.parseEnumSafely(Material.class, materialName, null);
        if (result != null) {
            EnumUtils.addToCache(cacheKey, result);
            return result;
        }
        result = EnumUtils.parseMaterialFlexible(materialName, defaultMaterial);
        EnumUtils.addToCache(cacheKey, result != null ? result : NullMarker.INSTANCE);
        return result;
    }

    private static void addToCache(String key, Object value) {
        if (enumCache.size() >= 500) {
            enumCache.clear();
        }
        enumCache.put(key, value);
    }

    public static Particle parseParticle(String particleName, Particle defaultParticle) {
        return EnumUtils.parseEnumSafely(Particle.class, particleName, defaultParticle);
    }

    public static EntityType parseEntityType(String entityName, EntityType defaultType) {
        return EnumUtils.parseEnumSafely(EntityType.class, entityName, defaultType);
    }

    public static BarColor parseBarColor(String colorName, BarColor defaultColor) {
        return EnumUtils.parseEnumSafely(BarColor.class, colorName, defaultColor);
    }

    public static BarStyle parseBarStyle(String styleName, BarStyle defaultStyle) {
        return EnumUtils.parseEnumSafely(BarStyle.class, styleName, defaultStyle);
    }

    public static Material parseMaterialFlexible(String materialName, Material defaultMaterial) {
        if (materialName == null || materialName.isEmpty()) {
            return defaultMaterial;
        }
        String normalizedName = materialName.trim().toUpperCase();
        Material[] values = cachedMaterialValues;
        if (values == null) {
            try {
                Method valuesMethod = Material.class.getMethod("values", new Class[0]);
                values = (Material[])valuesMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                return defaultMaterial;
            }
        }
        for (Material material : values) {
            String inputWithoutUnderscores;
            String materialNameStr = material.name();
            if (materialNameStr.equalsIgnoreCase(normalizedName)) {
                return material;
            }
            String withoutUnderscores = materialNameStr.replace("_", "");
            if (!withoutUnderscores.equalsIgnoreCase(inputWithoutUnderscores = normalizedName.replace("_", ""))) continue;
            return material;
        }
        return defaultMaterial;
    }

    public static <T extends Enum<T>> T parseEnumSafely(Class<T> enumClass, String value, T defaultValue) {
        Object result;
        String cacheKey;
        block14: {
            if (value == null || value.isEmpty()) {
                return defaultValue;
            }
            cacheKey = enumClass.getSimpleName() + ":" + value.toUpperCase();
            Object cached = enumCache.get(cacheKey);
            if (cached != null) {
                return (T)(cached == NullMarker.INSTANCE ? defaultValue : (Enum)cached);
            }
            result = null;
            try {
                try {
                    Method valueOfMethod = enumClass.getMethod("valueOf", String.class);
                    Object enumResult = valueOfMethod.invoke(null, value.toUpperCase());
                    if (enumClass.isInstance(enumResult)) {
                        result = (Enum)enumResult;
                    }
                }
                catch (Exception valueOfMethod) {
                    // empty catch block
                }
                if (result == null) {
                    try {
                        Field field = enumClass.getField(value.toUpperCase());
                        if (field.getType() == enumClass) {
                            result = (Enum)field.get(null);
                        }
                    }
                    catch (Exception field) {
                        // empty catch block
                    }
                }
                if (result != null) break block14;
                try {
                    Enum[] values;
                    Method valuesMethod = enumClass.getMethod("values", new Class[0]);
                    for (Enum enumConstant : values = (Enum[])valuesMethod.invoke(null, new Object[0])) {
                        if (!enumConstant.name().equalsIgnoreCase(value)) continue;
                        result = enumConstant;
                        break;
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EnumUtils.addToCache(cacheKey, result != null ? result : NullMarker.INSTANCE);
        return (T)(result != null ? result : defaultValue);
    }

    static {
        try {
            Method valuesMethod = Material.class.getMethod("values", new Class[0]);
            cachedMaterialValues = (Material[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class NullMarker {
        static final NullMarker INSTANCE = new NullMarker();

        private NullMarker() {
        }
    }
}

