/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class LegacyToMiniMessageConverter {
    private static final Map<String, String> COLOR_MAPPINGS = new HashMap<String, String>();
    private static final Map<String, String> FORMAT_MAPPINGS = new HashMap<String, String>();
    private static final Pattern HEX_PATTERN_DIRECT = Pattern.compile("(?<!<)#([0-9a-fA-F]{6})(?!>)");
    private static final Pattern HEX_PATTERN_AMPERSAND = Pattern.compile("&#([0-9a-fA-F]{6})");
    private static final Pattern HEX_PATTERN_LEGACY = Pattern.compile("&x(&[0-9a-fA-F]){6}");
    private static final Pattern LEGACY_COLOR_PATTERN = Pattern.compile("&([0-9a-fklmnor])");
    private static final Pattern SECTION_COLOR_PATTERN = Pattern.compile("\u00a7([0-9a-fklmnor])");

    public static String convert(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String result = input;
        result = LegacyToMiniMessageConverter.convertHexColorsDirect(result);
        result = LegacyToMiniMessageConverter.convertHexColorsAmpersand(result);
        result = LegacyToMiniMessageConverter.convertHexColorsLegacy(result);
        result = LegacyToMiniMessageConverter.convertLegacyCodes(result);
        result = LegacyToMiniMessageConverter.convertSectionCodes(result);
        return result;
    }

    private static String convertHexColorsDirect(String input) {
        return HEX_PATTERN_DIRECT.matcher(input).replaceAll(matchResult -> {
            String hex = matchResult.group(1);
            return "<#" + hex + ">";
        });
    }

    private static String convertHexColorsAmpersand(String input) {
        return HEX_PATTERN_AMPERSAND.matcher(input).replaceAll(matchResult -> {
            String hex = matchResult.group(1);
            return "<#" + hex + ">";
        });
    }

    private static String convertHexColorsLegacy(String input) {
        return HEX_PATTERN_LEGACY.matcher(input).replaceAll(matchResult -> {
            String match = matchResult.group();
            StringBuilder hex = new StringBuilder();
            for (int i = 3; i < match.length(); i += 2) {
                hex.append(match.charAt(i));
            }
            return "<#" + String.valueOf(hex) + ">";
        });
    }

    private static String convertLegacyCodes(String input) {
        return LEGACY_COLOR_PATTERN.matcher(input).replaceAll(matchResult -> {
            String code = matchResult.group(1);
            return LegacyToMiniMessageConverter.convertCodeToMiniMessage(code);
        });
    }

    private static String convertSectionCodes(String input) {
        return SECTION_COLOR_PATTERN.matcher(input).replaceAll(matchResult -> {
            String code = matchResult.group(1);
            return LegacyToMiniMessageConverter.convertCodeToMiniMessage(code);
        });
    }

    private static String convertCodeToMiniMessage(String code) {
        if (COLOR_MAPPINGS.containsKey(code)) {
            return "<" + COLOR_MAPPINGS.get(code) + ">";
        }
        if (FORMAT_MAPPINGS.containsKey(code)) {
            return "<" + FORMAT_MAPPINGS.get(code) + ">";
        }
        return "&" + code;
    }

    public static String convertWithProperNesting(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return LegacyToMiniMessageConverter.convert(input);
    }

    public static String[] convertBatch(String ... inputs) {
        if (inputs == null) {
            return null;
        }
        String[] results = new String[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            results[i] = LegacyToMiniMessageConverter.convert(inputs[i]);
        }
        return results;
    }

    public static boolean containsLegacyCodes(String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        return LEGACY_COLOR_PATTERN.matcher(input).find() || SECTION_COLOR_PATTERN.matcher(input).find() || HEX_PATTERN_DIRECT.matcher(input).find() || HEX_PATTERN_AMPERSAND.matcher(input).find() || HEX_PATTERN_LEGACY.matcher(input).find();
    }

    public static boolean isMiniMessageFormat(String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        return input.contains("<") && input.contains(">") && (input.contains("<#") || input.contains("<black>") || input.contains("<white>") || input.contains("<bold>") || input.contains("<italic>") || input.contains("<reset>") || input.contains("<gradient>") || input.contains("</"));
    }

    public static String convertIfNeeded(String input) {
        if (LegacyToMiniMessageConverter.containsLegacyCodes(input)) {
            return LegacyToMiniMessageConverter.convert(input);
        }
        return input;
    }

    static {
        COLOR_MAPPINGS.put("0", "black");
        COLOR_MAPPINGS.put("1", "dark_blue");
        COLOR_MAPPINGS.put("2", "dark_green");
        COLOR_MAPPINGS.put("3", "dark_aqua");
        COLOR_MAPPINGS.put("4", "dark_red");
        COLOR_MAPPINGS.put("5", "dark_purple");
        COLOR_MAPPINGS.put("6", "gold");
        COLOR_MAPPINGS.put("7", "gray");
        COLOR_MAPPINGS.put("8", "dark_gray");
        COLOR_MAPPINGS.put("9", "blue");
        COLOR_MAPPINGS.put("a", "green");
        COLOR_MAPPINGS.put("b", "aqua");
        COLOR_MAPPINGS.put("c", "red");
        COLOR_MAPPINGS.put("d", "light_purple");
        COLOR_MAPPINGS.put("e", "yellow");
        COLOR_MAPPINGS.put("f", "white");
        FORMAT_MAPPINGS.put("k", "obfuscated");
        FORMAT_MAPPINGS.put("l", "bold");
        FORMAT_MAPPINGS.put("m", "strikethrough");
        FORMAT_MAPPINGS.put("n", "underlined");
        FORMAT_MAPPINGS.put("o", "italic");
        FORMAT_MAPPINGS.put("r", "reset");
    }
}

