/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.xp;

import fr.ax_dev.universejobs.xp.ExpressionEvaluator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.configuration.file.YamlConfiguration;

public class XpCurve {
    private final String name;
    private final CurveType type;
    private final TreeMap<Integer, Double> linearCurve;
    private final String equation;
    private final Map<Integer, Double> cache = new HashMap<Integer, Double>();

    public static XpCurve fromFile(String name, File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        TreeMap<Integer, Double> perLevelXp = new TreeMap<Integer, Double>();
        for (String key : config.getKeys(false)) {
            try {
                int level = Integer.parseInt(key);
                double xp = config.getDouble(key);
                perLevelXp.put(level, xp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!perLevelXp.containsKey(1)) {
            perLevelXp.put(1, 0.0);
        }
        TreeMap<Integer, Double> cumulativeCurve = new TreeMap<Integer, Double>();
        double totalXp = 0.0;
        for (Map.Entry entry : perLevelXp.entrySet()) {
            cumulativeCurve.put((Integer)entry.getKey(), totalXp);
            totalXp += ((Double)entry.getValue()).doubleValue();
        }
        return new XpCurve(name, cumulativeCurve);
    }

    public static XpCurve fromEquation(String name, String equation) {
        return new XpCurve(name, equation);
    }

    public static XpCurve createDefault() {
        return new XpCurve("default", "100 * Math.pow(level, 2)");
    }

    private XpCurve(String name, TreeMap<Integer, Double> linearCurve) {
        this.name = name;
        this.type = CurveType.LINEAR;
        this.linearCurve = linearCurve;
        this.equation = null;
    }

    private XpCurve(String name, String equation) {
        this.name = name;
        this.type = CurveType.EQUATION;
        this.linearCurve = null;
        this.equation = equation;
    }

    public double getXpForLevel(int level) {
        if (level <= 1) {
            return 0.0;
        }
        if (this.cache.containsKey(level)) {
            return this.cache.get(level);
        }
        double xp = this.type == CurveType.LINEAR ? this.getLinearXp(level) : this.getEquationXp(level);
        this.cache.put(level, xp);
        return xp;
    }

    private double getLinearXp(int level) {
        if (this.linearCurve.containsKey(level)) {
            return this.linearCurve.get(level);
        }
        Map.Entry<Integer, Double> lower = this.linearCurve.floorEntry(level);
        Map.Entry<Integer, Double> higher = this.linearCurve.ceilingEntry(level);
        if (lower == null) {
            return this.linearCurve.firstEntry().getValue();
        }
        if (higher == null) {
            Map.Entry<Integer, Double> lastEntry = this.linearCurve.lastEntry();
            Map.Entry<Integer, Double> secondLastEntry = this.linearCurve.lowerEntry(lastEntry.getKey());
            if (secondLastEntry == null) {
                return lastEntry.getValue();
            }
            double slope = (lastEntry.getValue() - secondLastEntry.getValue()) / (double)(lastEntry.getKey() - secondLastEntry.getKey());
            return lastEntry.getValue() + slope * (double)(level - lastEntry.getKey());
        }
        double ratio = (double)(level - lower.getKey()) / (double)(higher.getKey() - lower.getKey());
        return lower.getValue() + ratio * (higher.getValue() - lower.getValue());
    }

    private double getEquationXp(int level) {
        try {
            return ExpressionEvaluator.evaluate(this.equation, "level", level);
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating XP equation '" + this.equation + "': " + e.getMessage(), e);
        }
    }

    public int getLevelForXp(double xp, int maxLevel) {
        int low = 1;
        int high = maxLevel;
        int result = 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            double requiredXp = this.getXpForLevel(mid);
            if (requiredXp <= xp) {
                result = mid;
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return result;
    }

    public double getXpToNextLevel(int currentLevel) {
        if (currentLevel <= 0) {
            return this.getXpForLevel(2);
        }
        return this.getXpForLevel(currentLevel + 1) - this.getXpForLevel(currentLevel);
    }

    public int getLevelFromXp(double xp) {
        return this.getLevelForXp(xp, 100);
    }

    public String getName() {
        return this.name;
    }

    public CurveType getType() {
        return this.type;
    }

    public String getEquation() {
        return this.equation;
    }

    public String toString() {
        return "XpCurve{name='" + this.name + "', type=" + String.valueOf((Object)this.type) + (String)(this.type == CurveType.EQUATION ? ", equation='" + this.equation + "'" : "") + "}";
    }

    public static enum CurveType {
        LINEAR,
        EQUATION;

    }
}

