/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.action;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionLimitManager;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.action.JobAction;
import fr.ax_dev.universejobs.bonus.MoneyBonusManager;
import fr.ax_dev.universejobs.bonus.XpBonusManager;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionResult;
import fr.ax_dev.universejobs.config.MessageConfig;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.utils.MessageUtils;
import fr.ax_dev.universejobs.utils.XpMessageSender;
import java.util.List;
import java.util.Set;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ActionProcessor {
    private static final String MATCHES_SUFFIX = ", matches: ";
    private final UniverseJobs plugin;
    private final JobManager jobManager;
    private final XpBonusManager bonusManager;
    private final MoneyBonusManager moneyBonusManager;
    private final XpMessageSender messageSender;
    private final ActionLimitManager limitManager;

    public ActionProcessor(UniverseJobs plugin, JobManager jobManager, XpBonusManager bonusManager, MoneyBonusManager moneyBonusManager, XpMessageSender messageSender, ActionLimitManager limitManager) {
        this.plugin = plugin;
        this.jobManager = jobManager;
        this.bonusManager = bonusManager;
        this.moneyBonusManager = moneyBonusManager;
        this.messageSender = messageSender;
        this.limitManager = limitManager;
    }

    public boolean processAction(Player player, ActionType actionType, Event event, ConditionContext context) {
        this.debugLog("Processing action " + String.valueOf((Object)actionType) + " for player " + player.getName());
        Set<String> playerJobs = this.jobManager.getPlayerJobs(player);
        this.debugLog("Player " + player.getName() + " has jobs: " + String.valueOf(playerJobs));
        boolean shouldCancel = false;
        for (String jobId : playerJobs) {
            if (!this.processPlayerJob(player, jobId, actionType, event, context)) continue;
            shouldCancel = true;
        }
        return shouldCancel;
    }

    private boolean processPlayerJob(Player player, String jobId, ActionType actionType, Event event, ConditionContext context) {
        Job job = this.jobManager.getJob(jobId);
        if (!this.isJobValid(job, jobId)) {
            return false;
        }
        List<JobAction> actions = job.getActions(actionType);
        this.debugLog("Job " + jobId + " has " + actions.size() + " actions for type " + String.valueOf((Object)actionType));
        boolean shouldCancel = false;
        for (JobAction action : actions) {
            if (!this.processJobAction(player, job, action, event, context)) continue;
            shouldCancel = true;
        }
        return shouldCancel;
    }

    private boolean isJobValid(Job job, String jobId) {
        if (job == null || !job.isEnabled()) {
            this.debugLog("Job " + jobId + " is null or disabled");
            return false;
        }
        return true;
    }

    private void debugLog(String message) {
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info(message);
        }
    }

    private boolean processJobAction(Player player, Job job, JobAction action, Event event, ConditionContext context) {
        if (!this.validateActionTarget(action, context, job)) {
            return false;
        }
        if (!this.validateInteractType(action, context, job)) {
            return false;
        }
        if (!this.validateProfession(action, context, job)) {
            return false;
        }
        if (!this.validateColor(action, context, job)) {
            return false;
        }
        if (!this.validateNbt(action, context, job)) {
            return false;
        }
        if (!this.validatePotionType(action, context, job)) {
            return false;
        }
        boolean shouldCancel = this.processActionRequirements(player, action, event, context);
        this.processActionRewards(player, job, action, context);
        this.executeActionEffects(player, action);
        return shouldCancel;
    }

    private boolean validateActionTarget(JobAction action, ConditionContext context, Job job) {
        boolean targetMatches;
        String target = context.getTarget();
        String nexoBlockId = context.getNexoBlockId();
        this.debugLog("Checking action target: " + action.getTarget() + " against context target: " + target);
        ActionType actionType = job.getActionTypeForAction(action);
        boolean bl = targetMatches = actionType == ActionType.ENCHANT ? action.matchesEnchantTarget(target, (String)context.get("enchantment_level")) : action.matchesTarget(target, nexoBlockId);
        if (!targetMatches) {
            this.debugLog("Target mismatch - action target: " + action.getTarget() + ", context target: " + target);
        } else {
            this.debugLog("Target matched! Processing action for player");
        }
        return targetMatches;
    }

    private boolean validateInteractType(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.BLOCK_INTERACT && actionType != ActionType.ENTITY_INTERACT) {
            return true;
        }
        String eventInteractType = (String)context.get("interact-type");
        String actionInteractType = action.getInteractType();
        this.debugLog("Interact type check - event: " + eventInteractType + ", action: " + actionInteractType);
        if (actionInteractType != null && !actionInteractType.equals("RIGHT_CLICK") && eventInteractType == null) {
            this.debugLog("Action requires specific interact-type (" + actionInteractType + ") but event doesn't provide interact-type info - skipping");
            return false;
        }
        if (eventInteractType != null && actionInteractType != null && !eventInteractType.equalsIgnoreCase(actionInteractType)) {
            this.debugLog("Interact type mismatch: expected " + actionInteractType + ", got " + eventInteractType);
            return false;
        }
        return true;
    }

    private boolean validateProfession(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.TRADE) {
            return true;
        }
        if (!action.hasProfessionRequirements()) {
            return true;
        }
        String villagerProfession = (String)context.get("profession");
        boolean professionMatches = action.matchesProfession(villagerProfession);
        this.debugLog("Profession check - required: " + String.valueOf(action.getProfessions()) + ", villager: " + villagerProfession + MATCHES_SUFFIX + professionMatches);
        return professionMatches;
    }

    private boolean validateColor(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.SHEAR) {
            return true;
        }
        if (!action.hasColorRequirements()) {
            return true;
        }
        String sheepColor = (String)context.get("color");
        boolean colorMatches = action.matchesColor(sheepColor);
        this.debugLog("Color check - required: " + String.valueOf(action.getColors()) + ", sheep: " + sheepColor + MATCHES_SUFFIX + colorMatches);
        return colorMatches;
    }

    private boolean validateNbt(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.EAT && actionType != ActionType.POTION) {
            return true;
        }
        if (!action.hasNbtRequirements()) {
            return true;
        }
        String itemNbt = (String)context.get("nbt");
        boolean nbtMatches = action.matchesNbt(itemNbt);
        this.debugLog("NBT check - required: " + String.valueOf(action.getNbtTags()) + ", item: " + itemNbt + MATCHES_SUFFIX + nbtMatches);
        return nbtMatches;
    }

    private boolean validatePotionType(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.POTION) {
            return true;
        }
        if (!action.hasPotionTypeRequirements()) {
            return true;
        }
        String potionType = (String)context.get("potion-type");
        boolean potionTypeMatches = action.matchesPotionType(potionType);
        this.debugLog("Potion-type check - required: " + String.valueOf(action.getPotionTypes()) + ", potion: " + potionType + MATCHES_SUFFIX + potionTypeMatches);
        return potionTypeMatches;
    }

    private boolean processActionRequirements(Player player, JobAction action, Event event, ConditionContext context) {
        if (!action.hasRequirements()) {
            return false;
        }
        ConditionResult result = action.getRequirements().evaluate(player, event, context);
        boolean shouldCancel = result.shouldCancelEvent();
        result.execute(player);
        return shouldCancel;
    }

    private void processActionRewards(Player player, Job job, JobAction action, ConditionContext context) {
        double xp = action.getXp();
        double money = action.getMoney();
        Object craftMultiplierObj = context.get("craft_multiplier");
        if (craftMultiplierObj instanceof Integer) {
            int craftMultiplier = (Integer)craftMultiplierObj;
            this.debugLog("Applied craft multiplier " + craftMultiplier + " - XP: " + action.getXp() + " -> " + (xp *= (double)craftMultiplier) + ", Money: " + action.getMoney() + " -> " + (money *= (double)craftMultiplier));
        }
        if (xp > 0.0 || money > 0.0) {
            this.awardRewards(player, job, action, xp, money);
        }
    }

    private void awardRewards(Player player, Job job, JobAction action, double xp, double money) {
        int currentLevel;
        if (action.hasLimits()) {
            ActionLimitManager.ActionGains allowedGains = this.limitManager.checkAndConsumeLimit(player, job.getId(), action.getTarget(), xp, money);
            xp = allowedGains.getXp();
            money = allowedGains.getMoney();
            if (!allowedGains.hasGains()) {
                return;
            }
        }
        double finalXp = 0.0;
        double finalMoney = 0.0;
        if (xp > 0.0 && (currentLevel = this.jobManager.getLevel(player, job.getId())) < job.getMaxLevel()) {
            finalXp = this.applyMultipliers(player, job, xp);
            double bonusMultiplier = this.bonusManager.getTotalMultiplier(player.getUniqueId(), job.getId());
            this.jobManager.addXp(player, job.getId(), finalXp *= bonusMultiplier);
            int newLevel = this.jobManager.getLevel(player, job.getId());
            if (newLevel > currentLevel) {
                this.handleLevelUp(player, job, currentLevel, newLevel);
            }
        }
        if (money > 0.0) {
            finalMoney = this.applyMoneyMultipliers(player, job, money);
            double moneyBonusMultiplier = this.moneyBonusManager.getTotalMultiplier(player.getUniqueId(), job.getId());
            this.addPlayerMoney(player, finalMoney *= moneyBonusMultiplier);
        }
        if (finalXp > 0.0 || finalMoney > 0.0) {
            PlayerJobData playerData = this.jobManager.getPlayerData(player);
            this.messageSender.sendXpMessage(player, job, finalXp, finalMoney, playerData);
            this.debugLog("Player " + player.getName() + " earned " + finalXp + " XP and " + finalMoney + " money from job " + job.getId());
        }
    }

    private double applyMultipliers(Player player, Job job, double baseXp) {
        double multiplier = 1.0;
        if (!player.isOp() && !player.hasPermission("*")) {
            for (int i = 10; i >= 1; --i) {
                String permission = "universejobs.multiplier." + i;
                if (!player.hasPermission(permission) || this.hasWildcardPermission(player)) continue;
                multiplier = i;
                break;
            }
        }
        return baseXp * multiplier;
    }

    private double applyMoneyMultipliers(Player player, Job job, double baseMoney) {
        double multiplier = 1.0;
        if (!player.isOp() && !player.hasPermission("*")) {
            for (int i = 10; i >= 1; --i) {
                String permission = "universejobs.multiplier." + i;
                if (!player.hasPermission(permission) || this.hasWildcardPermission(player)) continue;
                multiplier = i;
                break;
            }
        }
        return baseMoney * multiplier;
    }

    private void addPlayerMoney(Player player, double amount) {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("Vault")) {
            try {
                Economy economy = this.getVaultEconomy();
                if (economy != null) {
                    economy.depositPlayer((OfflinePlayer)player, amount);
                    return;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to use Vault for money reward: " + e.getMessage());
            }
        }
        String command = "eco give {player} {amount}".replace("{player}", player.getName()).replace("{amount}", String.valueOf(amount));
        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command);
    }

    private Economy getVaultEconomy() {
        try {
            if (this.plugin.getServer().getServicesManager().getRegistration(Economy.class) != null) {
                return (Economy)this.plugin.getServer().getServicesManager().getRegistration(Economy.class).getProvider();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void handleLevelUp(Player player, Job job, int oldLevel, int newLevel) {
        String message = this.plugin.getConfig().getString("messages.level-up", "&aCongratulations! You reached level {level} in {job}!").replace("{level}", String.valueOf(newLevel)).replace("{job}", job.getName());
        MessageUtils.sendMessage(player, message);
        try {
            String soundName = "ENTITY_PLAYER_LEVELUP";
            NamespacedKey key = NamespacedKey.minecraft((String)soundName.toLowerCase().replace("_", "."));
            Sound sound = (Sound)Registry.SOUNDS.get(key);
            if (sound == null) {
                sound = Sound.valueOf((String)soundName);
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executeLevelUpCommands(player, job, newLevel);
    }

    private void executeLevelUpCommands(Player player, Job job, int level) {
    }

    private boolean hasWildcardPermission(Player player) {
        return player.hasPermission("*") || player.hasPermission("universejobs.*") || player.hasPermission("universejobs.multiplier.*");
    }

    private void executeActionEffects(Player player, JobAction action) {
        if (action.hasMessage()) {
            MessageConfig messageConfig = action.getMessage();
            String text = messageConfig.getText();
            switch (messageConfig.getType()) {
                case CHAT: {
                    MessageUtils.sendMessage(player, text);
                    break;
                }
                case ACTIONBAR: {
                    MessageUtils.sendActionBar(player, text);
                    if (messageConfig.getDuration() <= 0) break;
                    this.plugin.getFoliaManager().runLater(() -> {
                        if (player.isOnline()) {
                            MessageUtils.sendActionBar(player, "");
                        }
                    }, messageConfig.getDuration());
                    break;
                }
                case BOSSBAR: {
                    this.messageSender.sendActionMessage(player, text, messageConfig);
                }
            }
        }
        if (action.hasCommands()) {
            for (String command : action.getCommands()) {
                String processedCommand = command.replace("{player}", player.getName());
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), processedCommand);
            }
        }
    }

    public Object getListener() {
        return null;
    }
}

