/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.bonus;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.bonus.BaseBonus;
import fr.ax_dev.universejobs.bonus.BonusManager;
import fr.ax_dev.universejobs.compatibility.FoliaCompatibilityManager;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class BaseBonusManager<T extends BaseBonus>
implements BonusManager<T> {
    protected final UniverseJobs plugin;
    protected final FoliaCompatibilityManager foliaManager;
    protected final Map<UUID, List<T>> playerBonuses = new ConcurrentHashMap<UUID, List<T>>();
    protected boolean cleanupRunning = false;

    protected BaseBonusManager(UniverseJobs plugin) {
        this.plugin = plugin;
        this.foliaManager = plugin.getFoliaManager();
        this.startCleanupTask();
    }

    protected abstract T createBonus(UUID var1, String var2, double var3, long var5, String var7, String var8);

    protected abstract String getBonusTypeName();

    @Override
    public int addGlobalBonus(double multiplier, long duration, String reason, String grantedBy) {
        int count = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            T bonus = this.createBonus(player.getUniqueId(), null, multiplier, duration, reason, grantedBy);
            this.addBonus(bonus);
            ++count;
        }
        if (count > 0) {
            String message = "Global " + this.getBonusTypeName() + " bonus started: " + multiplier + "x for " + this.formatDuration(duration);
            for (Player player : Bukkit.getOnlinePlayers()) {
                MessageUtils.sendMessage(player, message);
            }
        }
        return count;
    }

    @Override
    public void addPlayerBonus(UUID playerId, double multiplier, long duration, String reason, String grantedBy) {
        T bonus = this.createBonus(playerId, null, multiplier, duration, reason, grantedBy);
        this.addBonus(bonus);
    }

    @Override
    public void addJobBonus(UUID playerId, String jobId, double multiplier, long duration, String reason, String grantedBy) {
        T bonus = this.createBonus(playerId, jobId, multiplier, duration, reason, grantedBy);
        this.addBonus(bonus);
    }

    protected void addBonus(T bonus) {
        this.playerBonuses.computeIfAbsent(((BaseBonus)bonus).getPlayerId(), k -> new ArrayList()).add(bonus);
        Player player = Bukkit.getPlayer((UUID)((BaseBonus)bonus).getPlayerId());
        if (player != null) {
            String message = this.getBonusTypeName() + " bonus received: " + ((BaseBonus)bonus).getMultiplier() + "x for " + ((BaseBonus)bonus).getRemainingTimeFormatted();
            if (((BaseBonus)bonus).getJobId() != null) {
                message = message + " (Job: " + ((BaseBonus)bonus).getJobId() + ")";
            }
            MessageUtils.sendMessage(player, message);
        }
    }

    @Override
    public List<T> getActiveBonuses(UUID playerId) {
        List<T> bonuses = this.playerBonuses.get(playerId);
        if (bonuses == null) {
            return new ArrayList();
        }
        return bonuses.stream().filter(BaseBonus::isActive).collect(Collectors.toList());
    }

    @Override
    public List<T> getActiveBonuses(UUID playerId, String jobId) {
        return this.getActiveBonuses(playerId).stream().filter(bonus -> bonus.appliesTo(jobId)).collect(Collectors.toList());
    }

    @Override
    public boolean removeBonus(T bonus) {
        List<T> bonuses = this.playerBonuses.get(((BaseBonus)bonus).getPlayerId());
        if (bonuses != null) {
            boolean removed = bonuses.remove(bonus);
            if (removed && bonuses.isEmpty()) {
                this.playerBonuses.remove(((BaseBonus)bonus).getPlayerId());
            }
            return removed;
        }
        return false;
    }

    @Override
    public int removeAllBonuses(UUID playerId) {
        List<T> bonuses = this.playerBonuses.remove(playerId);
        return bonuses != null ? bonuses.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupExpiredBonuses() {
        if (this.cleanupRunning) {
            return;
        }
        this.cleanupRunning = true;
        try {
            int cleaned = 0;
            Iterator<Map.Entry<UUID, List<T>>> iterator = this.playerBonuses.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, List<T>> entry = iterator.next();
                List<T> bonuses = entry.getValue();
                int sizeBefore = bonuses.size();
                bonuses.removeIf(bonus -> !bonus.isActive());
                cleaned += sizeBefore - bonuses.size();
                if (!bonuses.isEmpty()) continue;
                iterator.remove();
            }
            if (cleaned > 0) {
                this.plugin.getLogger().info("Cleaned up " + cleaned + " expired " + this.getBonusTypeName().toLowerCase() + " bonuses");
            }
        }
        finally {
            this.cleanupRunning = false;
        }
    }

    @Override
    public Map<String, Object> getStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalPlayers", this.playerBonuses.size());
        stats.put("totalBonuses", this.playerBonuses.values().stream().mapToInt(List::size).sum());
        stats.put("activeBonuses", this.playerBonuses.values().stream().flatMap(Collection::stream).mapToInt(bonus -> bonus.isActive() ? 1 : 0).sum());
        return stats;
    }

    public double getTotalMultiplier(UUID playerId, String jobId) {
        List<T> activeBonuses = this.getActiveBonuses(playerId, jobId);
        double totalMultiplier = 1.0;
        for (BaseBonus bonus : activeBonuses) {
            totalMultiplier *= bonus.getMultiplier();
        }
        return totalMultiplier;
    }

    private void startCleanupTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::cleanupExpiredBonuses, 1200L, 1200L);
    }

    public void shutdown() {
        this.cleanupRunning = false;
    }

    private String formatDuration(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, secs);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, secs);
        }
        return String.format("%ds", secs);
    }
}

