/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.bonus.XpBonus;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminCommandHandler
extends JobCommandHandler {
    private static final String PERM_ADMIN_EXP = "universejobs.admin.exp";
    private static final String PERM_ADMIN_DEBUG = "universejobs.admin.debug";
    private static final String NO_PERMISSION_KEY = "commands.no-permission";
    private static final String PLAYER_PREFIX = "&cPlayer ";
    private static final String JOB_SUFFIX = " for job ";

    public AdminCommandHandler(UniverseJobs plugin) {
        super(plugin);
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "exp": {
                this.handleExpCommand(sender, args);
                break;
            }
            case "migrate": {
                this.handleMigrateCommand(sender, args);
                break;
            }
            case "reload": {
                this.handleReloadCommand(sender);
                break;
            }
            case "debug": {
                this.handleDebugCommand(sender, args);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions;
        block12: {
            block11: {
                completions = new ArrayList<String>();
                if (args.length == 0) {
                    return completions;
                }
                String subCommand = args[0].toLowerCase();
                if (args.length != 2) break block11;
                String input = args[1].toLowerCase();
                switch (subCommand) {
                    case "exp": {
                        if (!this.hasPermission(sender, PERM_ADMIN_EXP)) break;
                        List<String> expSubCommands = Arrays.asList("give", "take", "set");
                        for (String expSubCommand : expSubCommands) {
                            if (!expSubCommand.startsWith(input)) continue;
                            completions.add(expSubCommand);
                        }
                        break block12;
                    }
                    case "debug": {
                        if (!this.hasPermission(sender, PERM_ADMIN_DEBUG)) break;
                        completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList()));
                        break;
                    }
                }
                break block12;
            }
            if (args.length >= 3) {
                completions.addAll(this.getAdminTabCompletions(sender, args));
            }
        }
        return completions;
    }

    private void handleExpCommand(CommandSender sender, String[] args) {
        double amount;
        if (!this.hasPermission(sender, PERM_ADMIN_EXP)) {
            sender.sendMessage(this.languageManager.getMessage(NO_PERMISSION_KEY));
            return;
        }
        if (args.length < 5) {
            MessageUtils.sendMessage(sender, "&cUsage: /jobs exp <give|take|set> <player> <job> <amount>");
            return;
        }
        String expAction = this.sanitizeInput(args[1]);
        String playerName = this.sanitizeInput(args[2]);
        String jobId = this.sanitizeInput(args[3]);
        String amountStr = this.sanitizeInput(args[4]);
        if (!Arrays.asList("give", "take", "set").contains(expAction.toLowerCase())) {
            MessageUtils.sendMessage(sender, "&cInvalid action. Use: give, take, or set");
            return;
        }
        if (!this.isValidPlayerName(playerName)) {
            return;
        }
        if (!this.isValidJobId(jobId)) {
            return;
        }
        try {
            if (amountStr.isEmpty() || amountStr.length() > 15) {
                throw new NumberFormatException("Invalid amount format");
            }
            amount = Double.parseDouble(amountStr);
        }
        catch (NumberFormatException e) {
            MessageUtils.sendMessage(sender, "&cInvalid amount: " + amountStr);
            return;
        }
        if (amount <= 0.0 || amount > 1000000.0 || Double.isNaN(amount) || Double.isInfinite(amount)) {
            MessageUtils.sendMessage(sender, "&cAmount must be between 1 and 1,000,000");
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            MessageUtils.sendMessage(sender, PLAYER_PREFIX + playerName + " not found or not online.");
            return;
        }
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            MessageUtils.sendMessage(sender, "&cJob " + jobId + " not found.");
            return;
        }
        if (!this.jobManager.hasJob(targetPlayer, jobId)) {
            MessageUtils.sendMessage(sender, PLAYER_PREFIX + playerName + " doesn't have the job " + job.getName());
            return;
        }
        String senderName = sender instanceof Player ? sender.getName() : "Console";
        switch (expAction.toLowerCase()) {
            case "give": {
                this.jobManager.addXp(targetPlayer, jobId, amount);
                MessageUtils.sendMessage(sender, "&aGave " + amount + " XP to " + playerName + JOB_SUFFIX + job.getName());
                MessageUtils.sendMessage(targetPlayer, "&aReceived " + amount + " XP for " + job.getName() + " from " + senderName);
                break;
            }
            case "take": {
                double currentXp = this.jobManager.getXp(targetPlayer, jobId);
                double newXp = Math.max(0.0, currentXp - amount);
                this.jobManager.addXp(targetPlayer, jobId, newXp - currentXp);
                MessageUtils.sendMessage(sender, "&aTook " + amount + " XP from " + playerName + JOB_SUFFIX + job.getName());
                MessageUtils.sendMessage(targetPlayer, "&cLost " + amount + " XP for " + job.getName() + " (Admin action)");
                break;
            }
            case "set": {
                double currentXp = this.jobManager.getXp(targetPlayer, jobId);
                double difference = amount - currentXp;
                this.jobManager.addXp(targetPlayer, jobId, difference);
                MessageUtils.sendMessage(sender, "&aSet " + playerName + "'s XP to " + amount + JOB_SUFFIX + job.getName());
                MessageUtils.sendMessage(targetPlayer, "&aYour XP for " + job.getName() + " has been set to " + amount + " by " + senderName);
                break;
            }
            default: {
                MessageUtils.sendMessage(sender, "&cInvalid exp action. Use: give, take, or set");
            }
        }
    }

    private void handleMigrateCommand(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "universejobs.admin.migrate")) {
            sender.sendMessage(this.languageManager.getMessage(NO_PERMISSION_KEY));
            return;
        }
        String fromVersion = args.length > 1 ? this.sanitizeInput(args[1]) : "auto";
        String toVersion = args.length > 2 ? this.sanitizeInput(args[2]) : this.plugin.getDescription().getVersion();
        MessageUtils.sendMessage(sender, "&6Starting migration from " + fromVersion + " to " + toVersion + "...");
        MessageUtils.sendMessage(sender, "&cMigration feature not yet implemented.");
        this.plugin.getLogger().info("Migration requested from " + fromVersion + " to " + toVersion + " by " + sender.getName());
    }

    private void handleReloadCommand(CommandSender sender) {
        if (!this.hasPermission(sender, "universejobs.admin.reload")) {
            sender.sendMessage(this.languageManager.getMessage(NO_PERMISSION_KEY));
            return;
        }
        MessageUtils.sendMessage(sender, "&6Reloading UniverseJobs...");
        try {
            this.plugin.getConfigManager().reloadConfig();
            this.plugin.getLanguageManager().reload();
            this.jobManager.reloadJobs();
            this.rewardManager.reloadRewards();
            MessageUtils.sendMessage(sender, "&aUniverseJobs reloaded successfully!");
        }
        catch (Exception e) {
            MessageUtils.sendMessage(sender, "&cFailed to reload: " + e.getMessage());
            this.plugin.getLogger().severe("Failed to reload plugin: " + e.getMessage());
        }
    }

    private void handleDebugCommand(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, PERM_ADMIN_DEBUG)) {
            sender.sendMessage(this.languageManager.getMessage(NO_PERMISSION_KEY));
            return;
        }
        if (args.length < 2) {
            MessageUtils.sendMessage(sender, "&cUsage: /jobs debug <player>");
            return;
        }
        String playerName = this.sanitizeInput(args[1]);
        if (!this.isValidPlayerName(playerName)) {
            return;
        }
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            MessageUtils.sendMessage(sender, PLAYER_PREFIX + playerName + " not found or not online.");
            return;
        }
        MessageUtils.sendMessage(sender, "&6=== Debug Info for " + targetPlayer.getName() + " ===");
        Set<String> playerJobs = this.jobManager.getPlayerJobs(targetPlayer);
        MessageUtils.sendMessage(sender, "&eJobs: " + playerJobs.size());
        for (String string : playerJobs) {
            Job job = this.jobManager.getJob(string);
            if (job == null) continue;
            int level = this.jobManager.getLevel(targetPlayer, string);
            double xp = this.jobManager.getXp(targetPlayer, string);
            MessageUtils.sendMessage(sender, "&7  " + job.getName() + " - Level " + level + " (" + xp + " XP)");
        }
        if (this.bonusManager != null) {
            List bonuses = this.bonusManager.getActiveBonuses(targetPlayer.getUniqueId());
            MessageUtils.sendMessage(sender, "&eActive Bonuses: " + bonuses.size());
            for (XpBonus bonus : bonuses) {
                MessageUtils.sendMessage(sender, "&7  " + bonus.getMultiplier() + "x - " + bonus.getReason());
            }
        }
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() / 1024L / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L / 1024L;
        long usedMemory = l - freeMemory;
        MessageUtils.sendMessage(sender, "&eMemory Usage: " + usedMemory + "/" + l + " MB");
    }

    private List<String> getAdminTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String subCommand = args[0].toLowerCase();
        if (args.length == 3) {
            String input = args[2].toLowerCase();
            if ("exp".equals(subCommand) && this.hasPermission(sender, PERM_ADMIN_EXP)) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList()));
            }
        } else if (args.length == 4) {
            String input = args[3].toLowerCase();
            if ("exp".equals(subCommand) && this.hasPermission(sender, PERM_ADMIN_EXP)) {
                completions.addAll(this.jobManager.getAllJobs().stream().map(Job::getId).filter(jobId -> jobId.toLowerCase().startsWith(input)).collect(Collectors.toList()));
            }
        } else if (args.length == 5) {
            String input = args[4].toLowerCase();
            if ("exp".equals(subCommand) && this.hasPermission(sender, PERM_ADMIN_EXP)) {
                List<String> amounts = Arrays.asList("100", "500", "1000", "5000", "10000");
                completions.addAll(amounts.stream().filter(amount -> amount.startsWith(input)).collect(Collectors.toList()));
            }
        }
        return completions;
    }
}

