/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionLimitManager;
import fr.ax_dev.universejobs.bonus.MoneyBonusManager;
import fr.ax_dev.universejobs.bonus.XpBonusManager;
import fr.ax_dev.universejobs.config.LanguageManager;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.reward.RewardManager;
import fr.ax_dev.universejobs.reward.gui.RewardGuiManager;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class JobCommandHandler {
    protected final UniverseJobs plugin;
    protected final JobManager jobManager;
    protected final LanguageManager languageManager;
    protected final XpBonusManager bonusManager;
    protected final MoneyBonusManager moneyBonusManager;
    protected final RewardManager rewardManager;
    protected final RewardGuiManager rewardGuiManager;
    protected final ActionLimitManager limitManager;
    protected static final Pattern SAFE_JOB_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]{1,32}$");
    protected static final Pattern SAFE_PLAYER_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{1,16}$");
    protected static final Pattern COMMAND_INJECTION_PATTERN = Pattern.compile("[;&|`$(){}\\[\\]<>\"'\\\\]");

    public JobCommandHandler(UniverseJobs plugin) {
        this.plugin = plugin;
        this.jobManager = plugin.getJobManager();
        this.languageManager = plugin.getLanguageManager();
        this.bonusManager = plugin.getBonusManager();
        this.moneyBonusManager = plugin.getMoneyBonusManager();
        this.rewardManager = plugin.getRewardManager();
        this.rewardGuiManager = plugin.getRewardGuiManager();
        this.limitManager = plugin.getLimitManager();
    }

    public abstract boolean handleCommand(CommandSender var1, String[] var2);

    public abstract List<String> getTabCompletions(CommandSender var1, String[] var2);

    protected String sanitizeInput(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[^a-zA-Z0-9_-]", "").substring(0, Math.min(input.length(), 64));
    }

    protected boolean isValidJobId(String jobId) {
        return jobId != null && SAFE_JOB_ID_PATTERN.matcher(jobId).matches();
    }

    protected boolean isValidPlayerName(String playerName) {
        return playerName != null && SAFE_PLAYER_NAME_PATTERN.matcher(playerName).matches();
    }

    protected boolean validateCommandStructure(String[] args) {
        if (args.length > 10) {
            return false;
        }
        for (String arg : args) {
            if (arg == null || arg.length() > 256) {
                return false;
            }
            if (!COMMAND_INJECTION_PATTERN.matcher(arg).find()) continue;
            return false;
        }
        return true;
    }

    protected boolean hasPermission(CommandSender sender, String permission) {
        return sender.hasPermission(permission);
    }

    protected Player getPlayerFromSender(CommandSender sender) {
        return sender instanceof Player ? (Player)sender : null;
    }

    protected Player validatePlayerSender(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.languageManager.getMessage("commands.players-only"));
            return null;
        }
        Player player = (Player)sender;
        return player;
    }

    protected boolean validatePermission(CommandSender sender, String permission) {
        if (!this.hasPermission(sender, permission)) {
            sender.sendMessage(this.languageManager.getMessage("commands.no-permission"));
            return false;
        }
        return true;
    }
}

