/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.menu.MenuManager;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MenuCommandHandler
extends JobCommandHandler {
    private final MenuManager menuManager;

    public MenuCommandHandler(UniverseJobs plugin) {
        super(plugin);
        this.menuManager = plugin.getMenuManager();
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (!this.validateCommandStructure(args)) {
            MessageUtils.sendMessage((Player)sender, "&cInvalid command format.");
            return false;
        }
        Player player = this.validatePlayerSender(sender);
        if (player == null) {
            return false;
        }
        if (args.length == 0) {
            this.openMainMenu(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "main": 
            case "browse": 
            case "list": 
            case "all": {
                this.openMainMenu(player);
                return true;
            }
            case "rankings": 
            case "leaderboard": 
            case "top": 
            case "rank": {
                this.openRankingsMenu(player);
                return true;
            }
            case "reload": {
                if (!this.validatePermission((CommandSender)player, "universejobs.admin.menu.reload")) {
                    return false;
                }
                return this.reloadMenus(player);
            }
            case "help": 
            case "?": {
                this.showMenuHelp(player);
                return true;
            }
        }
        if (this.isValidJobName(subCommand)) {
            return this.openJobMenu(player, subCommand);
        }
        MessageUtils.sendMessage(player, "&cUnknown command. Type '&e/jobs menu help&c' for help.");
        this.showQuickHelp(player);
        return false;
    }

    private void openMainMenu(Player player) {
        try {
            this.menuManager.openJobsMainMenu(player);
            MessageUtils.sendMessage(player, "&aOpening jobs menu...");
        }
        catch (Exception e) {
            this.handleMenuError(player, "jobs menu", e);
        }
    }

    private boolean openJobMenu(Player player, String jobId) {
        Job job = this.validateJobAccess(player, jobId);
        if (job == null) {
            return false;
        }
        try {
            this.menuManager.openJobMenu(player, jobId);
            MessageUtils.sendMessage(player, "&aOpening " + job.getName() + " menu...");
            return true;
        }
        catch (Exception e) {
            return this.handleMenuError(player, "job menu", e);
        }
    }

    private boolean openActionsMenu(Player player, String jobId) {
        Job job = this.validateJobAccess(player, jobId);
        if (job == null) {
            return false;
        }
        try {
            this.rewardGuiManager.openRewardsGui(player, jobId);
            MessageUtils.sendMessage(player, "&aOpening " + job.getName() + " rewards...");
            return true;
        }
        catch (Exception e) {
            return this.handleMenuError(player, "rewards menu", e);
        }
    }

    private void openRankingsMenu(Player player) {
        try {
            this.menuManager.openGlobalRankingsMenu(player);
            MessageUtils.sendMessage(player, "&aOpening global rankings...");
        }
        catch (Exception e) {
            this.handleMenuError(player, "rankings menu", e);
        }
    }

    private boolean reloadMenus(Player player) {
        try {
            this.menuManager.reloadConfigurations();
            MessageUtils.sendMessage(player, "&aMenu configurations reloaded successfully!");
            this.plugin.getLogger().info("Menu configurations reloaded by " + player.getName());
            return true;
        }
        catch (Exception e) {
            return this.handleMenuError(player, "reload menu configurations", e);
        }
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return Arrays.asList(new String[0]);
        }
        if (args.length == 1) {
            List<String> completions = Arrays.asList("main", "browse", "list", "all", "rankings", "leaderboard", "top", "rank", "help");
            if (sender.hasPermission("universejobs.admin.menu.reload")) {
                completions = Arrays.asList("main", "browse", "list", "all", "rankings", "leaderboard", "top", "rank", "help", "reload");
            }
            List jobNames = this.jobManager.getJobs().values().stream().filter(Job::isEnabled).filter(job -> job.getPermission() == null || sender.hasPermission(job.getPermission())).map(Job::getId).collect(Collectors.toList());
            completions.addAll(jobNames);
            return completions.stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).sorted().collect(Collectors.toList());
        }
        return Arrays.asList(new String[0]);
    }

    private Job validateJobAccess(Player player, String jobId) {
        if (!this.isValidJobId(jobId)) {
            MessageUtils.sendMessage(player, "&cInvalid job ID format.");
            return null;
        }
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            MessageUtils.sendMessage(player, "&cJob not found: " + jobId);
            return null;
        }
        if (!job.isEnabled()) {
            MessageUtils.sendMessage(player, "&cThis job is currently disabled.");
            return null;
        }
        if (job.getPermission() != null && !player.hasPermission(job.getPermission())) {
            MessageUtils.sendMessage(player, "&cYou don't have permission to view this job.");
            return null;
        }
        return job;
    }

    private boolean handleMenuError(Player player, String menuType, Exception e) {
        MessageUtils.sendMessage(player, "&cFailed to open " + menuType + ".");
        this.plugin.getLogger().warning("Failed to open " + menuType + " for " + player.getName() + ": " + e.getMessage());
        return false;
    }

    private boolean isValidJobName(String jobName) {
        if (!this.isValidJobId(jobName)) {
            return false;
        }
        Job job = this.jobManager.getJob(jobName);
        return job != null && job.isEnabled();
    }

    private void showMenuHelp(Player player) {
        MessageUtils.sendMessage(player, "&6&l=== Jobs Menu Help ===");
        MessageUtils.sendMessage(player, "&e/jobs menu &7- Open main jobs menu");
        MessageUtils.sendMessage(player, "&e/jobs menu <jobname> &7- Open specific job menu directly");
        MessageUtils.sendMessage(player, "&e/jobs menu main &7- Open main jobs menu");
        MessageUtils.sendMessage(player, "&e/jobs menu rankings &7- View job rankings");
        MessageUtils.sendMessage(player, "");
        MessageUtils.sendMessage(player, "&6Examples:");
        MessageUtils.sendMessage(player, "&7- &e/jobs menu miner &7\u2192 Open miner job menu");
        MessageUtils.sendMessage(player, "&7- &e/jobs menu farmer &7\u2192 Open farmer job menu");
        MessageUtils.sendMessage(player, "&7- &e/jobs menu top &7\u2192 View leaderboards");
        if (player.hasPermission("universejobs.admin.menu.reload")) {
            MessageUtils.sendMessage(player, "");
            MessageUtils.sendMessage(player, "&cAdmin:");
            MessageUtils.sendMessage(player, "&e/jobs menu reload &7- Reload menu configurations");
        }
    }

    private void showQuickHelp(Player player) {
        MessageUtils.sendMessage(player, "&6Quick Examples:");
        MessageUtils.sendMessage(player, "&e/jobs menu main &7\u2192 Browse all jobs");
        List jobExamples = this.jobManager.getJobs().values().stream().filter(Job::isEnabled).filter(job -> job.getPermission() == null || player.hasPermission(job.getPermission())).map(Job::getId).limit(3L).collect(Collectors.toList());
        for (String jobId : jobExamples) {
            MessageUtils.sendMessage(player, "&e/jobs menu " + jobId + " &7\u2192 Open " + jobId + " menu");
        }
        MessageUtils.sendMessage(player, "&e/jobs menu rankings &7\u2192 View top players");
    }
}

