/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.reward.Reward;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RewardsCommandHandler
extends JobCommandHandler {
    private static final String CMD_CLAIM = "claim";
    private static final String CMD_ADMIN = "admin";
    private static final String CMD_DEBUG = "debug";
    private static final String CMD_RESET = "reset";
    private static final String PERM_REWARDS_ADMIN = "universejobs.rewards.admin";

    public RewardsCommandHandler(UniverseJobs plugin) {
        super(plugin);
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String rewardSubCommand;
        Player player = this.validatePlayerSender(sender);
        if (player == null) {
            return true;
        }
        if (!this.hasPermission((CommandSender)player, "universejobs.rewards.use")) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.no-permission"));
            return true;
        }
        if (args.length < 2) {
            return false;
        }
        switch (rewardSubCommand = args[1].toLowerCase()) {
            case "browse": 
            case "menu": 
            case "gui": {
                this.handleBrowseCommand(player);
                break;
            }
            case "open": {
                this.handleOpenCommand(player, args);
                break;
            }
            case "list": {
                this.handleListCommand(player, args);
                break;
            }
            case "claim": {
                this.handleClaimCommand(player, args);
                break;
            }
            case "info": {
                this.handleInfoCommand(player, args);
                break;
            }
            case "admin": {
                this.handleAdminCommand(player, args);
                break;
            }
            case "reload": {
                this.handleReloadCommand(player);
                break;
            }
            case "debug": {
                this.handleDebugCommand(player, args);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        Player player = this.getPlayerFromSender(sender);
        if (player == null || args.length == 0) {
            return completions;
        }
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            ArrayList<String> rewardSubCommands = new ArrayList<String>(Arrays.asList("browse", "menu", "gui", "open", "list", CMD_CLAIM, "info"));
            if (player.hasPermission(PERM_REWARDS_ADMIN)) {
                rewardSubCommands.addAll(Arrays.asList(CMD_ADMIN, "reload", CMD_DEBUG));
            }
            for (String rewardSubCommand : rewardSubCommands) {
                if (!rewardSubCommand.startsWith(input)) continue;
                completions.add(rewardSubCommand);
            }
        } else if (args.length >= 3) {
            completions.addAll(this.getRewardsTabCompletions(player, args));
        }
        return completions;
    }

    private void handleOpenCommand(Player player, String[] args) {
        if (args.length < 3) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.open.usage"));
            return;
        }
        String jobId = args[2];
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.job-not-found", "job", jobId));
            return;
        }
        if (!this.jobManager.hasJob(player, jobId)) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.must-have-job", "job", job.getName()));
            return;
        }
        this.rewardGuiManager.openRewardsGui(player, jobId);
    }

    private void handleBrowseCommand(Player player) {
        try {
            this.plugin.getMenuManager().openJobsMainMenu(player);
            MessageUtils.sendMessage(player, "&aOpening jobs menu...");
        }
        catch (Exception e) {
            MessageUtils.sendMessage(player, "&cFailed to open jobs menu.");
            this.plugin.getLogger().warning("Failed to open jobs menu for " + player.getName() + ": " + e.getMessage());
        }
    }

    private void handleListCommand(Player player, String[] args) {
        String jobId;
        String string = jobId = args.length > 2 ? args[2] : null;
        if (jobId == null) {
            for (Job job : this.jobManager.getAllJobs()) {
            }
        } else {
            Job job = this.jobManager.getJob(jobId);
            if (job == null) {
                return;
            }
            List<Reward> rewards = this.rewardManager.getJobRewards(jobId);
            if (rewards.isEmpty()) {
                return;
            }
        }
    }

    private void handleClaimCommand(Player player, String[] args) {
        if (args.length < 4) {
            return;
        }
        String jobId = args[2];
        String rewardId = args[3];
        Reward reward = this.rewardManager.getReward(jobId, rewardId);
        if (reward == null) {
            return;
        }
        if (this.rewardManager.claimReward(player, reward)) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.claim.success"));
        } else {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.claim.failed"));
        }
    }

    private void handleInfoCommand(Player player, String[] args) {
        if (args.length < 4) {
            return;
        }
        String jobId = args[2];
        String rewardId = args[3];
        Reward reward = this.rewardManager.getReward(jobId, rewardId);
        if (reward == null) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.reward-not-found"));
            return;
        }
    }

    private void handleAdminCommand(Player player, String[] args) {
        String adminSubCommand;
        if (!this.hasPermission((CommandSender)player, PERM_REWARDS_ADMIN)) {
            return;
        }
        if (args.length < 3) {
            return;
        }
        switch (adminSubCommand = args[2].toLowerCase()) {
            case "give": {
                if (args.length < 6) {
                    return;
                }
                String targetName = args[3];
                String jobId = args[4];
                String rewardId = args[5];
                Player target = Bukkit.getPlayer((String)targetName);
                if (target == null) {
                    return;
                }
                Reward reward = this.rewardManager.getReward(jobId, rewardId);
                if (reward == null) {
                    return;
                }
                this.rewardManager.claimReward(target, reward);
                break;
            }
            case "reset": {
                if (args.length < 5) {
                    return;
                }
                String targetName = args[3];
                String jobId = args[4];
                Player target = Bukkit.getPlayer((String)targetName);
                if (target == null) {
                    return;
                }
                this.rewardManager.resetJobRewards(target, jobId);
                break;
            }
        }
    }

    private void handleReloadCommand(Player player) {
        if (!this.hasPermission((CommandSender)player, PERM_REWARDS_ADMIN)) {
            return;
        }
        this.rewardManager.reloadRewards();
    }

    private void handleDebugCommand(Player player, String[] args) {
        if (!this.hasPermission((CommandSender)player, PERM_REWARDS_ADMIN)) {
            return;
        }
        if (args.length < 3) {
            return;
        }
        String jobId = args[2];
        this.rewardManager.debugPlayerRewards(player, jobId);
    }

    private List<String> getRewardsTabCompletions(Player player, String[] args) {
        if (args.length == 3) {
            return this.getRewardsCompletions3Args(player, args);
        }
        if (args.length == 4) {
            return this.getRewardsCompletions4Args(player, args);
        }
        if (args.length == 5) {
            return this.getRewardsCompletions5Args(player, args);
        }
        if (args.length == 6) {
            return this.getRewardsCompletions6Args(player, args);
        }
        return new ArrayList<String>();
    }

    private List<String> getRewardsCompletions3Args(Player player, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String rewardSubCommand = args[1].toLowerCase();
        String input = args[2].toLowerCase();
        switch (rewardSubCommand) {
            case "open": 
            case "claim": {
                this.addPlayerJobCompletions(player, input, completions);
                break;
            }
            case "list": 
            case "info": {
                this.addAllJobCompletions(input, completions);
                break;
            }
            case "admin": {
                this.addAdminSubCommandCompletions(player, input, completions);
                break;
            }
            case "debug": {
                this.addDebugJobCompletions(player, input, completions);
                break;
            }
        }
        return completions;
    }

    private List<String> getRewardsCompletions4Args(Player player, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String rewardSubCommand = args[1].toLowerCase();
        String jobId = args[2];
        String input = args[3].toLowerCase();
        switch (rewardSubCommand) {
            case "claim": 
            case "info": {
                this.addRewardCompletions(jobId, input, completions);
                break;
            }
            case "admin": {
                if (!player.hasPermission(PERM_REWARDS_ADMIN)) break;
                return this.getPlayerNameCompletions(input);
            }
        }
        return completions;
    }

    private List<String> getRewardsCompletions5Args(Player player, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!args[1].equalsIgnoreCase(CMD_ADMIN) || !player.hasPermission(PERM_REWARDS_ADMIN)) {
            return completions;
        }
        String adminSubCommand = args[2].toLowerCase();
        String input = args[4].toLowerCase();
        if ("give".equals(adminSubCommand) || CMD_RESET.equals(adminSubCommand)) {
            this.addAllJobCompletions(input, completions);
        }
        return completions;
    }

    private List<String> getRewardsCompletions6Args(Player player, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!(args[1].equalsIgnoreCase(CMD_ADMIN) && args[2].equalsIgnoreCase("give") && player.hasPermission(PERM_REWARDS_ADMIN))) {
            return completions;
        }
        String jobId = args[4];
        String input = args[5].toLowerCase();
        this.addRewardCompletions(jobId, input, completions);
        return completions;
    }

    private void addPlayerJobCompletions(Player player, String input, List<String> completions) {
        for (Job job : this.jobManager.getAllJobs()) {
            if (!this.jobManager.hasJob(player, job.getId()) || !job.getId().toLowerCase().startsWith(input)) continue;
            completions.add(job.getId());
        }
    }

    private void addAllJobCompletions(String input, List<String> completions) {
        for (Job job : this.jobManager.getAllJobs()) {
            if (!job.getId().toLowerCase().startsWith(input)) continue;
            completions.add(job.getId());
        }
    }

    private void addAdminSubCommandCompletions(Player player, String input, List<String> completions) {
        if (player.hasPermission(PERM_REWARDS_ADMIN)) {
            List<String> adminSubCommands = Arrays.asList("give", CMD_RESET);
            for (String adminSubCommand : adminSubCommands) {
                if (!adminSubCommand.startsWith(input)) continue;
                completions.add(adminSubCommand);
            }
        }
    }

    private void addDebugJobCompletions(Player player, String input, List<String> completions) {
        if (player.hasPermission(PERM_REWARDS_ADMIN)) {
            this.addAllJobCompletions(input, completions);
        }
    }

    private void addRewardCompletions(String jobId, String input, List<String> completions) {
        List<Reward> rewards = this.rewardManager.getJobRewards(jobId);
        for (Reward reward : rewards) {
            if (!reward.getId().toLowerCase().startsWith(input)) continue;
            completions.add(reward.getId());
        }
    }

    private List<String> getPlayerNameCompletions(String input) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
    }
}

