/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition;

import com.nexomc.nexo.api.NexoBlocks;
import com.nexomc.nexo.mechanics.custom_block.CustomBlockMechanic;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class ConditionContext {
    private static final String MATERIAL_KEY = "material";
    private final Map<String, Object> data = new HashMap<String, Object>();

    public ConditionContext set(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public <T> T get(String key, T defaultValue) {
        Object value = this.data.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public <T> T get(String key) {
        return this.get(key, null);
    }

    public boolean has(String key) {
        return this.data.containsKey(key);
    }

    public ConditionContext setBlock(Block block) {
        this.set("block", block).set(MATERIAL_KEY, block.getType());
        String nexoBlockId = this.detectNexoBlockId(block);
        if (nexoBlockId != null) {
            this.set("nexo_block_id", nexoBlockId);
        }
        return this;
    }

    public ConditionContext setEntity(Entity entity) {
        return this.set("entity", entity).set("entityType", entity.getType());
    }

    public ConditionContext setItem(ItemStack item) {
        if (item != null) {
            this.set("item", item).set(MATERIAL_KEY, item.getType());
        }
        return this;
    }

    public ConditionContext setMaterial(Material material) {
        return this.set(MATERIAL_KEY, material);
    }

    public Block getBlock() {
        return (Block)this.get("block");
    }

    public Entity getEntity() {
        return (Entity)this.get("entity");
    }

    public ItemStack getItem() {
        return (ItemStack)this.get("item");
    }

    public Material getMaterial() {
        return (Material)this.get(MATERIAL_KEY);
    }

    public String getTarget() {
        String explicitTarget = this.get("target", null);
        if (explicitTarget != null && !explicitTarget.isEmpty()) {
            return explicitTarget;
        }
        Material material = this.getMaterial();
        if (material != null) {
            return material.name();
        }
        Entity entity = this.getEntity();
        if (entity != null) {
            return entity.getType().name();
        }
        return "";
    }

    public String getNexoBlockId() {
        return (String)this.get("nexo_block_id");
    }

    private String detectNexoBlockId(Block block) {
        try {
            CustomBlockMechanic mechanic = NexoBlocks.customBlockMechanic((Location)((Location)block));
            return mechanic != null ? mechanic.getItemID() : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public String toString() {
        return "ConditionContext{data=" + String.valueOf(this.data) + "}";
    }
}

