/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.config;

import fr.ax_dev.universejobs.UniverseJobs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final UniverseJobs plugin;

    public ConfigManager(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.validateConfig(config);
    }

    private void validateConfig(FileConfiguration config) {
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.validateConfig(this.plugin.getConfig());
    }

    public String getMessage(String key, String defaultValue) {
        String message = this.plugin.getConfig().getString("messages." + key, defaultValue);
        return message;
    }

    public String getMessage(String key, String defaultValue, String ... placeholders) {
        String message = this.getMessage(key, defaultValue);
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        for (int i = 0; i < placeholders.length - 1; i += 2) {
            placeholderMap.put(placeholders[i], placeholders[i + 1]);
        }
        for (Map.Entry entry : placeholderMap.entrySet()) {
            message = message.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
        }
        return message;
    }

    public boolean isDebugEnabled() {
        return this.plugin.getConfig().getBoolean("debug", false);
    }

    public int getMaxJobsPerPlayer() {
        if (this.isAllJobsByDefault()) {
            return Integer.MAX_VALUE;
        }
        return this.plugin.getConfig().getInt("jobs.max-jobs-per-player", 3);
    }

    public boolean isAllJobsByDefault() {
        return this.plugin.getConfig().getBoolean("jobs.all-jobs-by-default", false);
    }

    public List<String> getJobsByDefault() {
        return this.plugin.getConfig().getStringList("jobs.jobs-by-default");
    }

    public boolean isDefaultJob(String jobId) {
        if (this.isAllJobsByDefault()) {
            return true;
        }
        return this.getJobsByDefault().contains(jobId);
    }

    public int getSaveInterval() {
        return this.plugin.getConfig().getInt("settings.save-interval", 300);
    }
}

