/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.config;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private static final String DEFAULT_LOCALE = "en_US";
    private static final String MISSING_MESSAGE_PREFIX = "<red>[Missing message: ";
    private static final String MISSING_MESSAGE_SUFFIX = "]";
    private final UniverseJobs plugin;
    private final Map<String, FileConfiguration> languageFiles;
    private String currentLocale;
    private FileConfiguration currentLanguage;
    private FileConfiguration fallbackLanguage;

    public LanguageManager(UniverseJobs plugin) {
        this.plugin = plugin;
        this.languageFiles = new HashMap<String, FileConfiguration>();
        this.currentLocale = DEFAULT_LOCALE;
        this.setupLanguageFiles();
        this.loadLanguage();
    }

    private void setupLanguageFiles() {
        String[] defaultLanguages;
        File languagesDir = new File(this.plugin.getDataFolder(), "languages");
        if (!languagesDir.exists()) {
            languagesDir.mkdirs();
        }
        for (String langFile : defaultLanguages = new String[]{"en_US.yml", "fr_FR.yml"}) {
            File file = new File(languagesDir, langFile);
            if (file.exists()) continue;
            try (InputStream in = this.plugin.getResource("languages/" + langFile);){
                if (in == null) continue;
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create language file " + langFile + ": " + e.getMessage());
            }
        }
    }

    public void loadLanguageFiles() {
        File[] files;
        this.languageFiles.clear();
        File languagesDir = new File(this.plugin.getDataFolder(), "languages");
        if (!languagesDir.exists()) {
            this.setupLanguageFiles();
        }
        if ((files = languagesDir.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : files) {
                try {
                    String locale = file.getName().replace(".yml", "");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                    this.languageFiles.put(locale, (FileConfiguration)config);
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to load language file: " + file.getName(), e);
                }
            }
        }
        if (!this.languageFiles.containsKey(DEFAULT_LOCALE)) {
            this.plugin.getLogger().warning("en_US language file not found! Creating fallback...");
            this.languageFiles.put(DEFAULT_LOCALE, (FileConfiguration)new YamlConfiguration());
        }
    }

    public void loadLanguage() {
        this.currentLocale = this.plugin.getConfig().getString("language.locale", DEFAULT_LOCALE);
        this.loadLanguageFiles();
        this.currentLanguage = this.languageFiles.get(this.currentLocale);
        this.fallbackLanguage = this.languageFiles.get(DEFAULT_LOCALE);
        if (this.currentLanguage == null) {
            this.plugin.getLogger().warning("Language " + this.currentLocale + " not found! Falling back to en_US");
            this.currentLanguage = this.fallbackLanguage;
            this.currentLocale = DEFAULT_LOCALE;
        }
    }

    public String getMessage(String key, Object ... placeholders) {
        String message = this.getRawMessage(key);
        if (message == null) {
            return MISSING_MESSAGE_PREFIX + key + MISSING_MESSAGE_SUFFIX;
        }
        if (placeholders.length > 0) {
            for (int i = 0; i < placeholders.length - 1; i += 2) {
                String placeholder = "{" + String.valueOf(placeholders[i]) + "}";
                String value = String.valueOf(placeholders[i + 1]);
                message = message.replace(placeholder, value);
            }
        }
        Component component = MessageUtils.parseMessage(message);
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    private String getRawMessage(String key) {
        String message = this.currentLanguage.getString(key);
        if (message == null && this.fallbackLanguage != null && !this.currentLocale.equals(DEFAULT_LOCALE) && (message = this.fallbackLanguage.getString(key)) != null) {
            this.plugin.getLogger().warning("Missing translation for key '" + key + "' in " + this.currentLocale + ", using English fallback");
        }
        return message;
    }

    public String getMessage(String key, Map<String, Object> placeholders) {
        String message = this.getRawMessage(key);
        if (message == null) {
            return MISSING_MESSAGE_PREFIX + key + MISSING_MESSAGE_SUFFIX;
        }
        if (placeholders != null) {
            for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
                String placeholder = "{" + entry.getKey() + "}";
                String value = String.valueOf(entry.getValue());
                message = message.replace(placeholder, value);
            }
        }
        Component component = MessageUtils.parseMessage(message);
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public String getMessage(String key) {
        return this.getMessage(key, new Object[0]);
    }

    public boolean hasMessage(String key) {
        return this.getRawMessage(key) != null;
    }

    public String getCurrentLocale() {
        return this.currentLocale;
    }

    public Set<String> getAvailableLocales() {
        return this.languageFiles.keySet();
    }

    public Component getMessageComponent(String key, Object ... placeholders) {
        String message = this.getRawMessage(key);
        if (message == null) {
            return MessageUtils.parseMessage(MISSING_MESSAGE_PREFIX + key + MISSING_MESSAGE_SUFFIX);
        }
        if (placeholders.length > 0) {
            for (int i = 0; i < placeholders.length - 1; i += 2) {
                String placeholder = "{" + String.valueOf(placeholders[i]) + "}";
                String value = String.valueOf(placeholders[i + 1]);
                message = message.replace(placeholder, value);
            }
        }
        return MessageUtils.parseMessage(message);
    }

    public Component getMessageComponent(String key, Map<String, Object> placeholders) {
        String message = this.getRawMessage(key);
        if (message == null) {
            return MessageUtils.parseMessage(MISSING_MESSAGE_PREFIX + key + MISSING_MESSAGE_SUFFIX);
        }
        if (placeholders != null) {
            for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
                String placeholder = "{" + entry.getKey() + "}";
                String value = String.valueOf(entry.getValue());
                message = message.replace(placeholder, value);
            }
        }
        return MessageUtils.parseMessage(message);
    }

    public void reload() {
        this.plugin.getLogger().info("Reloading language files...");
        this.loadLanguage();
    }
}

