/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.job;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.configuration.ConfigurationSection;

public class XpMessageSettings {
    private static final String CONFIG_DURATION = "duration";
    private final MessageType messageType;
    private final String text;
    private final int actionbarDuration;
    private final BossBarColor bossbarColor;
    private final BossBarStyle bossbarStyle;
    private int bossbarDuration;
    private final boolean bossbarShowProgress;
    private final String xpMessageFormat;
    private final String moneyMessageFormat;
    private final Set<BossBarFlag> bossbarFlags;
    private final int titleFadeIn;
    private final int titleFadeOut;
    private final int titleStay;

    public XpMessageSettings(ConfigurationSection config) {
        if (config == null) {
            this.messageType = MessageType.ACTIONBAR;
            this.text = "&e+{xp} XP ({job})";
            this.actionbarDuration = 60;
            this.bossbarColor = BossBarColor.GREEN;
            this.bossbarStyle = BossBarStyle.SOLID;
            this.bossbarDuration = 60;
            this.bossbarShowProgress = false;
            this.xpMessageFormat = "+{xp} XP";
            this.moneyMessageFormat = "+{money} money";
            this.bossbarFlags = new HashSet<BossBarFlag>();
            this.titleFadeIn = 10;
            this.titleFadeOut = 20;
            this.titleStay = 70;
        } else {
            this.messageType = this.parseMessageType(config);
            this.text = config.getString("text", "&e+{xp} XP ({job})");
            this.actionbarDuration = config.getInt("actionbar.duration", 60);
            ConfigurationSection optionsSection = config.getConfigurationSection("options");
            this.bossbarColor = this.parseBossBarColor(config, optionsSection);
            this.bossbarStyle = this.parseBossBarStyle(config, optionsSection);
            this.bossbarDuration = this.parseDuration(config, optionsSection);
            this.bossbarShowProgress = this.parseShowProgress(config, optionsSection);
            this.bossbarFlags = this.parseBossBarFlags(optionsSection);
            int[] titleSettings = this.parseTitleSettingsArray(optionsSection);
            this.titleFadeIn = titleSettings[0];
            this.titleFadeOut = titleSettings[1];
            this.titleStay = titleSettings[2];
            this.xpMessageFormat = config.getString("xp", "+{xp} XP");
            this.moneyMessageFormat = config.getString("money", "+{money} money");
        }
    }

    private MessageType parseMessageType(ConfigurationSection config) {
        String typeStr = config.getString("type", "actionbar").toUpperCase();
        try {
            return MessageType.valueOf(typeStr);
        }
        catch (IllegalArgumentException e) {
            return MessageType.ACTIONBAR;
        }
    }

    private BossBarColor parseBossBarColor(ConfigurationSection config, ConfigurationSection optionsSection) {
        String colorStr = this.getConfigValue(optionsSection, config, "color", "bossbar.color", "green");
        try {
            return BossBarColor.valueOf(colorStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BossBarColor.GREEN;
        }
    }

    private BossBarStyle parseBossBarStyle(ConfigurationSection config, ConfigurationSection optionsSection) {
        String styleStr = this.getConfigValue(optionsSection, config, "style", "bossbar.style", "solid");
        try {
            return BossBarStyle.valueOf(styleStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BossBarStyle.SOLID;
        }
    }

    private int parseDuration(ConfigurationSection config, ConfigurationSection optionsSection) {
        if (optionsSection != null) {
            Object durationObj = optionsSection.get(CONFIG_DURATION);
            if (durationObj instanceof String) {
                try {
                    return Integer.parseInt((String)durationObj);
                }
                catch (NumberFormatException e) {
                    return 60;
                }
            }
            return optionsSection.getInt(CONFIG_DURATION, 60);
        }
        return config.getInt(CONFIG_DURATION, config.getInt("bossbar.duration", 60));
    }

    private boolean parseShowProgress(ConfigurationSection config, ConfigurationSection optionsSection) {
        if (optionsSection != null) {
            return optionsSection.getBoolean("show-progress", false);
        }
        return config.getBoolean("show-progress", false);
    }

    private Set<BossBarFlag> parseBossBarFlags(ConfigurationSection optionsSection) {
        HashSet<BossBarFlag> flags = new HashSet<BossBarFlag>();
        if (optionsSection != null) {
            List flagStrings = optionsSection.getStringList("flags");
            for (String flagStr : flagStrings) {
                try {
                    BossBarFlag flag = BossBarFlag.valueOf(flagStr.toUpperCase());
                    flags.add(flag);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return flags;
    }

    private int[] parseTitleSettingsArray(ConfigurationSection optionsSection) {
        if (optionsSection != null) {
            return new int[]{optionsSection.getInt("fade-in", 10), optionsSection.getInt("fade-out", 20), optionsSection.getInt("stay", 70)};
        }
        return new int[]{10, 20, 70};
    }

    private String getConfigValue(ConfigurationSection optionsSection, ConfigurationSection config, String optionsKey, String fallbackKey, String defaultValue) {
        if (optionsSection != null) {
            return optionsSection.getString(optionsKey, defaultValue);
        }
        return config.getString(optionsKey, config.getString(fallbackKey, defaultValue));
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getText() {
        return this.text;
    }

    public int getActionbarDuration() {
        return this.actionbarDuration;
    }

    public BossBarColor getBossbarColor() {
        return this.bossbarColor;
    }

    public BossBarStyle getBossbarStyle() {
        return this.bossbarStyle;
    }

    public int getBossbarDuration() {
        return this.bossbarDuration;
    }

    public boolean shouldShowProgress() {
        return this.bossbarShowProgress;
    }

    public String getXpMessageFormat() {
        return this.xpMessageFormat;
    }

    public String getMoneyMessageFormat() {
        return this.moneyMessageFormat;
    }

    public Set<BossBarFlag> getBossbarFlags() {
        return new HashSet<BossBarFlag>(this.bossbarFlags);
    }

    public int getTitleFadeIn() {
        return this.titleFadeIn;
    }

    public int getTitleFadeOut() {
        return this.titleFadeOut;
    }

    public int getTitleStay() {
        return this.titleStay;
    }

    public String processMessage(double xp, double money) {
        String processedText = this.text;
        if (xp > 0.0) {
            String xpMessage = this.xpMessageFormat.replace("{xp}", String.valueOf((int)xp));
            processedText = processedText.replace("{message_xp}", xpMessage);
        } else {
            processedText = processedText.replace("{message_xp}", "");
        }
        if (money > 0.0) {
            String moneyMessage = this.moneyMessageFormat.replace("{money}", String.valueOf(money));
            processedText = processedText.replace("{message_money}", moneyMessage);
        } else {
            processedText = processedText.replace("{message_money}", "");
        }
        processedText = processedText.replace("{xp}", String.valueOf((int)xp));
        processedText = processedText.replace("{money}", String.valueOf(money));
        return processedText;
    }

    public BarColor toBukkitBarColor() {
        switch (this.bossbarColor.ordinal()) {
            case 0: {
                return BarColor.PINK;
            }
            case 1: {
                return BarColor.BLUE;
            }
            case 2: {
                return BarColor.RED;
            }
            case 3: {
                return BarColor.GREEN;
            }
            case 4: {
                return BarColor.YELLOW;
            }
            case 5: {
                return BarColor.PURPLE;
            }
            case 6: {
                return BarColor.WHITE;
            }
        }
        return BarColor.GREEN;
    }

    public BarStyle toBukkitBarStyle() {
        switch (this.bossbarStyle.ordinal()) {
            case 0: {
                return BarStyle.SOLID;
            }
            case 1: {
                return BarStyle.SEGMENTED_6;
            }
            case 2: {
                return BarStyle.SEGMENTED_10;
            }
            case 3: {
                return BarStyle.SEGMENTED_12;
            }
            case 4: {
                return BarStyle.SEGMENTED_20;
            }
        }
        return BarStyle.SOLID;
    }

    public BarFlag[] toBukkitBarFlags() {
        ArrayList<BarFlag> bukkitFlags = new ArrayList<BarFlag>();
        for (BossBarFlag flag : this.bossbarFlags) {
            switch (flag.ordinal()) {
                case 0: {
                    bukkitFlags.add(BarFlag.DARKEN_SKY);
                    break;
                }
                case 1: {
                    bukkitFlags.add(BarFlag.PLAY_BOSS_MUSIC);
                    break;
                }
                case 2: {
                    bukkitFlags.add(BarFlag.CREATE_FOG);
                }
            }
        }
        return bukkitFlags.toArray(new BarFlag[0]);
    }

    public static enum MessageType {
        CHAT,
        ACTIONBAR,
        BOSSBAR;

    }

    public static enum BossBarColor {
        PINK,
        BLUE,
        RED,
        GREEN,
        YELLOW,
        PURPLE,
        WHITE;

    }

    public static enum BossBarStyle {
        SOLID,
        SEGMENTED_6,
        SEGMENTED_10,
        SEGMENTED_12,
        SEGMENTED_20;

    }

    public static enum BossBarFlag {
        DARKEN_SKY,
        PLAY_BOSS_MUSIC,
        CREATE_FOG;

    }
}

