/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.MenuConfig;
import fr.ax_dev.universejobs.menu.impl.GlobalRankingsMenu;
import fr.ax_dev.universejobs.menu.impl.JobActionsMenu;
import fr.ax_dev.universejobs.menu.impl.JobsMainMenu;
import fr.ax_dev.universejobs.menu.impl.SingleJobMenu;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.plugin.Plugin;

public class MenuManager
implements Listener {
    private final UniverseJobs plugin;
    private final Map<UUID, BaseMenu> openMenus;
    private final MenuConfig menuConfig;

    public MenuManager(UniverseJobs plugin) {
        this.plugin = plugin;
        this.openMenus = new ConcurrentHashMap<UUID, BaseMenu>();
        this.menuConfig = new MenuConfig(plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.menuConfig.loadConfigurations();
    }

    public void openJobsMainMenu(Player player) {
        this.closeCurrentMenu(player);
        JobsMainMenu menu = new JobsMainMenu(this.plugin, player, this.menuConfig.getMainMenuConfig());
        this.openMenus.put(player.getUniqueId(), menu);
        menu.open();
    }

    public void openJobMenu(Player player, String jobId) {
        this.closeCurrentMenu(player);
        SingleJobMenu menu = new SingleJobMenu(this.plugin, player, jobId, this.menuConfig.getJobMenuConfig());
        this.openMenus.put(player.getUniqueId(), menu);
        menu.open();
    }

    public void openJobActionsMenu(Player player, String jobId) {
        this.closeCurrentMenu(player);
        JobActionsMenu menu = new JobActionsMenu(this.plugin, player, jobId, this.menuConfig.getActionsMenuConfig());
        this.openMenus.put(player.getUniqueId(), menu);
        menu.open();
    }

    public void openGlobalRankingsMenu(Player player) {
        this.closeCurrentMenu(player);
        GlobalRankingsMenu menu = new GlobalRankingsMenu(this.plugin, player, this.menuConfig.getRankingsMenuConfig());
        this.openMenus.put(player.getUniqueId(), menu);
        menu.open();
    }

    public void closeCurrentMenu(Player player) {
        BaseMenu currentMenu = this.openMenus.remove(player.getUniqueId());
        if (currentMenu != null) {
            currentMenu.close();
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        BaseMenu menu = this.openMenus.get(player.getUniqueId());
        if (menu != null && event.getView().getTopInventory().equals((Object)menu.getInventory())) {
            event.setCancelled(true);
            if (this.isClickInMenuInventory(event, menu) && this.isSecureClickType(event)) {
                menu.handleClick(event.getSlot(), event);
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        BaseMenu menu = this.openMenus.get(player.getUniqueId());
        if (menu != null && event.getView().getTopInventory().equals((Object)menu.getInventory())) {
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot >= event.getView().getTopInventory().getSize()) continue;
                event.setCancelled(true);
                break;
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        BaseMenu menu = this.openMenus.get(player.getUniqueId());
        if (menu != null && menu.isInventory(event.getInventory())) {
            this.openMenus.remove(player.getUniqueId());
            menu.onClose();
        }
    }

    public void closeAllMenus() {
        this.openMenus.values().forEach(BaseMenu::close);
        this.openMenus.clear();
    }

    public void reloadConfigurations() {
        this.menuConfig.loadConfigurations();
    }

    public MenuConfig getMenuConfig() {
        return this.menuConfig;
    }

    public void refreshPlayerMenu(Player player) {
        BaseMenu menu = this.openMenus.get(player.getUniqueId());
        if (menu != null) {
            menu.refresh();
        }
    }

    public boolean hasMenuOpen(Player player) {
        return this.openMenus.containsKey(player.getUniqueId());
    }

    public BaseMenu getCurrentMenu(Player player) {
        return this.openMenus.get(player.getUniqueId());
    }

    private boolean isClickInMenuInventory(InventoryClickEvent event, BaseMenu menu) {
        return event.getClickedInventory() != null && event.getClickedInventory().equals((Object)event.getView().getTopInventory()) && event.getClickedInventory().equals((Object)menu.getInventory());
    }

    private boolean isSecureClickType(InventoryClickEvent event) {
        switch (event.getClick()) {
            case LEFT: 
            case RIGHT: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: {
                return true;
            }
            case DOUBLE_CLICK: 
            case NUMBER_KEY: 
            case DROP: 
            case CONTROL_DROP: 
            case CREATIVE: 
            case UNKNOWN: {
                return false;
            }
        }
        return false;
    }
}

