/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.impl;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.action.JobAction;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.menu.utils.MenuItemUtils;
import fr.ax_dev.universejobs.reward.Reward;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class JobActionsMenu
extends BaseMenu {
    private final Job job;
    private final List<ActionInfo> actionInfos;
    private final List<Reward> jobRewards;

    public JobActionsMenu(UniverseJobs plugin, Player player, String jobId, SingleMenuConfig config) {
        super(plugin, player, config);
        this.job = plugin.getJobManager().getJob(jobId);
        this.actionInfos = new ArrayList<ActionInfo>();
        this.jobRewards = new ArrayList<Reward>();
        if (this.job == null) {
            MessageUtils.sendMessage(player, "&cJob not found: " + jobId);
            this.close();
            return;
        }
        this.loadJobActions();
        this.loadJobRewards();
        this.populateInventory();
    }

    private void loadJobActions() {
        for (ActionType actionType : this.job.getActionTypes()) {
            List<JobAction> actions = this.job.getActions(actionType);
            for (JobAction action : actions) {
                this.actionInfos.add(new ActionInfo(actionType, action));
            }
        }
    }

    private void loadJobRewards() {
        if (this.plugin.getRewardManager() != null) {
            this.jobRewards.addAll(this.plugin.getRewardManager().getJobRewards(this.job.getId()));
        }
    }

    @Override
    protected void populateInventory() {
        if (this.job == null) {
            return;
        }
        this.inventory.clear();
        this.addJobHeader();
        this.addActionAndRewardItems();
        this.addNavigationItems();
        this.addStaticItems();
        this.addFillItems();
    }

    private void addJobHeader() {
        ItemStack headerItem = this.createJobHeaderItem();
        this.inventory.setItem(4, headerItem);
    }

    private ItemStack createJobHeaderItem() {
        try {
            Material iconMaterial = Material.valueOf((String)this.job.getIcon().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            Material iconMaterial = Material.STONE;
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&7" + this.job.getDescription());
        lore.add("");
        lore.add("&7Total Actions: &e" + this.actionInfos.size());
        lore.add("&7Total Rewards: &e" + this.jobRewards.size());
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(this.job.getIcon(), "&6&l" + this.job.getName() + " - Actions & Rewards", lore, true);
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription()));
    }

    private void addActionAndRewardItems() {
        List<Integer> contentSlots = this.config.getContentSlots();
        ArrayList<DisplayItem> displayItems = new ArrayList<DisplayItem>();
        for (ActionInfo actionInfo : this.actionInfos) {
            displayItems.add(new DisplayItem("action", actionInfo));
        }
        for (Reward reward : this.jobRewards) {
            displayItems.add(new DisplayItem("reward", reward));
        }
        int startIndex = this.currentPage * this.config.getItemsPerPage();
        int endIndex = Math.min(startIndex + this.config.getItemsPerPage(), displayItems.size());
        for (int i = startIndex; i < endIndex; ++i) {
            DisplayItem displayItem = (DisplayItem)displayItems.get(i);
            int slotIndex = i - startIndex;
            if (slotIndex >= contentSlots.size()) break;
            int slot = contentSlots.get(slotIndex);
            ItemStack item = displayItem.type.equals("action") ? this.createActionItem((ActionInfo)displayItem.data) : this.createRewardItem((Reward)displayItem.data);
            this.inventory.setItem(slot, item);
        }
    }

    private ItemStack createActionItem(ActionInfo actionInfo) {
        ActionType actionType = actionInfo.actionType;
        JobAction action = actionInfo.action;
        String material = MenuItemUtils.getActionMaterial(actionType);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&7Type: &e" + actionType.name().toLowerCase().replace("_", " "));
        if (action.getTarget() != null && !action.getTarget().isEmpty()) {
            lore.add("&7Target: &e" + action.getTarget());
        }
        if (action.getXp() > 0.0) {
            lore.add("&7XP Reward: &b+" + action.getXp());
        }
        if (action.getMoney() > 0.0) {
            lore.add("&7Money Reward: &a$" + action.getMoney());
        }
        if (action.hasRequirements()) {
            lore.add("");
            lore.add("&6Conditions:");
            lore.add("&8- Various conditions apply");
        }
        lore.add("");
        lore.add("&8Action from job: &7" + this.job.getName());
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(material, "&e&l" + MenuItemUtils.formatActionName(actionType), lore, false);
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription()));
    }

    private ItemStack createRewardItem(Reward reward) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&7" + reward.getDescription());
        lore.add("");
        lore.add("&7Required Level: &e" + reward.getRequiredLevel());
        if (reward.isRepeatable()) {
            lore.add("&7Repeatable: &aYes");
            if (reward.getCooldownHours() > 0L) {
                lore.add("&7Cooldown: &e" + reward.getCooldownHours() + "h");
            }
        } else {
            lore.add("&7Repeatable: &cNo");
        }
        if (reward.hasEconomyReward()) {
            lore.add("&7Money Reward: &a$" + reward.getEconomyReward());
        }
        if (reward.hasCommands()) {
            lore.add("&7Special Rewards: &eYes");
        }
        if (!reward.getItems().isEmpty()) {
            lore.add("");
            lore.add("&6Item Rewards:");
            int itemsShown = 0;
            for (Reward.RewardItem item : reward.getItems()) {
                if (itemsShown >= 3) {
                    lore.add("&8... and " + (reward.getItems().size() - 3) + " more");
                    break;
                }
                String itemName = item.getDisplayName() != null ? item.getDisplayName() : item.getMaterial();
                lore.add("&8- &f" + item.getAmount() + "x " + itemName);
                ++itemsShown;
            }
        }
        lore.add("");
        lore.add("&e\u25b6 Click to view reward details");
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap("CHEST", "&6&l" + reward.getName(), lore, false);
        configMap.put("action", "view_reward");
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription()));
    }

    private void addNavigationItems() {
        Map<String, MenuItemConfig> navItems = this.config.getNavigationItems();
        MenuItemUtils.addNavigationItems(this.inventory, navItems, this.currentPage, this.hasNextPage(), this.getNavigationPlaceholders(), config -> this.createMenuItem((MenuItemConfig)config, this.getNavigationPlaceholders()));
    }

    private void addStaticItems() {
        Map<String, String> placeholders = MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription());
        MenuItemUtils.addStaticItems(this.inventory, this.config.getStaticItems(), placeholders, config -> this.createMenuItem((MenuItemConfig)config, placeholders));
    }

    @Override
    public void handleClick(int slot, InventoryClickEvent event) {
        if (this.handleNavigationClick(slot)) {
            return;
        }
        List<Integer> contentSlots = this.config.getContentSlots();
        int slotIndex = contentSlots.indexOf(slot);
        if (slotIndex >= 0) {
            List<DisplayItem> displayItems = this.getAllDisplayItems();
            int itemIndex = this.currentPage * this.config.getItemsPerPage() + slotIndex;
            if (itemIndex < displayItems.size()) {
                DisplayItem displayItem = displayItems.get(itemIndex);
                if (displayItem.type.equals("reward")) {
                    Reward reward = (Reward)displayItem.data;
                    this.plugin.getRewardGuiManager().openRewardsGui(this.player, this.job.getId());
                }
            }
        }
    }

    @Override
    protected boolean hasNextPage() {
        List<DisplayItem> displayItems = this.getAllDisplayItems();
        return (this.currentPage + 1) * this.config.getItemsPerPage() < displayItems.size();
    }

    @Override
    protected void handleBackButton() {
        this.plugin.getMenuManager().openJobMenu(this.player, this.job.getId());
    }

    private List<DisplayItem> getAllDisplayItems() {
        ArrayList<DisplayItem> displayItems = new ArrayList<DisplayItem>();
        for (ActionInfo actionInfo : this.actionInfos) {
            displayItems.add(new DisplayItem("action", actionInfo));
        }
        for (Reward reward : this.jobRewards) {
            displayItems.add(new DisplayItem("reward", reward));
        }
        return displayItems;
    }

    private Map<String, String> getNavigationPlaceholders() {
        List<DisplayItem> displayItems = this.getAllDisplayItems();
        Map<String, String> placeholders = MenuItemUtils.createNavigationPlaceholders(this.currentPage, displayItems.size(), this.config.getItemsPerPage());
        placeholders.put("total_actions", String.valueOf(this.actionInfos.size()));
        placeholders.put("total_rewards", String.valueOf(this.jobRewards.size()));
        return placeholders;
    }

    private static class ActionInfo {
        final ActionType actionType;
        final JobAction action;

        ActionInfo(ActionType actionType, JobAction action) {
            this.actionType = actionType;
            this.action = action;
        }
    }

    private static class DisplayItem {
        final String type;
        final Object data;

        DisplayItem(String type, Object data) {
            this.type = type;
            this.data = data;
        }
    }
}

