/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.impl;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.menu.utils.MenuItemUtils;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class JobsMainMenu
extends BaseMenu {
    private final List<Job> availableJobs;
    private final PlayerJobData playerData;

    public JobsMainMenu(UniverseJobs plugin, Player player, SingleMenuConfig config) {
        super(plugin, player, config);
        this.playerData = plugin.getJobManager().getPlayerData(player.getUniqueId());
        this.availableJobs = plugin.getJobManager().getJobs().values().stream().filter(job -> job.isEnabled()).filter(job -> job.getPermission() == null || player.hasPermission(job.getPermission())).sorted(Comparator.comparing(Job::getName)).collect(Collectors.toList());
        this.populateInventory();
    }

    @Override
    protected void populateInventory() {
        this.inventory.clear();
        this.addStaticItems();
        this.addJobItems();
        this.addNavigationItems();
        this.addFillItems();
    }

    private void addStaticItems() {
        Map<String, String> placeholders = this.getGeneralPlaceholders();
        MenuItemUtils.addStaticItems(this.inventory, this.config.getStaticItems(), placeholders, config -> this.createMenuItem((MenuItemConfig)config, placeholders));
    }

    private void addJobItems() {
        List<Integer> contentSlots = this.config.getContentSlots();
        int startIndex = this.currentPage * this.config.getItemsPerPage();
        int endIndex = Math.min(startIndex + this.config.getItemsPerPage(), this.availableJobs.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Job job = this.availableJobs.get(i);
            int slotIndex = i - startIndex;
            if (slotIndex >= contentSlots.size()) break;
            int slot = contentSlots.get(slotIndex);
            ItemStack jobItem = this.createJobItem(job);
            this.inventory.setItem(slot, jobItem);
        }
    }

    private ItemStack createJobItem(Job job) {
        Material iconMaterial;
        try {
            iconMaterial = Material.valueOf((String)job.getIcon().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            iconMaterial = Material.STONE;
        }
        ItemStack item = new ItemStack(iconMaterial);
        boolean hasJob = this.playerData.hasJob(job.getId());
        int playerLevel = hasJob ? this.playerData.getLevel(job.getId()) : 0;
        long playerXp = hasJob ? (long)this.playerData.getXp(job.getId()) : 0L;
        Map<String, String> placeholders = MenuItemUtils.createJobPlaceholders(job.getId(), job.getName(), job.getDescription());
        placeholders.put("job_max_level", String.valueOf(job.getMaxLevel()));
        placeholders.put("player_level", String.valueOf(playerLevel));
        placeholders.put("player_xp", String.valueOf(playerXp));
        placeholders.put("has_job", hasJob ? "Yes" : "No");
        placeholders.put("job_status", hasJob ? "&aJoined" : "&7Not Joined");
        if (hasJob && job.getXpCurve() != null && playerLevel < job.getMaxLevel()) {
            long nextLevelXp = (long)job.getXpCurve().getXpForLevel(playerLevel + 1);
            long xpToNext = nextLevelXp - playerXp;
            placeholders.put("xp_to_next", String.valueOf(Math.max(0L, xpToNext)));
            placeholders.put("next_level_xp", String.valueOf(nextLevelXp));
        } else {
            placeholders.put("xp_to_next", "0");
            placeholders.put("next_level_xp", "0");
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&7" + job.getDescription());
        lore.add("");
        lore.add("&7Max Level: &e{job_max_level}");
        if (hasJob) {
            lore.add("&7Your Level: &a{player_level}");
            lore.add("&7Your XP: &b{player_xp}");
            if (playerLevel < job.getMaxLevel()) {
                lore.add("&7XP to Next: &e{xp_to_next}");
            }
            lore.add("");
            lore.add("&7Status: {job_status}");
        } else {
            lore.add("&7Your Level: &c0");
            lore.add("&7Status: {job_status}");
        }
        lore.addAll(job.getLore());
        lore.add("");
        lore.add("&e\u25b6 Click to open job menu");
        if (hasJob) {
            lore.add("&c\u25b6 Shift+Click to leave job");
        } else {
            lore.add("&a\u25b6 Shift+Click to join job");
        }
        Map<String, Object> jobConfigMap = MenuItemUtils.createItemConfigMap(job.getIcon(), "&e&l" + job.getName(), lore, hasJob);
        jobConfigMap.put("action", "open_job");
        jobConfigMap.put("action-value", job.getId());
        MenuItemConfig jobItemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(jobConfigMap));
        return this.createMenuItem(jobItemConfig, placeholders);
    }

    private void addNavigationItems() {
        Map<String, MenuItemConfig> navItems = this.config.getNavigationItems();
        MenuItemUtils.addNavigationItems(this.inventory, navItems, this.currentPage, this.hasNextPage(), this.getNavigationPlaceholders(), config -> this.createMenuItem((MenuItemConfig)config, this.getNavigationPlaceholders()));
    }

    private Map<String, String> getNavigationPlaceholders() {
        Map<String, String> placeholders = MenuItemUtils.createNavigationPlaceholders(this.currentPage, this.availableJobs.size(), this.config.getItemsPerPage());
        placeholders.put("total_jobs", String.valueOf(this.availableJobs.size()));
        placeholders.put("player_jobs", String.valueOf(this.playerData.getJobs().size()));
        return placeholders;
    }

    private Map<String, String> getGeneralPlaceholders() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("total_jobs", String.valueOf(this.availableJobs.size()));
        placeholders.put("player_jobs", String.valueOf(this.playerData.getJobs().size()));
        return placeholders;
    }

    @Override
    public void handleClick(int slot, InventoryClickEvent event) {
        int jobIndex;
        if (this.handleNavigationClick(slot)) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        List<Integer> contentSlots = this.config.getContentSlots();
        int slotIndex = contentSlots.indexOf(slot);
        if (slotIndex >= 0 && (jobIndex = this.currentPage * this.config.getItemsPerPage() + slotIndex) < this.availableJobs.size()) {
            Job clickedJob = this.availableJobs.get(jobIndex);
            if (event.getClick().isShiftClick()) {
                this.handleQuickJoinLeave(clickedJob);
            } else {
                this.plugin.getMenuManager().openJobMenu(this.player, clickedJob.getId());
            }
        }
    }

    private void handleQuickJoinLeave(Job job) {
        boolean currentlyHasJob = this.playerData.hasJob(job.getId());
        if (currentlyHasJob) {
            if (this.plugin.getJobManager().leaveJob(this.player, job.getId())) {
                MessageUtils.sendMessage(this.player, "&cYou have left the job: &e" + job.getName());
                this.refresh();
            } else {
                MessageUtils.sendMessage(this.player, "&cFailed to leave the job.");
            }
        } else {
            if (!this.canJoinJob(job)) {
                return;
            }
            if (this.plugin.getJobManager().joinJob(this.player, job.getId())) {
                MessageUtils.sendMessage(this.player, "&aYou have joined the job: &e" + job.getName());
                this.refresh();
            } else {
                MessageUtils.sendMessage(this.player, "&cFailed to join the job.");
            }
        }
    }

    private boolean canJoinJob(Job job) {
        if (job.getPermission() != null && !this.player.hasPermission(job.getPermission())) {
            MessageUtils.sendMessage(this.player, "&cYou don't have permission to join this job.");
            return false;
        }
        int maxJobs = this.getMaxJobsForPlayer(this.player);
        int currentJobs = this.playerData.getJobs().size();
        if (currentJobs >= maxJobs) {
            MessageUtils.sendMessage(this.player, "&cYou have reached the maximum number of jobs (" + maxJobs + ").");
            return false;
        }
        return true;
    }

    private int getMaxJobsForPlayer(Player player) {
        int maxJobs = 1;
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String permission = permInfo.getPermission();
            if (!permission.startsWith("universejobs.max_join.") || !permInfo.getValue()) continue;
            try {
                String numberPart = permission.substring("universejobs.max_join.".length());
                int permissionValue = Integer.parseInt(numberPart);
                if (permissionValue <= maxJobs) continue;
                maxJobs = permissionValue;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxJobs;
    }

    @Override
    protected boolean hasNextPage() {
        return (this.currentPage + 1) * this.config.getItemsPerPage() < this.availableJobs.size();
    }

    private int getTotalPages() {
        return (int)Math.ceil((double)this.availableJobs.size() / (double)this.config.getItemsPerPage());
    }
}

