/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.impl;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.menu.utils.MenuItemUtils;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class SingleJobMenu
extends BaseMenu {
    private final Job job;
    private final PlayerJobData playerData;
    private boolean hasJob;

    public SingleJobMenu(UniverseJobs plugin, Player player, String jobId, SingleMenuConfig config) {
        super(plugin, player, config);
        this.job = plugin.getJobManager().getJob(jobId);
        this.playerData = plugin.getJobManager().getPlayerData(player.getUniqueId());
        this.hasJob = this.playerData.hasJob(jobId);
        if (this.job == null) {
            MessageUtils.sendMessage(player, "&cJob not found: " + jobId);
            this.close();
            return;
        }
        this.populateInventory();
    }

    @Override
    protected void populateInventory() {
        if (this.job == null) {
            return;
        }
        this.inventory.clear();
        this.addJobInformation();
        this.addActionButtons();
        this.addNavigationItems();
        this.addStaticItems();
        this.addFillItems();
    }

    private void addJobInformation() {
        ItemStack jobInfoItem = this.createJobInfoItem();
        this.inventory.setItem(13, jobInfoItem);
        ItemStack playerStatsItem = this.createPlayerStatsItem();
        this.inventory.setItem(22, playerStatsItem);
    }

    private ItemStack createJobInfoItem() {
        try {
            Material iconMaterial = Material.valueOf((String)this.job.getIcon().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            Material iconMaterial = Material.STONE;
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&7" + this.job.getDescription());
        lore.add("");
        lore.add("&7Max Level: &e" + this.job.getMaxLevel());
        lore.add("&7XP Type: &e" + this.job.getXpType());
        if (!this.job.getLore().isEmpty()) {
            lore.add("");
            lore.addAll(this.job.getLore());
        }
        if (!this.job.getActionTypes().isEmpty()) {
            lore.add("");
            lore.add("&6Available Actions:");
            this.job.getActionTypes().forEach(actionType -> lore.add("&8- &e" + actionType.name().toLowerCase().replace("_", " ")));
        }
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(this.job.getIcon(), "&e&l" + this.job.getName(), lore, true);
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription()));
    }

    private ItemStack createPlayerStatsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        if (this.hasJob) {
            int playerLevel = this.playerData.getLevel(this.job.getId());
            long playerXp = (long)this.playerData.getXp(this.job.getId());
            lore.add("&7Your Level: &a" + playerLevel);
            lore.add("&7Your XP: &b" + playerXp);
            if (playerLevel < this.job.getMaxLevel() && this.job.getXpCurve() != null) {
                long nextLevelXp = (long)this.job.getXpCurve().getXpForLevel(playerLevel + 1);
                long xpToNext = nextLevelXp - playerXp;
                lore.add("&7XP to Next Level: &e" + Math.max(0L, xpToNext));
                double progress = (double)playerXp / (double)nextLevelXp;
                String progressBar = this.createProgressBar(progress);
                lore.add("&7Progress: " + progressBar);
            }
            lore.add("");
            lore.add("&7Status: &aJoined");
        } else {
            lore.add("&7Your Level: &c0");
            lore.add("&7Your XP: &c0");
            lore.add("");
            lore.add("&7Status: &cNot Joined");
        }
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap("PLAYER_HEAD", "&6Your Progress", lore, this.hasJob);
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription()));
    }

    private void addActionButtons() {
        ItemStack joinLeaveButton = this.createJoinLeaveButton();
        this.inventory.setItem(29, joinLeaveButton);
        ItemStack actionsButton = this.createActionsButton();
        this.inventory.setItem(31, actionsButton);
        ItemStack rankingsButton = this.createRankingsButton();
        this.inventory.setItem(33, rankingsButton);
    }

    private ItemStack createJoinLeaveButton() {
        String material = this.hasJob ? "RED_CONCRETE" : "GREEN_CONCRETE";
        String name = this.hasJob ? "&c&lLeave Job" : "&a&lJoin Job";
        ArrayList<String> lore = new ArrayList<String>();
        if (this.hasJob) {
            lore.add("&7Click to leave this job");
            lore.add("");
            lore.add("&c&lWARNING:");
            lore.add("&cYou will lose all progress!");
        } else {
            lore.add("&7Click to join this job");
            if (this.job.getPermission() != null && !this.player.hasPermission(this.job.getPermission())) {
                lore.add("");
                lore.add("&c&lRequired Permission:");
                lore.add("&c" + this.job.getPermission());
            }
        }
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(material, name, lore, false);
        configMap.put("action", this.hasJob ? "leave_job" : "join_job");
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription()));
    }

    private ItemStack createActionsButton() {
        List<String> lore = Arrays.asList("&7View all available actions", "&7and their rewards for this job", "", "&e\u25b6 Click to open actions menu");
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap("DIAMOND_PICKAXE", "&6&lActions & Rewards", lore, false);
        configMap.put("action", "open_actions");
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription()));
    }

    private ItemStack createRankingsButton() {
        List<String> lore = Arrays.asList("&7View global job rankings", "&7and see top players", "", "&e\u25b6 Click to open rankings");
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap("GOLD_INGOT", "&6&lGlobal Rankings", lore, false);
        configMap.put("action", "open_rankings");
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription()));
    }

    private void addNavigationItems() {
        ItemStack backButton = this.createBackButton();
        this.inventory.setItem(39, backButton);
        ItemStack closeButton = this.createCloseButton();
        this.inventory.setItem(41, closeButton);
    }

    private ItemStack createBackButton() {
        List<String> lore = Arrays.asList("&7Go back to the main jobs menu");
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap("ARROW", "&7&l\u2190 Back to Jobs Menu", lore, false);
        configMap.put("action", "back_to_main");
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig);
    }

    private ItemStack createCloseButton() {
        List<String> lore = Arrays.asList("&7Close this menu");
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap("BARRIER", "&c&lClose", lore, false);
        configMap.put("action", "close");
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig);
    }

    private void addStaticItems() {
        Map<String, String> placeholders = MenuItemUtils.createJobPlaceholders(this.job.getId(), this.job.getName(), this.job.getDescription());
        MenuItemUtils.addStaticItems(this.inventory, this.config.getStaticItems(), placeholders, config -> this.createMenuItem((MenuItemConfig)config, placeholders));
    }

    @Override
    public void handleClick(int slot, InventoryClickEvent event) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        switch (slot) {
            case 29: {
                this.handleJoinLeave();
                break;
            }
            case 31: {
                this.plugin.getMenuManager().openJobActionsMenu(this.player, this.job.getId());
                break;
            }
            case 33: {
                this.plugin.getMenuManager().openGlobalRankingsMenu(this.player);
                break;
            }
            case 39: {
                this.plugin.getMenuManager().openJobsMainMenu(this.player);
                break;
            }
            case 41: {
                this.close();
                break;
            }
            default: {
                this.handleNavigationClick(slot);
            }
        }
    }

    private void handleJoinLeave() {
        if (this.hasJob) {
            if (this.plugin.getJobManager().leaveJob(this.player, this.job.getId())) {
                MessageUtils.sendMessage(this.player, "&cYou have left the job: &e" + this.job.getName());
                this.hasJob = false;
                this.refresh();
            } else {
                MessageUtils.sendMessage(this.player, "&cFailed to leave the job.");
            }
        } else {
            if (!this.canJoinJob()) {
                return;
            }
            if (this.plugin.getJobManager().joinJob(this.player, this.job.getId())) {
                MessageUtils.sendMessage(this.player, "&aYou have joined the job: &e" + this.job.getName());
                this.hasJob = true;
                this.refresh();
            } else {
                MessageUtils.sendMessage(this.player, "&cFailed to join the job.");
            }
        }
    }

    private boolean canJoinJob() {
        if (this.job.getPermission() != null && !this.player.hasPermission(this.job.getPermission())) {
            MessageUtils.sendMessage(this.player, "&cYou don't have permission to join this job.");
            return false;
        }
        int maxJobs = this.getMaxJobsForPlayer(this.player);
        int currentJobs = this.plugin.getJobManager().getPlayerData(this.player.getUniqueId()).getJobs().size();
        if (currentJobs >= maxJobs) {
            MessageUtils.sendMessage(this.player, "&cYou have reached the maximum number of jobs (" + maxJobs + ").");
            return false;
        }
        return true;
    }

    private int getMaxJobsForPlayer(Player player) {
        int maxJobs = 1;
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String permission = permInfo.getPermission();
            if (!permission.startsWith("universejobs.max_join.") || !permInfo.getValue()) continue;
            try {
                String numberPart = permission.substring("universejobs.max_join.".length());
                int permissionValue = Integer.parseInt(numberPart);
                if (permissionValue <= maxJobs) continue;
                maxJobs = permissionValue;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxJobs;
    }

    @Override
    protected boolean hasNextPage() {
        return false;
    }

    @Override
    protected void handleBackButton() {
        this.plugin.getMenuManager().openJobsMainMenu(this.player);
    }

    private String createProgressBar(double progress) {
        int bars = 20;
        int filled = (int)Math.round(progress * (double)bars);
        StringBuilder progressBar = new StringBuilder("&a");
        for (int i = 0; i < bars; ++i) {
            if (i < filled) {
                progressBar.append("\u2588");
                continue;
            }
            progressBar.append("&7\u2588");
        }
        progressBar.append(" &f").append(String.format("%.1f", progress * 100.0)).append("%");
        return progressBar.toString();
    }
}

