/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward.gui;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.reward.Reward;
import fr.ax_dev.universejobs.reward.RewardManager;
import fr.ax_dev.universejobs.reward.RewardStatus;
import fr.ax_dev.universejobs.reward.gui.GuiConfig;
import fr.ax_dev.universejobs.reward.gui.ItemBuilder;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomRewardGui
implements InventoryHolder {
    private final UniverseJobs plugin;
    private final Player player;
    private final Job job;
    private final List<Reward> rewards;
    private final GuiConfig config;
    private final RewardManager rewardManager;
    private Inventory inventory;
    private int currentPage;
    private final int rewardsPerPage;

    public CustomRewardGui(UniverseJobs plugin, Player player, Job job, List<Reward> rewards, GuiConfig config, int page) {
        this.plugin = plugin;
        this.player = player;
        this.job = job;
        this.rewards = rewards;
        this.config = config;
        this.rewardManager = plugin.getRewardManager();
        this.currentPage = page;
        this.rewardsPerPage = config.getRewardSlots().size();
        this.createInventory();
        this.populateInventory();
    }

    private void createInventory() {
        String title = MessageUtils.colorize(this.config.getTitle().replace("{job}", this.job.getName()));
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.config.getSize(), (String)title);
    }

    private void populateInventory() {
        this.inventory.clear();
        this.addFillItems();
        this.addCustomItems();
        this.addNavigationItems();
        this.addRewardItems();
    }

    private void addFillItems() {
        block4: {
            Map<String, Object> fillConfig = this.config.getFillItems();
            if (!((Boolean)fillConfig.getOrDefault("enabled", false)).booleanValue()) break block4;
            String fillMaterialName = (String)fillConfig.getOrDefault("material", "GRAY_STAINED_GLASS_PANE");
            String fillName = (String)fillConfig.getOrDefault("name", " ");
            List fillSlots = fillConfig.getOrDefault("slots", new ArrayList());
            ItemStack fillItem = ItemBuilder.fromMaterialName(this.plugin, fillMaterialName).name(fillName).build();
            if (fillSlots.isEmpty()) {
                for (int i = 0; i < this.inventory.getSize(); ++i) {
                    if (this.inventory.getItem(i) != null) continue;
                    this.inventory.setItem(i, fillItem);
                }
            } else {
                Iterator iterator = fillSlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (slot < 0 || slot >= this.inventory.getSize()) continue;
                    this.inventory.setItem(slot, fillItem);
                }
            }
        }
    }

    private void addCustomItems() {
        for (GuiConfig.GuiItem guiItem : this.config.getItems().values()) {
            ItemStack item = this.createItemFromConfig(guiItem);
            for (int slot : guiItem.getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
    }

    private void addNavigationItems() {
        ItemStack item;
        GuiConfig.NavigationConfig nav = this.config.getNavigation();
        if (nav.getPreviousPage() != null && this.currentPage > 0) {
            item = this.createItemFromConfig(nav.getPreviousPage());
            for (int slot : nav.getPreviousPage().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
        if (nav.getNextPage() != null && this.hasNextPage()) {
            item = this.createItemFromConfig(nav.getNextPage());
            for (int slot : nav.getNextPage().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
        if (nav.getClose() != null) {
            item = this.createItemFromConfig(nav.getClose());
            for (int slot : nav.getClose().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
        if (nav.getRefresh() != null) {
            item = this.createItemFromConfig(nav.getRefresh());
            for (int slot : nav.getRefresh().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
        if (nav.getInfo() != null) {
            item = this.createItemFromConfig(nav.getInfo());
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                ArrayList<String> lore = new ArrayList<String>(meta.getLore() != null ? meta.getLore() : new ArrayList());
                lore.add("");
                lore.add(MessageUtils.colorize("&7Job: &e" + this.job.getName()));
                lore.add(MessageUtils.colorize("&7Total Rewards: &e" + this.rewards.size()));
                lore.add(MessageUtils.colorize("&7Page: &e" + (this.currentPage + 1) + "/" + this.getTotalPages()));
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            for (int slot : nav.getInfo().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
    }

    private void addRewardItems() {
        int rewardIndex;
        List<Integer> rewardSlots = this.config.getRewardSlots();
        int startIndex = this.currentPage * this.rewardsPerPage;
        for (int i = 0; i < this.rewardsPerPage && i < rewardSlots.size() && (rewardIndex = startIndex + i) < this.rewards.size(); ++i) {
            Reward reward = this.rewards.get(rewardIndex);
            ItemStack rewardItem = this.createRewardItem(reward);
            int slot = rewardSlots.get(i);
            if (slot < 0 || slot >= this.inventory.getSize()) continue;
            this.inventory.setItem(slot, rewardItem);
        }
    }

    private ItemStack createItemFromConfig(GuiConfig.GuiItem guiItem) {
        ItemBuilder builder = ItemBuilder.fromMaterialName(this.plugin, guiItem.getMaterialName()).amount(guiItem.getAmount());
        if (!guiItem.getDisplayName().isEmpty()) {
            builder.name(guiItem.getDisplayName());
        }
        if (!guiItem.getLore().isEmpty()) {
            builder.lore(guiItem.getLore());
        }
        if (guiItem.getCustomModelData() > 0) {
            builder.customModelData(guiItem.getCustomModelData());
        }
        ItemStack item = builder.build();
        for (Map.Entry<Enchantment, Integer> entry : guiItem.getEnchantments().entrySet()) {
            item.addUnsafeEnchantment(entry.getKey(), entry.getValue().intValue());
        }
        if (guiItem.isGlowing() && guiItem.getEnchantments().isEmpty()) {
            item.addUnsafeEnchantment(Enchantment.LURE, 1);
            ItemMeta glowMeta = item.getItemMeta();
            if (glowMeta != null) {
                glowMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                item.setItemMeta(glowMeta);
            }
        }
        return item;
    }

    private ItemStack createRewardItem(Reward reward) {
        RewardStatus status = this.rewardManager.getRewardStatus(this.player, reward);
        ItemBuilder builder = new ItemBuilder(this.plugin, Material.CHEST).name(MessageUtils.colorize(reward.getName()));
        String statusIndicator = status.getIndicator();
        builder.name(statusIndicator + " " + MessageUtils.colorize(reward.getName()));
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MessageUtils.colorize(reward.getDescription()));
        lore.add("");
        lore.add(MessageUtils.colorize("&7Required Level: &e" + reward.getRequiredLevel()));
        lore.add(MessageUtils.colorize("&7Status: " + status.getDescription()));
        if (reward.isRepeatable()) {
            lore.add(MessageUtils.colorize("&7Repeatable: &aYes"));
            if (reward.getCooldownHours() > 0L) {
                lore.add(MessageUtils.colorize("&7Cooldown: &e" + this.formatTimeHours(reward.getCooldownHours())));
            }
        } else {
            lore.add(MessageUtils.colorize("&7Repeatable: &cNo"));
        }
        if (status == RewardStatus.RETRIEVABLE) {
            lore.add("");
            lore.add(MessageUtils.colorize("&a\u25b6 Click to claim!"));
        }
        builder.lore(lore);
        Material material = switch (status) {
            default -> throw new MatchException(null, null);
            case RewardStatus.RETRIEVABLE -> Material.LIME_SHULKER_BOX;
            case RewardStatus.BLOCKED -> Material.RED_SHULKER_BOX;
            case RewardStatus.RETRIEVED -> Material.GRAY_SHULKER_BOX;
        };
        ItemStack finalItem = new ItemStack(material);
        ItemMeta finalMeta = finalItem.getItemMeta();
        if (finalMeta != null) {
            finalMeta.setDisplayName(statusIndicator + " " + MessageUtils.colorize(reward.getName()));
            finalMeta.setLore(lore);
            finalItem.setItemMeta(finalMeta);
        }
        return finalItem;
    }

    private String formatTimeHours(long hours) {
        if (hours < 24L) {
            return hours + "h";
        }
        if (hours < 168L) {
            return hours / 24L + "d";
        }
        return hours / 168L + "w";
    }

    private boolean hasNextPage() {
        return (this.currentPage + 1) * this.rewardsPerPage < this.rewards.size();
    }

    private int getTotalPages() {
        return (int)Math.ceil((double)this.rewards.size() / (double)this.rewardsPerPage);
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    public boolean isInventory(Inventory inventory) {
        return this.inventory.equals((Object)inventory);
    }

    public void handleClick(int slot) {
        int rewardIndex;
        List<Integer> rewardSlots = this.config.getRewardSlots();
        int rewardSlotIndex = rewardSlots.indexOf(slot);
        if (rewardSlotIndex != -1 && (rewardIndex = this.currentPage * this.rewardsPerPage + rewardSlotIndex) < this.rewards.size()) {
            Reward reward = this.rewards.get(rewardIndex);
            this.handleRewardClick(reward);
            return;
        }
        GuiConfig.NavigationConfig nav = this.config.getNavigation();
        if (nav.getPreviousPage() != null && nav.getPreviousPage().getSlots().contains(slot)) {
            if (this.currentPage > 0) {
                CustomRewardGui newGui = new CustomRewardGui(this.plugin, this.player, this.job, this.rewards, this.config, this.currentPage - 1);
                newGui.open();
            }
        } else if (nav.getNextPage() != null && nav.getNextPage().getSlots().contains(slot)) {
            if (this.hasNextPage()) {
                CustomRewardGui newGui = new CustomRewardGui(this.plugin, this.player, this.job, this.rewards, this.config, this.currentPage + 1);
                newGui.open();
            }
        } else if (nav.getClose() != null && nav.getClose().getSlots().contains(slot)) {
            this.player.closeInventory();
        } else if (nav.getRefresh() != null && nav.getRefresh().getSlots().contains(slot)) {
            this.populateInventory();
        }
    }

    private void handleRewardClick(Reward reward) {
        RewardStatus status = this.rewardManager.getRewardStatus(this.player, reward);
        if (status == RewardStatus.RETRIEVABLE) {
            if (this.rewardManager.claimReward(this.player, reward)) {
                MessageUtils.sendMessage(this.player, "&aReward claimed successfully!");
                this.populateInventory();
            } else {
                MessageUtils.sendMessage(this.player, "&cFailed to claim reward.");
            }
        } else if (status == RewardStatus.BLOCKED) {
            this.rewardManager.canClaimReward(this.player, reward, true);
        } else {
            MessageUtils.sendMessage(this.player, "&7You have already claimed this reward.");
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

