/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward.gui;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.reward.Reward;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private ItemStack item;
    private ItemMeta meta;

    public ItemBuilder(UniverseJobs plugin, Material material) {
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
    }

    public ItemBuilder(UniverseJobs plugin, ItemStack item) {
        this.item = item.clone();
        this.meta = this.item.getItemMeta();
    }

    public static ItemBuilder of(UniverseJobs plugin, String materialName) {
        Material material;
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Unknown material: " + materialName + ", using STONE");
            material = Material.STONE;
        }
        return new ItemBuilder(plugin, material);
    }

    public static ItemBuilder fromRewardItem(UniverseJobs plugin, Reward.RewardItem rewardItem) {
        ItemStack iaItem;
        ItemStack nexoItem;
        if (rewardItem.isNexoItem() && (nexoItem = ItemBuilder.createNexoItem(rewardItem.getNexoId())) != null) {
            ItemBuilder builder = new ItemBuilder(plugin, nexoItem);
            return builder.amount(rewardItem.getAmount());
        }
        if (rewardItem.isItemsAdderItem() && (iaItem = ItemBuilder.createItemsAdderItem(rewardItem.getItemsAdderId())) != null) {
            ItemBuilder builder = new ItemBuilder(plugin, iaItem);
            return builder.amount(rewardItem.getAmount());
        }
        ItemBuilder builder = ItemBuilder.of(plugin, rewardItem.getMaterial()).amount(rewardItem.getAmount());
        if (rewardItem.hasCustomModelData()) {
            builder.customModelData(rewardItem.getCustomModelData());
        }
        if (rewardItem.getDisplayName() != null) {
            builder.name(rewardItem.getDisplayName());
        }
        if (!rewardItem.getLore().isEmpty()) {
            builder.lore(rewardItem.getLore());
        }
        return builder;
    }

    public ItemBuilder name(String name) {
        if (this.meta != null && name != null) {
            this.meta.setDisplayName(MessageUtils.colorize(name));
        }
        return this;
    }

    public ItemBuilder lore(List<String> lore) {
        if (this.meta != null && lore != null) {
            ArrayList<String> colorizedLore = new ArrayList<String>();
            for (String line : lore) {
                colorizedLore.add(MessageUtils.colorize(line));
            }
            this.meta.setLore(colorizedLore);
        }
        return this;
    }

    public ItemBuilder addLore(String line) {
        if (this.meta != null && line != null) {
            ArrayList<String> lore = this.meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.add(MessageUtils.colorize(line));
            this.meta.setLore(lore);
        }
        return this;
    }

    public ItemBuilder amount(int amount) {
        if (amount > 0) {
            this.item.setAmount(Math.min(amount, this.item.getMaxStackSize()));
        }
        return this;
    }

    public ItemBuilder customModelData(int modelData) {
        if (this.meta != null && modelData > 0) {
            this.meta.setCustomModelData(Integer.valueOf(modelData));
        }
        return this;
    }

    public ItemBuilder flags(ItemFlag ... flags) {
        if (this.meta != null) {
            this.meta.addItemFlags(flags);
        }
        return this;
    }

    public ItemBuilder hideAttributes() {
        return this.flags(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_DESTROYS);
    }

    public ItemBuilder unbreakable(boolean unbreakable) {
        if (this.meta != null) {
            this.meta.setUnbreakable(unbreakable);
        }
        return this;
    }

    public ItemStack build() {
        if (this.meta != null) {
            this.item.setItemMeta(this.meta);
        }
        return this.item.clone();
    }

    private static ItemStack createNexoItem(String nexoId) {
        if (!Bukkit.getPluginManager().isPluginEnabled("Nexo")) {
            return null;
        }
        try {
            Class<?> nexoItemsClass = Class.forName("com.nexomc.nexo.api.NexoItems");
            Object itemBuilder = nexoItemsClass.getMethod("itemFromId", String.class).invoke(null, nexoId);
            if (itemBuilder != null) {
                return (ItemStack)itemBuilder.getClass().getMethod("build", new Class[0]).invoke(itemBuilder, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static ItemStack createItemsAdderItem(String itemsAdderId) {
        if (!Bukkit.getPluginManager().isPluginEnabled("ItemsAdder")) {
            return null;
        }
        try {
            Class<?> customStackClass = Class.forName("dev.lone.itemsadder.api.CustomStack");
            Object customStack = customStackClass.getMethod("getInstance", String.class).invoke(null, itemsAdderId);
            if (customStack != null) {
                return (ItemStack)customStack.getClass().getMethod("getItemStack", new Class[0]).invoke(customStack, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStack createNavigationItem(UniverseJobs plugin, Material material, String name, String ... lore) {
        ItemBuilder builder = new ItemBuilder(plugin, material).name(name).hideAttributes();
        for (String line : lore) {
            builder.addLore(line);
        }
        return builder.build();
    }

    public static ItemStack createFillerItem(UniverseJobs plugin) {
        return new ItemBuilder(plugin, Material.GRAY_STAINED_GLASS_PANE).name(" ").hideAttributes().build();
    }

    public static ItemBuilder fromMaterialName(UniverseJobs plugin, String materialName) {
        if (materialName.startsWith("nexo:")) {
            String nexoId = materialName.substring(5);
            ItemStack nexoItem = ItemBuilder.createNexoItem(nexoId);
            if (nexoItem != null) {
                return new ItemBuilder(plugin, nexoItem);
            }
            plugin.getLogger().warning("Nexo item not found: " + nexoId + ", falling back to STONE");
            return new ItemBuilder(plugin, Material.STONE);
        }
        if (materialName.startsWith("itemsadder:")) {
            String iaId = materialName.substring(11);
            ItemStack iaItem = ItemBuilder.createItemsAdderItem(iaId);
            if (iaItem != null) {
                return new ItemBuilder(plugin, iaItem);
            }
            plugin.getLogger().warning("ItemsAdder item not found: " + iaId + ", falling back to STONE");
            return new ItemBuilder(plugin, Material.STONE);
        }
        try {
            Material material = Material.valueOf((String)materialName.toUpperCase());
            return new ItemBuilder(plugin, material);
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Unknown material: " + materialName + ", using STONE");
            return new ItemBuilder(plugin, Material.STONE);
        }
    }
}

