/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward.gui;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.reward.Reward;
import fr.ax_dev.universejobs.reward.RewardManager;
import fr.ax_dev.universejobs.reward.RewardStatus;
import fr.ax_dev.universejobs.reward.gui.CustomRewardGui;
import fr.ax_dev.universejobs.reward.gui.GuiConfig;
import fr.ax_dev.universejobs.reward.gui.ItemBuilder;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RewardGuiManager
implements Listener {
    private final UniverseJobs plugin;
    private final RewardManager rewardManager;
    private final Map<UUID, Object> openGuis;

    public RewardGuiManager(UniverseJobs plugin, RewardManager rewardManager) {
        this.plugin = plugin;
        this.rewardManager = rewardManager;
        this.openGuis = new ConcurrentHashMap<UUID, Object>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openRewardsGui(Player player, String jobId) {
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job == null) {
            MessageUtils.sendMessage(player, "&cJob not found: " + jobId);
            return;
        }
        List<Reward> rewards = this.rewardManager.getJobRewards(jobId);
        if (rewards.isEmpty()) {
            MessageUtils.sendMessage(player, "&cNo rewards available for job: " + job.getName());
            return;
        }
        ArrayList<Reward> availableRewards = new ArrayList<Reward>();
        for (Reward reward : rewards) {
            if (reward.getPermission() != null && !player.hasPermission(reward.getPermission())) continue;
            availableRewards.add(reward);
        }
        if (availableRewards.isEmpty()) {
            MessageUtils.sendMessage(player, "&cNo rewards available for you in job: " + job.getName());
            return;
        }
        GuiConfig guiConfig = this.rewardManager.getGuiConfig(job.getId());
        if (guiConfig != null) {
            CustomRewardGui customGui = new CustomRewardGui(this.plugin, player, job, availableRewards, guiConfig, 0);
            this.openGuis.put(player.getUniqueId(), customGui);
            customGui.open();
        } else {
            RewardGui gui = new RewardGui(player, job, availableRewards, 0);
            this.openGuis.put(player.getUniqueId(), gui);
            gui.open();
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        RewardGui gui;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Object guiObj = this.openGuis.get(player.getUniqueId());
        if (guiObj == null) {
            return;
        }
        event.setCancelled(true);
        if (guiObj instanceof CustomRewardGui) {
            CustomRewardGui customGui = (CustomRewardGui)guiObj;
            if (customGui.isInventory(event.getInventory())) {
                customGui.handleClick(event.getSlot());
            }
        } else if (guiObj instanceof RewardGui && (gui = (RewardGui)guiObj).isInventory(event.getInventory())) {
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            gui.handleClick(event.getSlot(), clickedItem);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Object guiObj = this.openGuis.get(player.getUniqueId());
        if (guiObj != null) {
            boolean shouldRemove = false;
            if (guiObj instanceof CustomRewardGui) {
                CustomRewardGui customGui = (CustomRewardGui)guiObj;
                shouldRemove = customGui.isInventory(event.getInventory());
            } else if (guiObj instanceof RewardGui) {
                RewardGui gui = (RewardGui)guiObj;
                shouldRemove = gui.isInventory(event.getInventory());
            }
            if (shouldRemove) {
                this.openGuis.remove(player.getUniqueId());
            }
        }
    }

    public void closeAllGuis() {
        for (Object guiObj : this.openGuis.values()) {
            if (guiObj instanceof RewardGui) {
                RewardGui gui = (RewardGui)guiObj;
                gui.close();
                continue;
            }
            if (!(guiObj instanceof CustomRewardGui)) continue;
            CustomRewardGui customRewardGui = (CustomRewardGui)guiObj;
        }
        this.openGuis.clear();
    }

    private String formatTime(long timeMs) {
        long seconds = timeMs / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d " + hours % 24L + "h";
        }
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m " + seconds % 60L + "s";
        }
        return seconds + "s";
    }

    private class RewardGui
    implements InventoryHolder {
        private final Player player;
        private final Job job;
        private final List<Reward> rewards;
        private final int page;
        private final Inventory inventory;
        private static final int REWARDS_PER_PAGE = 45;
        private static final int GUI_SIZE = 54;

        public RewardGui(Player player, Job job, List<Reward> rewards, int page) {
            this.player = player;
            this.job = job;
            this.rewards = rewards;
            this.page = page;
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)MessageUtils.colorize("&6" + job.getName() + " Rewards"));
            this.setupGui();
        }

        private void setupGui() {
            this.inventory.clear();
            int startIndex = this.page * 45;
            int endIndex = Math.min(startIndex + 45, this.rewards.size());
            for (int i = startIndex; i < endIndex; ++i) {
                Reward reward = this.rewards.get(i);
                int slot = reward.getGuiSlot();
                if (slot == -1 || slot >= 45 || this.inventory.getItem(slot) != null) {
                    slot = i - startIndex;
                }
                if (slot >= 45) continue;
                ItemStack rewardItem = this.createRewardItem(reward);
                this.inventory.setItem(slot, rewardItem);
            }
            this.setupNavigationItems();
            this.fillEmptySlots();
        }

        private ItemStack createRewardItem(Reward reward) {
            long lastClaim;
            long nextClaim;
            long timeLeft;
            ItemStack item;
            RewardStatus status = RewardGuiManager.this.rewardManager.getRewardStatus(this.player, reward);
            if (!reward.getItems().isEmpty()) {
                Reward.RewardItem firstItem = reward.getItems().get(0);
                item = ItemBuilder.fromRewardItem(RewardGuiManager.this.plugin, firstItem).build();
            } else {
                item = new ItemStack(Material.CHEST);
            }
            ItemBuilder builder = new ItemBuilder(RewardGuiManager.this.plugin, item).name("&e" + reward.getName()).addLore("").addLore("&7" + reward.getDescription());
            if (reward.getRequiredLevel() > 1) {
                int playerLevel = RewardGuiManager.this.plugin.getJobManager().getLevel(this.player, reward.getJobId());
                String levelColor = playerLevel >= reward.getRequiredLevel() ? "&a" : "&c";
                builder.addLore("&7Required Level: " + levelColor + reward.getRequiredLevel());
            }
            if (reward.getCooldownHours() > 0L && status == RewardStatus.RETRIEVED && (timeLeft = (nextClaim = (lastClaim = RewardGuiManager.this.rewardManager.getLastClaimTime(this.player, reward)) + reward.getCooldownHours() * 3600000L) - System.currentTimeMillis()) > 0L) {
                String timeString = RewardGuiManager.this.formatTime(timeLeft);
                builder.addLore("&7Cooldown: &c" + timeString);
            }
            if (!reward.getItems().isEmpty()) {
                builder.addLore("").addLore("&6Rewards:");
                int itemsShown = 0;
                for (Reward.RewardItem rewardItem : reward.getItems()) {
                    if (itemsShown >= 3) {
                        builder.addLore("&7... and " + (reward.getItems().size() - 3) + " more");
                        break;
                    }
                    String itemName = rewardItem.getDisplayName() != null ? rewardItem.getDisplayName() : rewardItem.getMaterial();
                    builder.addLore("&8- &f" + rewardItem.getAmount() + "x " + itemName);
                    ++itemsShown;
                }
            }
            if (reward.hasEconomyReward()) {
                builder.addLore("&8- &f$" + reward.getEconomyReward());
            }
            if (reward.hasCommands()) {
                builder.addLore("&8- &fSpecial rewards");
            }
            builder.addLore("").addLore("&7Status: " + status.getIndicator() + " " + status.getDescription());
            return builder.build();
        }

        private void setupNavigationItems() {
            int totalPages = (int)Math.ceil((double)this.rewards.size() / 45.0);
            if (this.page > 0) {
                ItemStack prevItem = ItemBuilder.createNavigationItem(RewardGuiManager.this.plugin, Material.ARROW, "&ePrevious Page", "&7Click to go to page " + this.page);
                this.inventory.setItem(45, prevItem);
            }
            ItemStack pageInfo = ItemBuilder.createNavigationItem(RewardGuiManager.this.plugin, Material.BOOK, "&6Page " + (this.page + 1) + " of " + totalPages, "&7Showing rewards for " + this.job.getName());
            this.inventory.setItem(49, pageInfo);
            if (this.page < totalPages - 1) {
                ItemStack nextItem = ItemBuilder.createNavigationItem(RewardGuiManager.this.plugin, Material.ARROW, "&eNext Page", "&7Click to go to page " + (this.page + 2));
                this.inventory.setItem(53, nextItem);
            }
            ItemStack closeItem = ItemBuilder.createNavigationItem(RewardGuiManager.this.plugin, Material.BARRIER, "&cClose", "&7Click to close this menu");
            this.inventory.setItem(48, closeItem);
            ItemStack refreshItem = ItemBuilder.createNavigationItem(RewardGuiManager.this.plugin, Material.EMERALD, "&aRefresh", "&7Click to refresh rewards");
            this.inventory.setItem(50, refreshItem);
        }

        private void fillEmptySlots() {
            ItemStack filler = ItemBuilder.createFillerItem(RewardGuiManager.this.plugin);
            for (int i = 46; i <= 52; ++i) {
                if (this.inventory.getItem(i) != null) continue;
                this.inventory.setItem(i, filler);
            }
        }

        public void handleClick(int slot, ItemStack item) {
            if (slot >= 45) {
                this.handleNavigationClick(slot);
                return;
            }
            Reward clickedReward = this.getRewardAtSlot(slot);
            if (clickedReward != null) {
                this.handleRewardClick(clickedReward);
            }
        }

        private void handleNavigationClick(int slot) {
            switch (slot) {
                case 45: {
                    if (this.page <= 0) break;
                    RewardGui newGui = new RewardGui(this.player, this.job, this.rewards, this.page - 1);
                    RewardGuiManager.this.openGuis.put(this.player.getUniqueId(), newGui);
                    newGui.open();
                    break;
                }
                case 48: {
                    this.player.closeInventory();
                    break;
                }
                case 50: {
                    this.setupGui();
                    break;
                }
                case 53: {
                    int totalPages = (int)Math.ceil((double)this.rewards.size() / 45.0);
                    if (this.page >= totalPages - 1) break;
                    RewardGui newGui = new RewardGui(this.player, this.job, this.rewards, this.page + 1);
                    RewardGuiManager.this.openGuis.put(this.player.getUniqueId(), newGui);
                    newGui.open();
                }
            }
        }

        private void handleRewardClick(Reward reward) {
            RewardStatus status = RewardGuiManager.this.rewardManager.getRewardStatus(this.player, reward);
            if (status == RewardStatus.RETRIEVABLE) {
                if (RewardGuiManager.this.rewardManager.claimReward(this.player, reward)) {
                    MessageUtils.sendMessage(this.player, "&aSuccessfully claimed reward: " + reward.getName());
                    this.setupGui();
                } else {
                    MessageUtils.sendMessage(this.player, "&cFailed to claim reward: " + reward.getName());
                }
            } else if (status == RewardStatus.BLOCKED) {
                MessageUtils.sendMessage(this.player, "&cYou don't meet the requirements for this reward yet.");
            } else if (status == RewardStatus.RETRIEVED) {
                if (reward.isRepeatable() && reward.getCooldownHours() > 0L) {
                    long lastClaim = RewardGuiManager.this.rewardManager.getLastClaimTime(this.player, reward);
                    long nextClaim = lastClaim + reward.getCooldownHours() * 3600000L;
                    long timeLeft = nextClaim - System.currentTimeMillis();
                    if (timeLeft > 0L) {
                        String timeString = RewardGuiManager.this.formatTime(timeLeft);
                        MessageUtils.sendMessage(this.player, "&cYou can claim this reward again in: " + timeString);
                    }
                } else {
                    MessageUtils.sendMessage(this.player, "&cYou have already claimed this reward.");
                }
            }
        }

        private Reward getRewardAtSlot(int slot) {
            int startIndex = this.page * 45;
            for (int i = 0; i < Math.min(45, this.rewards.size() - startIndex); ++i) {
                Reward reward = this.rewards.get(startIndex + i);
                int rewardSlot = reward.getGuiSlot();
                if (rewardSlot == -1) {
                    rewardSlot = i;
                }
                if (rewardSlot != slot) continue;
                return reward;
            }
            return null;
        }

        public void open() {
            this.player.openInventory(this.inventory);
        }

        public void close() {
            this.player.closeInventory();
        }

        public boolean isInventory(Inventory inv) {
            return this.inventory.equals((Object)inv);
        }

        public Inventory getInventory() {
            return this.inventory;
        }
    }
}

