/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward.storage;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.reward.storage.RewardStorage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileRewardStorage
implements RewardStorage {
    private final UniverseJobs plugin;
    private final File dataFolder;
    private final Map<UUID, Map<String, Map<String, Long>>> playerRewards;
    private final Set<UUID> dirtyPlayers;

    public FileRewardStorage(UniverseJobs plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "reward-data");
        this.playerRewards = new ConcurrentHashMap<UUID, Map<String, Map<String, Long>>>();
        this.dirtyPlayers = ConcurrentHashMap.newKeySet();
    }

    @Override
    public void initialize() {
        if (!this.dataFolder.exists() && !this.dataFolder.mkdirs()) {
            this.plugin.getLogger().severe("Failed to create reward data folder: " + this.dataFolder.getPath());
        }
    }

    @Override
    public void shutdown() {
        this.save();
        this.playerRewards.clear();
        this.dirtyPlayers.clear();
        this.plugin.getLogger().info("File-based reward storage shutdown complete");
    }

    @Override
    public boolean hasClaimedReward(UUID playerId, String jobId, String rewardId) {
        Map<String, Map<String, Long>> jobRewards = this.playerRewards.get(playerId);
        if (jobRewards == null) {
            return false;
        }
        Map<String, Long> rewards = jobRewards.get(jobId);
        if (rewards == null) {
            return false;
        }
        return rewards.containsKey(rewardId);
    }

    @Override
    public void claimReward(UUID playerId, String jobId, String rewardId, long claimTime) {
        this.playerRewards.computeIfAbsent(playerId, k -> new ConcurrentHashMap()).computeIfAbsent(jobId, k -> new ConcurrentHashMap()).put(rewardId, claimTime);
        this.dirtyPlayers.add(playerId);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info(String.format("Player %s claimed reward %s:%s", playerId, jobId, rewardId));
        }
    }

    @Override
    public long getClaimTime(UUID playerId, String jobId, String rewardId) {
        Map<String, Map<String, Long>> jobRewards = this.playerRewards.get(playerId);
        if (jobRewards == null) {
            return -1L;
        }
        Map<String, Long> rewards = jobRewards.get(jobId);
        if (rewards == null) {
            return -1L;
        }
        return rewards.getOrDefault(rewardId, -1L);
    }

    @Override
    public Set<String> getClaimedRewards(UUID playerId, String jobId) {
        Map<String, Map<String, Long>> jobRewards = this.playerRewards.get(playerId);
        if (jobRewards == null) {
            return new HashSet<String>();
        }
        Map<String, Long> rewards = jobRewards.get(jobId);
        if (rewards == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(rewards.keySet());
    }

    @Override
    public Set<String> getAllClaimedRewards(UUID playerId) {
        HashSet<String> allRewards = new HashSet<String>();
        Map<String, Map<String, Long>> jobRewards = this.playerRewards.get(playerId);
        if (jobRewards != null) {
            for (Map.Entry<String, Map<String, Long>> jobEntry : jobRewards.entrySet()) {
                String jobId = jobEntry.getKey();
                for (String rewardId : jobEntry.getValue().keySet()) {
                    allRewards.add(jobId + ":" + rewardId);
                }
            }
        }
        return allRewards;
    }

    @Override
    public void resetRewardClaim(UUID playerId, String jobId, String rewardId) {
        Map<String, Map<String, Long>> jobRewards = this.playerRewards.get(playerId);
        if (jobRewards == null) {
            return;
        }
        Map<String, Long> rewards = jobRewards.get(jobId);
        if (rewards == null) {
            return;
        }
        if (rewards.remove(rewardId) != null) {
            this.dirtyPlayers.add(playerId);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info(String.format("Reset reward claim %s:%s for player %s", jobId, rewardId, playerId));
            }
        }
    }

    @Override
    public void resetJobRewards(UUID playerId, String jobId) {
        Map<String, Map<String, Long>> jobRewards = this.playerRewards.get(playerId);
        if (jobRewards == null) {
            return;
        }
        if (jobRewards.remove(jobId) != null) {
            this.dirtyPlayers.add(playerId);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info(String.format("Reset all rewards for job %s for player %s", jobId, playerId));
            }
        }
    }

    @Override
    public void resetAllRewards(UUID playerId) {
        if (this.playerRewards.remove(playerId) != null) {
            this.dirtyPlayers.add(playerId);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info(String.format("Reset all rewards for player %s", playerId));
            }
        }
    }

    @Override
    public void save() {
        if (this.dirtyPlayers.isEmpty()) {
            return;
        }
        HashSet<UUID> toSave = new HashSet<UUID>(this.dirtyPlayers);
        this.dirtyPlayers.clear();
        for (UUID playerId : toSave) {
            this.savePlayerData(playerId);
        }
    }

    @Override
    public void loadPlayerData(UUID playerId) {
        if (this.playerRewards.containsKey(playerId)) {
            return;
        }
        File playerFile = new File(this.dataFolder, playerId.toString() + ".yml");
        if (!playerFile.exists()) {
            this.playerRewards.put(playerId, new ConcurrentHashMap());
            return;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
            ConcurrentHashMap jobRewards = new ConcurrentHashMap();
            for (String jobId : config.getKeys(false)) {
                if (!config.isConfigurationSection(jobId)) continue;
                ConcurrentHashMap<String, Long> rewards = new ConcurrentHashMap<String, Long>();
                for (String rewardId : config.getConfigurationSection(jobId).getKeys(false)) {
                    long claimTime = config.getLong(jobId + "." + rewardId, System.currentTimeMillis());
                    rewards.put(rewardId, claimTime);
                }
                jobRewards.put(jobId, rewards);
            }
            this.playerRewards.put(playerId, jobRewards);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Loaded reward data for player: " + String.valueOf(playerId));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load reward data for player " + String.valueOf(playerId), e);
            this.playerRewards.put(playerId, new ConcurrentHashMap());
        }
    }

    @Override
    public void unloadPlayerData(UUID playerId) {
        if (this.dirtyPlayers.contains(playerId)) {
            this.savePlayerData(playerId);
            this.dirtyPlayers.remove(playerId);
        }
        this.playerRewards.remove(playerId);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Unloaded reward data for player: " + String.valueOf(playerId));
        }
    }

    private void savePlayerData(UUID playerId) {
        Map<String, Map<String, Long>> jobRewards = this.playerRewards.get(playerId);
        if (jobRewards == null || jobRewards.isEmpty()) {
            File playerFile = new File(this.dataFolder, playerId.toString() + ".yml");
            if (playerFile.exists() && playerFile.delete() && this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Deleted empty reward file for player: " + String.valueOf(playerId));
            }
            return;
        }
        File playerFile = new File(this.dataFolder, playerId.toString() + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<String, Map<String, Long>> jobEntry : jobRewards.entrySet()) {
            String jobId = jobEntry.getKey();
            Map<String, Long> rewards = jobEntry.getValue();
            for (Map.Entry<String, Long> rewardEntry : rewards.entrySet()) {
                String rewardId = rewardEntry.getKey();
                long claimTime = rewardEntry.getValue();
                config.set(jobId + "." + rewardId, (Object)claimTime);
            }
        }
        try {
            config.save(playerFile);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Saved reward data for player: " + String.valueOf(playerId));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save reward data for player " + String.valueOf(playerId), e);
        }
    }
}

