/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.compatibility.FoliaCompatibilityManager;
import fr.ax_dev.universejobs.config.MessageConfig;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.job.XpMessageSettings;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class XpMessageSender {
    private final UniverseJobs plugin;
    private final FoliaCompatibilityManager foliaManager;
    private final Map<UUID, BossBar> activeBossBars = new ConcurrentHashMap<UUID, BossBar>();
    private final Map<UUID, Runnable> activeActionBarCleanups = new ConcurrentHashMap<UUID, Runnable>();
    private final Map<UUID, Runnable> activeBossBarCleanups = new ConcurrentHashMap<UUID, Runnable>();
    private final Map<UUID, BukkitRunnable> activeBossBarTasks = new ConcurrentHashMap<UUID, BukkitRunnable>();

    public XpMessageSender(UniverseJobs plugin) {
        this.plugin = plugin;
        this.foliaManager = plugin.getFoliaManager();
    }

    public void sendXpMessage(Player player, Job job, double xp, PlayerJobData playerData) {
        this.sendXpMessage(player, job, xp, 0.0, playerData);
    }

    public void sendXpMessage(Player player, Job job, double xp, double money, PlayerJobData playerData) {
        if (!this.plugin.getConfig().getBoolean("messages.show-xp-gain", true)) {
            return;
        }
        XpMessageSettings settings = job.getXpMessageSettings();
        int currentLevel = this.plugin.getJobManager().getLevel(player, job.getId());
        double[] progress = playerData.getXpProgress(job.getId());
        double currentXpInLevel = progress[0];
        double xpNeededForNext = progress[1];
        double progressPercent = xpNeededForNext > 0.0 ? currentXpInLevel / xpNeededForNext * 100.0 : 100.0;
        String message = settings.processMessage(xp, money).replace("{job}", job.getName()).replace("{level}", String.valueOf(currentLevel)).replace("{progress}", String.format("%.1f", progressPercent)).replace("{current_xp}", String.format("%.1f", currentXpInLevel)).replace("{needed_xp}", String.format("%.1f", xpNeededForNext)).replace("{player}", player.getName());
        message = this.processPlaceholderAPI(player, message);
        switch (settings.getMessageType()) {
            case CHAT: {
                this.sendChatMessage(player, message);
                break;
            }
            case ACTIONBAR: {
                this.sendActionBarMessage(player, message, settings.getActionbarDuration());
                break;
            }
            case BOSSBAR: {
                this.sendBossBarMessage(player, message, settings, job, playerData);
                break;
            }
            default: {
                this.sendActionBarMessage(player, message, settings.getActionbarDuration());
            }
        }
    }

    private void sendChatMessage(Player player, String message) {
        MessageUtils.sendMessage(player, message);
    }

    private void sendActionBarMessage(Player player, String message, int durationTicks) {
        try {
            UUID playerId = player.getUniqueId();
            Runnable existingCleanup = this.activeActionBarCleanups.remove(playerId);
            if (existingCleanup != null) {
                // empty if block
            }
            this.foliaManager.runAtEntity((Entity)player, () -> {
                if (player.isOnline()) {
                    player.sendActionBar(MessageUtils.parseMessage(message));
                }
            });
            Runnable clearTask = () -> {
                if (player.isOnline()) {
                    player.sendActionBar(MessageUtils.parseMessage(""));
                }
                this.activeActionBarCleanups.remove(playerId);
            };
            this.activeActionBarCleanups.put(playerId, clearTask);
            this.foliaManager.runLater(() -> this.foliaManager.runAtEntity((Entity)player, clearTask), durationTicks);
        }
        catch (Exception e) {
            this.sendChatMessage(player, message);
        }
    }

    private void sendBossBarMessage(Player player, String message, XpMessageSettings settings, Job job, PlayerJobData playerData) {
        try {
            UUID playerId = player.getUniqueId();
            BossBar existingBar = this.activeBossBars.get(playerId);
            if (existingBar != null) {
                existingBar.setTitle(MessageUtils.stripFormatting(message));
                double progress = 1.0;
                if (settings.shouldShowProgress() && playerData != null) {
                    progress = this.calculateXpProgress(job.getId(), playerData);
                }
                existingBar.setProgress(progress);
                this.activeBossBarCleanups.remove(playerId);
                Runnable removalTask = () -> {
                    BossBar currentBar = this.activeBossBars.get(playerId);
                    if (currentBar != null && currentBar.equals((Object)existingBar) && player.isOnline()) {
                        currentBar.removePlayer(player);
                        this.activeBossBars.remove(playerId);
                        this.activeBossBarCleanups.remove(playerId);
                    }
                };
                this.activeBossBarCleanups.put(playerId, removalTask);
                this.foliaManager.runLater(() -> this.foliaManager.runAtEntity((Entity)player, removalTask), settings.getBossbarDuration());
            } else {
                BarColor color = settings.toBukkitBarColor();
                BarStyle style = settings.toBukkitBarStyle();
                BossBar bossBar = Bukkit.createBossBar((String)MessageUtils.stripFormatting(message), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
                bossBar.addPlayer(player);
                double progress = 1.0;
                if (settings.shouldShowProgress() && playerData != null) {
                    progress = this.calculateXpProgress(job.getId(), playerData);
                }
                bossBar.setProgress(progress);
                this.activeBossBars.put(playerId, bossBar);
                Runnable removalTask = () -> {
                    BossBar currentBar = this.activeBossBars.get(playerId);
                    if (currentBar != null && currentBar.equals((Object)bossBar) && player.isOnline()) {
                        currentBar.removePlayer(player);
                        this.activeBossBars.remove(playerId);
                        this.activeBossBarCleanups.remove(playerId);
                    }
                };
                this.activeBossBarCleanups.put(playerId, removalTask);
                this.foliaManager.runLater(() -> this.foliaManager.runAtEntity((Entity)player, removalTask), settings.getBossbarDuration());
            }
        }
        catch (Exception e) {
            this.sendActionBarMessage(player, message, settings.getActionbarDuration());
        }
    }

    public void cleanupPlayer(Player player) {
        UUID playerId = player.getUniqueId();
        BossBar bossBar = this.activeBossBars.remove(playerId);
        if (bossBar != null) {
            bossBar.removePlayer(player);
        }
        this.activeBossBarCleanups.remove(playerId);
        this.activeActionBarCleanups.remove(playerId);
    }

    public void cleanup() {
        for (BossBar bossBar : this.activeBossBars.values()) {
            bossBar.removeAll();
        }
        this.activeBossBars.clear();
        this.activeBossBarCleanups.clear();
        this.activeActionBarCleanups.clear();
    }

    private double calculateXpProgress(String jobId, PlayerJobData playerData) {
        try {
            double[] progress = playerData.getXpProgress(jobId);
            double currentXpInLevel = progress[0];
            double xpNeededForNext = progress[1];
            if (xpNeededForNext <= 0.0) {
                if (this.plugin.getConfigManager().isDebugEnabled()) {
                    this.plugin.getLogger().info("Player at max level for job " + jobId + " - showing full bar");
                }
                return 1.0;
            }
            currentXpInLevel = Math.max(0.0, currentXpInLevel);
            double progressRatio = currentXpInLevel / xpNeededForNext;
            double clampedProgress = Math.max(0.0, Math.min(1.0, progressRatio));
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                int currentLevel = playerData.getLevel(jobId);
                this.plugin.getLogger().info(String.format("Job %s - Level %d: %.1f/%.1f XP (%.1f%% progress)", jobId, currentLevel, currentXpInLevel, xpNeededForNext, clampedProgress * 100.0));
            }
            return clampedProgress;
        }
        catch (Exception e) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().warning("Failed to calculate XP progress for job " + jobId + ": " + e.getMessage());
            }
            return 1.0;
        }
    }

    public void sendActionMessage(Player player, String message, MessageConfig messageConfig) {
        String processedMessage = this.processPlaceholderAPI(player, message);
        switch (messageConfig.getType()) {
            case CHAT: {
                this.sendChatMessage(player, processedMessage);
                break;
            }
            case ACTIONBAR: {
                this.sendActionBarMessage(player, processedMessage, messageConfig.getDuration());
                break;
            }
            case BOSSBAR: {
                this.sendCustomBossBarMessage(player, processedMessage, messageConfig);
                break;
            }
            default: {
                this.sendActionBarMessage(player, processedMessage, messageConfig.getDuration());
            }
        }
    }

    private void sendCustomBossBarMessage(final Player player, String message, MessageConfig messageConfig) {
        try {
            final UUID playerId = player.getUniqueId();
            final BossBar existingBar = this.activeBossBars.get(playerId);
            if (existingBar != null) {
                existingBar.setTitle(MessageUtils.stripFormatting(message));
                existingBar.setColor(messageConfig.getBossbarColor());
                existingBar.setStyle(messageConfig.getBossbarStyle());
                existingBar.setProgress(1.0);
                BukkitRunnable existingTask = this.activeBossBarTasks.get(playerId);
                if (existingTask != null) {
                    existingTask.cancel();
                }
                BukkitRunnable newTask = new BukkitRunnable(){

                    public void run() {
                        BossBar currentBar = XpMessageSender.this.activeBossBars.get(playerId);
                        if (currentBar != null && currentBar.equals((Object)existingBar)) {
                            currentBar.removePlayer(player);
                            XpMessageSender.this.activeBossBars.remove(playerId);
                            XpMessageSender.this.activeBossBarTasks.remove(playerId);
                        }
                    }
                };
                newTask.runTaskLater((Plugin)this.plugin, (long)messageConfig.getDuration());
                this.activeBossBarTasks.put(playerId, newTask);
            } else {
                final BossBar newBar = Bukkit.createBossBar((String)MessageUtils.stripFormatting(message), (BarColor)messageConfig.getBossbarColor(), (BarStyle)messageConfig.getBossbarStyle(), (BarFlag[])new BarFlag[0]);
                newBar.setProgress(1.0);
                newBar.addPlayer(player);
                this.activeBossBars.put(playerId, newBar);
                BukkitRunnable removalTask = new BukkitRunnable(){

                    public void run() {
                        BossBar currentBar = XpMessageSender.this.activeBossBars.get(playerId);
                        if (currentBar != null && currentBar.equals((Object)newBar)) {
                            currentBar.removePlayer(player);
                            XpMessageSender.this.activeBossBars.remove(playerId);
                            XpMessageSender.this.activeBossBarTasks.remove(playerId);
                        }
                    }
                };
                removalTask.runTaskLater((Plugin)this.plugin, (long)messageConfig.getDuration());
                this.activeBossBarTasks.put(playerId, removalTask);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to send custom bossbar message: " + e.getMessage());
            this.sendChatMessage(player, message);
        }
    }

    private String processPlaceholderAPI(Player player, String message) {
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return message;
        }
        try {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        catch (Exception e) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().warning("Failed to process PlaceholderAPI placeholders: " + e.getMessage());
            }
            return message;
        }
    }
}

