/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.action;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionLimitManager;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.action.JobAction;
import fr.ax_dev.universejobs.bonus.MoneyBonusManager;
import fr.ax_dev.universejobs.bonus.XpBonusManager;
import fr.ax_dev.universejobs.cache.ConfigurationCache;
import fr.ax_dev.universejobs.cache.PlayerJobCache;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionResult;
import fr.ax_dev.universejobs.config.MessageConfig;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.utils.AsyncXpMessageSender;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.List;
import java.util.Set;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ActionProcessor {
    private static final String MATCHES_SUFFIX = ", matches: ";
    private final UniverseJobs plugin;
    private final JobManager jobManager;
    private final XpBonusManager bonusManager;
    private final MoneyBonusManager moneyBonusManager;
    private final AsyncXpMessageSender messageSender;
    private final ActionLimitManager limitManager;
    private final ConfigurationCache configCache;
    private final PlayerJobCache playerCache;

    public ActionProcessor(UniverseJobs plugin, JobManager jobManager, XpBonusManager bonusManager, MoneyBonusManager moneyBonusManager, AsyncXpMessageSender messageSender, ActionLimitManager limitManager, ConfigurationCache configCache, PlayerJobCache playerCache) {
        this.plugin = plugin;
        this.jobManager = jobManager;
        this.bonusManager = bonusManager;
        this.moneyBonusManager = moneyBonusManager;
        this.messageSender = messageSender;
        this.limitManager = limitManager;
        this.configCache = configCache;
        this.playerCache = playerCache;
    }

    public boolean processAction(Player player, ActionType actionType, Event event, ConditionContext context) {
        Set<String> playerJobs;
        if (this.configCache.isDebugEnabled()) {
            this.plugin.getLogger().info("Processing action " + String.valueOf((Object)actionType) + " for player " + player.getName());
        }
        if ((playerJobs = this.playerCache.getPlayerJobs(player.getUniqueId())).isEmpty()) {
            if (this.configCache.isDebugEnabled()) {
                this.plugin.getLogger().info("DEBUG: Player " + player.getName() + " has no jobs! Available jobs in cache: " + String.valueOf(this.playerCache.getStats().getOrDefault("cached_players", "0")));
            }
            return false;
        }
        if (this.configCache.isDebugEnabled()) {
            this.plugin.getLogger().info("DEBUG: Player " + player.getName() + " has jobs: " + String.valueOf(playerJobs));
        }
        return this.processJobsAsync(player, playerJobs, actionType, event, context);
    }

    private boolean processJobsAsync(Player player, Set<String> playerJobs, ActionType actionType, Event event, ConditionContext context) {
        boolean shouldCancel = false;
        if (!this.configCache.isDebugEnabled()) {
            for (String jobId : playerJobs) {
                if (!this.processPlayerJobFast(player, jobId, actionType, event, context)) continue;
                shouldCancel = true;
            }
        } else {
            for (String jobId : playerJobs) {
                if (!this.processPlayerJob(player, jobId, actionType, event, context)) continue;
                shouldCancel = true;
            }
        }
        return shouldCancel;
    }

    private boolean processPlayerJob(Player player, String jobId, ActionType actionType, Event event, ConditionContext context) {
        Job job = this.jobManager.getJob(jobId);
        if (!this.isJobValid(job, jobId)) {
            return false;
        }
        List<JobAction> actions = job.getActions(actionType);
        this.debugLog("Job " + jobId + " has " + actions.size() + " actions for type " + String.valueOf((Object)actionType));
        boolean shouldCancel = false;
        for (JobAction action : actions) {
            if (!this.processJobAction(player, job, action, event, context)) continue;
            shouldCancel = true;
        }
        return shouldCancel;
    }

    private boolean isJobValid(Job job, String jobId) {
        if (job == null || !job.isEnabled()) {
            this.debugLog("Job " + jobId + " is null or disabled");
            return false;
        }
        return true;
    }

    private void debugLog(String message) {
        if (this.configCache.isDebugEnabled()) {
            this.plugin.getLogger().info(message);
        }
    }

    private boolean processJobAction(Player player, Job job, JobAction action, Event event, ConditionContext context) {
        if (!this.validateActionTarget(action, context, job)) {
            return false;
        }
        if (!this.validateInteractType(action, context, job)) {
            return false;
        }
        if (!this.validateProfession(action, context, job)) {
            return false;
        }
        if (!this.validateColor(action, context, job)) {
            return false;
        }
        if (!this.validateNbt(action, context, job)) {
            return false;
        }
        if (!this.validatePotionType(action, context, job)) {
            return false;
        }
        if (!this.validateEnchantLevel(action, context, job)) {
            return false;
        }
        ActionType actionType = job.getActionTypeForAction(action);
        if (!this.validateFurnaceType(action, context, actionType)) {
            return false;
        }
        boolean shouldCancel = false;
        boolean conditionMet = true;
        if (action.hasRequirements()) {
            ConditionResult result = action.getRequirements().evaluate(player, event, context);
            conditionMet = result.isAllowed();
            shouldCancel = result.shouldCancelEvent();
            result.execute(player);
        }
        if (conditionMet) {
            this.processActionRewardsFast(player, job, action, context);
            this.executeActionEffects(player, action);
        }
        return shouldCancel;
    }

    private boolean processPlayerJobFast(Player player, String jobId, ActionType actionType, Event event, ConditionContext context) {
        Job job = this.jobManager.getJob(jobId);
        if (job == null || !job.isEnabled()) {
            if (this.configCache.isDebugEnabled()) {
                this.plugin.getLogger().info("DEBUG: Job " + jobId + " is null or disabled");
            }
            return false;
        }
        List<JobAction> actionsList = job.getActions(actionType);
        if (actionsList.isEmpty()) {
            if (this.configCache.isDebugEnabled()) {
                this.plugin.getLogger().info("DEBUG: No actions found for " + String.valueOf((Object)actionType));
            }
            return false;
        }
        if (this.configCache.isDebugEnabled()) {
            this.plugin.getLogger().info("DEBUG: Found " + actionsList.size() + " actions for " + String.valueOf((Object)actionType) + " with target " + context.getTarget());
        }
        boolean shouldCancel = false;
        for (JobAction action : actionsList) {
            if (!this.validateActionTargetFast(action, context) || !this.validateInteractTypeFast(action, context, job) || !this.validateProfessionFast(action, context) || !this.validateColorFast(action, context) || !this.validateNbtFast(action, context) || !this.validatePotionTypeFast(action, context) || !this.validateEnchantLevelFast(action, context, job) || !this.validateFurnaceTypeFast(action, context, actionType)) continue;
            if (this.configCache.isDebugEnabled()) {
                this.plugin.getLogger().info("DEBUG: Processing action for " + action.getTarget() + " with " + action.getXp() + " XP");
            }
            boolean conditionMet = true;
            if (action.hasRequirements()) {
                ConditionResult result = action.getRequirements().evaluate(player, event, context);
                conditionMet = result.isAllowed();
                if (result.shouldCancelEvent()) {
                    shouldCancel = true;
                }
                result.execute(player);
            }
            if (!conditionMet) continue;
            this.processActionRewardsFast(player, job, action, context);
        }
        return shouldCancel;
    }

    private boolean validateActionTargetFast(JobAction action, ConditionContext context) {
        return this.configCache.isValidTarget(action.getTarget(), context.getTarget());
    }

    private boolean validateInteractTypeFast(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.BLOCK_INTERACT && actionType != ActionType.ENTITY_INTERACT) {
            return true;
        }
        String eventInteractType = (String)context.get("interact-type");
        String actionInteractType = action.getInteractType();
        if (actionInteractType != null && !actionInteractType.equals("RIGHT_CLICK") && eventInteractType == null) {
            return false;
        }
        return eventInteractType == null || actionInteractType == null || eventInteractType.equalsIgnoreCase(actionInteractType);
    }

    private boolean validateProfessionFast(JobAction action, ConditionContext context) {
        if (!action.hasProfessionRequirements()) {
            return true;
        }
        String villagerProfession = (String)context.get("profession");
        return action.matchesProfession(villagerProfession);
    }

    private boolean validateColorFast(JobAction action, ConditionContext context) {
        if (!action.hasColorRequirements()) {
            return true;
        }
        String sheepColor = (String)context.get("color");
        return action.matchesColor(sheepColor);
    }

    private boolean validateNbtFast(JobAction action, ConditionContext context) {
        if (!action.hasNbtRequirements()) {
            return true;
        }
        String itemNbt = (String)context.get("nbt");
        return action.matchesNbt(itemNbt);
    }

    private boolean validatePotionTypeFast(JobAction action, ConditionContext context) {
        if (!action.hasPotionTypeRequirements()) {
            return true;
        }
        String potionType = (String)context.get("potion-type");
        return action.matchesPotionType(potionType);
    }

    private boolean validateEnchantLevelFast(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.ENCHANT) {
            return true;
        }
        if (action.getEnchantLevel() == null || action.getEnchantLevel().isEmpty()) {
            return true;
        }
        String enchantLevelStr = (String)context.get("enchantment_level");
        if (enchantLevelStr == null) {
            return false;
        }
        try {
            int enchantLevel = Integer.parseInt(enchantLevelStr);
            return this.matchesEnchantLevel(action.getEnchantLevel(), enchantLevel);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean validateFurnaceTypeFast(JobAction action, ConditionContext context, ActionType actionType) {
        if (actionType != ActionType.SMELT) {
            return true;
        }
        String furnaceType = (String)context.get("furnace_type");
        if (furnaceType == null || action.getBlacklistedFurnaces() == null || action.getBlacklistedFurnaces().isEmpty()) {
            return true;
        }
        return !action.getBlacklistedFurnaces().contains(furnaceType);
    }

    private void processActionRewardsFast(Player player, Job job, JobAction action, ConditionContext context) {
        double finalMoney;
        double finalXp;
        int currentLevel;
        double xp = action.getXp();
        double money = action.getMoney();
        if (xp <= 0.0 && money <= 0.0) {
            return;
        }
        Object craftMultiplierObj = context.get("craft_multiplier");
        if (craftMultiplierObj instanceof Integer) {
            int craftMultiplier = (Integer)craftMultiplierObj;
            xp *= (double)craftMultiplier;
            money *= (double)craftMultiplier;
        }
        if (action.hasLimits()) {
            ActionLimitManager.ActionGains allowedGains = this.limitManager.checkAndConsumeLimit(player, job.getId(), action.getTarget(), xp, money);
            xp = allowedGains.getXp();
            money = allowedGains.getMoney();
            if (!allowedGains.hasGains()) {
                return;
            }
        }
        if (xp > 0.0 && (currentLevel = this.jobManager.getLevel(player, job.getId())) < job.getMaxLevel()) {
            finalXp = this.applyMultipliers(player, job, xp);
            double bonusMultiplier = this.bonusManager.getTotalMultiplier(player.getUniqueId(), job.getId());
            this.jobManager.addXp(player, job.getId(), finalXp *= bonusMultiplier);
            int newLevel = this.jobManager.getLevel(player, job.getId());
            if (newLevel > currentLevel) {
                this.handleLevelUp(player, job, currentLevel, newLevel);
            }
        }
        if (money > 0.0) {
            double moneyBonusMultiplier = this.moneyBonusManager.getTotalMultiplier(player.getUniqueId(), job.getId());
            double finalMoney2 = money * moneyBonusMultiplier;
            this.addPlayerMoney(player, finalMoney2);
        }
        boolean suppressMessage = "true".equals(context.get("suppress_message"));
        finalXp = xp > 0.0 ? this.applyMultipliers(player, job, xp) * this.bonusManager.getTotalMultiplier(player.getUniqueId(), job.getId()) : 0.0;
        double d = finalMoney = money > 0.0 ? money * this.moneyBonusManager.getTotalMultiplier(player.getUniqueId(), job.getId()) : 0.0;
        if (this.configCache.isShowXpGain() && (finalXp > 0.0 || finalMoney > 0.0) && !suppressMessage) {
            PlayerJobData playerData = this.jobManager.getPlayerData(player);
            this.messageSender.sendXpMessage(player, job, finalXp, finalMoney, playerData);
        }
    }

    private boolean validateActionTarget(JobAction action, ConditionContext context, Job job) {
        String actionTarget = action.getTarget();
        String contextTarget = context.getTarget();
        boolean matches = this.configCache.isValidTarget(actionTarget, contextTarget);
        if (this.configCache.isDebugEnabled()) {
            if (matches) {
                this.plugin.getLogger().info("Target matched! Processing action for player");
            } else {
                this.plugin.getLogger().info("Target mismatch - action: " + actionTarget + ", context: " + contextTarget);
            }
        }
        return matches;
    }

    private boolean validateInteractType(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.BLOCK_INTERACT && actionType != ActionType.ENTITY_INTERACT) {
            return true;
        }
        String eventInteractType = (String)context.get("interact-type");
        String actionInteractType = action.getInteractType();
        this.debugLog("Interact type check - event: " + eventInteractType + ", action: " + actionInteractType);
        if (actionInteractType != null && !actionInteractType.equals("RIGHT_CLICK") && eventInteractType == null) {
            this.debugLog("Action requires specific interact-type (" + actionInteractType + ") but event doesn't provide interact-type info - skipping");
            return false;
        }
        if (eventInteractType != null && actionInteractType != null && !eventInteractType.equalsIgnoreCase(actionInteractType)) {
            this.debugLog("Interact type mismatch: expected " + actionInteractType + ", got " + eventInteractType);
            return false;
        }
        return true;
    }

    private boolean validateProfession(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.TRADE) {
            return true;
        }
        if (!action.hasProfessionRequirements()) {
            return true;
        }
        String villagerProfession = (String)context.get("profession");
        boolean professionMatches = action.matchesProfession(villagerProfession);
        this.debugLog("Profession check - required: " + String.valueOf(action.getProfessions()) + ", villager: " + villagerProfession + MATCHES_SUFFIX + professionMatches);
        return professionMatches;
    }

    private boolean validateColor(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.SHEAR) {
            return true;
        }
        if (!action.hasColorRequirements()) {
            return true;
        }
        String sheepColor = (String)context.get("color");
        boolean colorMatches = action.matchesColor(sheepColor);
        this.debugLog("Color check - required: " + String.valueOf(action.getColors()) + ", sheep: " + sheepColor + MATCHES_SUFFIX + colorMatches);
        return colorMatches;
    }

    private boolean validateNbt(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.EAT && actionType != ActionType.POTION) {
            return true;
        }
        if (!action.hasNbtRequirements()) {
            return true;
        }
        String itemNbt = (String)context.get("nbt");
        boolean nbtMatches = action.matchesNbt(itemNbt);
        this.debugLog("NBT check - required: " + String.valueOf(action.getNbtTags()) + ", item: " + itemNbt + MATCHES_SUFFIX + nbtMatches);
        return nbtMatches;
    }

    private boolean validatePotionType(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.POTION) {
            return true;
        }
        if (!action.hasPotionTypeRequirements()) {
            return true;
        }
        String potionType = (String)context.get("potion-type");
        boolean potionTypeMatches = action.matchesPotionType(potionType);
        this.debugLog("Potion-type check - required: " + String.valueOf(action.getPotionTypes()) + ", potion: " + potionType + MATCHES_SUFFIX + potionTypeMatches);
        return potionTypeMatches;
    }

    private boolean validateEnchantLevel(JobAction action, ConditionContext context, Job job) {
        ActionType actionType = job.getActionTypeForAction(action);
        if (actionType != ActionType.ENCHANT) {
            return true;
        }
        if (action.getEnchantLevel() == null || action.getEnchantLevel().isEmpty()) {
            return true;
        }
        String enchantLevelStr = (String)context.get("enchantment_level");
        if (enchantLevelStr == null) {
            this.debugLog("Enchant-level check - no enchantment level in context");
            return false;
        }
        try {
            int enchantLevel = Integer.parseInt(enchantLevelStr);
            boolean levelMatches = this.matchesEnchantLevel(action.getEnchantLevel(), enchantLevel);
            this.debugLog("Enchant-level check - required: " + action.getEnchantLevel() + ", actual: " + enchantLevel + MATCHES_SUFFIX + levelMatches);
            return levelMatches;
        }
        catch (NumberFormatException e) {
            this.debugLog("Enchant-level check - invalid level format: " + enchantLevelStr);
            return false;
        }
    }

    private boolean validateFurnaceType(JobAction action, ConditionContext context, ActionType actionType) {
        if (actionType != ActionType.SMELT) {
            return true;
        }
        String furnaceType = (String)context.get("furnace_type");
        if (furnaceType == null || action.getBlacklistedFurnaces() == null || action.getBlacklistedFurnaces().isEmpty()) {
            return true;
        }
        boolean isBlacklisted = action.getBlacklistedFurnaces().contains(furnaceType);
        this.debugLog("Furnace-type check - type: " + furnaceType + ", blacklisted: " + String.valueOf(action.getBlacklistedFurnaces()) + ", blocked: " + isBlacklisted);
        return !isBlacklisted;
    }

    private boolean matchesEnchantLevel(String requirement, int actualLevel) {
        String[] parts;
        if (requirement == null || requirement.isEmpty()) {
            return true;
        }
        if ((requirement = requirement.trim()).contains("-") && (parts = requirement.split("-", 2)).length == 2) {
            try {
                int minLevel = Integer.parseInt(parts[0].trim());
                int maxLevel = Integer.parseInt(parts[1].trim());
                return actualLevel >= minLevel && actualLevel <= maxLevel;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        try {
            int requiredLevel = Integer.parseInt(requirement);
            return actualLevel == requiredLevel;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private double applyMultipliers(Player player, Job job, double baseXp) {
        double multiplier = 1.0;
        if (!player.isOp() && !player.hasPermission("*")) {
            for (int i = 10; i >= 1; --i) {
                String permission = "universejobs.multiplier.exp." + i;
                if (!player.hasPermission(permission) || this.hasWildcardPermission(player)) continue;
                multiplier = i;
                break;
            }
        }
        return baseXp * multiplier;
    }

    private void addPlayerMoney(Player player, double amount) {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("Vault")) {
            try {
                Economy economy = this.getVaultEconomy();
                if (economy != null) {
                    economy.depositPlayer((OfflinePlayer)player, amount);
                    return;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to use Vault for money reward: " + e.getMessage());
            }
        }
        String command = "eco give {player} {amount}".replace("{player}", player.getName()).replace("{amount}", String.valueOf(amount));
        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command);
    }

    private Economy getVaultEconomy() {
        try {
            if (this.plugin.getServer().getServicesManager().getRegistration(Economy.class) != null) {
                return (Economy)this.plugin.getServer().getServicesManager().getRegistration(Economy.class).getProvider();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void handleLevelUp(Player player, Job job, int oldLevel, int newLevel) {
        String message = this.plugin.getConfig().getString("messages.level-up", "&aCongratulations! You reached level {level} in {job}!").replace("{level}", String.valueOf(newLevel)).replace("{job}", job.getName());
        MessageUtils.sendMessage(player, message);
        try {
            String soundName = "ENTITY_PLAYER_LEVELUP";
            NamespacedKey key = NamespacedKey.minecraft((String)soundName.toLowerCase().replace("_", "."));
            Sound sound = (Sound)Registry.SOUNDS.get(key);
            if (sound == null) {
                sound = Sound.valueOf((String)soundName);
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executeLevelUpCommands(player, job, newLevel);
    }

    private void executeLevelUpCommands(Player player, Job job, int level) {
    }

    private boolean hasWildcardPermission(Player player) {
        return player.hasPermission("*") || player.hasPermission("universejobs.*") || player.hasPermission("universejobs.multiplier.*") || player.hasPermission("universejobs.multiplier.money.*") || player.hasPermission("universejobs.multiplier.exp.*");
    }

    private void executeActionEffects(Player player, JobAction action) {
        if (action.hasMessage()) {
            MessageConfig messageConfig = action.getMessage();
            String text = messageConfig.getText();
            switch (messageConfig.getType()) {
                case CHAT: {
                    MessageUtils.sendMessage(player, text);
                    break;
                }
                case ACTIONBAR: {
                    MessageUtils.sendActionBar(player, text);
                    if (messageConfig.getDuration() <= 0) break;
                    this.plugin.getFoliaManager().runLater(() -> {
                        if (player.isOnline()) {
                            MessageUtils.sendActionBar(player, "");
                        }
                    }, messageConfig.getDuration());
                    break;
                }
                case BOSSBAR: {
                    this.messageSender.sendActionMessage(player, text, messageConfig);
                }
            }
        }
        if (action.hasCommands()) {
            for (String command : action.getCommands()) {
                String processedCommand = command.replace("{player}", player.getName());
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), processedCommand);
            }
        }
    }

    public Object getListener() {
        return null;
    }
}

