/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionLimitManager;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ActionLimitCommandHandler
extends JobCommandHandler {
    private static final String CMD_RESTORE = "restore";
    private static final String CMD_STATUS = "status";

    public ActionLimitCommandHandler(UniverseJobs plugin) {
        super(plugin);
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (!this.hasPermission(sender, "universejobs.admin.actionlimits")) {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.no-permission"));
            return true;
        }
        if (args.length < 2) {
            this.sendActionLimitHelp(sender);
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "restore": {
                this.handleActionLimitRestore(sender, args);
                break;
            }
            case "status": {
                this.handleActionLimitStatus(sender, args);
                break;
            }
            default: {
                this.sendActionLimitHelp(sender);
            }
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!this.hasPermission(sender, "universejobs.admin.actionlimits")) {
            return completions;
        }
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            List<String> actionLimitSubCommands = Arrays.asList(CMD_RESTORE, CMD_STATUS);
            for (String actionLimitSubCommand : actionLimitSubCommands) {
                if (!actionLimitSubCommand.startsWith(input)) continue;
                completions.add(actionLimitSubCommand);
            }
        } else if (args.length >= 3) {
            completions.addAll(this.getActionLimitTabCompletions(args));
        }
        return completions;
    }

    private void handleActionLimitRestore(CommandSender sender, String[] args) {
        if (args.length < 3) {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.restore.usage"));
            return;
        }
        String playerName = args[2];
        String jobId = args.length > 3 ? args[3] : "*";
        String target = args.length > 4 ? args[4] : "*";
        int totalRestored = 0;
        if ("*".equals(playerName)) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                int restored = this.limitManager.restorePlayerLimit(onlinePlayer, jobId, target);
                totalRestored += restored;
            }
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.restore.all-success", "count", String.valueOf(totalRestored)));
        } else {
            Player targetPlayer = Bukkit.getPlayer((String)playerName);
            if (targetPlayer == null) {
                MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.player-not-found", "player", playerName));
                return;
            }
            int restored = this.limitManager.restorePlayerLimit(targetPlayer, jobId, target);
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.restore.player-success", "count", String.valueOf(restored), "player", targetPlayer.getName()));
            MessageUtils.sendMessage(targetPlayer, this.languageManager.getMessage("commands.actionlimit.restore.player-notification"));
        }
    }

    private void handleActionLimitStatus(CommandSender sender, String[] args) {
        if (args.length < 5) {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.usage"));
            return;
        }
        String playerName = args[2];
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.player-not-found", "player", playerName));
            return;
        }
        String jobId = args[3];
        String target = args[4];
        ActionLimitManager.ActionLimitStatus status = this.limitManager.getPlayerLimitStatus(targetPlayer, jobId, target);
        if (status == null) {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.no-limits", "job", jobId, "target", target));
            return;
        }
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.header"));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.player", "player", targetPlayer.getName()));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.job", "job", jobId));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.target", "target", target));
        if (status.isOnCooldown()) {
            long remainingSeconds = status.getRemainingCooldownSeconds();
            long minutes = remainingSeconds / 60L;
            long seconds = remainingSeconds % 60L;
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.cooldown", "minutes", String.valueOf(minutes), "seconds", String.valueOf(seconds)));
        } else {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.available"));
        }
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.actions", "current", String.valueOf(status.getCurrentActionsPerformed()), "max", String.valueOf(status.getLimit().getMaxActionsPerPeriod()), "remaining", String.valueOf(status.getRemainingActions())));
        if (status.getLimit().isBlockExp() && status.getLimit().isBlockMoney()) {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.blocking-both"));
        } else if (status.getLimit().isBlockExp()) {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.blocking-xp"));
        } else if (status.getLimit().isBlockMoney()) {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.blocking-money"));
        } else {
            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.status.blocking-none"));
        }
    }

    private void sendActionLimitHelp(CommandSender sender) {
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.actionlimit.help"));
    }

    private List<String> getActionLimitTabCompletions(String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String actionLimitSubCommand = args[1].toLowerCase();
        if (args.length == 3) {
            String input = args[2].toLowerCase();
            switch (actionLimitSubCommand) {
                case "restore": {
                    completions.add("*");
                    completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList()));
                    break;
                }
                case "status": {
                    completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList()));
                    break;
                }
            }
        } else if (args.length == 4) {
            String input = args[3].toLowerCase();
            if (actionLimitSubCommand.equals(CMD_RESTORE)) {
                completions.add("*");
                completions.addAll(this.jobManager.getAllJobs().stream().map(Job::getId).filter(jobId -> jobId.toLowerCase().startsWith(input)).collect(Collectors.toList()));
            } else if (actionLimitSubCommand.equals(CMD_STATUS)) {
                completions.addAll(this.jobManager.getAllJobs().stream().map(Job::getId).filter(jobId -> jobId.toLowerCase().startsWith(input)).collect(Collectors.toList()));
            }
        } else if (args.length == 5) {
            String input = args[4].toLowerCase();
            if (actionLimitSubCommand.equals(CMD_RESTORE)) {
                completions.add("*");
                completions.addAll(Arrays.asList("STONE", "DIAMOND_ORE", "COAL_ORE", "IRON_ORE", "WHEAT", "ZOMBIE", "CREEPER").stream().filter(target -> target.toLowerCase().startsWith(input.toUpperCase())).collect(Collectors.toList()));
            } else if (actionLimitSubCommand.equals(CMD_STATUS)) {
                completions.addAll(Arrays.asList("STONE", "DIAMOND_ORE", "COAL_ORE", "IRON_ORE", "WHEAT", "ZOMBIE", "CREEPER").stream().filter(target -> target.toLowerCase().startsWith(input.toUpperCase())).collect(Collectors.toList()));
            }
        }
        return completions;
    }
}

