/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.menu.MenuManager;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MenuCommandHandler
extends JobCommandHandler {
    private final MenuManager menuManager;

    public MenuCommandHandler(UniverseJobs plugin) {
        super(plugin);
        this.menuManager = plugin.getMenuManager();
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (!this.validateCommandStructure(args)) {
            MessageUtils.sendMessage((Player)sender, this.languageManager.getMessage("commands.menu.invalid-format"));
            return false;
        }
        Player player = this.validatePlayerSender(sender);
        if (player == null) {
            return false;
        }
        if (args.length == 0) {
            this.openMainMenu(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "rankings": {
                this.openRankingsMenu(player);
                return true;
            }
            case "reload": {
                if (!this.hasPermission((CommandSender)player, "universejobs.admin.menu.reload")) {
                    return false;
                }
                return this.reloadMenus(player);
            }
        }
        if (this.isValidJobName(subCommand)) {
            return this.openJobMenu(player, subCommand);
        }
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.unknown"));
        this.showQuickHelp(player);
        return false;
    }

    private void openMainMenu(Player player) {
        try {
            this.menuManager.openJobsMainMenu(player);
        }
        catch (Exception e) {
            this.handleMenuError(player, "jobs menu", e);
        }
    }

    private boolean openJobMenu(Player player, String jobId) {
        Job job = this.validateJobAccess(player, jobId);
        if (job == null) {
            return false;
        }
        try {
            this.menuManager.openJobMenu(player, jobId);
            return true;
        }
        catch (Exception e) {
            return this.handleMenuError(player, "job menu", e);
        }
    }

    private void openRankingsMenu(Player player) {
        try {
            this.menuManager.openGlobalRankingsMenu(player);
        }
        catch (Exception e) {
            this.handleMenuError(player, "rankings menu", e);
        }
    }

    private boolean reloadMenus(Player player) {
        try {
            this.menuManager.reloadConfigurations();
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.reload.success"));
            this.plugin.getLogger().info("Menu configurations reloaded by " + player.getName());
            return true;
        }
        catch (Exception e) {
            return this.handleMenuError(player, "reload menu configurations", e);
        }
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return Arrays.asList(new String[0]);
        }
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList("rankings"));
            if (sender.hasPermission("universejobs.admin.menu.reload")) {
                completions.add("reload");
            }
            List jobNames = this.jobManager.getJobs().values().stream().filter(Job::isEnabled).filter(job -> job.getPermission() == null || sender.hasPermission(job.getPermission())).map(Job::getId).collect(Collectors.toList());
            completions.addAll(jobNames);
            return completions.stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).sorted().collect(Collectors.toList());
        }
        return Arrays.asList(new String[0]);
    }

    private Job validateJobAccess(Player player, String jobId) {
        if (!this.isValidJobId(jobId)) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.invalid-job-id"));
            return null;
        }
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.job-not-found", "job", jobId));
            return null;
        }
        if (!job.isEnabled()) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.job-disabled"));
            return null;
        }
        if (job.getPermission() != null && !player.hasPermission(job.getPermission())) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.no-permission"));
            return null;
        }
        return job;
    }

    private boolean handleMenuError(Player player, String menuType, Exception e) {
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.failed-open", "type", menuType));
        this.plugin.getLogger().warning("Failed to open " + menuType + " for " + player.getName() + ": " + e.getMessage());
        return false;
    }

    private boolean isValidJobName(String jobName) {
        if (!this.isValidJobId(jobName)) {
            return false;
        }
        Job job = this.jobManager.getJob(jobName);
        return job != null && job.isEnabled();
    }

    private void showQuickHelp(Player player) {
        List jobExamples = this.jobManager.getJobs().values().stream().filter(Job::isEnabled).filter(job -> job.getPermission() == null || player.hasPermission(job.getPermission())).map(Job::getId).limit(3L).collect(Collectors.toList());
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.quick-help.header"));
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.quick-help.main"));
        for (String jobId : jobExamples) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.quick-help.job-example", "job", jobId));
        }
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.menu.quick-help.rankings"));
    }
}

