/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition.impl;

import fr.ax_dev.universejobs.condition.AbstractCondition;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionType;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlaceholderCondition
extends AbstractCondition {
    private final String placeholder;
    private final String operator;
    private final String value;

    public PlaceholderCondition(ConfigurationSection config) {
        super(config);
        this.placeholder = config.getString("placeholder", "");
        this.operator = config.getString("operator", "equals");
        this.value = config.getString("value", "");
    }

    @Override
    public boolean isMet(Player player, Event event, ConditionContext context) {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return false;
        }
        String parsedValue = PlaceholderAPI.setPlaceholders((Player)player, (String)this.placeholder);
        return switch (this.operator.toLowerCase()) {
            case "equals", "=" -> parsedValue.equals(this.value);
            case "not_equals", "!=" -> {
                if (!parsedValue.equals(this.value)) {
                    yield true;
                }
                yield false;
            }
            case "contains" -> parsedValue.toLowerCase().contains(this.value.toLowerCase());
            case "not_contains" -> {
                if (!parsedValue.toLowerCase().contains(this.value.toLowerCase())) {
                    yield true;
                }
                yield false;
            }
            case "starts_with" -> parsedValue.toLowerCase().startsWith(this.value.toLowerCase());
            case "ends_with" -> parsedValue.toLowerCase().endsWith(this.value.toLowerCase());
            case "greater_than", ">" -> {
                if (this.compareNumeric(parsedValue, this.value) > 0) {
                    yield true;
                }
                yield false;
            }
            case "less_than", "<" -> {
                if (this.compareNumeric(parsedValue, this.value) < 0) {
                    yield true;
                }
                yield false;
            }
            case "greater_equal", ">=" -> {
                if (this.compareNumeric(parsedValue, this.value) >= 0) {
                    yield true;
                }
                yield false;
            }
            case "less_equal", "<=" -> {
                if (this.compareNumeric(parsedValue, this.value) <= 0) {
                    yield true;
                }
                yield false;
            }
            case "regex" -> parsedValue.matches(this.value);
            default -> false;
        };
    }

    private int compareNumeric(String value1, String value2) {
        try {
            double num1 = Double.parseDouble(value1);
            double num2 = Double.parseDouble(value2);
            return Double.compare(num1, num2);
        }
        catch (NumberFormatException e) {
            return value1.compareTo(value2);
        }
    }

    @Override
    public ConditionType getType() {
        return ConditionType.PLACEHOLDER;
    }

    public String toString() {
        return "PlaceholderCondition{placeholder='" + this.placeholder + "', operator='" + this.operator + "', value='" + this.value + "'}";
    }
}

