/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.condition.ConditionContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.momirealms.customfishing.api.BukkitCustomFishingPlugin;
import net.momirealms.customfishing.api.event.FishingLootSpawnEvent;
import net.momirealms.customfishing.api.mechanic.item.ItemManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class CustomFishingEventListener
implements Listener {
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;
    private final Map<UUID, Long> lastFishingTime = new HashMap<UUID, Long>();
    private static final long FISHING_COOLDOWN_MS = 100L;

    public CustomFishingEventListener(UniverseJobs plugin, ActionProcessor actionProcessor) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
        plugin.getLogger().info("CustomFishingEventListener initialized successfully");
        if (plugin.getConfigManager().isDebugEnabled()) {
            plugin.getLogger().info("CustomFishing integration enabled with debug mode");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onFishingLootSpawn(FishingLootSpawnEvent event) {
        String fishId;
        Player player = event.getPlayer();
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomFishing trigger onFishingLootSpawn");
        }
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastFishingTime.get(playerUUID);
        if (lastTime != null && currentTime - lastTime < 100L) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("CustomFishing loot spawn blocked (double-action protection): " + player.getName() + " cooldown remaining: " + (100L - (currentTime - lastTime)) + "ms");
            }
            return;
        }
        this.lastFishingTime.put(playerUUID, currentTime);
        Entity entity = event.getEntity();
        if (!(entity instanceof Item)) {
            return;
        }
        Item item = (Item)entity;
        ItemStack itemStack = item.getItemStack();
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomFishing ItemStack debug:");
            this.plugin.getLogger().info("  Material: " + String.valueOf(itemStack.getType()));
            if (itemStack.hasItemMeta()) {
                if (itemStack.getItemMeta().hasDisplayName()) {
                    this.plugin.getLogger().info("  Display name: " + itemStack.getItemMeta().getDisplayName());
                }
                if (itemStack.getItemMeta().hasCustomModelData()) {
                    this.plugin.getLogger().info("  Custom model data: " + itemStack.getItemMeta().getCustomModelData());
                }
                if (itemStack.getItemMeta().hasLore()) {
                    this.plugin.getLogger().info("  Lore: " + String.valueOf(itemStack.getItemMeta().getLore()));
                }
            }
        }
        if ((fishId = this.getFishIdFromItemStack(itemStack)) == null || fishId.isEmpty()) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("CustomFishing: Unable to determine fish ID from ItemStack: " + String.valueOf(itemStack.getType()));
            }
            return;
        }
        ConditionContext context = new ConditionContext().set("target", "customfishing:" + fishId).set("customfishing_fish_id", fishId).set("itemstack", itemStack);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomFishing caught: customfishing:" + fishId + " by " + player.getName());
            this.plugin.getLogger().info("Processing FISH action with target: customfishing:" + fishId + " by " + player.getName());
        }
        this.actionProcessor.processAction(player, ActionType.FISH, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomFishing loot spawn processed: " + fishId + " by " + player.getName() + " at " + String.valueOf(player.getLocation()));
        }
    }

    private String getFishIdFromItemStack(ItemStack itemStack) {
        block7: {
            if (itemStack == null) {
                return null;
            }
            try {
                ItemManager itemManager;
                String possibleId;
                BukkitCustomFishingPlugin customFishingApi = BukkitCustomFishingPlugin.getInstance();
                if (customFishingApi != null && (possibleId = this.identifyCustomFishingItem(itemManager = customFishingApi.getItemManager(), itemStack)) != null && !possibleId.isEmpty()) {
                    return possibleId;
                }
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isDebugEnabled()) break block7;
                this.plugin.getLogger().warning("Failed to use CustomFishing API for item identification: " + e.getMessage());
            }
        }
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasCustomModelData()) {
            int customModelData = itemStack.getItemMeta().getCustomModelData();
            return "fish_" + customModelData;
        }
        String materialName = itemStack.getType().name().toLowerCase();
        if (materialName.contains("fish") || materialName.contains("cod") || materialName.contains("salmon") || materialName.contains("tropical")) {
            return materialName;
        }
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            String displayName = itemStack.getItemMeta().getDisplayName();
            String cleanName = displayName.replaceAll("\u00a7[0-9a-fk-or]", "").replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase();
            return cleanName;
        }
        return materialName;
    }

    private String identifyCustomFishingItem(ItemManager itemManager, ItemStack itemStack) {
        if (itemStack.hasItemMeta()) {
            String displayName;
            String cleanName;
            String potentialId;
            if (itemStack.getItemMeta().hasDisplayName() && (potentialId = this.convertDisplayNameToId(cleanName = (displayName = itemStack.getItemMeta().getDisplayName()).replaceAll("\u00a7[0-9a-fk-or]", "").trim())) != null) {
                return potentialId;
            }
            if (itemStack.getItemMeta().hasLore()) {
                for (String loreLine : itemStack.getItemMeta().getLore()) {
                    String potentialId2;
                    String cleanLore = loreLine.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
                    if (!cleanLore.toLowerCase().contains("fish") && !cleanLore.toLowerCase().contains("catch") || (potentialId2 = this.extractIdFromLore(cleanLore)) == null) continue;
                    return potentialId2;
                }
            }
        }
        return null;
    }

    private String convertDisplayNameToId(String displayName) {
        if (displayName == null || displayName.isEmpty()) {
            return null;
        }
        String lowerName = displayName.toLowerCase();
        if (lowerName.contains("cod")) {
            return "cod";
        }
        if (lowerName.contains("salmon")) {
            return "salmon";
        }
        if (lowerName.contains("tropical")) {
            return "tropical_fish";
        }
        if (lowerName.contains("pufferfish")) {
            return "pufferfish";
        }
        if (lowerName.contains("bass")) {
            return "bass";
        }
        if (lowerName.contains("carp")) {
            return "carp";
        }
        if (lowerName.contains("tuna")) {
            return "tuna";
        }
        if (lowerName.contains("mackerel")) {
            return "mackerel";
        }
        if (lowerName.contains("sardine")) {
            return "sardine";
        }
        return lowerName.replaceAll("[^a-z0-9]", "_").replaceAll("_+", "_").trim();
    }

    private String extractIdFromLore(String lore) {
        String[] parts;
        if (lore == null || lore.isEmpty()) {
            return null;
        }
        String lowerLore = lore.toLowerCase();
        if ((lowerLore.contains("rarity:") || lowerLore.contains("type:")) && (parts = lowerLore.split(":")).length > 1) {
            return parts[1].trim().replaceAll("[^a-z0-9]", "_");
        }
        return null;
    }

    public void cleanupOldFishingTimes() {
        long currentTime = System.currentTimeMillis();
        long cleanupThreshold = 600000L;
        this.lastFishingTime.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > cleanupThreshold);
    }
}

