/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.MenuUtils;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public abstract class BaseMenu
implements InventoryHolder {
    protected final UniverseJobs plugin;
    protected final Player player;
    protected final SingleMenuConfig config;
    protected Inventory inventory;
    protected int currentPage = 0;

    public BaseMenu(UniverseJobs plugin, Player player, SingleMenuConfig config) {
        this.plugin = plugin;
        this.player = player;
        this.config = config;
    }

    protected final void initialize() {
        this.createInventory();
        this.populateInventory();
    }

    protected void createInventory() {
        String title = this.processPlaceholders(this.config.getTitle());
        Component titleComponent = MessageUtils.parseMessage(title);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.config.getSize(), (Component)titleComponent);
    }

    protected abstract void populateInventory();

    public abstract void handleClick(int var1, InventoryClickEvent var2);

    public void open() {
        this.player.openInventory(this.inventory);
    }

    public void close() {
        this.player.closeInventory();
    }

    public void onClose() {
    }

    public boolean isInventory(Inventory inventory) {
        return this.inventory.equals((Object)inventory);
    }

    public void refresh() {
        this.inventory.clear();
        this.populateInventory();
    }

    protected ItemStack createMenuItem(MenuItemConfig itemConfig) {
        return MenuUtils.createMenuItem(this.plugin, this.player, itemConfig);
    }

    protected ItemStack createMenuItem(MenuItemConfig itemConfig, Map<String, String> customPlaceholders) {
        return MenuUtils.createMenuItem(this.plugin, this.player, itemConfig, customPlaceholders);
    }

    protected void addFillItems() {
        MenuItemConfig fillConfig = this.config.getFillItem();
        if (fillConfig == null || !fillConfig.isEnabled()) {
            return;
        }
        ItemStack fillItem = this.createMenuItem(fillConfig);
        List<Integer> slotsToFill = fillConfig.getSlots();
        if (slotsToFill.isEmpty()) {
            slotsToFill = this.config.getFillSlots();
        }
        for (int slot : slotsToFill) {
            if (slot < 0 || slot >= this.inventory.getSize() || this.inventory.getItem(slot) != null) continue;
            this.inventory.setItem(slot, fillItem);
        }
    }

    protected String processPlaceholders(String text) {
        return MenuUtils.processPlaceholders(this.player, text);
    }

    protected String replacePlaceholders(String text, Map<String, String> placeholders) {
        return MenuUtils.replacePlaceholders(text, placeholders);
    }

    protected boolean handleNavigationClick(int slot) {
        if (this.config.getNavigationSlots().containsKey("previous") && this.config.getNavigationSlots().get("previous").contains(slot) && this.currentPage > 0) {
            --this.currentPage;
            this.refresh();
            return true;
        }
        if (this.config.getNavigationSlots().containsKey("next") && this.config.getNavigationSlots().get("next").contains(slot) && this.hasNextPage()) {
            ++this.currentPage;
            this.refresh();
            return true;
        }
        if (this.config.getNavigationSlots().containsKey("close") && this.config.getNavigationSlots().get("close").contains(slot)) {
            this.close();
            return true;
        }
        if (this.config.getNavigationSlots().containsKey("back") && this.config.getNavigationSlots().get("back").contains(slot)) {
            this.handleBackButton();
            return true;
        }
        return false;
    }

    protected abstract boolean hasNextPage();

    protected void handleBackButton() {
        this.close();
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

