/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.reward.gui.ItemBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class MenuUtils {
    public static String processPlaceholders(Player player, String text) {
        if (text == null) {
            return "";
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public static String replacePlaceholders(String text, Map<String, String> placeholders) {
        if (text == null || placeholders == null) {
            return text;
        }
        String result = text;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("{") && key.endsWith("}")) {
                result = result.replace(key, entry.getValue());
                continue;
            }
            result = result.replace("{" + key + "}", entry.getValue());
        }
        return result;
    }

    public static ItemStack createMenuItem(UniverseJobs plugin, Player player, MenuItemConfig itemConfig) {
        return MenuUtils.createMenuItem(plugin, player, itemConfig, null);
    }

    public static ItemStack createMenuItem(UniverseJobs plugin, Player player, MenuItemConfig itemConfig, Map<String, String> customPlaceholders) {
        ItemStack item;
        ItemMeta meta;
        ItemBuilder builder = ItemBuilder.fromMaterialName(plugin, itemConfig.getMaterial()).amount(itemConfig.getAmount());
        String displayName = itemConfig.getDisplayName();
        if (customPlaceholders != null) {
            displayName = MenuUtils.replacePlaceholders(displayName, customPlaceholders);
        }
        displayName = MenuUtils.processPlaceholders(player, displayName);
        builder.name(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        Iterator<String> iterator = itemConfig.getLore().iterator();
        while (iterator.hasNext()) {
            String loreLine;
            String processedLore = loreLine = iterator.next();
            if (customPlaceholders != null) {
                processedLore = MenuUtils.replacePlaceholders(processedLore, customPlaceholders);
            }
            processedLore = MenuUtils.processPlaceholders(player, processedLore);
            lore.add(processedLore);
        }
        builder.lore(lore);
        if (itemConfig.getCustomModelData() > 0) {
            builder.customModelData(itemConfig.getCustomModelData());
        }
        if (itemConfig.isHideAttributes() || itemConfig.isHideEnchants()) {
            builder.hideAttributes();
        }
        if ((meta = (item = builder.build()).getItemMeta()) != null) {
            if (item.getType() == Material.PLAYER_HEAD && !itemConfig.getSkullOwner().isEmpty() && meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                String skullOwner = itemConfig.getSkullOwner();
                if (customPlaceholders != null) {
                    skullOwner = MenuUtils.replacePlaceholders(skullOwner, customPlaceholders);
                }
                skullOwner = MenuUtils.processPlaceholders(player, skullOwner);
                try {
                    skullMeta.setOwningPlayer(plugin.getServer().getOfflinePlayer(skullOwner));
                }
                catch (Exception e) {
                    plugin.getLogger().warning("Failed to set skull owner: " + skullOwner);
                }
            }
            for (Map.Entry<String, Integer> entry : itemConfig.getEnchantments().entrySet()) {
                try {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)entry.getKey().toLowerCase()));
                    if (enchantment == null) continue;
                    meta.addEnchant(enchantment, entry.getValue().intValue(), true);
                }
                catch (Exception e) {
                    plugin.getLogger().warning("Invalid enchantment: " + entry.getKey());
                }
            }
            if (itemConfig.isGlow() && itemConfig.getEnchantments().isEmpty()) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (itemConfig.isHideToolTip()) {
                meta.setHideTooltip(true);
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

