/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class ActionItemFormat {
    private final List<String> loreBonus;
    private final int amount;
    private final boolean glow;
    private final boolean hideAttributes;
    private final boolean hideEnchants;

    public ActionItemFormat(ConfigurationSection config) {
        this.loreBonus = config.getStringList("lore_bonus");
        this.amount = config.getInt("amount", 1);
        this.glow = config.getBoolean("glow", false);
        this.hideAttributes = config.getBoolean("hide-attributes", true);
        this.hideEnchants = config.getBoolean("hide-enchants", true);
    }

    public ActionItemFormat() {
        this.loreBonus = ActionItemFormat.getDefaultLoreBonus();
        this.amount = 1;
        this.glow = false;
        this.hideAttributes = true;
        this.hideEnchants = true;
    }

    private static List<String> getDefaultLoreBonus() {
        return Arrays.asList("", "<gray>Rewards:", "<gray>\u251c <gray>XP: <#abffb3>+{action_xp}", "<gray>\u2514 <gray>Money: <#FFD700>${action_money}", "", "<gray>Requirements: {action_requirements}");
    }

    public List<String> getLoreBonus() {
        return new ArrayList<String>(this.loreBonus);
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public boolean isHideAttributes() {
        return this.hideAttributes;
    }

    public boolean isHideEnchants() {
        return this.hideEnchants;
    }
}

