/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.config;

import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class MenuItemConfig {
    private final boolean enabled;
    private final String material;
    private final int amount;
    private final String displayName;
    private final List<String> lore;
    private final int customModelData;
    private final Map<String, Integer> enchantments;
    private final boolean glow;
    private final boolean hideAttributes;
    private final boolean hideEnchants;
    private final boolean hideToolTip;
    private final List<Integer> slots;
    private final String action;
    private final String actionValue;
    private final String skullOwner;
    private final String hasJobMaterial;
    private final String hasJobDisplayName;
    private final List<String> hasJobLore;

    public MenuItemConfig(ConfigurationSection config) {
        this.enabled = config.getBoolean("enabled", true);
        this.material = config.getString("material", "STONE");
        this.amount = config.getInt("amount", 1);
        this.displayName = config.getString("display-name", "");
        this.lore = config.getStringList("lore");
        this.customModelData = config.getInt("custom-model-data", 0);
        this.glow = config.getBoolean("glow", false);
        this.hideAttributes = config.getBoolean("hide-attributes", false);
        this.hideEnchants = config.getBoolean("hide-enchants", false);
        this.hideToolTip = config.getBoolean("hideToolTip", false);
        this.slots = config.getIntegerList("slots");
        this.action = config.getString("action", "none");
        this.actionValue = config.getString("action-value", "");
        this.skullOwner = config.getString("skull-owner", "");
        this.hasJobMaterial = config.getString("has-job-material", "");
        this.hasJobDisplayName = config.getString("has-job-display-name", "");
        this.hasJobLore = config.getStringList("has-job-lore");
        this.enchantments = new HashMap<String, Integer>();
        ConfigurationSection enchantSection = config.getConfigurationSection("enchantments");
        if (enchantSection != null) {
            for (String enchantKey : enchantSection.getKeys(false)) {
                int level = enchantSection.getInt(enchantKey, 1);
                this.enchantments.put(enchantKey, level);
            }
        }
    }

    public static MenuItemConfig defaultItem(String material, String displayName, String ... lore) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("enabled", true);
        configMap.put("material", material);
        configMap.put("amount", 1);
        configMap.put("display-name", displayName);
        configMap.put("lore", Arrays.asList(lore));
        configMap.put("custom-model-data", 0);
        configMap.put("glow", false);
        configMap.put("hide-attributes", false);
        configMap.put("hide-enchants", false);
        configMap.put("hideToolTip", false);
        configMap.put("slots", new ArrayList());
        configMap.put("action", "none");
        configMap.put("action-value", "");
        return new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
    }

    public static MenuItemConfig navigationItem(String material, String displayName, String action, List<Integer> slots, String ... lore) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("enabled", true);
        configMap.put("material", material);
        configMap.put("amount", 1);
        configMap.put("display-name", displayName);
        configMap.put("lore", Arrays.asList(lore));
        configMap.put("custom-model-data", 0);
        configMap.put("glow", false);
        configMap.put("hide-attributes", false);
        configMap.put("hide-enchants", false);
        configMap.put("hideToolTip", false);
        configMap.put("slots", slots);
        configMap.put("action", action);
        configMap.put("action-value", "");
        return new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return new ArrayList<String>(this.lore);
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public Map<String, Integer> getEnchantments() {
        return new HashMap<String, Integer>(this.enchantments);
    }

    public boolean isGlow() {
        return this.glow;
    }

    public boolean isHideAttributes() {
        return this.hideAttributes;
    }

    public boolean isHideEnchants() {
        return this.hideEnchants;
    }

    public boolean isHideToolTip() {
        return this.hideToolTip;
    }

    public List<Integer> getSlots() {
        return new ArrayList<Integer>(this.slots);
    }

    public String getAction() {
        return this.action;
    }

    public String getActionValue() {
        return this.actionValue;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public String getHasJobMaterial() {
        return this.hasJobMaterial;
    }

    public String getHasJobDisplayName() {
        return this.hasJobDisplayName;
    }

    public List<String> getHasJobLore() {
        return new ArrayList<String>(this.hasJobLore);
    }

    public boolean hasJobAlternative() {
        return this.hasJobMaterial != null && !this.hasJobMaterial.isEmpty();
    }
}

