/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.impl;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.menu.utils.MenuItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GlobalRankingsMenu
extends BaseMenu {
    private final Map<String, List<RankingEntry>> jobRankings = new HashMap<String, List<RankingEntry>>();
    private final List<String> availableJobs;
    private String selectedJob;

    public GlobalRankingsMenu(UniverseJobs plugin, Player player, SingleMenuConfig config) {
        super(plugin, player, config);
        this.availableJobs = plugin.getJobManager().getJobs().values().stream().filter(Job::isEnabled).map(Job::getId).sorted().collect(Collectors.toList());
        this.selectedJob = this.availableJobs.isEmpty() ? null : this.availableJobs.get(0);
        this.loadRankings();
        this.initialize();
    }

    private void loadRankings() {
        for (String jobId : this.availableJobs) {
            List<RankingEntry> rankings = this.calculateJobRankings(jobId);
            this.jobRankings.put(jobId, rankings);
        }
    }

    private List<RankingEntry> calculateJobRankings(String jobId) {
        ArrayList<RankingEntry> rankings = new ArrayList<RankingEntry>();
        Map<UUID, PlayerJobData> allPlayerData = this.plugin.getJobManager().getAllPlayerData();
        for (Map.Entry<UUID, PlayerJobData> entry : allPlayerData.entrySet()) {
            UUID playerId = entry.getKey();
            PlayerJobData playerData = entry.getValue();
            if (!playerData.hasJob(jobId)) continue;
            int level = playerData.getLevel(jobId);
            long xp = (long)playerData.getXp(jobId);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerId);
            String playerName = offlinePlayer.getName();
            if (playerName == null) continue;
            rankings.add(new RankingEntry(playerId, playerName, level, xp));
        }
        rankings.sort((a, b) -> {
            int levelCompare = Integer.compare(b.level, a.level);
            if (levelCompare != 0) {
                return levelCompare;
            }
            return Long.compare(b.xp, a.xp);
        });
        for (int i = 0; i < rankings.size(); ++i) {
            ((RankingEntry)rankings.get((int)i)).rank = i + 1;
        }
        return rankings;
    }

    @Override
    protected void populateInventory() {
        this.inventory.clear();
        this.addHeader();
        this.addJobSelectionButtons();
        this.addRankingEntries();
        this.addNavigationItems();
        this.addStaticItems();
        this.addFillItems();
    }

    private void addHeader() {
        if (this.selectedJob == null) {
            ItemStack noJobsItem = this.createNoJobsItem();
            this.inventory.setItem(4, noJobsItem);
            return;
        }
        Job job = this.plugin.getJobManager().getJob(this.selectedJob);
        if (job == null) {
            return;
        }
        ItemStack headerItem = this.createHeaderItem(job);
        this.inventory.setItem(4, headerItem);
    }

    private ItemStack createHeaderItem(Job job) {
        List rankings = this.jobRankings.getOrDefault(this.selectedJob, new ArrayList());
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&7Global rankings for this job");
        lore.add("");
        lore.add("&7Total Players: &e" + rankings.size());
        if (!rankings.isEmpty()) {
            RankingEntry topPlayer = (RankingEntry)rankings.get(0);
            lore.add("&7Top Player: &a" + topPlayer.playerName);
            lore.add("&7Top Level: &e" + topPlayer.level);
        }
        UUID playerUUID = this.player.getUniqueId();
        Optional<RankingEntry> playerRanking = rankings.stream().filter(entry -> entry.playerId.equals(playerUUID)).findFirst();
        if (playerRanking.isPresent()) {
            RankingEntry entry2 = playerRanking.get();
            lore.add("");
            lore.add("&6Your Ranking:");
            lore.add("&7Rank: &e#" + entry2.rank);
            lore.add("&7Level: &a" + entry2.level);
            lore.add("&7XP: &b" + entry2.xp);
        } else {
            lore.add("");
            lore.add("&6Your Ranking:");
            lore.add("&7You don't have this job");
        }
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(job.getIconMaterial(), "&6&l" + job.getName() + " Rankings", lore, true);
        if (job.getCustomModelData() > 0) {
            configMap.put("custom-model-data", job.getCustomModelData());
        }
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(job.getId(), job.getName(), job.getDescription()));
    }

    private ItemStack createNoJobsItem() {
        List<String> lore = Arrays.asList("&7No jobs available to show rankings for");
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap("BARRIER", "&c&lNo Jobs Available", lore, false);
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig);
    }

    private void addJobSelectionButtons() {
        if (this.availableJobs.isEmpty()) {
            return;
        }
        int startSlot = 10;
        int maxButtons = 7;
        for (int i = 0; i < Math.min(this.availableJobs.size(), maxButtons); ++i) {
            String jobId = this.availableJobs.get(i);
            Job job = this.plugin.getJobManager().getJob(jobId);
            if (job == null) continue;
            ItemStack jobButton = this.createJobSelectionButton(job, jobId.equals(this.selectedJob));
            this.inventory.setItem(startSlot + i, jobButton);
        }
    }

    private ItemStack createJobSelectionButton(Job job, boolean selected) {
        List rankings = this.jobRankings.getOrDefault(job.getId(), new ArrayList());
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&7Click to view rankings for this job");
        lore.add("");
        lore.add("&7Players: &e" + rankings.size());
        if (selected) {
            lore.add("");
            lore.add("&a\u25b6 Currently Selected");
        }
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(job.getIconMaterial(), "&e" + job.getName(), lore, selected);
        if (job.getCustomModelData() > 0) {
            configMap.put("custom-model-data", job.getCustomModelData());
        }
        configMap.put("action", "select_job");
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, MenuItemUtils.createJobPlaceholders(job.getId(), job.getName(), job.getDescription()));
    }

    private void addRankingEntries() {
        if (this.selectedJob == null) {
            return;
        }
        List rankings = this.jobRankings.getOrDefault(this.selectedJob, new ArrayList());
        if (rankings.isEmpty()) {
            return;
        }
        List<Integer> contentSlots = this.config.getContentSlots();
        int startIndex = this.currentPage * this.config.getItemsPerPage();
        int endIndex = Math.min(startIndex + this.config.getItemsPerPage(), rankings.size());
        for (int i = startIndex; i < endIndex; ++i) {
            RankingEntry entry = (RankingEntry)rankings.get(i);
            int slotIndex = i - startIndex;
            if (slotIndex >= contentSlots.size()) break;
            int slot = contentSlots.get(slotIndex);
            ItemStack rankingItem = this.createRankingItem(entry);
            this.inventory.setItem(slot, rankingItem);
        }
    }

    private ItemStack createRankingItem(RankingEntry entry) {
        String material = this.getRankMaterial(entry.rank);
        String rankColor = this.getRankColor(entry.rank);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("&7Player: &f" + entry.playerName);
        lore.add("&7Level: &a" + entry.level);
        lore.add("&7Total XP: &b" + entry.xp);
        if (entry.playerId.equals(this.player.getUniqueId())) {
            lore.add("");
            lore.add("&e\u2b50 This is you!");
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("rank", String.valueOf(entry.rank));
        placeholders.put("player", entry.playerName);
        placeholders.put("level", String.valueOf(entry.level));
        placeholders.put("xp", String.valueOf(entry.xp));
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(material, rankColor + "#" + entry.rank + " - " + entry.playerName, lore, entry.playerId.equals(this.player.getUniqueId()));
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, placeholders);
    }

    private void addNavigationItems() {
        Map<String, MenuItemConfig> navItems = this.config.getNavigationItems();
        MenuItemUtils.addNavigationItems(this.inventory, navItems, this.currentPage, this.hasNextPage(), this.getNavigationPlaceholders(), config -> this.createMenuItem((MenuItemConfig)config, this.getNavigationPlaceholders()));
    }

    private void addStaticItems() {
        HashMap<String, String> placeholders = this.selectedJob != null ? MenuItemUtils.createJobPlaceholders(this.selectedJob, this.plugin.getJobManager().getJob(this.selectedJob).getName(), this.plugin.getJobManager().getJob(this.selectedJob).getDescription()) : new HashMap<String, String>();
        MenuItemUtils.addStaticItems(this.inventory, this.config.getStaticItems(), placeholders, config -> this.createMenuItem((MenuItemConfig)config, (Map<String, String>)placeholders));
    }

    @Override
    public void handleClick(int slot, InventoryClickEvent event) {
        if (this.handleNavigationClick(slot)) {
            return;
        }
        if (slot >= 10 && slot <= 16) {
            String newSelectedJob;
            int jobIndex = slot - 10;
            if (jobIndex < this.availableJobs.size() && !(newSelectedJob = this.availableJobs.get(jobIndex)).equals(this.selectedJob)) {
                this.selectedJob = newSelectedJob;
                this.currentPage = 0;
                this.refresh();
            }
            return;
        }
        List<Integer> contentSlots = this.config.getContentSlots();
        if (contentSlots.contains(slot)) {
            // empty if block
        }
    }

    @Override
    protected boolean hasNextPage() {
        if (this.selectedJob == null) {
            return false;
        }
        List rankings = this.jobRankings.getOrDefault(this.selectedJob, new ArrayList());
        return (this.currentPage + 1) * this.config.getItemsPerPage() < rankings.size();
    }

    @Override
    protected void handleBackButton() {
        this.plugin.getMenuManager().openJobsMainMenu(this.player);
    }

    private Map<String, String> getNavigationPlaceholders() {
        ArrayList rankings = this.selectedJob != null ? (List)this.jobRankings.getOrDefault(this.selectedJob, new ArrayList()) : new ArrayList();
        Map<String, String> placeholders = MenuItemUtils.createNavigationPlaceholders(this.currentPage, rankings.size(), this.config.getItemsPerPage());
        placeholders.put("total_players", String.valueOf(rankings.size()));
        placeholders.put("selected_job", this.selectedJob != null ? this.selectedJob : "None");
        return placeholders;
    }

    private String getRankMaterial(int rank) {
        return switch (rank) {
            case 1 -> "GOLD_INGOT";
            case 2 -> "IRON_INGOT";
            case 3 -> "COPPER_INGOT";
            default -> rank <= 10 ? "EMERALD" : "PLAYER_HEAD";
        };
    }

    private String getRankColor(int rank) {
        return switch (rank) {
            case 1 -> "&6&l";
            case 2 -> "&7&l";
            case 3 -> "&c&l";
            default -> rank <= 10 ? "&a" : "&f";
        };
    }

    private static class RankingEntry {
        final UUID playerId;
        final String playerName;
        final int level;
        final long xp;
        int rank;

        RankingEntry(UUID playerId, String playerName, int level, long xp) {
            this.playerId = playerId;
            this.playerName = playerName;
            this.level = level;
            this.xp = xp;
        }
    }
}

