/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.impl;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.action.JobAction;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.config.ActionItemFormat;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.menu.utils.MaterialUtils;
import fr.ax_dev.universejobs.menu.utils.MenuItemUtils;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class JobActionsMenu
extends BaseMenu
implements InventoryHolder {
    private static final int HEADER_SLOT = 4;
    private static final String ACTION_TYPE = "action";
    private final Job job;
    private final Map<String, List<ActionInfo>> groupedActions;
    private final Map<String, String> cachedPlaceholders;

    public JobActionsMenu(UniverseJobs plugin, Player player, String jobId, SingleMenuConfig config) {
        super(plugin, player, config);
        this.job = plugin.getJobManager().getJob(jobId);
        if (this.job == null) {
            throw new IllegalArgumentException("Job not found: " + jobId);
        }
        plugin.getLanguageManager();
        this.groupedActions = new HashMap<String, List<ActionInfo>>();
        this.cachedPlaceholders = new HashMap<String, String>();
        this.loadJobData();
        this.cachedPlaceholders.putAll(this.createJobPlaceholders());
        this.initialize();
    }

    @Override
    protected void createInventory() {
        String title = this.config.getTitle().replace("{job_name}", this.job.getDisplayName());
        title = this.processPlaceholders(title);
        Component titleComponent = MessageUtils.parseMessage(title);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.config.getSize(), (Component)titleComponent);
    }

    private void loadJobData() {
        this.loadJobActionsEfficiently();
    }

    private void loadJobActionsEfficiently() {
        for (ActionType actionType : this.job.getActionTypes()) {
            for (JobAction action : this.job.getActions(actionType)) {
                String target = action.getTarget();
                this.groupedActions.computeIfAbsent(target, k -> new ArrayList()).add(new ActionInfo(actionType, action));
            }
        }
    }

    @Override
    protected void populateInventory() {
        this.addStaticItems();
        this.addFillItems();
        List<DisplayItem> displayItems = this.createDisplayItems();
        this.addPaginatedItems(displayItems);
        this.addNavigationItems();
    }

    private void addStaticItems() {
        if (this.config.getStaticItems().containsKey("info-header")) {
            MenuItemConfig headerConfig = this.config.getStaticItems().get("info-header");
            ItemStack headerItem = this.createMenuItem(headerConfig, this.cachedPlaceholders);
            this.inventory.setItem(4, headerItem);
        }
    }

    private List<DisplayItem> createDisplayItems() {
        ArrayList<DisplayItem> displayItems = new ArrayList<DisplayItem>(this.groupedActions.size());
        this.groupedActions.forEach((target, actions) -> displayItems.add(new DisplayItem(ACTION_TYPE, new GroupedActionInfo((String)target, (List<ActionInfo>)actions))));
        return displayItems;
    }

    private void addPaginatedItems(List<DisplayItem> displayItems) {
        int slotIndex;
        List<Integer> contentSlots = this.config.getContentSlots();
        int itemsPerPage = this.config.getItemsPerPage();
        int startIndex = this.currentPage * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, displayItems.size());
        for (int i = startIndex; i < endIndex && (slotIndex = i - startIndex) < contentSlots.size(); ++i) {
            DisplayItem displayItem = displayItems.get(i);
            ItemStack item = null;
            if (ACTION_TYPE.equals(displayItem.type)) {
                item = this.createGroupedActionItem((GroupedActionInfo)displayItem.data);
            }
            if (item == null) continue;
            this.inventory.setItem(contentSlots.get(slotIndex).intValue(), item);
        }
    }

    private ItemStack createGroupedActionItem(GroupedActionInfo groupedInfo) {
        List<String> lore = this.buildGroupedActionLore(groupedInfo);
        ActionInfo firstAction = groupedInfo.actions.get(0);
        Material material = MaterialUtils.getSourceMaterialForTarget(groupedInfo.target, firstAction.actionType);
        String materialName = material.name();
        Object displayName = groupedInfo.target;
        if (firstAction.action.getDisplayName() != null && !firstAction.action.getDisplayName().isEmpty()) {
            displayName = firstAction.action.getDisplayName();
            if (!((String)displayName).startsWith("<") && !((String)displayName).startsWith("&")) {
                displayName = "<!italic><white>" + (String)displayName;
            }
        } else {
            displayName = "<!italic><white>" + (String)displayName;
        }
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(materialName, (String)displayName, lore, false);
        MenuItemConfig itemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
        return this.createMenuItem(itemConfig, this.cachedPlaceholders);
    }

    private List<String> buildGroupedActionLore(GroupedActionInfo groupedInfo) {
        ArrayList<String> lore = new ArrayList<String>();
        JobAction firstAction = groupedInfo.actions.get((int)0).action;
        if (firstAction.getLore() != null && !firstAction.getLore().isEmpty()) {
            for (String loreLine : firstAction.getLore()) {
                if (!(loreLine.trim().isEmpty() || loreLine.startsWith("<") || loreLine.startsWith("&"))) {
                    lore.add("<!italic><white>" + loreLine);
                    continue;
                }
                lore.add(loreLine);
            }
        }
        for (ActionInfo actionInfo : this.groupedActions.get(groupedInfo.target)) {
            JobAction action = actionInfo.action;
            Object actionTypeStr = actionInfo.actionType.name().toLowerCase();
            actionTypeStr = ((String)actionTypeStr).substring(0, 1).toUpperCase() + ((String)actionTypeStr).substring(1);
            ActionItemFormat format = this.config.getActionItemFormat();
            if (format == null || format.getLoreBonus() == null) continue;
            ArrayList<String> formatLore = new ArrayList<String>(format.getLoreBonus());
            for (int i = 0; i < formatLore.size(); ++i) {
                Object line = (String)formatLore.get(i);
                line = ((String)line).replace("{action_type}", (CharSequence)actionTypeStr);
                line = ((String)line).replace("{action_target}", action.getTarget());
                line = ((String)line).replace("{action_xp}", String.valueOf(action.getXp()));
                line = ((String)line).replace("{action_money}", String.valueOf(action.getMoney()));
                String requirements = this.buildRequirementsString(action);
                if (!(((String)(line = ((String)line).replace("{action_requirements}", requirements))).trim().isEmpty() || ((String)line).startsWith("<") || ((String)line).startsWith("&"))) {
                    line = "<!italic><white>" + (String)line;
                }
                formatLore.set(i, (String)line);
            }
            lore.addAll(formatLore);
        }
        return lore;
    }

    private String buildRequirementsString(JobAction action) {
        ArrayList<CallSite> requirements = new ArrayList<CallSite>();
        if (action.getEnchantLevel() != null && !action.getEnchantLevel().isEmpty()) {
            requirements.add((CallSite)((Object)("Enchant Level: " + action.getEnchantLevel())));
        }
        if (action.hasPotionTypeRequirements()) {
            requirements.add((CallSite)((Object)("Potion Types: " + String.join((CharSequence)", ", action.getPotionTypes()))));
        }
        if (action.hasProfessionRequirements()) {
            requirements.add((CallSite)((Object)("Professions: " + String.join((CharSequence)", ", action.getProfessions()))));
        }
        if (action.hasColorRequirements()) {
            requirements.add((CallSite)((Object)("Colors: " + String.join((CharSequence)", ", action.getColors()))));
        }
        if (action.hasNbtRequirements()) {
            requirements.add((CallSite)((Object)("Item Types: " + String.join((CharSequence)", ", action.getNbtTags()))));
        }
        if (!action.getInteractType().equals("RIGHT_CLICK")) {
            requirements.add((CallSite)((Object)("Interact: " + action.getInteractType().replace("_", " "))));
        }
        return requirements.isEmpty() ? "None" : String.join((CharSequence)", ", requirements);
    }

    private void addNavigationItems() {
        Map<String, String> navPlaceholders = this.createNavigationPlaceholders();
        this.config.getNavigationItems().forEach((key, itemConfig) -> {
            if (itemConfig.isEnabled()) {
                ItemStack navItem = this.createMenuItem((MenuItemConfig)itemConfig, navPlaceholders);
                for (int slot : itemConfig.getSlots()) {
                    this.inventory.setItem(slot, navItem);
                }
            }
        });
    }

    @Override
    public void handleClick(int slot, InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.handleNavigationClick(slot)) {
            return;
        }
    }

    @Override
    protected boolean hasNextPage() {
        return (this.currentPage + 1) * this.config.getItemsPerPage() < this.groupedActions.size();
    }

    private Map<String, String> createJobPlaceholders() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{job_id}", this.job.getId());
        placeholders.put("{job_name}", this.job.getDisplayName());
        placeholders.put("{job_description}", this.job.getDescription());
        int totalActions = this.groupedActions.values().stream().mapToInt(List::size).sum();
        placeholders.put("{total_actions}", String.valueOf(totalActions));
        return placeholders;
    }

    private Map<String, String> createNavigationPlaceholders() {
        int totalActions = this.groupedActions.values().stream().mapToInt(List::size).sum();
        Map<String, String> placeholders = MenuItemUtils.createNavigationPlaceholders(this.currentPage, this.groupedActions.size(), this.config.getItemsPerPage());
        placeholders.put("total_actions", String.valueOf(totalActions));
        placeholders.put("job_name", this.job.getDisplayName());
        return placeholders;
    }

    private static class ActionInfo {
        final ActionType actionType;
        final JobAction action;

        ActionInfo(ActionType actionType, JobAction action) {
            this.actionType = actionType;
            this.action = action;
        }
    }

    private static class DisplayItem {
        final String type;
        final Object data;

        DisplayItem(String type, Object data) {
            this.type = type;
            this.data = data;
        }
    }

    private static class GroupedActionInfo {
        final String target;
        final List<ActionInfo> actions;

        GroupedActionInfo(String target, List<ActionInfo> actions) {
            this.target = target;
            this.actions = actions;
        }
    }
}

