/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.impl;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.config.LanguageManager;
import fr.ax_dev.universejobs.config.ProgressBarConfig;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.config.JobItemFormat;
import fr.ax_dev.universejobs.menu.config.JobSlotManager;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.menu.utils.MenuItemUtils;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class JobsMainMenu
extends BaseMenu
implements InventoryHolder {
    private static final int DEFAULT_PROGRESS_BARS = 20;
    private static final char PROGRESS_FILLED = '\u25b0';
    private static final char PROGRESS_EMPTY = '\u25b1';
    private static final String PROGRESS_FILLED_COLOR = "&a";
    private static final String PROGRESS_EMPTY_COLOR = "&7";
    private final List<Job> availableJobs;
    private final PlayerJobData playerData;
    private final JobSlotManager jobSlotManager;
    private final Map<String, String> cachedPlaceholders;
    private final LanguageManager languageManager;

    public JobsMainMenu(UniverseJobs plugin, Player player, SingleMenuConfig config, JobSlotManager jobSlotManager) {
        super(plugin, player, config);
        this.playerData = plugin.getJobManager().getPlayerData(player.getUniqueId());
        this.jobSlotManager = jobSlotManager;
        this.languageManager = plugin.getLanguageManager();
        this.availableJobs = this.loadAvailableJobsForPlayer();
        this.cachedPlaceholders = this.createGeneralPlaceholders();
        this.initialize();
    }

    private List<Job> loadAvailableJobsForPlayer() {
        return this.plugin.getJobManager().getJobs().values().stream().filter(Job::isEnabled).filter(job -> job.getPermission() == null || this.player.hasPermission(job.getPermission())).sorted(Comparator.comparing(Job::getName)).collect(Collectors.toList());
    }

    @Override
    protected void populateInventory() {
        this.inventory.clear();
        this.populateStaticItems();
        this.populateJobItems();
        this.populateNavigationItems();
        this.addFillItems();
    }

    private void populateStaticItems() {
        MenuItemUtils.addStaticItems(this.inventory, this.config.getStaticItems(), this.cachedPlaceholders, config -> this.createMenuItem((MenuItemConfig)config, this.cachedPlaceholders));
    }

    private void populateJobItems() {
        Map<String, Integer> jobSlots = this.jobSlotManager.calculateJobSlots(this.availableJobs);
        this.availableJobs.forEach(job -> {
            Integer slot = (Integer)jobSlots.get(job.getId());
            if (slot != null) {
                try {
                    ItemStack jobItem = this.createJobItemOptimized((Job)job);
                    if (jobItem != null) {
                        this.inventory.setItem(slot.intValue(), jobItem);
                        this.logDebugPlacement((Job)job, slot);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to create job item for " + job.getId() + ": " + e.getMessage());
                }
            }
        });
    }

    private void logDebugPlacement(Job job, int slot) {
        if (this.plugin.getConfigCache() != null && this.plugin.getConfigCache().isDebugEnabled()) {
            this.plugin.getLogger().info("Placed job '" + job.getId() + "' in slot " + slot);
        }
    }

    private ItemStack createJobItemOptimized(Job job) {
        JobItemFormat format = this.config.getJobItemFormat();
        Material iconMaterial = this.getJobMaterial(job, format);
        if (iconMaterial == null) {
            return null;
        }
        boolean hasJob = this.playerData.hasJob(job.getId());
        int playerLevel = hasJob ? this.playerData.getLevel(job.getId()) : 0;
        long playerXp = hasJob ? (long)this.playerData.getXp(job.getId()) : 0L;
        Map<String, String> jobPlaceholders = this.createJobPlaceholdersOptimized(job, hasJob, playerLevel, playerXp);
        Map<String, Object> jobConfigMap = this.createJobConfigMap(job, format, iconMaterial, hasJob);
        MenuItemConfig jobItemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(jobConfigMap));
        return this.createMenuItem(jobItemConfig, jobPlaceholders);
    }

    private Material getJobMaterial(Job job, JobItemFormat format) {
        if (format.isUseJobIcon()) {
            if (job.getIconMaterial() == null || job.getIconMaterial().isEmpty()) {
                this.plugin.getLogger().severe("No material configured for job " + job.getId());
                return null;
            }
            try {
                return Material.valueOf((String)job.getIconMaterial().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().severe("Invalid material for job " + job.getId() + ": " + job.getIconMaterial());
                return null;
            }
        }
        return Material.PAPER;
    }

    private Map<String, Object> createJobConfigMap(Job job, JobItemFormat format, Material iconMaterial, boolean hasJob) {
        HashMap<String, Object> jobConfigMap = new HashMap<String, Object>();
        jobConfigMap.put("material", iconMaterial.name());
        jobConfigMap.put("display-name", format.getDisplayName());
        jobConfigMap.put("lore", hasJob ? format.getLore() : format.getLoreWithoutJob());
        jobConfigMap.put("amount", format.getAmount());
        jobConfigMap.put("glow", hasJob ? format.isGlowWhenJoined() : format.isGlowWhenNotJoined());
        jobConfigMap.put("hide-attributes", format.isHideAttributes());
        jobConfigMap.put("hide-enchants", format.isHideEnchants());
        if (job.getCustomModelData() > 0) {
            jobConfigMap.put("custom-model-data", job.getCustomModelData());
        }
        jobConfigMap.put("action", "open_job");
        jobConfigMap.put("action-value", job.getId());
        return jobConfigMap;
    }

    private void populateNavigationItems() {
        Map<String, MenuItemConfig> navItems = this.config.getNavigationItems();
        for (Map.Entry<String, MenuItemConfig> entry : navItems.entrySet()) {
            MenuItemConfig navConfig = entry.getValue();
            if (!navConfig.isEnabled()) continue;
            ItemStack navItem = this.createMenuItem(navConfig, this.getNavigationPlaceholders());
            this.placeItemInSlots(navItem, navConfig.getSlots());
        }
    }

    private void placeItemInSlots(ItemStack item, List<Integer> slots) {
        if (item == null || slots == null) {
            return;
        }
        for (int slot : slots) {
            if (slot < 0 || slot >= this.inventory.getSize()) continue;
            this.inventory.setItem(slot, item);
        }
    }

    @Override
    public void handleClick(int slot, InventoryClickEvent event) {
        if (this.handleNavigationClick(slot)) {
            return;
        }
        this.handleJobClick(slot, event);
    }

    private void handleJobClick(int slot, InventoryClickEvent event) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        Job clickedJob = this.findJobFromSlot(slot);
        if (clickedJob == null) {
            return;
        }
        if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
            this.handleQuickJobToggle(clickedJob);
        } else {
            this.plugin.getMenuManager().openJobMenu(this.player, clickedJob.getId());
        }
    }

    private Job findJobFromSlot(int slot) {
        int jobIndex;
        List<Integer> contentSlots = this.config.getContentSlots();
        int slotIndex = contentSlots.indexOf(slot);
        if (slotIndex >= 0 && (jobIndex = this.currentPage * this.config.getItemsPerPage() + slotIndex) < this.availableJobs.size()) {
            return this.availableJobs.get(jobIndex);
        }
        return null;
    }

    private void handleQuickJobToggle(Job job) {
        boolean currentlyHasJob = this.playerData.hasJob(job.getId());
        if (currentlyHasJob) {
            this.handleQuickLeaveJob(job);
        } else {
            this.handleQuickJoinJob(job);
        }
    }

    private void handleQuickLeaveJob(Job job) {
        if (this.plugin.getJobManager().leaveJob(this.player, job.getId())) {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.leave.success", "job", job.getName()));
            this.refresh();
        } else {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.leave.failed", "job", job.getName()));
        }
    }

    private void handleQuickJoinJob(Job job) {
        if (!this.validateJobJoinRequirements(job)) {
            return;
        }
        if (this.plugin.getJobManager().joinJob(this.player, job.getId())) {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.join.success", "job", job.getName()));
            this.refresh();
        } else {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.join.failed", "job", job.getName()));
        }
    }

    private boolean validateJobJoinRequirements(Job job) {
        if (job.getPermission() != null && !this.player.hasPermission(job.getPermission())) {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.join.no-permission", "job", job.getName()));
            return false;
        }
        int maxJobs = this.plugin.getConfigManager().getMaxJobsPerPlayer();
        int currentJobs = this.playerData.getJobs().size();
        if (currentJobs >= maxJobs) {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.join.max-jobs-reached", "max", String.valueOf(maxJobs)));
            return false;
        }
        return true;
    }

    private Map<String, String> getNavigationPlaceholders() {
        Map<String, String> placeholders = MenuItemUtils.createNavigationPlaceholders(this.currentPage, this.availableJobs.size(), this.config.getItemsPerPage());
        placeholders.put("total_jobs", String.valueOf(this.availableJobs.size()));
        placeholders.put("player_jobs", String.valueOf(this.playerData.getJobs().size()));
        return placeholders;
    }

    private Map<String, String> createGeneralPlaceholders() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("total_jobs", String.valueOf(this.availableJobs.size()));
        placeholders.put("player_jobs", String.valueOf(this.playerData.getJobs().size()));
        return placeholders;
    }

    private Map<String, String> createJobPlaceholdersOptimized(Job job, boolean hasJob, int playerLevel, long playerXp) {
        HashMap<String, String> placeholders = new HashMap<String, String>(this.cachedPlaceholders);
        this.addJobBasicPlaceholders(placeholders, job);
        this.addPlayerStatusPlaceholders(placeholders, hasJob, playerLevel, playerXp);
        this.addProgressPlaceholders(placeholders, job, hasJob, playerLevel, playerXp);
        return placeholders;
    }

    private void addJobBasicPlaceholders(Map<String, String> placeholders, Job job) {
        placeholders.put("job_id", job.getId());
        placeholders.put("job_name", job.getName());
        placeholders.put("job_description", job.getDescription());
        placeholders.put("job_max_level", String.valueOf(job.getMaxLevel()));
        placeholders.put("job_permission", job.getPermission() != null ? job.getPermission() : "none");
    }

    private void addPlayerStatusPlaceholders(Map<String, String> placeholders, boolean hasJob, int playerLevel, long playerXp) {
        placeholders.put("player_level", String.valueOf(playerLevel));
        placeholders.put("player_xp", String.valueOf(playerXp));
        placeholders.put("has_job", hasJob ? "Yes" : "No");
        placeholders.put("job_status", hasJob ? "&aJoined" : "&7Not Joined");
    }

    private void addProgressPlaceholders(Map<String, String> placeholders, Job job, boolean hasJob, int playerLevel, long playerXp) {
        if (hasJob && job.getXpCurve() != null && playerLevel < job.getMaxLevel()) {
            this.calculateAndAddProgressValues(placeholders, job, playerLevel, playerXp);
        } else {
            this.addDefaultProgressValues(placeholders, job, playerLevel);
        }
    }

    private void calculateAndAddProgressValues(Map<String, String> placeholders, Job job, int playerLevel, long playerXp) {
        long currentLevelXp = (long)job.getXpCurve().getXpForLevel(playerLevel);
        long nextLevelXp = (long)job.getXpCurve().getXpForLevel(playerLevel + 1);
        long xpToNext = Math.max(0L, nextLevelXp - playerXp);
        long xpProgress = playerXp - currentLevelXp;
        long xpRequired = nextLevelXp - currentLevelXp;
        placeholders.put("xp_to_next", String.valueOf(xpToNext));
        placeholders.put("next_level_xp", String.valueOf(nextLevelXp));
        placeholders.put("current_level_xp", String.valueOf(currentLevelXp));
        double progressPercent = xpRequired > 0L ? (double)xpProgress / (double)xpRequired * 100.0 : 0.0;
        placeholders.put("progress_percent", String.format("%.1f", progressPercent));
        placeholders.put("progress_bar", this.createProgressBarOptimized(progressPercent));
    }

    private void addDefaultProgressValues(Map<String, String> placeholders, Job job, int playerLevel) {
        placeholders.put("xp_to_next", "0");
        placeholders.put("next_level_xp", "0");
        placeholders.put("current_level_xp", "0");
        boolean isMaxLevel = playerLevel >= job.getMaxLevel();
        placeholders.put("progress_percent", isMaxLevel ? "100.0" : "0.0");
        placeholders.put("progress_bar", this.createProgressBarOptimized(isMaxLevel ? 100.0 : 0.0));
    }

    private String createProgressBarOptimized(double percent) {
        int i;
        ProgressBarConfig progressBarConfig = this.plugin.getAccessor().getConfigManager().getProgressBarConfig();
        if (progressBarConfig != null) {
            return progressBarConfig.generateProgressBar(percent, 100.0, false);
        }
        int filledBars = (int)Math.round(percent / 100.0 * 20.0);
        StringBuilder bar = new StringBuilder(64);
        bar.append(PROGRESS_FILLED_COLOR);
        for (i = 0; i < filledBars; ++i) {
            bar.append('\u25b0');
        }
        bar.append(PROGRESS_EMPTY_COLOR);
        for (i = filledBars; i < 20; ++i) {
            bar.append('\u25b1');
        }
        return bar.toString();
    }

    @Override
    protected boolean hasNextPage() {
        return (this.currentPage + 1) * this.config.getItemsPerPage() < this.availableJobs.size();
    }

    private int getTotalPages() {
        return (int)Math.ceil((double)this.availableJobs.size() / (double)this.config.getItemsPerPage());
    }
}

